/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.batch;

import org.kuali.kfs.module.purap.document.service.ReceivingService;
import org.kuali.kfs.sys.batch.AbstractStep;

import java.util.Date;

public class ApproveLineItemReceivingStep extends AbstractStep {

    private ReceivingService receivingService;

    @Override
    public boolean execute(String jobName, Date jobRunDate) throws InterruptedException {
        receivingService.approveReceivingDocsForPOAmendment();
        return true;
    }

    public ReceivingService getReceivingService() {
        return receivingService;
    }

    public void setReceivingService(ReceivingService receivingService) {
        this.receivingService = receivingService;
    }

}
