/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.kfs.core.api.impex.xml.XmlConstants;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceContact;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Name"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}PostalAddress" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Email" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Phone" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Fax" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}URL" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="role" use="required" type="{http://www.kuali.org/kfs/sys/types}oneToTwentyCharType" /&gt;
 *       &lt;attribute name="addressID" type="{http://www.kuali.org/kfs/sys/types}zeroToTwentyCharType" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {"name", "postalAddress", "email", "phone", "fax", "url"})
@XmlRootElement(name = "Contact", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
public class Contact {

    @XmlElement(name = "Name", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    protected Name name;
    @XmlElement(name = "PostalAddress", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected List<PostalAddress> postalAddress;
    @XmlElement(name = "Email", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected List<Email> email;
    @XmlElement(name = "Phone", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected List<Phone> phone;
    @XmlElement(name = "Fax", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected List<Fax> fax;
    @XmlElement(name = "URL", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected List<URL> url;
    @XmlAttribute(name = "role", required = true)
    protected String role;
    @XmlAttribute(name = "addressID")
    protected String addressID;

    /**
     * Gets the value of the name property.
     *
     * @return possible object is {@link Name }
     */
    public Name getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     *
     * @param name allowed object is {@link Name }
     */
    public void setName(final Name name) {
        this.name = name;
    }

    /**
     * Gets the value of the postalAddress property.
     *
     * <p>
     * This accessor method returns a reference to the live list, not a snapshot. Therefore any modification you make to
     * the returned list will be present inside the Jakarta XML Binding object. This is why there is not a
     * <CODE>set</CODE> method for the postalAddress property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPostalAddress().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list {@link PostalAddress }
     */
    public List<PostalAddress> getPostalAddress() {
        if (postalAddress == null) {
            postalAddress = new ArrayList<>();
        }
        return postalAddress;
    }

    /**
     * Gets the value of the email property.
     *
     * <p>
     * This accessor method returns a reference to the live list, not a snapshot. Therefore any modification you make to
     * the returned list will be present inside the Jakarta XML Binding object. This is why there is not a
     * <CODE>set</CODE> method for the email property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getEmail().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list {@link Email }
     */
    public List<Email> getEmail() {
        if (email == null) {
            email = new ArrayList<>();
        }
        return email;
    }

    /**
     * Gets the value of the phone property.
     *
     * <p>
     * This accessor method returns a reference to the live list, not a snapshot. Therefore any modification you make to
     * the returned list will be present inside the Jakarta XML Binding object. This is why there is not a
     * <CODE>set</CODE> method for the phone property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPhone().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list {@link Phone }
     */
    public List<Phone> getPhone() {
        if (phone == null) {
            phone = new ArrayList<>();
        }
        return phone;
    }

    /**
     * Gets the value of the fax property.
     *
     * <p>
     * This accessor method returns a reference to the live list, not a snapshot. Therefore any modification you make to
     * the returned list will be present inside the Jakarta XML Binding object. This is why there is not a
     * <CODE>set</CODE> method for the fax property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFax().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list {@link Fax }
     */
    public List<Fax> getFax() {
        if (fax == null) {
            fax = new ArrayList<>();
        }
        return fax;
    }

    /**
     * Gets the value of the url property.
     *
     * <p>
     * This accessor method returns a reference to the live list, not a snapshot. Therefore any modification you make to
     * the returned list will be present inside the Jakarta XML Binding object. This is why there is not a
     * <CODE>set</CODE> method for the url property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getURL().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list {@link URL }
     */
    public List<URL> getURL() {
        if (url == null) {
            url = new ArrayList<>();
        }
        return url;
    }

    /**
     * Gets the value of the role property.
     *
     * @return possible object is {@link String }
     */
    public String getRole() {
        return role;
    }

    /**
     * Sets the value of the role property.
     *
     * @param role allowed object is {@link String }
     */
    public void setRole(final String role) {
        this.role = role;
    }

    /**
     * Gets the value of the addressID property.
     *
     * @return possible object is {@link String }
     */
    public String getAddressID() {
        return addressID;
    }

    /**
     * Sets the value of the addressID property.
     *
     * @param addressID allowed object is {@link String }
     */
    public void setAddressID(final String addressID) {
        this.addressID = addressID;
    }

    ElectronicInvoiceContact toElectronicInvoiceContact() {
        final ElectronicInvoiceContact contact = new ElectronicInvoiceContact();
        contact.setAddressID(addressID);
        if (CollectionUtils.isNotEmpty(email)) {
            contact.setEmailAddresses(email.stream().collect(Collectors.toMap(Email::getName, Email::getValue)));
        }
        if (CollectionUtils.isNotEmpty(fax)) {
            contact.setFaxNumbers(fax.stream()
                    .collect(Collectors.toMap(Fax::getName, fx -> fx.getTelephoneNumber().getCombinedNumber())));
        }
        contact.setName(name.getValue());
        if (CollectionUtils.isNotEmpty(phone)) {
            contact.setPhoneNumbers(phone.stream()
                    .collect(Collectors.toMap(Phone::getName, ph -> ph.getTelephoneNumber().getCombinedNumber())));
        }
        if (CollectionUtils.isNotEmpty(postalAddress)) {
            contact.setPostalAddresses(postalAddress.stream()
                    .map(PostalAddress::toElectronicInvoicePostalAddress)
                    .collect(Collectors.toList()));
        }
        contact.setRole(role);
        if (CollectionUtils.isNotEmpty(url)) {
            contact.setWebAddresses(url.stream().map(URL::getValue).collect(Collectors.toList()));
        }
        return contact;
    }

}
