/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.kuali.kfs.core.api.impex.xml.XmlConstants;

/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="From"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Credential"/&gt;
 *                 &lt;/sequence&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="To"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Credential"/&gt;
 *                 &lt;/sequence&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="Sender"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Credential"/&gt;
 *                   &lt;element name="UserAgent" type="{http://www.kuali.org/kfs/sys/types}zeroToFiftyFiveCharType"/&gt;
 *                 &lt;/sequence&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {"from", "to", "sender"})
public class ElectronicInvoiceHeader {

    @XmlElement(name = "From", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    private From from;

    @XmlElement(name = "Sender", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    private Sender sender;

    @XmlElement(name = "To", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    private To to;

    /**
     * Gets the value of the from property.
     *
     * @return possible object is {@link From }
     */
    public From getFrom() {
        return from;
    }

    /**
     * Sets the value of the from property.
     *
     * @param value allowed object is {@link From }
     */
    public void setFrom(final From value) {
        from = value;
    }

    /**
     * Gets the value of the sender property.
     *
     * @return possible object is {@link Sender }
     */
    public Sender getSender() {
        return sender;
    }

    /**
     * Sets the value of the sender property.
     *
     * @param value allowed object is {@link Sender }
     */
    public void setSender(final Sender value) {
        sender = value;
    }

    /**
     * Gets the value of the to property.
     *
     * @return possible object is {@link To }
     */
    public To getTo() {
        return to;
    }

    /**
     * Sets the value of the to property.
     *
     * @param value allowed object is {@link To }
     */
    public void setTo(final To value) {
        to = value;
    }

    /**
     * <p>Java class for anonymous complex type.
     *
     * <p>The following schema fragment specifies the expected content contained within this class.
     *
     * <pre>
     * &lt;complexType&gt;
     *   &lt;complexContent&gt;
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *       &lt;sequence&gt;
     *         &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Credential"/&gt;
     *       &lt;/sequence&gt;
     *     &lt;/restriction&gt;
     *   &lt;/complexContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = "credential")
    public static class From {

        @XmlElement(name = "Credential", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
        private Credential credential;

        /**
         * Gets the value of the credential property.
         *
         * @return possible object is {@link Credential }
         */
        public Credential getCredential() {
            return credential;
        }

        /**
         * Sets the value of the credential property.
         *
         * @param value allowed object is {@link Credential }
         */
        public void setCredential(final Credential value) {
            credential = value;
        }

    }

    /**
     * <p>Java class for anonymous complex type.
     *
     * <p>The following schema fragment specifies the expected content contained within this class.
     *
     * <pre>
     * &lt;complexType&gt;
     *   &lt;complexContent&gt;
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *       &lt;sequence&gt;
     *         &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Credential"/&gt;
     *         &lt;element name="UserAgent" type="{http://www.kuali.org/kfs/sys/types}zeroToFiftyFiveCharType"/&gt;
     *       &lt;/sequence&gt;
     *     &lt;/restriction&gt;
     *   &lt;/complexContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {"credential", "userAgent"})
    public static class Sender {

        @XmlElement(name = "Credential", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
        private Credential credential;

        @XmlElement(name = "UserAgent", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
        private String userAgent;

        /**
         * Gets the value of the credential property.
         *
         * @return possible object is {@link Credential }
         */
        public Credential getCredential() {
            return credential;
        }

        /**
         * Sets the value of the credential property.
         *
         * @param value allowed object is {@link Credential }
         */
        public void setCredential(final Credential value) {
            credential = value;
        }

        /**
         * Gets the value of the userAgent property.
         *
         * @return possible object is {@link String }
         */
        public String getUserAgent() {
            return userAgent;
        }

        /**
         * Sets the value of the userAgent property.
         *
         * @param value allowed object is {@link String }
         */
        public void setUserAgent(final String value) {
            userAgent = value;
        }

    }

    /**
     * <p>Java class for anonymous complex type.
     *
     * <p>The following schema fragment specifies the expected content contained within this class.
     *
     * <pre>
     * &lt;complexType&gt;
     *   &lt;complexContent&gt;
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *       &lt;sequence&gt;
     *         &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Credential"/&gt;
     *       &lt;/sequence&gt;
     *     &lt;/restriction&gt;
     *   &lt;/complexContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = "credential")
    public static class To {

        @XmlElement(name = "Credential", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
        private Credential credential;

        /**
         * Gets the value of the credential property.
         *
         * @return possible object is {@link Credential }
         */
        public Credential getCredential() {
            return credential;
        }

        /**
         * Sets the value of the credential property.
         *
         * @param value allowed object is {@link Credential }
         */
        public void setCredential(final Credential value) {
            credential = value;
        }

    }

}
