/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.kuali.kfs.core.api.impex.xml.XmlConstants;

/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="From"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Credential"/&gt;
 *                 &lt;/sequence&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="To"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Credential"/&gt;
 *                 &lt;/sequence&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="Sender"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Credential"/&gt;
 *                   &lt;element name="UserAgent" type="{http://www.kuali.org/kfs/sys/types}zeroToFiftyFiveCharType"/&gt;
 *                 &lt;/sequence&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {"from", "to", "sender"})
public class Header {

    @XmlElement(name = "From", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    protected From from;
    @XmlElement(name = "To", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    protected To to;
    @XmlElement(name = "Sender", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    protected Sender sender;

    /**
     * Gets the value of the from property.
     *
     * @return possible object is {@link From }
     */
    public From getFrom() {
        return from;
    }

    /**
     * Sets the value of the from property.
     *
     * @param from allowed object is {@link From }
     */
    public void setFrom(final From from) {
        this.from = from;
    }

    public void setFrom(final String domain, final String identity) {
        final From newFrom = new From();
        final Credential newCredential = new Credential();
        newCredential.setDomain(domain);
        newCredential.setIdentity(identity);
        newFrom.setCredential(newCredential);
        from = newFrom;
    }

    public String getFromDomain() {
        return from.getCredential().getDomain();
    }

    public void setFromDomain(final String fromDomain) {
        from.getCredential().setDomain(fromDomain);
    }

    public String getFromIdentity() {
        return from.getCredential().getIdentity();
    }

    public void setFromIdentity(final String fromIdentity) {
        from.getCredential().setIdentity(fromIdentity);
    }

    public String getFromSharedSecret() {
        return from.getCredential().getSharedSecret();
    }

    public void setFromSharedSecret(final String fromSharedSecret) {
        from.getCredential().setSharedSecret(fromSharedSecret);
    }

    /**
     * Gets the value of the to property.
     *
     * @return possible object is {@link To }
     */
    public To getTo() {
        return to;
    }

    /**
     * Sets the value of the to property.
     *
     * @param to allowed object is {@link To }
     */
    public void setTo(final To to) {
        this.to = to;
    }

    public void setTo(final String domain, final String identity) {
        final To newTo = new To();
        final Credential newCredential = new Credential();
        newCredential.setDomain(domain);
        newCredential.setIdentity(identity);
        newTo.setCredential(newCredential);
        to = newTo;
    }

    public String getToDomain() {
        return to.getCredential().getDomain();
    }

    public void setToDomain(final String toDomain) {
        to.getCredential().setDomain(toDomain);
    }

    public String getToIdentity() {
        return to.getCredential().getIdentity();
    }

    public void setToIdentity(final String toIdentity) {
        to.getCredential().setIdentity(toIdentity);
    }

    public String getToSharedSecret() {
        return to.getCredential().getSharedSecret();
    }

    public void setToSharedSecret(final String toSharedSecret) {
        to.getCredential().setSharedSecret(toSharedSecret);
    }

    /**
     * Gets the value of the sender property.
     *
     * @return possible object is {@link Sender }
     */
    public Sender getSender() {
        return sender;
    }

    /**
     * Sets the value of the sender property.
     *
     * @param sender allowed object is {@link Sender }
     */
    public void setSender(final Sender sender) {
        this.sender = sender;
    }

    public String getSenderDomain() {
        return sender.getCredential().getDomain();
    }

    public void setSenderDomain(final String senderDomain) {
        sender.getCredential().setDomain(senderDomain);
    }

    public String getSenderIdentity() {
        return sender.getCredential().getIdentity();
    }

    public void setSenderIdentity(final String senderIdentity) {
        sender.getCredential().setIdentity(senderIdentity);
    }

    public String getSenderUserAgent() {
        return sender.getUserAgent();
    }

    public void setSenderUserAgent(final String senderUserAgent) {
        sender.setUserAgent(senderUserAgent);
    }

    public String getSenderSharedSecret() {
        return sender.getCredential().getSharedSecret();
    }

    public void setSenderSharedSecret(final String senderSharedSecret) {
        sender.getCredential().setSharedSecret(senderSharedSecret);
    }

}
