/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.kuali.kfs.core.api.impex.xml.XmlConstants;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Contact" maxOccurs="unbounded"/&gt;
 *         &lt;choice minOccurs="0"&gt;
 *           &lt;element name="CarrierIdentifier" minOccurs="0"&gt;
 *             &lt;complexType&gt;
 *               &lt;complexContent&gt;
 *                 &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                   &lt;attribute name="domain" use="required" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *                 &lt;/restriction&gt;
 *               &lt;/complexContent&gt;
 *             &lt;/complexType&gt;
 *           &lt;/element&gt;
 *           &lt;element name="ShipmentIdentifier" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;/choice&gt;
 *         &lt;element name="DocumentReference" minOccurs="0"&gt;
 *           &lt;complexType&gt;
 *             &lt;simpleContent&gt;
 *               &lt;extension base="&lt;http://www.w3.org/2001/XMLSchema&gt;string"&gt;
 *                 &lt;attribute name="payloadID" use="required" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *               &lt;/extension&gt;
 *             &lt;/simpleContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="shippingDate" type="{http://www.kuali.org/kfs/purap/types}dateStringType" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {"contact", "carrierIdentifier", "shipmentIdentifier", "documentReference"})
@XmlRootElement(name = "InvoiceDetailShipping", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
public class InvoiceDetailShipping {

    @XmlElement(name = "Contact", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    protected List<Contact> contact;
    @XmlElement(name = "CarrierIdentifier", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected CarrierIdentifier carrierIdentifier;
    @XmlElement(name = "ShipmentIdentifier", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected String shipmentIdentifier;
    @XmlElement(name = "DocumentReference", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected DocumentReference documentReference;
    @XmlAttribute(name = "shippingDate")
    protected String shippingDate;

    /**
     * Gets the value of the contact property.
     *
     * <p>
     * This accessor method returns a reference to the live list, not a snapshot. Therefore any modification you make to
     * the returned list will be present inside the Jakarta XML Binding object. This is why there is not a
     * <CODE>set</CODE> method for the contact property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getContact().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list {@link Contact }
     */
    public List<Contact> getContact() {
        if (contact == null) {
            contact = new ArrayList<>();
        }
        return contact;
    }

    /**
     * Gets the value of the carrierIdentifier property.
     *
     * @return possible object is {@link CarrierIdentifier }
     */
    public CarrierIdentifier getCarrierIdentifier() {
        return carrierIdentifier;
    }

    /**
     * Sets the value of the carrierIdentifier property.
     *
     * @param carrierIdentifier allowed object is {@link CarrierIdentifier }
     */
    public void setCarrierIdentifier(final CarrierIdentifier carrierIdentifier) {
        this.carrierIdentifier = carrierIdentifier;
    }

    /**
     * Gets the value of the shipmentIdentifier property.
     *
     * @return possible object is {@link String }
     */
    public String getShipmentIdentifier() {
        return shipmentIdentifier;
    }

    /**
     * Sets the value of the shipmentIdentifier property.
     *
     * @param shipmentIdentifier allowed object is {@link String }
     */
    public void setShipmentIdentifier(final String shipmentIdentifier) {
        this.shipmentIdentifier = shipmentIdentifier;
    }

    /**
     * Gets the value of the documentReference property.
     *
     * @return possible object is {@link DocumentReference }
     */
    public DocumentReference getDocumentReference() {
        return documentReference;
    }

    /**
     * Sets the value of the documentReference property.
     *
     * @param documentReference allowed object is {@link DocumentReference }
     */
    public void setDocumentReference(final DocumentReference documentReference) {
        this.documentReference = documentReference;
    }

    /**
     * Gets the value of the shippingDate property.
     *
     * @return possible object is {@link String }
     */
    public String getShippingDate() {
        return shippingDate;
    }

    /**
     * Sets the value of the shippingDate property.
     *
     * @param shippingDate allowed object is {@link String }
     */
    public void setShippingDate(final String shippingDate) {
        this.shippingDate = shippingDate;
    }

}
