/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.kfs.core.api.impex.xml.XmlConstants;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceDetailRequestSummary;

/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="SubtotalAmount"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Money"/&gt;
 *                 &lt;/sequence&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Tax"/&gt;
 *         &lt;element name="SpecialHandlingAmount" minOccurs="0"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Money"/&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Description" minOccurs="0"/&gt;
 *                 &lt;/sequence&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="ShippingAmount" minOccurs="0"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Money"/&gt;
 *                 &lt;/sequence&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}GrossAmount" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}InvoiceDetailDiscount" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}NetAmount"/&gt;
 *         &lt;element name="DepositAmount" minOccurs="0"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Money"/&gt;
 *                 &lt;/sequence&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="DueAmount" minOccurs="0"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Money"/&gt;
 *                 &lt;/sequence&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {"subtotalAmount", "tax", "specialHandlingAmount", "shippingAmount", "grossAmount",
    "invoiceDetailDiscount", "netAmount", "depositAmount", "dueAmount"})
public class InvoiceDetailSummary {

    @XmlElement(name = "SubtotalAmount", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    protected SubtotalAmount subtotalAmount;
    @XmlElement(name = "Tax", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    protected Tax tax;
    @XmlElement(name = "SpecialHandlingAmount", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected SpecialHandlingAmount specialHandlingAmount;
    @XmlElement(name = "ShippingAmount", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected ShippingAmount shippingAmount;
    @XmlElement(name = "GrossAmount", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected GrossAmount grossAmount;
    @XmlElement(name = "InvoiceDetailDiscount", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected InvoiceDetailDiscount invoiceDetailDiscount;
    @XmlElement(name = "NetAmount", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    protected NetAmount netAmount;
    @XmlElement(name = "DepositAmount", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected DepositAmount depositAmount;
    @XmlElement(name = "DueAmount", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected DueAmount dueAmount;

    /**
     * Gets the value of the subtotalAmount property.
     *
     * @return possible object is {@link SubtotalAmount }
     */
    public SubtotalAmount getSubtotalAmount() {
        return subtotalAmount;
    }

    /**
     * Sets the value of the subtotalAmount property.
     *
     * @param subtotalAmount allowed object is {@link SubtotalAmount }
     */
    public void setSubtotalAmount(final SubtotalAmount subtotalAmount) {
        this.subtotalAmount = subtotalAmount;
    }

    /**
     * Gets the value of the tax property.
     *
     * @return possible object is {@link Tax }
     */
    public Tax getTax() {
        return tax;
    }

    /**
     * Sets the value of the tax property.
     *
     * @param tax allowed object is {@link Tax }
     */
    public void setTax(final Tax tax) {
        this.tax = tax;
    }

    /**
     * Gets the value of the specialHandlingAmount property.
     *
     * @return possible object is {@link SpecialHandlingAmount }
     */
    public SpecialHandlingAmount getSpecialHandlingAmount() {
        return specialHandlingAmount;
    }

    /**
     * Sets the value of the specialHandlingAmount property.
     *
     * @param specialHandlingAmount allowed object is {@link SpecialHandlingAmount }
     */
    public void setSpecialHandlingAmount(final SpecialHandlingAmount specialHandlingAmount) {
        this.specialHandlingAmount = specialHandlingAmount;
    }

    /**
     * Gets the value of the shippingAmount property.
     *
     * @return possible object is {@link ShippingAmount }
     */
    public ShippingAmount getShippingAmount() {
        return shippingAmount;
    }

    /**
     * Sets the value of the shippingAmount property.
     *
     * @param shippingAmount allowed object is {@link ShippingAmount }
     */
    public void setShippingAmount(final ShippingAmount shippingAmount) {
        this.shippingAmount = shippingAmount;
    }

    /**
     * Gets the value of the grossAmount property.
     *
     * @return possible object is {@link GrossAmount }
     */
    public GrossAmount getGrossAmount() {
        return grossAmount;
    }

    /**
     * Sets the value of the grossAmount property.
     *
     * @param grossAmount allowed object is {@link GrossAmount }
     */
    public void setGrossAmount(final GrossAmount grossAmount) {
        this.grossAmount = grossAmount;
    }

    /**
     * Gets the value of the invoiceDetailDiscount property.
     *
     * @return possible object is {@link InvoiceDetailDiscount }
     */
    public InvoiceDetailDiscount getInvoiceDetailDiscount() {
        return invoiceDetailDiscount;
    }

    /**
     * Sets the value of the invoiceDetailDiscount property.
     *
     * @param invoiceDetailDiscount allowed object is {@link InvoiceDetailDiscount }
     */
    public void setInvoiceDetailDiscount(final InvoiceDetailDiscount invoiceDetailDiscount) {
        this.invoiceDetailDiscount = invoiceDetailDiscount;
    }

    /**
     * Gets the value of the netAmount property.
     *
     * @return possible object is {@link NetAmount }
     */
    public NetAmount getNetAmount() {
        return netAmount;
    }

    /**
     * Sets the value of the netAmount property.
     *
     * @param netAmount allowed object is {@link NetAmount }
     */
    public void setNetAmount(final NetAmount netAmount) {
        this.netAmount = netAmount;
    }

    /**
     * Gets the value of the depositAmount property.
     *
     * @return possible object is {@link DepositAmount }
     */
    public DepositAmount getDepositAmount() {
        return depositAmount;
    }

    /**
     * Sets the value of the depositAmount property.
     *
     * @param depositAmount allowed object is {@link DepositAmount }
     */
    public void setDepositAmount(final DepositAmount depositAmount) {
        this.depositAmount = depositAmount;
    }

    /**
     * Gets the value of the dueAmount property.
     *
     * @return possible object is {@link DueAmount }
     */
    public DueAmount getDueAmount() {
        return dueAmount;
    }

    /**
     * Sets the value of the dueAmount property.
     *
     * @param dueAmount allowed object is {@link DueAmount }
     */
    public void setDueAmount(final DueAmount dueAmount) {
        this.dueAmount = dueAmount;
    }

    public ElectronicInvoiceDetailRequestSummary toElectronicInvoiceDetailRequestSummary() {
        final ElectronicInvoiceDetailRequestSummary summary = new ElectronicInvoiceDetailRequestSummary();

        if (depositAmount != null) {
            summary.setDepositAmount(depositAmount.getMoney().getValue());
            summary.setDepositAmountCurrency(depositAmount.getMoney().getCurrency());
        }

        if (invoiceDetailDiscount != null) {
            summary.setDiscountAmount(invoiceDetailDiscount.getMoney().getValue());
            summary.setDiscountAmountCurrency(invoiceDetailDiscount.getMoney().getValue());
        }

        if (dueAmount != null) {
            summary.setDueAmount(dueAmount.getMoney().getValue());
            summary.setDueAmountCurrency(dueAmount.getMoney().getCurrency());
        }

        if (grossAmount != null) {
            summary.setGrossAmount(grossAmount.getMoney().getValue());
            summary.setGrossAmountCurrency(grossAmount.getMoney().getCurrency());
        }

        if (netAmount != null) {
            summary.setNetAmount(netAmount.getMoney().getValue());
            summary.setNetAmountCurrency(netAmount.getMoney().getCurrency());
        }

        if (shippingAmount != null) {
            summary.setShippingAmount(shippingAmount.getMoney().getValue());
            summary.setShippingAmountCurrency(shippingAmount.getMoney().getCurrency());
        }

        if (specialHandlingAmount != null) {
            summary.setSpecialHandlingAmount(specialHandlingAmount.getMoney().getValue());
            summary.setSpecialHandlingAmountCurrency(specialHandlingAmount.getMoney().getCurrency());
            if (specialHandlingAmount.getDescription() != null) {
                summary.setSpecialHandlingAmountDescription(specialHandlingAmount.getDescription().getValue());
            }
        }

        if (subtotalAmount != null) {
            summary.setSubTotalAmount(subtotalAmount.getMoney().getValue());
            summary.setSubTotalAmountCurrency(subtotalAmount.getMoney().getCurrency());
        }

        if (tax != null) {
            summary.setTaxAmount(tax.getMoney().getValue());
            summary.setTaxAmountCurrency(tax.getMoney().getCurrency());
            summary.setTaxDescription(tax.getDescription().getValue());
            if (CollectionUtils.isNotEmpty(tax.getTaxDetail())) {
                final TaxDetail detail = tax.getTaxDetail().get(tax.getTaxDetail().size() - 1);
                summary.setTaxCategory(detail.getCategory());
                summary.setTaxPurpose(detail.getPurpose());
                if (detail.getPercentageRate() != null) {
                    summary.setTaxPercentageRate(detail.getPercentageRate().toPlainString());
                }
            }
        }

        return summary;
    }

}
