/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import org.kuali.kfs.core.api.impex.xml.XmlConstants;

/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType&gt;
 *   &lt;simpleContent&gt;
 *     &lt;extension base="&lt;http://www.w3.org/2001/XMLSchema&gt;string"&gt;
 *       &lt;attribute name="agreementID" use="required" type="{http://www.kuali.org/kfs/purap/types}idType" /&gt;
 *       &lt;attribute name="agreementDate" type="{http://www.kuali.org/kfs/purap/types}dateStringType" /&gt;
 *     &lt;/extension&gt;
 *   &lt;/simpleContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = "value")
@XmlRootElement(name = "MasterAgreementIDInfo", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
public class MasterAgreementIDInfo {

    @XmlValue
    protected String value;
    @XmlAttribute(name = "agreementID", required = true)
    protected String agreementID;
    @XmlAttribute(name = "agreementDate")
    protected String agreementDate;

    /**
     * Gets the value of the value property.
     *
     * @return possible object is {@link String }
     */
    public String getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     *
     * @param value allowed object is {@link String }
     */
    public void setValue(final String value) {
        this.value = value;
    }

    /**
     * Gets the value of the agreementID property.
     *
     * @return possible object is {@link String }
     */
    public String getAgreementID() {
        return agreementID;
    }

    /**
     * Sets the value of the agreementID property.
     *
     * @param agreementID allowed object is {@link String }
     */
    public void setAgreementID(final String agreementID) {
        this.agreementID = agreementID;
    }

    /**
     * Gets the value of the agreementDate property.
     *
     * @return possible object is {@link String }
     */
    public String getAgreementDate() {
        return agreementDate;
    }

    /**
     * Sets the value of the agreementDate property.
     *
     * @param agreementDate allowed object is {@link String }
     */
    public void setAgreementDate(final String agreementDate) {
        this.agreementDate = agreementDate;
    }

}
