/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.kuali.kfs.core.api.impex.xml.XmlConstants;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoicePostalAddress;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="DeliverTo" type="{http://www.kuali.org/kfs/sys/types}zeroToFiftyFiveCharType" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element name="Street" type="{http://www.kuali.org/kfs/purap/types}addressType" maxOccurs="unbounded"/&gt;
 *         &lt;element name="City" type="{http://www.kuali.org/kfs/purap/types}addressType"/&gt;
 *         &lt;element name="State" type="{http://www.kuali.org/kfs/purap/types}addressType"/&gt;
 *         &lt;element name="PostalCode" type="{http://www.kuali.org/kfs/purap/types}postalCodeType"/&gt;
 *         &lt;element name="Country"&gt;
 *           &lt;complexType&gt;
 *             &lt;simpleContent&gt;
 *               &lt;extension base="&lt;http://www.kuali.org/kfs/purap/types&gt;addressType"&gt;
 *                 &lt;attribute name="isoCountryCode" use="required" type="{http://www.kuali.org/kfs/purap/types}countryCodeType" /&gt;
 *               &lt;/extension&gt;
 *             &lt;/simpleContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="name" type="{http://www.kuali.org/kfs/sys/types}oneToFiftyCharType" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {"deliverTo", "street", "city", "state", "postalCode", "country"})
@XmlRootElement(name = "PostalAddress", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
public class PostalAddress {

    @XmlElement(name = "DeliverTo", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected List<String> deliverTo;
    @XmlElement(name = "Street", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    protected List<String> street;
    @XmlElement(name = "City", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    protected String city;
    @XmlElement(name = "State", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    protected String state;
    @XmlElement(name = "PostalCode", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    protected String postalCode;
    @XmlElement(name = "Country", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    protected Country country;
    @XmlAttribute(name = "name")
    protected String name;

    /**
     * Gets the value of the deliverTo property.
     *
     * <p>
     * This accessor method returns a reference to the live list, not a snapshot. Therefore any modification you make to
     * the returned list will be present inside the Jakarta XML Binding object. This is why there is not a
     * <CODE>set</CODE> method for the deliverTo property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDeliverTo().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list {@link String }
     */
    public List<String> getDeliverTo() {
        if (deliverTo == null) {
            deliverTo = new ArrayList<String>();
        }
        return deliverTo;
    }

    /**
     * Gets the value of the street property.
     *
     * <p>
     * This accessor method returns a reference to the live list, not a snapshot. Therefore any modification you make to
     * the returned list will be present inside the Jakarta XML Binding object. This is why there is not a
     * <CODE>set</CODE> method for the street property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getStreet().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list {@link String }
     */
    public List<String> getStreet() {
        if (street == null) {
            street = new ArrayList<String>();
        }
        return street;
    }

    /**
     * Gets the value of the city property.
     *
     * @return possible object is {@link String }
     */
    public String getCity() {
        return city;
    }

    /**
     * Sets the value of the city property.
     *
     * @param city allowed object is {@link String }
     */
    public void setCity(final String city) {
        this.city = city;
    }

    /**
     * Gets the value of the state property.
     *
     * @return possible object is {@link String }
     */
    public String getState() {
        return state;
    }

    /**
     * Sets the value of the state property.
     *
     * @param state allowed object is {@link String }
     */
    public void setState(final String state) {
        this.state = state;
    }

    /**
     * Gets the value of the postalCode property.
     *
     * @return possible object is {@link String }
     */
    public String getPostalCode() {
        return postalCode;
    }

    /**
     * Sets the value of the postalCode property.
     *
     * @param postalCode allowed object is {@link String }
     */
    public void setPostalCode(final String postalCode) {
        this.postalCode = postalCode;
    }

    /**
     * Gets the value of the country property.
     *
     * @return possible object is {@link Country }
     */
    public Country getCountry() {
        return country;
    }

    /**
     * Sets the value of the country property.
     *
     * @param country allowed object is {@link Country }
     */
    public void setCountry(final Country country) {
        this.country = country;
    }

    /**
     * Gets the value of the name property.
     *
     * @return possible object is {@link String }
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     *
     * @param name allowed object is {@link String }
     */
    public void setName(final String name) {
        this.name = name;
    }

    public ElectronicInvoicePostalAddress toElectronicInvoicePostalAddress() {
        final ElectronicInvoicePostalAddress address = new ElectronicInvoicePostalAddress();
        address.setCityName(city);
        address.setCountryCode(country.getIsoCountryCode());
        address.setCountryName(country.getValue());
        address.setPostalCode(postalCode);
        address.setStateCode(state);
        address.addName(name);
        street.forEach(address::addStreet);
        return address;
    }

}
