/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.kuali.kfs.core.api.impex.xml.XmlConstants;

/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="CountryCode"&gt;
 *           &lt;complexType&gt;
 *             &lt;simpleContent&gt;
 *               &lt;extension base="&lt;http://www.kuali.org/kfs/purap/types&gt;addressType"&gt;
 *                 &lt;attribute name="isoCountryCode" type="{http://www.kuali.org/kfs/sys/types}oneToFourCharType" /&gt;
 *               &lt;/extension&gt;
 *             &lt;/simpleContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="AreaOrCityCode" type="{http://www.kuali.org/kfs/sys/types}oneToFourCharType"/&gt;
 *         &lt;element name="Number" type="{http://www.kuali.org/kfs/sys/types}oneToTwentyCharType"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {"countryCode", "areaOrCityCode", "number"})
public class TelephoneNumber {

    @XmlElement(name = "CountryCode", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    protected CountryCode countryCode;
    @XmlElement(name = "AreaOrCityCode", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    protected String areaOrCityCode;
    @XmlElement(name = "Number", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    protected String number;

    /**
     * Gets the value of the countryCode property.
     *
     * @return possible object is {@link CountryCode }
     */
    public CountryCode getCountryCode() {
        return countryCode;
    }

    /**
     * Sets the value of the countryCode property.
     *
     * @param countryCode allowed object is {@link CountryCode }
     */
    public void setCountryCode(final CountryCode countryCode) {
        this.countryCode = countryCode;
    }

    /**
     * Gets the value of the areaOrCityCode property.
     *
     * @return possible object is {@link String }
     */
    public String getAreaOrCityCode() {
        return areaOrCityCode;
    }

    /**
     * Sets the value of the areaOrCityCode property.
     *
     * @param areaOrCityCode allowed object is {@link String }
     */
    public void setAreaOrCityCode(final String areaOrCityCode) {
        this.areaOrCityCode = areaOrCityCode;
    }

    /**
     * Gets the value of the number property.
     *
     * @return possible object is {@link String }
     */
    public String getNumber() {
        return number;
    }

    /**
     * Sets the value of the number property.
     *
     * @param number allowed object is {@link String }
     */
    public void setNumber(final String number) {
        this.number = number;
    }

    public String getCombinedNumber() {
        return countryCode.getValue() + areaOrCityCode + number;
    }

}
