/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.kuali.kfs.core.api.impex.xml.XmlConstants;

/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/purap/electronicInvoice}Money"/&gt;
 *         &lt;element name="UnitOfMeasure" type="{http://www.kuali.org/kfs/purap/types}uomType"/&gt;
 *         &lt;element name="TermReference" minOccurs="0"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;attribute name="termName" use="required" type="{http://www.kuali.org/kfs/sys/types}oneToTwentyCharType" /&gt;
 *                 &lt;attribute name="term" use="required" type="{http://www.kuali.org/kfs/sys/types}oneToTenCharType" /&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {"money", "unitOfMeasure", "termReference"})
public class UnitRate {

    @XmlElement(name = "Money", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true, defaultValue = "0")
    protected Money money;
    @XmlElement(name = "UnitOfMeasure", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE, required = true)
    protected String unitOfMeasure;
    @XmlElement(name = "TermReference", namespace = XmlConstants.ELECTRONIC_INV_NAMESPACE)
    protected TermReference termReference;

    /**
     * Gets the value of the money property.
     *
     * @return possible object is {@link Money }
     */
    public Money getMoney() {
        return money;
    }

    /**
     * Sets the value of the money property.
     *
     * @param money allowed object is {@link Money }
     */
    public void setMoney(final Money money) {
        this.money = money;
    }

    /**
     * Gets the value of the unitOfMeasure property.
     *
     * @return possible object is {@link String }
     */
    public String getUnitOfMeasure() {
        return unitOfMeasure;
    }

    /**
     * Sets the value of the unitOfMeasure property.
     *
     * @param unitOfMeasure allowed object is {@link String }
     */
    public void setUnitOfMeasure(final String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    /**
     * Gets the value of the termReference property.
     *
     * @return possible object is {@link TermReference }
     */
    public TermReference getTermReference() {
        return termReference;
    }

    /**
     * Sets the value of the termReference property.
     *
     * @param termReference allowed object is {@link TermReference }
     */
    public void setTermReference(final TermReference termReference) {
        this.termReference = termReference;
    }

}
