/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.kuali.kfs.module.purap.businessobject.options;

import org.kuali.kfs.sys.businessobject.options.PaymentMethodValuesFinderBase;

/**
 * An extension of {@link PaymentMethodValuesFinderBase} specifically for payment request documents.
 */
public class PaymentRequestPaymentMethodValuesFinder extends PaymentMethodValuesFinderBase {

    private static final String DISPLAY_ON_PAYMENT_REQUEST = "displayOnPaymentRequest";

    public PaymentRequestPaymentMethodValuesFinder() {
        super(DISPLAY_ON_PAYMENT_REQUEST);
    }
}
