/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.document.service;

import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;

public interface PurApWorkflowIntegrationService {

    /**
     * Take all actions on the given document based on the given criteria
     *
     * @param document
     * @param potentialAnnotation
     * @param nodeName
     * @param user
     */
    void takeAllActionsForGivenCriteria(Document document, String potentialAnnotation, String nodeName, Person user);

    /**
     * Determine if the document will stop at the given node in the future routing process
     *
     * @param document
     * @param givenNodeName
     * @return boolean indicating if document is going to stop at the given node
     */
    boolean willDocumentStopAtGivenFutureRouteNode(PurchasingAccountsPayableDocument document, String givenNodeName);
}
