/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.util.cxml;

import org.kuali.kfs.sys.batch.XmlBatchInputFileTypeBase;

import java.io.File;

/**
 * This is the base class for all the b2b file type classes. All the methods in this class returns a default value since
 * there is no need to do anything in these methods in b2b.
 */
public abstract class B2BFileTypeBase<T> extends XmlBatchInputFileTypeBase<T> {

    @Override
    public String getFileName(
            final String principalId,
            final Object parsedFileContents,
            final String fileUserIdentifier
    ) {
        return null;
    }

    @Override
    public boolean validate(final Object parsedFileContents) {
        return false;
    }

    @Override
    public String getTitleKey() {
        return null;
    }

    @Override
    public String getAuthorPrincipalName(final File file) {
        return null;
    }
}
