/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.util.cxml;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.kuali.kfs.core.api.impex.xml.XmlConstants;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/purap/b2bPunchOutOrder}UnitPrice"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/purap/b2bPunchOutOrder}Description"/&gt;
 *         &lt;element name="UnitOfMeasure" type="{http://www.kuali.org/kfs/purap/types}uomType"/&gt;
 *         &lt;element name="Classification" maxOccurs="unbounded"&gt;
 *           &lt;complexType&gt;
 *             &lt;simpleContent&gt;
 *               &lt;extension base="&lt;http://www.kuali.org/kfs/sys/types&gt;zeroToThirtyCharType"&gt;
 *                 &lt;attribute name="domain" type="{http://www.kuali.org/kfs/sys/types}oneToTwentyOneCharType" /&gt;
 *               &lt;/extension&gt;
 *             &lt;/simpleContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="ManufacturerPartID" type="{http://www.kuali.org/kfs/sys/types}oneToTwentyOneCharType" minOccurs="0"/&gt;
 *         &lt;element name="ManufacturerName" type="{http://www.kuali.org/kfs/sys/types}zeroToFiftyFiveCharType" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/purap/b2bPunchOutOrder}Extrinsic" maxOccurs="unbounded"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "unitPrice",
    "description",
    "unitOfMeasure",
    "classification",
    "manufacturerPartID",
    "manufacturerName",
    "extrinsic"
})
public class ItemDetail {

    @XmlElement(name = "Classification", namespace = XmlConstants.B2B_PUNCH_OUT_ORDER_NAMESPACE, required = true)
    private List<Classification> classification;

    @XmlElement(name = "Description", namespace = XmlConstants.B2B_PUNCH_OUT_ORDER_NAMESPACE, required = true)
    private Description description;

    @XmlElement(name = "Extrinsic", namespace = XmlConstants.B2B_PUNCH_OUT_ORDER_NAMESPACE, required = true)
    private List<CxmlExtrinsic> extrinsic;

    @XmlElement(name = "ManufacturerName", namespace = XmlConstants.B2B_PUNCH_OUT_ORDER_NAMESPACE)
    private String manufacturerName;

    @XmlElement(name = "ManufacturerPartID", namespace = XmlConstants.B2B_PUNCH_OUT_ORDER_NAMESPACE)
    private String manufacturerPartID;

    @XmlElement(name = "UnitOfMeasure", namespace = XmlConstants.B2B_PUNCH_OUT_ORDER_NAMESPACE, required = true)
    private String unitOfMeasure;

    @XmlElement(name = "UnitPrice", namespace = XmlConstants.B2B_PUNCH_OUT_ORDER_NAMESPACE, required = true)
    private UnitPrice unitPrice;

    /**
     * Gets the value of the classification property.
     *
     * <p>
     * This accessor method returns a reference to the live list, not a snapshot. Therefore, any modification you make
     * to the returned list will be present inside the Jakarta XML Binding object. This is why there is not a {@code
     * set} method for the classification property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getClassification().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list {@link Classification }
     */
    public List<Classification> getClassificationList() {
        if (classification == null) {
            classification = new ArrayList<>();
        }
        return classification;
    }

    /**
     * Gets the value of the description property.
     *
     * @return possible object is {@link Description }
     */
    public Description getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     *
     * @param description allowed object is {@link Description }
     */
    public void setDescription(final Description description) {
        this.description = description;
    }

    /**
     * Gets the value of the extrinsic property.
     *
     * <p>
     * This accessor method returns a reference to the live list, not a snapshot. Therefore, any modification you make
     * to the returned list will be present inside the Jakarta XML Binding object. This is why there is not a {@code
     * set} method for the extrinsic property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtrinsic().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list {@link CxmlExtrinsic }
     */
    List<CxmlExtrinsic> getExtrinsicList() {
        if (extrinsic == null) {
            extrinsic = new ArrayList<>();
        }
        return extrinsic;
    }

    /**
     * Gets the value of the manufacturerName property.
     *
     * @return possible object is {@link String }
     */
    public String getManufacturerName() {
        return manufacturerName;
    }

    /**
     * Sets the value of the manufacturerName property.
     *
     * @param manufacturerName allowed object is {@link String }
     */
    public void setManufacturerName(final String manufacturerName) {
        this.manufacturerName = manufacturerName;
    }

    /**
     * Gets the value of the manufacturerPartID property.
     *
     * @return possible object is {@link String }
     */
    public String getManufacturerPartID() {
        return manufacturerPartID;
    }

    /**
     * Sets the value of the manufacturerPartID property.
     *
     * @param manufacturerPartID allowed object is {@link String }
     */
    public void setManufacturerPartID(final String manufacturerPartID) {
        this.manufacturerPartID = manufacturerPartID;
    }

    /**
     * Gets the value of the unitOfMeasure property.
     *
     * @return possible object is {@link String }
     */
    public String getUnitOfMeasure() {
        return unitOfMeasure;
    }

    /**
     * Sets the value of the unitOfMeasure property.
     *
     * @param unitOfMeasure allowed object is {@link String }
     */
    public void setUnitOfMeasure(final String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    /**
     * Gets the value of the unitPrice property.
     *
     * @return possible object is {@link UnitPrice }
     */
    public UnitPrice getUnitPrice() {
        return unitPrice;
    }

    /**
     * Sets the value of the unitPrice property.
     *
     * @param unitPrice allowed object is {@link UnitPrice }
     */
    public void setUnitPrice(final UnitPrice unitPrice) {
        this.unitPrice = unitPrice;
    }
}
