/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.util.cxml;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import org.kuali.kfs.core.api.impex.xml.XmlConstants;
import org.kuali.kfs.module.purap.businessobject.B2BShoppingCartItem;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.kuali.org/kfs/purap/b2bPunchOutOrder}ItemID"/&gt;
 *         &lt;element name="ItemDetail"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/b2bPunchOutOrder}UnitPrice"/&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/b2bPunchOutOrder}Description"/&gt;
 *                   &lt;element name="UnitOfMeasure" type="{http://www.kuali.org/kfs/purap/types}uomType"/&gt;
 *                   &lt;element name="Classification" maxOccurs="unbounded"&gt;
 *                     &lt;complexType&gt;
 *                       &lt;simpleContent&gt;
 *                         &lt;extension base="&lt;http://www.kuali.org/kfs/sys/types&gt;zeroToThirtyCharType"&gt;
 *                           &lt;attribute name="domain" type="{http://www.kuali.org/kfs/sys/types}oneToTwentyOneCharType" /&gt;
 *                         &lt;/extension&gt;
 *                       &lt;/simpleContent&gt;
 *                     &lt;/complexType&gt;
 *                   &lt;/element&gt;
 *                   &lt;element name="ManufacturerPartID" type="{http://www.kuali.org/kfs/sys/types}oneToTwentyOneCharType" minOccurs="0"/&gt;
 *                   &lt;element name="ManufacturerName" type="{http://www.kuali.org/kfs/sys/types}zeroToFiftyFiveCharType" minOccurs="0"/&gt;
 *                   &lt;element ref="{http://www.kuali.org/kfs/purap/b2bPunchOutOrder}Extrinsic" maxOccurs="unbounded"/&gt;
 *                 &lt;/sequence&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="SupplierID" maxOccurs="unbounded" minOccurs="0"&gt;
 *           &lt;complexType&gt;
 *             &lt;simpleContent&gt;
 *               &lt;extension base="&lt;http://www.kuali.org/kfs/sys/types&gt;zeroToNinetyCharType"&gt;
 *                 &lt;attribute name="domain" type="{http://www.kuali.org/kfs/sys/types}zeroToTwentyCharType" /&gt;
 *               &lt;/extension&gt;
 *             &lt;/simpleContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="quantity" type="{http://www.w3.org/2001/XMLSchema}unsignedInt" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {"itemID", "itemDetail", "supplierID"})
public class ItemIn {

    @XmlElement(name = "ItemDetail", namespace = XmlConstants.B2B_PUNCH_OUT_ORDER_NAMESPACE, required = true)
    private ItemDetail itemDetail;

    @XmlElement(name = "ItemID", namespace = XmlConstants.B2B_PUNCH_OUT_ORDER_NAMESPACE, required = true)
    private ItemID itemID;

    @XmlAttribute(name = "quantity")
    @XmlSchemaType(name = "unsignedInt")
    private Long quantity;

    @XmlElement(name = "SupplierID", namespace = XmlConstants.B2B_PUNCH_OUT_ORDER_NAMESPACE)
    private List<SupplierID> supplierID;

    /**
     * Gets the value of the itemDetail property.
     *
     * @return possible object is {@link ItemDetail }
     */
    public ItemDetail getItemDetail() {
        return itemDetail;
    }

    /**
     * Sets the value of the itemDetail property.
     *
     * @param itemDetail allowed object is {@link ItemDetail }
     */
    public void setItemDetail(final ItemDetail itemDetail) {
        this.itemDetail = itemDetail;
    }

    /**
     * Gets the value of the itemID property.
     *
     * @return possible object is {@link ItemID }
     */
    public ItemID getItemID() {
        return itemID;
    }

    /**
     * Sets the value of the itemID property.
     *
     * @param itemID allowed object is {@link ItemID }
     */
    public void setItemID(final ItemID itemID) {
        this.itemID = itemID;
    }

    /**
     * Gets the value of the quantity property.
     *
     * @return possible object is {@link Long }
     */
    public Long getQuantity() {
        return quantity;
    }

    /**
     * Sets the value of the quantity property.
     *
     * @param quantity allowed object is {@link Long }
     */
    public void setQuantity(final Long quantity) {
        this.quantity = quantity;
    }

    /**
     * Gets the value of the supplierID property.
     *
     * <p>
     * This accessor method returns a reference to the live list, not a snapshot. Therefore, any modification you
     * make to the returned list will be present inside the Jakarta XML Binding object. This is why there is not a
     * {@code set} method for the supplierID property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSupplierID().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list {@link SupplierID }
     */
    public List<SupplierID> getSupplierID() {
        if (supplierID == null) {
            supplierID = new ArrayList<>();
        }
        return supplierID;
    }

    public B2BShoppingCartItem toB2BShoppingCartItem() {
        B2BShoppingCartItem item = new B2BShoppingCartItem();
        item.setSupplierPartId(itemID.getSupplierPartID());
        item.setSupplierPartAuxiliaryId(itemID.getSupplierPartAuxiliaryID());
        item.setDescription(itemDetail.getDescription().getValue());
        item.setQuantity(quantity.toString());
        item.setManufacturerName(itemDetail.getManufacturerName());
        item.setManufacturerPartID(itemDetail.getManufacturerPartID());
        item.setUnitOfMeasure(itemDetail.getUnitOfMeasure());
        item.setUnitPrice(itemDetail.getUnitPrice().getMoney().getValue().toPlainString());
        item.setUnitPriceCurrency(itemDetail.getUnitPrice().getMoney().getValue().toPlainString());
        itemDetail.getClassificationList().forEach(classification -> item.addClassification(classification.getDomain(), classification.getValue()));
        itemDetail.getExtrinsicList().forEach(extrinsic -> item.addExtrinsic(extrinsic.getName(), extrinsic.getValue()));
        supplierID.forEach(supplier -> item.setSupplier(supplier.getDomain(), supplier.getValue()));

        return item;
    }

    /**
     * <p>Java class for anonymous complex type.
     *
     * <p>The following schema fragment specifies the expected content contained within this class.
     *
     * <pre>
     * &lt;complexType&gt;
     *   &lt;simpleContent&gt;
     *     &lt;extension base="&lt;http://www.kuali.org/kfs/sys/types&gt;zeroToNinetyCharType"&gt;
     *       &lt;attribute name="domain" type="{http://www.kuali.org/kfs/sys/types}zeroToTwentyCharType" /&gt;
     *     &lt;/extension&gt;
     *   &lt;/simpleContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = "value")
    public static class SupplierID {

        @XmlAttribute(name = "domain")
        private String domain;

        @XmlValue
        private String value;

        public SupplierID() {
        }

        public SupplierID(final String domain, final String value) {
            this.domain = domain;
            this.value = value;
        }

        /**
         * Gets the value of the domain property.
         *
         * @return possible object is {@link String }
         */
        public String getDomain() {
            return domain;
        }

        /**
         * Sets the value of the domain property.
         *
         * @param domain allowed object is {@link String }
         */
        public void setDomain(final String domain) {
            this.domain = domain;
        }

        /**
         * Gets the value of the value property.
         *
         * @return possible object is {@link String }
         */
        public String getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         *
         * @param value allowed object is {@link String }
         */
        public void setValue(final String value) {
            this.value = value;
        }

    }

    /**
     * <p>Java class for anonymous complex type.
     *
     * <p>The following schema fragment specifies the expected content contained within this class.
     *
     * <pre>
     * &lt;complexType&gt;
     *   &lt;complexContent&gt;
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *       &lt;sequence&gt;
     *         &lt;element name="SupplierPartID" type="{http://www.kuali.org/kfs/purap/types}catalogNumberType"/&gt;
     *         &lt;element name="SupplierPartAuxiliaryID" type="{http://www.kuali.org/kfs/purap/types}auxiliaryIDType" minOccurs="0"/&gt;
     *       &lt;/sequence&gt;
     *     &lt;/restriction&gt;
     *   &lt;/complexContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {"supplierPartID", "supplierPartAuxiliaryID"})
    @XmlRootElement(name = "ItemID", namespace = XmlConstants.B2B_PUNCH_OUT_ORDER_NAMESPACE)
    public static class ItemID {

        @XmlElement(name = "SupplierPartAuxiliaryID", namespace = XmlConstants.B2B_PUNCH_OUT_ORDER_NAMESPACE)
        private String supplierPartAuxiliaryID;

        @XmlElement(name = "SupplierPartID", namespace = XmlConstants.B2B_PUNCH_OUT_ORDER_NAMESPACE, required = true)
        private String supplierPartID;

        public ItemID() {
        }

        public ItemID(final String supplierPartID, final String supplierPartAuxiliaryID) {
            this.supplierPartID = supplierPartID;
            this.supplierPartAuxiliaryID = supplierPartAuxiliaryID;
        }

        /**
         * Gets the value of the supplierPartAuxiliaryID property.
         *
         * @return possible object is {@link String }
         */
        public String getSupplierPartAuxiliaryID() {
            return supplierPartAuxiliaryID;
        }

        /**
         * Sets the value of the supplierPartAuxiliaryID property.
         *
         * @param supplierPartAuxiliaryID allowed object is {@link String }
         */
        public void setSupplierPartAuxiliaryID(final String supplierPartAuxiliaryID) {
            this.supplierPartAuxiliaryID = supplierPartAuxiliaryID;
        }

        /**
         * Gets the value of the supplierPartID property.
         *
         * @return possible object is {@link String }
         */
        public String getSupplierPartID() {
            return supplierPartID;
        }

        /**
         * Sets the value of the supplierPartID property.
         *
         * @param supplierPartID allowed object is {@link String }
         */
        public void setSupplierPartID(final String supplierPartID) {
            this.supplierPartID = supplierPartID;
        }
    }
}
