/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.util.cxml;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.kuali.kfs.core.api.impex.xml.XmlConstants;

/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="Status"&gt;
 *           &lt;complexType&gt;
 *             &lt;simpleContent&gt;
 *               &lt;extension base="&lt;http://www.w3.org/2001/XMLSchema&gt;string"&gt;
 *                 &lt;attribute name="code" type="{http://www.kuali.org/kfs/purap/types}statusCodeType" /&gt;
 *                 &lt;attribute name="text" type="{http://www.kuali.org/kfs/purap/types}statusTextType" /&gt;
 *               &lt;/extension&gt;
 *             &lt;/simpleContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *         &lt;element name="PunchOutOrderMessage"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element name="BuyerCookie" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *                   &lt;element name="PunchOutOrderMessageHeader"&gt;
 *                     &lt;complexType&gt;
 *                       &lt;complexContent&gt;
 *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                           &lt;sequence&gt;
 *                             &lt;element name="Total"&gt;
 *                               &lt;complexType&gt;
 *                                 &lt;complexContent&gt;
 *                                   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                                     &lt;sequence&gt;
 *                                       &lt;element ref="{http://www.kuali.org/kfs/purap/b2bPunchOutOrder}Money"/&gt;
 *                                     &lt;/sequence&gt;
 *                                   &lt;/restriction&gt;
 *                                 &lt;/complexContent&gt;
 *                               &lt;/complexType&gt;
 *                             &lt;/element&gt;
 *                           &lt;/sequence&gt;
 *                           &lt;attribute name="operationAllowed" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *                           &lt;attribute name="quoteStatus" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *                         &lt;/restriction&gt;
 *                       &lt;/complexContent&gt;
 *                     &lt;/complexType&gt;
 *                   &lt;/element&gt;
 *                   &lt;element name="ItemIn" maxOccurs="unbounded"&gt;
 *                     &lt;complexType&gt;
 *                       &lt;complexContent&gt;
 *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                           &lt;sequence&gt;
 *                             &lt;element ref="{http://www.kuali.org/kfs/purap/b2bPunchOutOrder}ItemID"/&gt;
 *                             &lt;element name="ItemDetail"&gt;
 *                               &lt;complexType&gt;
 *                                 &lt;complexContent&gt;
 *                                   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                                     &lt;sequence&gt;
 *                                       &lt;element ref="{http://www.kuali.org/kfs/purap/b2bPunchOutOrder}UnitPrice"/&gt;
 *                                       &lt;element ref="{http://www.kuali.org/kfs/purap/b2bPunchOutOrder}Description"/&gt;
 *                                       &lt;element name="UnitOfMeasure" type="{http://www.kuali.org/kfs/purap/types}uomType"/&gt;
 *                                       &lt;element name="Classification" maxOccurs="unbounded"&gt;
 *                                         &lt;complexType&gt;
 *                                           &lt;simpleContent&gt;
 *                                             &lt;extension base="&lt;http://www.kuali.org/kfs/sys/types&gt;zeroToThirtyCharType"&gt;
 *                                               &lt;attribute name="domain" type="{http://www.kuali.org/kfs/sys/types}oneToTwentyOneCharType" /&gt;
 *                                             &lt;/extension&gt;
 *                                           &lt;/simpleContent&gt;
 *                                         &lt;/complexType&gt;
 *                                       &lt;/element&gt;
 *                                       &lt;element name="ManufacturerPartID" type="{http://www.kuali.org/kfs/sys/types}oneToTwentyOneCharType" minOccurs="0"/&gt;
 *                                       &lt;element name="ManufacturerName" type="{http://www.kuali.org/kfs/sys/types}zeroToFiftyFiveCharType" minOccurs="0"/&gt;
 *                                       &lt;element ref="{http://www.kuali.org/kfs/purap/b2bPunchOutOrder}Extrinsic" maxOccurs="unbounded"/&gt;
 *                                     &lt;/sequence&gt;
 *                                   &lt;/restriction&gt;
 *                                 &lt;/complexContent&gt;
 *                               &lt;/complexType&gt;
 *                             &lt;/element&gt;
 *                             &lt;element name="SupplierID" maxOccurs="unbounded" minOccurs="0"&gt;
 *                               &lt;complexType&gt;
 *                                 &lt;simpleContent&gt;
 *                                   &lt;extension base="&lt;http://www.kuali.org/kfs/sys/types&gt;zeroToNinetyCharType"&gt;
 *                                     &lt;attribute name="domain" type="{http://www.kuali.org/kfs/sys/types}zeroToTwentyCharType" /&gt;
 *                                   &lt;/extension&gt;
 *                                 &lt;/simpleContent&gt;
 *                               &lt;/complexType&gt;
 *                             &lt;/element&gt;
 *                           &lt;/sequence&gt;
 *                           &lt;attribute name="quantity" type="{http://www.w3.org/2001/XMLSchema}unsignedInt" /&gt;
 *                         &lt;/restriction&gt;
 *                       &lt;/complexContent&gt;
 *                     &lt;/complexType&gt;
 *                   &lt;/element&gt;
 *                 &lt;/sequence&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="deploymentMode" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {"status", "punchOutOrderMessage"})
public class Message {

    @XmlAttribute(name = "deploymentMode")
    private String deploymentMode;

    @XmlElement(name = "PunchOutOrderMessage", namespace = XmlConstants.B2B_PUNCH_OUT_ORDER_NAMESPACE, required = true)
    private PunchOutOrderMessage punchOutOrderMessage = new PunchOutOrderMessage();

    @XmlElement(name = "Status", namespace = XmlConstants.B2B_PUNCH_OUT_ORDER_NAMESPACE, required = true)
    private Status status = new Status();

    /**
     * Gets the value of the deploymentMode property.
     *
     * @return possible object is {@link String }
     */
    public String getDeploymentMode() {
        return deploymentMode;
    }

    /**
     * Sets the value of the deploymentMode property.
     *
     * @param deploymentMode allowed object is {@link String }
     */
    public void setDeploymentMode(final String deploymentMode) {
        this.deploymentMode = deploymentMode;
    }

    /**
     * Gets the value of the punchOutOrderMessage property.
     *
     * @return possible object is {@link PunchOutOrderMessage }
     */
    public PunchOutOrderMessage getPunchOutOrderMessage() {
        return punchOutOrderMessage;
    }

    /**
     * Sets the value of the punchOutOrderMessage property.
     *
     * @param punchOutOrderMessage allowed object is {@link PunchOutOrderMessage }
     */
    public void setPunchOutOrderMessage(final PunchOutOrderMessage punchOutOrderMessage) {
        this.punchOutOrderMessage = punchOutOrderMessage;
    }

    /**
     * Gets the value of the status property.
     *
     * @return possible object is {@link Status }
     */
    public Status getStatus() {
        return status;
    }

    /**
     * Sets the value of the status property.
     *
     * @param status allowed object is {@link Status }
     */
    public void setStatus(final Status status) {
        this.status = status;
    }

    /**
     * <p>Java class for anonymous complex type.
     *
     * <p>The following schema fragment specifies the expected content contained within this class.
     *
     * <pre>
     * &lt;complexType&gt;
     *   &lt;simpleContent&gt;
     *     &lt;extension base="&lt;http://www.w3.org/2001/XMLSchema&gt;string"&gt;
     *       &lt;attribute name="code" type="{http://www.kuali.org/kfs/purap/types}statusCodeType" /&gt;
     *       &lt;attribute name="text" type="{http://www.kuali.org/kfs/purap/types}statusTextType" /&gt;
     *     &lt;/extension&gt;
     *   &lt;/simpleContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = "value")
    public static class Status {

        @XmlAttribute(name = "code")
        @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
        private String code;

        @XmlAttribute(name = "text")
        private String text;

        @XmlValue
        private String value;

        Status() {
        }

        public Status(final String code, final String text, final String value) {
            this.code = code;
            this.text = text;
            this.value = value;
        }

        /**
         * Gets the value of the code property.
         *
         * @return possible object is {@link String }
         */
        public String getCode() {
            return code;
        }

        /**
         * Sets the value of the code property.
         *
         * @param code allowed object is {@link String }
         */
        public void setCode(final String code) {
            this.code = code;
        }

        /**
         * Gets the value of the text property.
         *
         * @return possible object is {@link String }
         */
        public String getText() {
            return text;
        }

        /**
         * Sets the value of the text property.
         *
         * @param text allowed object is {@link String }
         */
        public void setText(final String text) {
            this.text = text;
        }

        /**
         * Gets the value of the value property.
         *
         * @return possible object is {@link String }
         */
        public String getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         *
         * @param value allowed object is {@link String }
         */
        public void setValue(final String value) {
            this.value = value;
        }
    }
}
