/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.util.MessageList;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.sys.service.UniversityDateService;

@ConfigureContext(session=UserNameFixture.khuntley)
public class PurchasingAccountsPayableDocumentBaseIntegTest
extends KualiIntegTestBase {
    PurchasingAccountsPayableDocument purapDoc;
    Integer currentFY;

    protected void setUp() throws Exception {
        super.setUp();
        KNSGlobalVariables.setMessageList((MessageList)new MessageList());
        this.purapDoc = new PurchaseOrderDocument();
        this.currentFY = ((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear();
    }

    protected void tearDown() throws Exception {
        this.purapDoc = null;
        super.tearDown();
    }

    public void testIsPostingYearNext_UseCurrent() {
        this.purapDoc.setPostingYear(this.currentFY);
        PurchasingAccountsPayableDocumentBaseIntegTest.assertFalse((boolean)this.purapDoc.isPostingYearNext());
    }

    public void testIsPostingYearNext_UseNext() {
        this.purapDoc.setPostingYear(Integer.valueOf(this.currentFY + 1));
        PurchasingAccountsPayableDocumentBaseIntegTest.assertTrue((boolean)this.purapDoc.isPostingYearNext());
    }

    public void testIsPostingYearNext_UsePast() {
        this.purapDoc.setPostingYear(Integer.valueOf(this.currentFY - 1));
        PurchasingAccountsPayableDocumentBaseIntegTest.assertFalse((boolean)this.purapDoc.isPostingYearNext());
    }

    public void testGetPostingYearNextOrCurrent_UseCurrent() {
        this.purapDoc.setPostingYear(this.currentFY);
        PurchasingAccountsPayableDocumentBaseIntegTest.assertEquals((Object)this.purapDoc.getPostingYearNextOrCurrent(), (Object)this.currentFY);
    }

    public void testGetPostingYearNextOrCurrent_UseNext() {
        Integer nextFY = this.currentFY + 1;
        this.purapDoc.setPostingYear(nextFY);
        PurchasingAccountsPayableDocumentBaseIntegTest.assertEquals((Object)this.purapDoc.getPostingYearNextOrCurrent(), (Object)nextFY);
    }

    public void testGetPostingYearNextOrCurrent_UsePast() {
        this.purapDoc.setPostingYear(Integer.valueOf(this.currentFY - 1));
        PurchasingAccountsPayableDocumentBaseIntegTest.assertEquals((Object)this.purapDoc.getPostingYearNextOrCurrent(), (Object)this.currentFY);
    }
}

