/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.purap.businessobject.PurApItemBase;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocumentBase;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderDocumentFixture;
import org.kuali.kfs.module.purap.fixture.RequisitionDocumentFixture;
import org.kuali.kfs.module.purap.fixture.SystemParameterBelowTheLineItemCMFixture;
import org.kuali.kfs.module.purap.fixture.SystemParameterBelowTheLineItemPaymentRequestFixture;
import org.kuali.kfs.module.purap.fixture.SystemParameterBelowTheLineItemPurchaseOrderFixture;
import org.kuali.kfs.module.purap.fixture.SystemParameterBelowTheLineItemRequisitionFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.parke)
public class SystemParameterBelowTheLineItemTypeIntegTest
extends KualiIntegTestBase {
    private ParameterService parameterService;

    protected void setUp() throws Exception {
        super.setUp();
        this.parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public final void testRequisitionExistingItemTypesAreValid() {
        RequisitionDocument requisitionWithValidBelowLineItems = SystemParameterBelowTheLineItemRequisitionFixture.REQ_VALID_BELOW_LINE_ITEMS.createRequisitionDocument();
        RequisitionDocument requisitionWithInvalidBelowLineItems = SystemParameterBelowTheLineItemRequisitionFixture.REQ_INVALID_BELOW_LINE_ITEMS.createRequisitionDocument();
        this.testExistingItemTypesAreValid(RequisitionDocument.class, (PurchasingAccountsPayableDocumentBase)requisitionWithValidBelowLineItems, (PurchasingAccountsPayableDocumentBase)requisitionWithInvalidBelowLineItems);
    }

    public final void testRequisitionAllowsNegative() {
        RequisitionDocument requisitionWithNoBelowLineItems = RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS.createRequisitionDocument();
        RequisitionDocument requisitionWithNegativeBelowLineItems = SystemParameterBelowTheLineItemRequisitionFixture.REQ_WITH_NEGATIVE_BELOW_LINE_ITEMS.createRequisitionDocument();
        this.testAllowsNegative(RequisitionDocument.class, (PurchasingAccountsPayableDocumentBase)requisitionWithNoBelowLineItems, (PurchasingAccountsPayableDocumentBase)requisitionWithNegativeBelowLineItems);
    }

    public final void testRequisitionAllowsPositive() {
        RequisitionDocument requisitionWithNoBelowLineItems = RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS.createRequisitionDocument();
        RequisitionDocument requisitionWithValidBelowLineItems = SystemParameterBelowTheLineItemRequisitionFixture.REQ_VALID_BELOW_LINE_ITEMS.createRequisitionDocument();
        this.testAllowsPositive(RequisitionDocument.class, (PurchasingAccountsPayableDocumentBase)requisitionWithValidBelowLineItems, (PurchasingAccountsPayableDocumentBase)requisitionWithNoBelowLineItems);
    }

    public final void testRequisitionAllowsZero() {
        RequisitionDocument requisitionWithZeroBelowLineItems = SystemParameterBelowTheLineItemRequisitionFixture.REQ_WITH_ZERO_BELOW_LINE_ITEMS.createRequisitionDocument();
        RequisitionDocument requisitionWithNoBelowLineItems = RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS.createRequisitionDocument();
        this.testAllowsZero(RequisitionDocument.class, (PurchasingAccountsPayableDocumentBase)requisitionWithZeroBelowLineItems, (PurchasingAccountsPayableDocumentBase)requisitionWithNoBelowLineItems);
    }

    public final void testRequisitionRequiringDescription() {
        RequisitionDocument requisitionWithBelowLineItemsWithoutDescription = SystemParameterBelowTheLineItemRequisitionFixture.REQ_WITH_BELOW_LINE_ITEMS_WITHOUT_DESCRIPTION.createRequisitionDocument();
        RequisitionDocument requisitionWithBelowLineItemsWithDescription = SystemParameterBelowTheLineItemRequisitionFixture.REQ_WITH_BELOW_LINE_ITEMS_WITH_DESCRIPTION.createRequisitionDocument();
        this.testRequiringDescription(RequisitionDocument.class, (PurchasingAccountsPayableDocumentBase)requisitionWithBelowLineItemsWithoutDescription, (PurchasingAccountsPayableDocumentBase)requisitionWithBelowLineItemsWithDescription);
    }

    public final void testPurchaseOrderExistingItemTypesAreValid() {
        PurchaseOrderDocument purchaseOrderWithValidBelowLineItems = SystemParameterBelowTheLineItemPurchaseOrderFixture.PO_VALID_BELOW_LINE_ITEMS.createPurchaseOrderDocument();
        PurchaseOrderDocument purchaseOrderWithInvalidBelowLineItems = SystemParameterBelowTheLineItemPurchaseOrderFixture.PO_INVALID_BELOW_LINE_ITEMS.createPurchaseOrderDocument();
        this.testExistingItemTypesAreValid(PurchaseOrderDocument.class, (PurchasingAccountsPayableDocumentBase)purchaseOrderWithValidBelowLineItems, (PurchasingAccountsPayableDocumentBase)purchaseOrderWithInvalidBelowLineItems);
    }

    public final void testPurchaseOrderAllowsNegative() {
        PurchaseOrderDocument purchaseOrderWithNoBelowLineItems = PurchaseOrderDocumentFixture.PO_ONLY_REQUIRED_FIELDS.createPurchaseOrderDocument();
        PurchaseOrderDocument purchaseOrderWithNegativeBelowLineItems = SystemParameterBelowTheLineItemPurchaseOrderFixture.PO_WITH_NEGATIVE_BELOW_LINE_ITEMS.createPurchaseOrderDocument();
        this.testAllowsNegative(PurchaseOrderDocument.class, (PurchasingAccountsPayableDocumentBase)purchaseOrderWithNoBelowLineItems, (PurchasingAccountsPayableDocumentBase)purchaseOrderWithNegativeBelowLineItems);
    }

    public final void testPurchaseOrderAllowsPositive() {
        PurchaseOrderDocument purchaseOrderWithValidBelowLineItems = SystemParameterBelowTheLineItemPurchaseOrderFixture.PO_VALID_BELOW_LINE_ITEMS.createPurchaseOrderDocument();
        PurchaseOrderDocument purchaseOrderWithNoBelowLineItems = PurchaseOrderDocumentFixture.PO_ONLY_REQUIRED_FIELDS.createPurchaseOrderDocument();
        this.testAllowsPositive(PurchaseOrderDocument.class, (PurchasingAccountsPayableDocumentBase)purchaseOrderWithValidBelowLineItems, (PurchasingAccountsPayableDocumentBase)purchaseOrderWithNoBelowLineItems);
    }

    public final void testPurchaseOrderAllowsZero() {
        PurchaseOrderDocument purchaseOrderWithZeroBelowLineItems = SystemParameterBelowTheLineItemPurchaseOrderFixture.PO_WITH_ZERO_BELOW_LINE_ITEMS.createPurchaseOrderDocument();
        PurchaseOrderDocument purchaseOrderWithNoBelowLineItems = PurchaseOrderDocumentFixture.PO_ONLY_REQUIRED_FIELDS.createPurchaseOrderDocument();
        this.testAllowsZero(PurchaseOrderDocument.class, (PurchasingAccountsPayableDocumentBase)purchaseOrderWithZeroBelowLineItems, (PurchasingAccountsPayableDocumentBase)purchaseOrderWithNoBelowLineItems);
    }

    public final void testPurchaseOrderRequiringDescription() {
        PurchaseOrderDocument purchaseOrderWithBelowLineItemsWithoutDescription = SystemParameterBelowTheLineItemPurchaseOrderFixture.PO_WITH_BELOW_LINE_ITEMS_WITHOUT_DESCRIPTION.createPurchaseOrderDocument();
        PurchaseOrderDocument purchaseOrderWithBelowLineItemsWithDescription = SystemParameterBelowTheLineItemPurchaseOrderFixture.PO_WITH_BELOW_LINE_ITEMS_WITH_DESCRIPTION.createPurchaseOrderDocument();
        this.testRequiringDescription(PurchaseOrderDocument.class, (PurchasingAccountsPayableDocumentBase)purchaseOrderWithBelowLineItemsWithoutDescription, (PurchasingAccountsPayableDocumentBase)purchaseOrderWithBelowLineItemsWithDescription);
    }

    @ConfigureContext(session=UserNameFixture.appleton)
    public final void testPaymentRequestExistingItemTypesAreValid() {
        PaymentRequestDocument paymentRequestWithValidBelowLineItems = SystemParameterBelowTheLineItemPaymentRequestFixture.PREQ_VALID_BELOW_LINE_ITEMS.createPaymentRequestDocument();
        PaymentRequestDocument paymentRequestWithInvalidBelowLineItems = SystemParameterBelowTheLineItemPaymentRequestFixture.PREQ_INVALID_BELOW_LINE_ITEMS.createPaymentRequestDocument();
        this.testExistingItemTypesAreValid(PaymentRequestDocument.class, (PurchasingAccountsPayableDocumentBase)paymentRequestWithValidBelowLineItems, (PurchasingAccountsPayableDocumentBase)paymentRequestWithInvalidBelowLineItems);
    }

    @ConfigureContext(session=UserNameFixture.appleton)
    public final void testPaymentRequestAllowsNegative() {
        PaymentRequestDocument paymentRequestWithValidNegativeBelowLineItems = SystemParameterBelowTheLineItemPaymentRequestFixture.PREQ_WITH_VALID_NEGATIVE_BELOW_LINE_ITEMS.createPaymentRequestDocument();
        PaymentRequestDocument paymentRequestWithInvalidNegativeBelowLineItems = SystemParameterBelowTheLineItemPaymentRequestFixture.PREQ_WITH_INVALID_NEGATIVE_BELOW_LINE_ITEMS.createPaymentRequestDocument();
        this.testAllowsNegative(PaymentRequestDocument.class, (PurchasingAccountsPayableDocumentBase)paymentRequestWithValidNegativeBelowLineItems, (PurchasingAccountsPayableDocumentBase)paymentRequestWithInvalidNegativeBelowLineItems);
    }

    @ConfigureContext(session=UserNameFixture.appleton)
    public final void testPaymentRequestAllowsPositive() {
        PaymentRequestDocument paymentRequestWithValidPositiveBelowLineItems = SystemParameterBelowTheLineItemPaymentRequestFixture.PREQ_WITH_VALID_POSITIVE_BELOW_LINE_ITEMS.createPaymentRequestDocument();
        PaymentRequestDocument paymentRequestWithInvalidPositiveBelowLineItems = SystemParameterBelowTheLineItemPaymentRequestFixture.PREQ_WITH_INVALID_POSITIVE_BELOW_LINE_ITEMS.createPaymentRequestDocument();
        this.testAllowsPositive(PaymentRequestDocument.class, (PurchasingAccountsPayableDocumentBase)paymentRequestWithValidPositiveBelowLineItems, (PurchasingAccountsPayableDocumentBase)paymentRequestWithInvalidPositiveBelowLineItems);
    }

    @ConfigureContext(session=UserNameFixture.appleton)
    public final void testPaymentRequestAllowsZero() {
        PaymentRequestDocument paymentRequestWithValidZeroBelowLineItems = SystemParameterBelowTheLineItemPaymentRequestFixture.PREQ_WITH_VALID_ZERO_BELOW_LINE_ITEMS.createPaymentRequestDocument();
        PaymentRequestDocument paymentRequestWithInvalidZeroBelowLineItems = SystemParameterBelowTheLineItemPaymentRequestFixture.PREQ_WITH_INVALID_ZERO_BELOW_LINE_ITEMS.createPaymentRequestDocument();
        this.testAllowsZero(PaymentRequestDocument.class, (PurchasingAccountsPayableDocumentBase)paymentRequestWithValidZeroBelowLineItems, (PurchasingAccountsPayableDocumentBase)paymentRequestWithInvalidZeroBelowLineItems);
    }

    @ConfigureContext(session=UserNameFixture.appleton)
    public final void testPaymentRequestRequiringDescription() {
        PaymentRequestDocument paymentRequestWithBelowLineItemsWithoutDescription = SystemParameterBelowTheLineItemPaymentRequestFixture.PREQ_WITH_BELOW_LINE_ITEMS_WITHOUT_DESCRIPTION.createPaymentRequestDocument();
        PaymentRequestDocument paymentRequestWithBelowLineItemsWithDescription = SystemParameterBelowTheLineItemPaymentRequestFixture.PREQ_WITH_BELOW_LINE_ITEMS_WITH_DESCRIPTION.createPaymentRequestDocument();
        this.testRequiringDescription(PaymentRequestDocument.class, (PurchasingAccountsPayableDocumentBase)paymentRequestWithBelowLineItemsWithoutDescription, (PurchasingAccountsPayableDocumentBase)paymentRequestWithBelowLineItemsWithDescription);
    }

    @ConfigureContext(session=UserNameFixture.appleton)
    public final void testCreditMemoExistingItemTypesAreValid() {
        VendorCreditMemoDocument creditMemoWithValidBelowLineItems = SystemParameterBelowTheLineItemCMFixture.CM_VALID_BELOW_LINE_ITEMS.createCreditMemoDocument();
        VendorCreditMemoDocument creditMemoWithInvalidBelowLineItems = SystemParameterBelowTheLineItemCMFixture.CM_INVALID_BELOW_LINE_ITEMS.createCreditMemoDocument();
        this.testExistingItemTypesAreValid(VendorCreditMemoDocument.class, (PurchasingAccountsPayableDocumentBase)creditMemoWithValidBelowLineItems, (PurchasingAccountsPayableDocumentBase)creditMemoWithInvalidBelowLineItems);
    }

    @ConfigureContext(session=UserNameFixture.appleton)
    public final void testCreditMemoAllowsNegative() {
        VendorCreditMemoDocument creditMemoWithValidNegativeBelowLineItems = SystemParameterBelowTheLineItemCMFixture.CM_VALID_NEGATIVE_BELOW_LINE_ITEMS.createCreditMemoDocument();
        VendorCreditMemoDocument creditMemoWithInvalidNegativeBelowLineItems = SystemParameterBelowTheLineItemCMFixture.CM_INVALID_NEGATIVE_BELOW_LINE_ITEMS.createCreditMemoDocument();
        this.testAllowsNegative(VendorCreditMemoDocument.class, (PurchasingAccountsPayableDocumentBase)creditMemoWithValidNegativeBelowLineItems, (PurchasingAccountsPayableDocumentBase)creditMemoWithInvalidNegativeBelowLineItems);
    }

    @ConfigureContext(session=UserNameFixture.appleton)
    public final void testCreditMemoAllowsPositive() {
        VendorCreditMemoDocument creditMemoWithValidPositiveBelowLineItems = SystemParameterBelowTheLineItemCMFixture.CM_VALID_POSITIVE_BELOW_LINE_ITEMS.createCreditMemoDocument();
        VendorCreditMemoDocument creditMemoWithInvalidPositiveBelowLineItems = SystemParameterBelowTheLineItemCMFixture.CM_INVALID_POSITIVE_BELOW_LINE_ITEMS.createCreditMemoDocument();
        this.testAllowsPositive(VendorCreditMemoDocument.class, (PurchasingAccountsPayableDocumentBase)creditMemoWithValidPositiveBelowLineItems, (PurchasingAccountsPayableDocumentBase)creditMemoWithInvalidPositiveBelowLineItems);
    }

    @ConfigureContext(session=UserNameFixture.appleton)
    public final void testCreditMemoAllowsZero() {
        VendorCreditMemoDocument creditMemoWithValidZeroBelowLineItems = SystemParameterBelowTheLineItemCMFixture.CM_VALID_ZERO_BELOW_LINE_ITEMS.createCreditMemoDocument();
        VendorCreditMemoDocument creditMemoWithInvalidZeroBelowLineItems = SystemParameterBelowTheLineItemCMFixture.CM_INVALID_ZERO_BELOW_LINE_ITEMS.createCreditMemoDocument();
        this.testAllowsZero(VendorCreditMemoDocument.class, (PurchasingAccountsPayableDocumentBase)creditMemoWithValidZeroBelowLineItems, (PurchasingAccountsPayableDocumentBase)creditMemoWithInvalidZeroBelowLineItems);
    }

    @ConfigureContext(session=UserNameFixture.appleton)
    public final void testCreditMemoRequiringDescription() {
        VendorCreditMemoDocument creditMemoWithBelowLineItemsWithoutDescription = SystemParameterBelowTheLineItemCMFixture.CM_WITH_BELOW_LINE_ITEMS_WITHOUT_DESCRIPTION.createCreditMemoDocument();
        VendorCreditMemoDocument creditMemoWithBelowLineItemsWithDescription = SystemParameterBelowTheLineItemCMFixture.CM_WITH_BELOW_LINE_ITEMS_WITH_DESCRIPTION.createCreditMemoDocument();
        this.testRequiringDescription(VendorCreditMemoDocument.class, (PurchasingAccountsPayableDocumentBase)creditMemoWithBelowLineItemsWithoutDescription, (PurchasingAccountsPayableDocumentBase)creditMemoWithBelowLineItemsWithDescription);
    }

    private void testExistingItemTypesAreValid(Class documentClass, PurchasingAccountsPayableDocumentBase validDocument, PurchasingAccountsPayableDocumentBase invalidDocument) {
        String theItemType;
        ArrayList validTypes = new ArrayList(this.parameterService.getParameterValuesAsString(documentClass, "ADDITIONAL_CHARGES_ITEM_TYPES"));
        for (PurApItemBase theItem : validDocument.getItems()) {
            theItemType = theItem.getItemTypeCode();
            SystemParameterBelowTheLineItemTypeIntegTest.assertTrue((boolean)validTypes.contains(theItemType));
        }
        for (PurApItemBase theItem : invalidDocument.getItems()) {
            theItemType = theItem.getItemTypeCode();
            SystemParameterBelowTheLineItemTypeIntegTest.assertFalse((boolean)validTypes.contains(theItemType));
        }
    }

    private void testAllowsNegative(Class documentClass, PurchasingAccountsPayableDocumentBase validDocument, PurchasingAccountsPayableDocumentBase invalidDocument) {
        String theItemType;
        ArrayList allowNegativeTypes = new ArrayList(this.parameterService.getParameterValuesAsString(documentClass, "ITEM_TYPES_ALLOWING_NEGATIVE"));
        for (PurApItemBase theItem : validDocument.getItems()) {
            if (!theItem.getTotalAmount().isNegative() || !theItem.getItemType().isAdditionalChargeIndicator()) continue;
            theItemType = theItem.getItemTypeCode();
            SystemParameterBelowTheLineItemTypeIntegTest.assertTrue((boolean)allowNegativeTypes.contains(theItemType));
        }
        for (PurApItemBase theItem : invalidDocument.getItems()) {
            if (!theItem.getTotalAmount().isNegative() || !theItem.getItemType().isAdditionalChargeIndicator()) continue;
            theItemType = theItem.getItemTypeCode();
            SystemParameterBelowTheLineItemTypeIntegTest.assertFalse((boolean)allowNegativeTypes.contains(theItemType));
        }
    }

    private void testAllowsPositive(Class documentClass, PurchasingAccountsPayableDocumentBase validDocument, PurchasingAccountsPayableDocumentBase invalidDocument) {
        String theItemType;
        ArrayList allowPositiveTypes = new ArrayList(this.parameterService.getParameterValuesAsString(documentClass, "ITEM_TYPES_ALLOWING_POSITIVE"));
        for (PurApItemBase theItem : validDocument.getItems()) {
            if (!theItem.getTotalAmount().isPositive() || !theItem.getItemType().isAdditionalChargeIndicator()) continue;
            theItemType = theItem.getItemTypeCode();
            SystemParameterBelowTheLineItemTypeIntegTest.assertTrue((boolean)allowPositiveTypes.contains(theItemType));
        }
        for (PurApItemBase theItem : invalidDocument.getItems()) {
            if (!theItem.getTotalAmount().isPositive() || !theItem.getItemType().isAdditionalChargeIndicator()) continue;
            theItemType = theItem.getItemTypeCode();
            SystemParameterBelowTheLineItemTypeIntegTest.assertFalse((boolean)allowPositiveTypes.contains(theItemType));
        }
    }

    private void testAllowsZero(Class documentClass, PurchasingAccountsPayableDocumentBase validDocument, PurchasingAccountsPayableDocumentBase invalidDocument) {
        String theItemType;
        ArrayList allowZeroTypes = new ArrayList(this.parameterService.getParameterValuesAsString(documentClass, "ITEM_TYPES_ALLOWING_ZERO"));
        for (PurApItemBase theItem : validDocument.getItems()) {
            if (!theItem.getTotalAmount().isZero() || !theItem.getItemType().isAdditionalChargeIndicator()) continue;
            theItemType = theItem.getItemTypeCode();
            SystemParameterBelowTheLineItemTypeIntegTest.assertTrue((boolean)allowZeroTypes.contains(theItemType));
        }
        for (PurApItemBase theItem : invalidDocument.getItems()) {
            if (!theItem.getTotalAmount().isZero() || !theItem.getItemType().isAdditionalChargeIndicator()) continue;
            theItemType = theItem.getItemTypeCode();
            SystemParameterBelowTheLineItemTypeIntegTest.assertFalse((boolean)allowZeroTypes.contains(theItemType));
        }
    }

    private void testRequiringDescription(Class documentClass, PurchasingAccountsPayableDocumentBase docBlankDesc, PurchasingAccountsPayableDocumentBase docItemTypesRequiredDesc) {
        String theItemType;
        ArrayList requiringDescriptionTypes = new ArrayList(this.parameterService.getParameterValuesAsString(documentClass, "ITEM_TYPES_REQUIRING_USER_ENTERED_DESCRIPTION"));
        for (PurApItemBase theItem : docBlankDesc.getItems()) {
            theItemType = theItem.getItemTypeCode();
            if (!StringUtils.isBlank((CharSequence)theItem.getItemDescription())) continue;
            SystemParameterBelowTheLineItemTypeIntegTest.assertFalse((boolean)requiringDescriptionTypes.contains(theItemType));
        }
        for (PurApItemBase theItem : docItemTypesRequiredDesc.getItems()) {
            theItemType = theItem.getItemTypeCode();
            if (!requiringDescriptionTypes.contains(theItemType)) continue;
            SystemParameterBelowTheLineItemTypeIntegTest.assertFalse((boolean)StringUtils.isBlank((CharSequence)theItem.getItemDescription()));
        }
    }
}

