/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.authorization;

import java.util.ArrayList;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocumentBase;
import org.kuali.kfs.module.purap.document.authorization.PurapAccountingLineAuthorizer;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class PurapAccountingLineAuthorizerTest {
    private PurapAccountingLineAuthorizer cut;

    PurapAccountingLineAuthorizerTest() {
    }

    @BeforeEach
    void setup() {
        this.cut = new PurapAccountingLineAuthorizer();
    }

    @Test
    void findTheItemForAccountingLine_notPurApDoc_Null(@Mock(stubOnly=true) AccountingDocument accountingDocMock) {
        AccountingLine accountingLine = null;
        PurApItem purApItem = this.cut.findTheItemForAccountingLine(accountingDocMock, accountingLine);
        Assertions.assertNull((Object)purApItem);
    }

    @Test
    void findTheItemForAccountingLine_noItems_Null(@Mock(stubOnly=true) PurchasingAccountsPayableDocumentBase accountingDocMock) {
        AccountingLine accountingLine = null;
        Mockito.when((Object)accountingDocMock.getItems()).thenReturn(Collections.emptyList());
        PurApItem purApItem = this.cut.findTheItemForAccountingLine((AccountingDocument)accountingDocMock, accountingLine);
        Assertions.assertNull((Object)purApItem);
    }

    @Test
    void findTheItemForAccountingLine_noAccountingLinesInItems_Null(@Mock(stubOnly=true) AccountingLine accountingLineMock, @Mock(stubOnly=true) PurchasingAccountsPayableDocumentBase accountingDocMock, @Mock(stubOnly=true) PurApItem purApItem1Mock, @Mock(stubOnly=true) PurApItem purApItem2Mock) {
        ArrayList<PurApItem> purApItems = new ArrayList<PurApItem>();
        purApItems.add(purApItem1Mock);
        purApItems.add(purApItem2Mock);
        Mockito.when((Object)accountingDocMock.getItems()).thenReturn(purApItems);
        PurApItem purApItem = this.cut.findTheItemForAccountingLine((AccountingDocument)accountingDocMock, accountingLineMock);
        Assertions.assertNull((Object)purApItem);
    }

    @Test
    void findTheItemForAccountingLine_noMatchingAccountingLine_Null(@Mock(stubOnly=true) AccountingLine accountingLineMock, @Mock(stubOnly=true) PurchasingAccountsPayableDocumentBase accountingDocMock, @Mock(stubOnly=true) PurApItem purApItem1Mock, @Mock(stubOnly=true) PurApItem purApItem2Mock, @Mock(stubOnly=true) PurApAccountingLine purApAccountingLine1Mock, @Mock(stubOnly=true) PurApAccountingLine purApAccountingLine2Mock) {
        ArrayList<PurApItem> purApItems = new ArrayList<PurApItem>();
        ArrayList<PurApAccountingLine> sourceAccountingLines = new ArrayList<PurApAccountingLine>();
        sourceAccountingLines.add(purApAccountingLine1Mock);
        sourceAccountingLines.add(purApAccountingLine2Mock);
        Mockito.when((Object)purApItem1Mock.getSourceAccountingLines()).thenReturn(sourceAccountingLines);
        purApItems.add(purApItem1Mock);
        purApItems.add(purApItem2Mock);
        Mockito.when((Object)accountingDocMock.getItems()).thenReturn(purApItems);
        PurApItem purApItem = this.cut.findTheItemForAccountingLine((AccountingDocument)accountingDocMock, accountingLineMock);
        Assertions.assertNull((Object)purApItem);
    }

    @Test
    void findTheItemForAccountingLine_matchingAccountingLine_Returned(@Mock(stubOnly=true) PurApAccountingLine accountingLine1Mock, @Mock(stubOnly=true) PurApAccountingLine accountingLine2Mock, @Mock(stubOnly=true) PurchasingAccountsPayableDocumentBase accountingDocMock, @Mock(stubOnly=true) PurApItem purApItem1Mock, @Mock(stubOnly=true) PurApItem purApItem2Mock) {
        ArrayList<PurApItem> purApItems = new ArrayList<PurApItem>();
        ArrayList<PurApAccountingLine> sourceAccountingLines = new ArrayList<PurApAccountingLine>();
        sourceAccountingLines.add(accountingLine1Mock);
        sourceAccountingLines.add(accountingLine2Mock);
        Mockito.when((Object)purApItem1Mock.getSourceAccountingLines()).thenReturn(sourceAccountingLines);
        purApItems.add(purApItem1Mock);
        purApItems.add(purApItem2Mock);
        Mockito.when((Object)accountingDocMock.getItems()).thenReturn(purApItems);
        PurApItem purApItem = this.cut.findTheItemForAccountingLine((AccountingDocument)accountingDocMock, (AccountingLine)accountingLine1Mock);
        Assertions.assertEquals(purApItems.get(0), (Object)purApItem);
    }
}

