/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.authorization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.document.DocumentPresentationControllerBase;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderAmendmentDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.authorization.PurchaseOrderAmendmentDocumentPresentationController;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.document.authorization.FinancialSystemTransactionalDocumentPresentationControllerBase;
import org.kuali.kfs.sys.service.BankService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class PurchaseOrderAmendmentDocumentPresentationControllerTest {
    private PurchaseOrderAmendmentDocumentPresentationController cut;
    @Mock(stubOnly=true)
    private BankService bankSvcMock;
    @Mock(stubOnly=true)
    private ParameterService parameterSvcMock;
    @Mock(stubOnly=true)
    private PurapService purapSvcMock;
    private Set<String> expectedEditModes;

    PurchaseOrderAmendmentDocumentPresentationControllerTest() {
    }

    @BeforeEach
    void setup() {
        this.setupBaseExpectedEditModesFromSuperclassCalls();
        this.cut = new PurchaseOrderAmendmentDocumentPresentationController();
        this.cut.setPurapService(this.purapSvcMock);
        FinancialSystemTransactionalDocumentPresentationControllerBase.setBankService((BankService)this.bankSvcMock);
        DocumentPresentationControllerBase.setParameterService((ParameterService)this.parameterSvcMock);
    }

    private void setupBaseExpectedEditModesFromSuperclassCalls() {
        this.expectedEditModes = new HashSet<String>(Arrays.asList("lockVendorEntry", "amountTotaling", "assignSensitiveData"));
    }

    private static void setupPoDocMock(DocumentHeader finSysDocHeaderMock, PurchaseOrderAmendmentDocument poDocMock, WorkflowDocument workflowDocMock) {
        Mockito.when((Object)finSysDocHeaderMock.getWorkflowDocument()).thenReturn((Object)workflowDocMock);
        Mockito.when((Object)poDocMock.getDocumentHeader()).thenReturn((Object)finSysDocHeaderMock);
    }

    @Test
    void getEditModes_NothingAddedToBaseEditModes(@Mock(stubOnly=true) DocumentHeader finSysDocHeaderMock, @Mock(stubOnly=true) PurchaseOrderAmendmentDocument poDocMock, @Mock(stubOnly=true) WorkflowDocument workflowDocMock) {
        PurchaseOrderAmendmentDocumentPresentationControllerTest.setupPoDocMock(finSysDocHeaderMock, poDocMock, workflowDocMock);
        Set editModes = this.cut.getEditModes((Document)poDocMock);
        Assertions.assertEquals(this.expectedEditModes, (Object)editModes);
    }

    @Test
    void getEditModes_AppdocChangeInProcess_NotInitiatedSavedOrCompletionRequested_NothingAddedToBaseEditModes(@Mock(stubOnly=true) DocumentHeader finSysDocHeaderMock, @Mock(stubOnly=true) PurchaseOrderAmendmentDocument poDocMock, @Mock(stubOnly=true) WorkflowDocument workflowDocMock) {
        PurchaseOrderAmendmentDocumentPresentationControllerTest.setupPoDocMock(finSysDocHeaderMock, poDocMock, workflowDocMock);
        Mockito.when((Object)poDocMock.getApplicationDocumentStatus()).thenReturn((Object)"Change in Process");
        Set editModes = this.cut.getEditModes((Document)poDocMock);
        Assertions.assertEquals(this.expectedEditModes, (Object)editModes);
    }

    @Test
    void getEditModes_AppdocChangeInProcess_Initiated_AmendmentEntryEditModeAdded(@Mock(stubOnly=true) DocumentHeader finSysDocHeaderMock, @Mock(stubOnly=true) PurchaseOrderAmendmentDocument poDocMock, @Mock(stubOnly=true) WorkflowDocument workflowDocMock) {
        PurchaseOrderAmendmentDocumentPresentationControllerTest.setupPoDocMock(finSysDocHeaderMock, poDocMock, workflowDocMock);
        this.expectedEditModes.add("amendmentEntry");
        Mockito.when((Object)poDocMock.getApplicationDocumentStatus()).thenReturn((Object)"Change in Process");
        Mockito.when((Object)workflowDocMock.isInitiated()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)poDocMock);
        Assertions.assertEquals(this.expectedEditModes, (Object)editModes);
    }

    @Test
    void getEditModes_AppdocChangeInProcess_Saved_AmendmentEntryEditModeAdded(@Mock(stubOnly=true) DocumentHeader finSysDocHeaderMock, @Mock(stubOnly=true) PurchaseOrderAmendmentDocument poDocMock, @Mock(stubOnly=true) WorkflowDocument workflowDocMock) {
        PurchaseOrderAmendmentDocumentPresentationControllerTest.setupPoDocMock(finSysDocHeaderMock, poDocMock, workflowDocMock);
        this.expectedEditModes.add("amendmentEntry");
        Mockito.when((Object)poDocMock.getApplicationDocumentStatus()).thenReturn((Object)"Change in Process");
        Mockito.when((Object)workflowDocMock.isSaved()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)poDocMock);
        Assertions.assertEquals(this.expectedEditModes, (Object)editModes);
    }

    @Test
    void getEditModes_AppdocChangeInProcess_CompletionRequested_AmendmentEntryEditModeAdded(@Mock(stubOnly=true) DocumentHeader finSysDocHeaderMock, @Mock(stubOnly=true) PurchaseOrderAmendmentDocument poDocMock, @Mock(stubOnly=true) WorkflowDocument workflowDocMock) {
        PurchaseOrderAmendmentDocumentPresentationControllerTest.setupPoDocMock(finSysDocHeaderMock, poDocMock, workflowDocMock);
        this.expectedEditModes.add("amendmentEntry");
        Mockito.when((Object)poDocMock.getApplicationDocumentStatus()).thenReturn((Object)"Change in Process");
        Mockito.when((Object)workflowDocMock.isCompletionRequested()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)poDocMock);
        Assertions.assertEquals(this.expectedEditModes, (Object)editModes);
    }

    @Test
    void getEditModes_AppdocAwaitNewUnorderedItemReview_AmendmentEntryEditModeAdded(@Mock(stubOnly=true) DocumentHeader finSysDocHeaderMock, @Mock(stubOnly=true) PurchaseOrderAmendmentDocument poDocMock, @Mock(stubOnly=true) WorkflowDocument workflowDocMock) {
        PurchaseOrderAmendmentDocumentPresentationControllerTest.setupPoDocMock(finSysDocHeaderMock, poDocMock, workflowDocMock);
        this.expectedEditModes.add("amendmentEntry");
        Mockito.when((Object)poDocMock.getApplicationDocumentStatus()).thenReturn((Object)"Awaiting New Unordered Item Review");
        Set editModes = this.cut.getEditModes((Document)poDocMock);
        Assertions.assertEquals(this.expectedEditModes, (Object)editModes);
    }

    @Test
    void getEditModes_StoppedInNewUnorderedItemsRouteNode_UnorderedItemAccountEntryEditModeAdded(@Mock(stubOnly=true) DocumentHeader finSysDocHeaderMock, @Mock(stubOnly=true) PurchaseOrderAmendmentDocument poDocMock, @Mock(stubOnly=true) WorkflowDocument workflowDocMock) {
        PurchaseOrderAmendmentDocumentPresentationControllerTest.setupPoDocMock(finSysDocHeaderMock, poDocMock, workflowDocMock);
        this.expectedEditModes.add("unorderedItemAccountEntry");
        Mockito.when((Object)this.purapSvcMock.isDocumentStoppedInRouteNode((PurchasingAccountsPayableDocument)poDocMock, "New Unordered Items")).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)poDocMock);
        Assertions.assertEquals(this.expectedEditModes, (Object)editModes);
    }

    @Test
    void getEditModes_HasAboveTheLineItems_AllEditable_NothingAddedToBaseEditModes(@Mock(stubOnly=true) DocumentHeader finSysDocHeaderMock, @Mock(stubOnly=true) PurchaseOrderAmendmentDocument poDocMock, @Mock(stubOnly=true) WorkflowDocument workflowDocMock) {
        PurchaseOrderAmendmentDocumentPresentationControllerTest.setupPoDocMock(finSysDocHeaderMock, poDocMock, workflowDocMock);
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        items.add(PurchaseOrderAmendmentDocumentPresentationControllerTest.buildAboveTheLinePoItem(true));
        items.add(PurchaseOrderAmendmentDocumentPresentationControllerTest.buildAboveTheLinePoItem(true));
        Mockito.when((Object)poDocMock.getItems()).thenReturn(items);
        Set editModes = this.cut.getEditModes((Document)poDocMock);
        Assertions.assertEquals(this.expectedEditModes, (Object)editModes);
    }

    private static PurApItem buildAboveTheLinePoItem(boolean editable) {
        PurchaseOrderItem poItem = new PurchaseOrderItem();
        ItemType itemType = new ItemType();
        itemType.setItemTypeCode("ITEM");
        poItem.setItemType(itemType);
        poItem.getSourceAccountingLines().add(new PurchaseOrderAccount());
        poItem.getSourceAccountingLines().add(new PurchaseOrderAccount());
        poItem.setItemActiveIndicator(editable);
        return poItem;
    }

    @Test
    void getEditModes_HasAboveTheLineItems_OneEditable_DisableRemoveAccountsEditModeAddedToBaseEditModes(@Mock(stubOnly=true) DocumentHeader finSysDocHeaderMock, @Mock(stubOnly=true) PurchaseOrderAmendmentDocument poDocMock, @Mock(stubOnly=true) WorkflowDocument workflowDocMock) {
        PurchaseOrderAmendmentDocumentPresentationControllerTest.setupPoDocMock(finSysDocHeaderMock, poDocMock, workflowDocMock);
        this.expectedEditModes.add("disableRemoveAccounts");
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        items.add(PurchaseOrderAmendmentDocumentPresentationControllerTest.buildAboveTheLinePoItem(true));
        items.add(PurchaseOrderAmendmentDocumentPresentationControllerTest.buildAboveTheLinePoItem(false));
        Mockito.when((Object)poDocMock.getItems()).thenReturn(items);
        Set editModes = this.cut.getEditModes((Document)poDocMock);
        Assertions.assertEquals(this.expectedEditModes, (Object)editModes);
    }

    @Test
    void getEditModes_HasAboveTheLineItems_NoneEditable_DisableRemoveAccountsEditModeAddedToBaseEditModes(@Mock(stubOnly=true) DocumentHeader finSysDocHeaderMock, @Mock(stubOnly=true) PurchaseOrderAmendmentDocument poDocMock, @Mock(stubOnly=true) WorkflowDocument workflowDocMock) {
        PurchaseOrderAmendmentDocumentPresentationControllerTest.setupPoDocMock(finSysDocHeaderMock, poDocMock, workflowDocMock);
        this.expectedEditModes.add("disableRemoveAccounts");
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        items.add(PurchaseOrderAmendmentDocumentPresentationControllerTest.buildAboveTheLinePoItem(false));
        items.add(PurchaseOrderAmendmentDocumentPresentationControllerTest.buildAboveTheLinePoItem(false));
        Mockito.when((Object)poDocMock.getItems()).thenReturn(items);
        Set editModes = this.cut.getEditModes((Document)poDocMock);
        Assertions.assertEquals(this.expectedEditModes, (Object)editModes);
    }
}

