/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.authorization;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.kew.api.KewApiServiceLocator;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kew.api.document.DocumentStatus;
import org.kuali.kfs.kew.api.document.WorkflowDocumentService;
import org.kuali.kfs.kim.api.permission.PermissionService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.bo.DataObjectAuthorizerBase;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.authorization.RequisitionDocumentAuthorizer;
import org.kuali.kfs.module.purap.service.SensitiveDataService;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.context.SpringContext;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class RequisitionDocumentAuthorizerTest {
    private static final String PRINCIPAL_ID = "4004609468";
    private RequisitionDocumentAuthorizer cut;
    @Mock(stubOnly=true)
    private DocumentHeader documentHeaderMock;
    @Mock(stubOnly=true)
    private PermissionService permissionSvcMock;
    @Mock(stubOnly=true)
    private Person userMock;
    @Mock(stubOnly=true)
    private RequisitionDocument requisitionDocument;
    @Mock(stubOnly=true)
    private SensitiveDataService sensitiveDataSvcMock;
    @Mock(stubOnly=true)
    private WorkflowDocument workflowDocumentMock;
    @Mock(stubOnly=true)
    private WorkflowDocumentService workflowDocumentSvcMock;

    RequisitionDocumentAuthorizerTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.workflowDocumentMock.getStatus()).thenReturn((Object)DocumentStatus.ENROUTE);
        Mockito.when((Object)this.documentHeaderMock.getWorkflowDocument()).thenReturn((Object)this.workflowDocumentMock);
        Mockito.when((Object)this.requisitionDocument.getDocumentHeader()).thenReturn((Object)this.documentHeaderMock);
        Mockito.when((Object)this.requisitionDocument.isDocumentStoppedInRouteNode("Commodity")).thenReturn((Object)true);
        this.cut = new RequisitionDocumentAuthorizer();
        DataObjectAuthorizerBase.setPermissionService((PermissionService)this.permissionSvcMock);
    }

    @AfterEach
    void tearDown() {
        DataObjectAuthorizerBase.setPermissionService(null);
    }

    @Test
    void getEditModes_NotComodityReviewNode() {
        Set updatedEditModes;
        HashSet<String> editModes = new HashSet<String>();
        editModes.add("restrictFullEntry");
        try (MockedStatic kewApiServiceLocatorStaticMock = Mockito.mockStatic(KewApiServiceLocator.class);
             MockedStatic kradUtilsMockedStatic = Mockito.mockStatic(KRADUtils.class);){
            kewApiServiceLocatorStaticMock.when(KewApiServiceLocator::getWorkflowDocumentService).thenReturn((Object)this.workflowDocumentSvcMock);
            kradUtilsMockedStatic.when(() -> KRADUtils.getNamespaceCode(RequisitionDocument.class)).thenReturn((Object)"KFS-PURAP");
            updatedEditModes = this.cut.getEditModes((Document)this.requisitionDocument, this.userMock, editModes);
        }
        Assertions.assertEquals((int)1, (int)updatedEditModes.size());
        Assertions.assertTrue((boolean)updatedEditModes.contains("restrictFullEntry"));
    }

    @Test
    void getEditModes_CommodityReviewNode_NoItems() {
        Set updatedEditModes;
        Set<String> editModes = RequisitionDocumentAuthorizerTest.setupCommodityReviewEditModes();
        try (MockedStatic kewApiServiceLocatorStaticMock = Mockito.mockStatic(KewApiServiceLocator.class);
             MockedStatic kradUtilsMockedStatic = Mockito.mockStatic(KRADUtils.class);){
            kewApiServiceLocatorStaticMock.when(KewApiServiceLocator::getWorkflowDocumentService).thenReturn((Object)this.workflowDocumentSvcMock);
            kradUtilsMockedStatic.when(() -> KRADUtils.getNamespaceCode(RequisitionDocument.class)).thenReturn((Object)"KFS-PURAP");
            updatedEditModes = this.cut.getEditModes((Document)this.requisitionDocument, this.userMock, editModes);
        }
        Assertions.assertEquals((int)2, (int)updatedEditModes.size());
        Assertions.assertTrue((boolean)updatedEditModes.contains("restrictFullEntry"));
        Assertions.assertTrue((boolean)updatedEditModes.contains("enableCommodityCode"));
    }

    private static Set<String> setupCommodityReviewEditModes() {
        HashSet<String> editModes = new HashSet<String>();
        editModes.add("restrictFullEntry");
        editModes.add("enableCommodityCode");
        editModes.add("allowCapitalAssetEdit");
        return editModes;
    }

    @Test
    void getEditModes_CommodityReviewNode_ItemsWithoutCommodityCodes() {
        Set updatedEditModes;
        Set<String> editModes = RequisitionDocumentAuthorizerTest.setupCommodityReviewEditModes();
        this.setupPurApItems(null);
        try (MockedStatic kewApiServiceLocatorStaticMock = Mockito.mockStatic(KewApiServiceLocator.class);
             MockedStatic kradUtilsMockedStatic = Mockito.mockStatic(KRADUtils.class);){
            kewApiServiceLocatorStaticMock.when(KewApiServiceLocator::getWorkflowDocumentService).thenReturn((Object)this.workflowDocumentSvcMock);
            kradUtilsMockedStatic.when(() -> KRADUtils.getNamespaceCode(RequisitionDocument.class)).thenReturn((Object)"KFS-PURAP");
            updatedEditModes = this.cut.getEditModes((Document)this.requisitionDocument, this.userMock, editModes);
        }
        Assertions.assertEquals((int)2, (int)updatedEditModes.size());
        Assertions.assertTrue((boolean)updatedEditModes.contains("restrictFullEntry"));
        Assertions.assertTrue((boolean)updatedEditModes.contains("enableCommodityCode"));
    }

    @Test
    void getEditModes_CommodityReviewNode_ItemsWithCommodityCodes_NoPermission() {
        Set updatedEditModes;
        Mockito.when((Object)this.userMock.getPrincipalId()).thenReturn((Object)PRINCIPAL_ID);
        Set<String> editModes = RequisitionDocumentAuthorizerTest.setupCommodityReviewEditModes();
        this.setupPurApItems("11");
        try (MockedStatic kewApiServiceLocatorStaticMock = Mockito.mockStatic(KewApiServiceLocator.class);
             MockedStatic kradUtilsMockedStatic = Mockito.mockStatic(KRADUtils.class);
             MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            kewApiServiceLocatorStaticMock.when(KewApiServiceLocator::getWorkflowDocumentService).thenReturn((Object)this.workflowDocumentSvcMock);
            kradUtilsMockedStatic.when(() -> KRADUtils.getNamespaceCode(RequisitionDocument.class)).thenReturn((Object)"KFS-PURAP");
            springContextMockedStatic.when(() -> SpringContext.getBean(SensitiveDataService.class)).thenReturn((Object)this.sensitiveDataSvcMock);
            updatedEditModes = this.cut.getEditModes((Document)this.requisitionDocument, this.userMock, editModes);
        }
        Assertions.assertEquals((int)2, (int)updatedEditModes.size());
        Assertions.assertTrue((boolean)updatedEditModes.contains("restrictFullEntry"));
        Assertions.assertTrue((boolean)updatedEditModes.contains("enableCommodityCode"));
    }

    private void setupPurApItems(String purchasingCommodityCode) {
        ArrayList<RequisitionItem> purApItems = new ArrayList<RequisitionItem>();
        RequisitionItem requisitionItemWithCommodityCode = new RequisitionItem();
        requisitionItemWithCommodityCode.setPurchasingCommodityCode(purchasingCommodityCode);
        purApItems.add(requisitionItemWithCommodityCode);
        RequisitionItem requisitionItemWithoutCommodityCode = new RequisitionItem();
        purApItems.add(requisitionItemWithoutCommodityCode);
        Mockito.when((Object)this.requisitionDocument.getItems()).thenReturn(purApItems);
    }

    @Test
    void getEditModes_CommodityReviewNode_ItemsWithCommodityCodes_HasPermission() {
        Set updatedEditModes;
        Mockito.when((Object)this.userMock.getPrincipalId()).thenReturn((Object)PRINCIPAL_ID);
        Set<String> editModes = RequisitionDocumentAuthorizerTest.setupCommodityReviewEditModes();
        this.setupPurApItems("11");
        Mockito.when((Object)this.permissionSvcMock.isAuthorizedByTemplate((String)ArgumentMatchers.eq((Object)PRINCIPAL_ID), (String)ArgumentMatchers.eq((Object)KFSConstants.PermissionTemplate.MODIFY_ACCOUNTING_LINES.namespace), (String)ArgumentMatchers.eq((Object)KFSConstants.PermissionTemplate.MODIFY_ACCOUNTING_LINES.name), (Map)ArgumentMatchers.any(), (Map)ArgumentMatchers.any())).thenReturn((Object)true);
        try (MockedStatic kewApiServiceLocatorStaticMock = Mockito.mockStatic(KewApiServiceLocator.class);
             MockedStatic kradUtilsMockedStatic = Mockito.mockStatic(KRADUtils.class);
             MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            kewApiServiceLocatorStaticMock.when(KewApiServiceLocator::getWorkflowDocumentService).thenReturn((Object)this.workflowDocumentSvcMock);
            kradUtilsMockedStatic.when(() -> KRADUtils.getNamespaceCode(RequisitionDocument.class)).thenReturn((Object)"KFS-PURAP");
            springContextMockedStatic.when(() -> SpringContext.getBean(SensitiveDataService.class)).thenReturn((Object)this.sensitiveDataSvcMock);
            updatedEditModes = this.cut.getEditModes((Document)this.requisitionDocument, this.userMock, editModes);
        }
        Assertions.assertEquals((int)3, (int)updatedEditModes.size());
        Assertions.assertTrue((boolean)updatedEditModes.contains("restrictFullEntry"));
        Assertions.assertTrue((boolean)updatedEditModes.contains("enableCommodityCode"));
        Assertions.assertTrue((boolean)updatedEditModes.contains("allowCapitalAssetEdit"));
    }
}

