/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.kew.api.document.WorkflowDocumentService;
import org.kuali.kfs.kew.routeheader.DocumentStatusTransition;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.impl.AccountsPayableServiceImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class AccountsPayableServiceImplTest {
    private static final String DOCUMENT_NUMBER1 = "123456";
    private static final String DOCUMENT_NUMBER2 = "654321";
    private AccountsPayableServiceImpl cut;
    @Mock(stubOnly=true)
    private WorkflowDocumentService workflowDocumentServiceMock;

    AccountsPayableServiceImplTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new AccountsPayableServiceImpl();
        this.cut.setWorkflowDocumentService(this.workflowDocumentServiceMock);
    }

    private static List<DocumentStatusTransition> setupPreqDocumentStatusTransitions() {
        ArrayList<DocumentStatusTransition> preqDocumentStatusTransitions = new ArrayList<DocumentStatusTransition>();
        preqDocumentStatusTransitions.add(AccountsPayableServiceImplTest.setupDocumentStatusTransition(DOCUMENT_NUMBER1, "Department-Approved", "Cancelled", new Timestamp(3000L)));
        preqDocumentStatusTransitions.add(AccountsPayableServiceImplTest.setupDocumentStatusTransition(DOCUMENT_NUMBER1, "In Process", "Department-Approved", new Timestamp(2000L)));
        preqDocumentStatusTransitions.add(AccountsPayableServiceImplTest.setupDocumentStatusTransition(DOCUMENT_NUMBER1, "Initiated", "In Process", new Timestamp(1000L)));
        return preqDocumentStatusTransitions;
    }

    private static List<DocumentStatusTransition> setupCmDocumentStatusTransitions() {
        ArrayList<DocumentStatusTransition> cmDocumentStatusTransitions = new ArrayList<DocumentStatusTransition>();
        cmDocumentStatusTransitions.add(AccountsPayableServiceImplTest.setupDocumentStatusTransition(DOCUMENT_NUMBER2, "Complete", "Cancelled", new Timestamp(3000L)));
        cmDocumentStatusTransitions.add(AccountsPayableServiceImplTest.setupDocumentStatusTransition(DOCUMENT_NUMBER2, "In Process", "Complete", new Timestamp(2000L)));
        cmDocumentStatusTransitions.add(AccountsPayableServiceImplTest.setupDocumentStatusTransition(DOCUMENT_NUMBER2, "Initiated", "In Process", new Timestamp(1000L)));
        return cmDocumentStatusTransitions;
    }

    private static DocumentStatusTransition setupDocumentStatusTransition(String documentNumber, String oldStatus, String newStatus, Timestamp timestamp) {
        DocumentStatusTransition documentStatusTransition = new DocumentStatusTransition(documentNumber, oldStatus, newStatus);
        documentStatusTransition.setStatusTransitionDate(timestamp);
        return documentStatusTransition;
    }

    @Test
    void revertToPreviousAppDocStatus_PREQ(@Mock PaymentRequestDocument paymentRequestDocumentMock) {
        Mockito.when((Object)paymentRequestDocumentMock.getDocumentNumber()).thenReturn((Object)DOCUMENT_NUMBER1);
        List<DocumentStatusTransition> preqDocumentStatusTransitions = AccountsPayableServiceImplTest.setupPreqDocumentStatusTransitions();
        ((WorkflowDocumentService)Mockito.doReturn(preqDocumentStatusTransitions).when((Object)this.workflowDocumentServiceMock)).getDocumentStatusTransitionHistory(DOCUMENT_NUMBER1);
        this.cut.revertToPreviousAppDocStatus((AccountsPayableDocument)paymentRequestDocumentMock);
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocumentMock)).updateAndSaveAppDocStatus("Department-Approved");
    }

    @Test
    void revertToPreviousAppDocStatus_CM(@Mock VendorCreditMemoDocument vendorCreditMemoDocumentMock) {
        Mockito.when((Object)vendorCreditMemoDocumentMock.getDocumentNumber()).thenReturn((Object)DOCUMENT_NUMBER2);
        List<DocumentStatusTransition> cmDocumentStatusTransitions = AccountsPayableServiceImplTest.setupCmDocumentStatusTransitions();
        ((WorkflowDocumentService)Mockito.doReturn(cmDocumentStatusTransitions).when((Object)this.workflowDocumentServiceMock)).getDocumentStatusTransitionHistory(DOCUMENT_NUMBER2);
        this.cut.revertToPreviousAppDocStatus((AccountsPayableDocument)vendorCreditMemoDocumentMock);
        ((VendorCreditMemoDocument)Mockito.verify((Object)vendorCreditMemoDocumentMock)).updateAndSaveAppDocStatus("Complete");
    }
}

