/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.impl.CreditMemoServiceImpl;
import org.kuali.kfs.module.purap.document.validation.event.AttributedContinuePurapEvent;
import org.kuali.kfs.sys.businessobject.Bank;
import org.kuali.kfs.sys.businessobject.PaymentMethod;
import org.kuali.kfs.sys.service.BankService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class CreditMemoServiceImplTest {
    private static final String BANK_CODE = "bank code";
    private CreditMemoServiceImpl cut;

    CreditMemoServiceImplTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new CreditMemoServiceImpl();
    }

    @Test
    @DisplayName(value="populateAndSaveCreditMemo() with a source payment request document and no payment method")
    void populateAndSaveCreditMemoWithPaymentRequest(@Mock(stubOnly=true) BusinessObjectService businessObjectServiceMock, @Mock DocumentService documentServiceMock, @Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock VendorCreditMemoDocument vendorCreditMemoDocumentMock) {
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        this.cut.setDocumentService(documentServiceMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.isSourceDocumentPaymentRequest()).thenReturn((Object)true);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestDocument()).thenReturn((Object)paymentRequestDocumentMock);
        Bank bank = new Bank();
        bank.setBankCode(BANK_CODE);
        Mockito.when((Object)paymentRequestDocumentMock.getBankCode()).thenReturn((Object)BANK_CODE);
        Mockito.when((Object)paymentRequestDocumentMock.getBank()).thenReturn((Object)bank);
        this.cut.populateAndSaveCreditMemo(vendorCreditMemoDocumentMock);
        ((VendorCreditMemoDocument)Mockito.verify((Object)vendorCreditMemoDocumentMock)).updateAndSaveAppDocStatus("In Process");
        ((VendorCreditMemoDocument)Mockito.verify((Object)vendorCreditMemoDocumentMock)).setBankCode(BANK_CODE);
        ((VendorCreditMemoDocument)Mockito.verify((Object)vendorCreditMemoDocumentMock)).setBank(bank);
        ((DocumentService)Mockito.verify((Object)documentServiceMock)).saveDocument((Document)vendorCreditMemoDocumentMock, AttributedContinuePurapEvent.class);
    }

    @Test
    @DisplayName(value="populateAndSaveCreditMemo() with a source payment request document and a valid payment method")
    void populateAndSaveCreditMemoWithPaymentRequestAndPaymentMethod(@Mock(stubOnly=true) BusinessObjectService businessObjectServiceMock, @Mock DocumentService documentServiceMock, @Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock VendorCreditMemoDocument vendorCreditMemoDocumentMock) {
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        this.cut.setDocumentService(documentServiceMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.isSourceDocumentPaymentRequest()).thenReturn((Object)true);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestDocument()).thenReturn((Object)paymentRequestDocumentMock);
        Bank wrongBank = new Bank();
        wrongBank.setBankCode("wrong");
        Mockito.when((Object)paymentRequestDocumentMock.getBankCode()).thenReturn((Object)"wrong");
        Mockito.when((Object)paymentRequestDocumentMock.getBank()).thenReturn((Object)wrongBank);
        PaymentMethod paymentMethod = CreditMemoServiceImplTest.setUpPaymentMethod(businessObjectServiceMock);
        Bank expectedBank = CreditMemoServiceImplTest.setUpPaymentMethodBank(paymentMethod, BANK_CODE);
        this.cut.populateAndSaveCreditMemo(vendorCreditMemoDocumentMock);
        ((VendorCreditMemoDocument)Mockito.verify((Object)vendorCreditMemoDocumentMock)).updateAndSaveAppDocStatus("In Process");
        ((VendorCreditMemoDocument)Mockito.verify((Object)vendorCreditMemoDocumentMock)).setPaymentMethodCode("P");
        ((VendorCreditMemoDocument)Mockito.verify((Object)vendorCreditMemoDocumentMock)).setPaymentMethod(paymentMethod);
        ((VendorCreditMemoDocument)Mockito.verify((Object)vendorCreditMemoDocumentMock)).setBankCode(BANK_CODE);
        ((VendorCreditMemoDocument)Mockito.verify((Object)vendorCreditMemoDocumentMock)).setBank(expectedBank);
        ((DocumentService)Mockito.verify((Object)documentServiceMock)).saveDocument((Document)vendorCreditMemoDocumentMock, AttributedContinuePurapEvent.class);
    }

    @Test
    @DisplayName(value="populateAndSaveCreditMemo() without source payment request document or payment method")
    void populateAndSaveCreditMemoWithoutPaymentRequestOrPaymentMethod(@Mock(stubOnly=true) BankService bankServiceMock, @Mock(stubOnly=true) BusinessObjectService businessObjectServiceMock, @Mock DocumentService documentServiceMock, @Mock VendorCreditMemoDocument vendorCreditMemoDocumentMock) {
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        this.cut.setBankService(bankServiceMock);
        this.cut.setDocumentService(documentServiceMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.isSourceDocumentPaymentRequest()).thenReturn((Object)false);
        Bank bank = CreditMemoServiceImplTest.setUpParameterBank(BANK_CODE, bankServiceMock, vendorCreditMemoDocumentMock);
        this.cut.populateAndSaveCreditMemo(vendorCreditMemoDocumentMock);
        ((VendorCreditMemoDocument)Mockito.verify((Object)vendorCreditMemoDocumentMock)).updateAndSaveAppDocStatus("In Process");
        ((VendorCreditMemoDocument)Mockito.verify((Object)vendorCreditMemoDocumentMock)).setBankCode(BANK_CODE);
        ((VendorCreditMemoDocument)Mockito.verify((Object)vendorCreditMemoDocumentMock)).setBank(bank);
        ((DocumentService)Mockito.verify((Object)documentServiceMock)).saveDocument((Document)vendorCreditMemoDocumentMock, AttributedContinuePurapEvent.class);
    }

    @Test
    @DisplayName(value="populateAndSaveCreditMemo() with an inactive payment method")
    void populateAndSaveCreditMemoWithInactivePaymentMethod(@Mock(stubOnly=true) BankService bankServiceMock, @Mock(stubOnly=true) BusinessObjectService businessObjectServiceMock, @Mock DocumentService documentServiceMock, @Mock VendorCreditMemoDocument vendorCreditMemoDocumentMock) {
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        this.cut.setBankService(bankServiceMock);
        this.cut.setDocumentService(documentServiceMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.isSourceDocumentPaymentRequest()).thenReturn((Object)false);
        PaymentMethod paymentMethod = CreditMemoServiceImplTest.setUpPaymentMethod(businessObjectServiceMock);
        CreditMemoServiceImplTest.setUpPaymentMethodBank(paymentMethod, "wrong");
        Bank bank = CreditMemoServiceImplTest.setUpParameterBank(BANK_CODE, bankServiceMock, vendorCreditMemoDocumentMock);
        this.cut.populateAndSaveCreditMemo(vendorCreditMemoDocumentMock);
        ((VendorCreditMemoDocument)Mockito.verify((Object)vendorCreditMemoDocumentMock)).updateAndSaveAppDocStatus("In Process");
        ((VendorCreditMemoDocument)Mockito.verify((Object)vendorCreditMemoDocumentMock)).setBankCode(BANK_CODE);
        ((VendorCreditMemoDocument)Mockito.verify((Object)vendorCreditMemoDocumentMock)).setBank(bank);
        ((DocumentService)Mockito.verify((Object)documentServiceMock)).saveDocument((Document)vendorCreditMemoDocumentMock, AttributedContinuePurapEvent.class);
    }

    @Test
    @DisplayName(value="populateAndSaveCreditMemo() with an active payment method with a bank")
    void populateAndSaveCreditMemoWithPaymentMethod(@Mock(stubOnly=true) BankService bankServiceMock, @Mock(stubOnly=true) BusinessObjectService businessObjectServiceMock, @Mock DocumentService documentServiceMock, @Mock VendorCreditMemoDocument vendorCreditMemoDocumentMock) {
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        this.cut.setBankService(bankServiceMock);
        this.cut.setDocumentService(documentServiceMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.isSourceDocumentPaymentRequest()).thenReturn((Object)false);
        PaymentMethod paymentMethod = CreditMemoServiceImplTest.setUpPaymentMethod(businessObjectServiceMock);
        Bank expectedBank = CreditMemoServiceImplTest.setUpPaymentMethodBank(paymentMethod, BANK_CODE);
        CreditMemoServiceImplTest.setUpParameterBank("wrong", bankServiceMock, vendorCreditMemoDocumentMock);
        this.cut.populateAndSaveCreditMemo(vendorCreditMemoDocumentMock);
        ((VendorCreditMemoDocument)Mockito.verify((Object)vendorCreditMemoDocumentMock)).updateAndSaveAppDocStatus("In Process");
        ((VendorCreditMemoDocument)Mockito.verify((Object)vendorCreditMemoDocumentMock)).setPaymentMethodCode("P");
        ((VendorCreditMemoDocument)Mockito.verify((Object)vendorCreditMemoDocumentMock)).setPaymentMethod(paymentMethod);
        ((VendorCreditMemoDocument)Mockito.verify((Object)vendorCreditMemoDocumentMock)).setBankCode(BANK_CODE);
        ((VendorCreditMemoDocument)Mockito.verify((Object)vendorCreditMemoDocumentMock)).setBank(expectedBank);
        ((DocumentService)Mockito.verify((Object)documentServiceMock)).saveDocument((Document)vendorCreditMemoDocumentMock, AttributedContinuePurapEvent.class);
    }

    @Test
    @DisplayName(value="populateAndSaveCreditMemo() with validation exception")
    void populateAndSaveCreditMemoWithValidationException(@Mock(stubOnly=true) BankService bankServiceMock, @Mock(stubOnly=true) BusinessObjectService businessObjectServiceMock, @Mock DocumentService documentServiceMock, @Mock VendorCreditMemoDocument vendorCreditMemoDocumentMock) {
        this.cut.setBankService(bankServiceMock);
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        this.cut.setDocumentService(documentServiceMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.isSourceDocumentPaymentRequest()).thenReturn((Object)false);
        Mockito.when((Object)documentServiceMock.saveDocument((Document)vendorCreditMemoDocumentMock, AttributedContinuePurapEvent.class)).thenThrow(new Throwable[]{new ValidationException("fake")});
        this.cut.populateAndSaveCreditMemo(vendorCreditMemoDocumentMock);
        ((VendorCreditMemoDocument)Mockito.verify((Object)vendorCreditMemoDocumentMock)).updateAndSaveAppDocStatus("In Process");
        ((VendorCreditMemoDocument)Mockito.verify((Object)vendorCreditMemoDocumentMock)).updateAndSaveAppDocStatus("Initiated");
    }

    private static PaymentMethod setUpPaymentMethod(BusinessObjectService businessObjectServiceMock) {
        PaymentMethod paymentMethod = new PaymentMethod();
        paymentMethod.setActive(true);
        paymentMethod.setPaymentMethodCode("P");
        Mockito.when((Object)((PaymentMethod)businessObjectServiceMock.findBySinglePrimaryKey(PaymentMethod.class, (Object)"P"))).thenReturn((Object)paymentMethod);
        return paymentMethod;
    }

    private static Bank setUpParameterBank(String bankCode, BankService bankServiceMock, VendorCreditMemoDocument vendorCreditMemoDocumentMock) {
        Bank bank = new Bank();
        bank.setBankCode(bankCode);
        Mockito.when((Object)bankServiceMock.getDefaultBankByDocType(vendorCreditMemoDocumentMock.getClass())).thenReturn((Object)bank);
        return bank;
    }

    private static Bank setUpPaymentMethodBank(PaymentMethod paymentMethod, String bankCode) {
        Bank bank = new Bank();
        bank.setBankCode(bankCode);
        paymentMethod.setBankCode(bankCode);
        paymentMethod.setBank(bank);
        return bank;
    }
}

