/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItem;
import org.kuali.kfs.module.purap.document.validation.impl.PaymentRequestProcessItemValidation;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class PaymentRequestProcessItemValidationTest {
    private PaymentRequestProcessItemValidation cut;

    PaymentRequestProcessItemValidationTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new PaymentRequestProcessItemValidation();
    }

    @Test
    void validateItemWithoutAccounts_ValidExtendedCost_AccountListNotEmpty_ReturnsTrue(@Mock(stubOnly=true) PaymentRequestItem paymentRequestItemMock) {
        Mockito.when((Object)paymentRequestItemMock.getExtendedPrice()).thenReturn((Object)new KualiDecimal(70));
        Mockito.when((Object)paymentRequestItemMock.isAccountListEmpty()).thenReturn((Object)false);
        Assertions.assertTrue((boolean)this.cut.validateItemWithoutAccounts(paymentRequestItemMock, "foo"));
    }

    @Test
    void validateItemWithoutAccounts_ValidExtendedCost_NoAccount_ReturnsFalse(@Mock(stubOnly=true) PaymentRequestItem paymentRequestItemMock) {
        Mockito.when((Object)paymentRequestItemMock.getExtendedPrice()).thenReturn((Object)new KualiDecimal(70));
        Mockito.when((Object)paymentRequestItemMock.isAccountListEmpty()).thenReturn((Object)true);
        Assertions.assertFalse((boolean)this.cut.validateItemWithoutAccounts(paymentRequestItemMock, "foo"));
    }

    @Test
    void validateItemWithoutAccounts_NullExtendedCost_ReturnsTrue(@Mock(stubOnly=true) PaymentRequestItem paymentRequestItemMock) {
        Mockito.when((Object)paymentRequestItemMock.getExtendedPrice()).thenReturn(null);
        Assertions.assertTrue((boolean)this.cut.validateItemWithoutAccounts(paymentRequestItemMock, "foo"));
    }
}

