/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.module.purap.document.validation.impl.PurchaseOrderDocumentPreRules;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class PurchaseOrderDocumentPreRulesTest {
    private PurchaseOrderDocumentPreRules cut;
    @Mock(stubOnly=true)
    private PurchaseOrderDocument poDocMock;

    PurchaseOrderDocumentPreRulesTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new PurchaseOrderDocumentPreRules();
        KNSGlobalVariables.getMessageList().clear();
    }

    @AfterEach
    void tearDown() {
        KNSGlobalVariables.getMessageList().clear();
    }

    @Test
    void validateTotalDollarAmountIsLessThanPurchaseOrderTotalLimit_ZeroAmountSmallLimit() {
        Mockito.when((Object)this.poDocMock.getTotalDollarAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)this.poDocMock.getPurchaseOrderTotalLimit()).thenReturn((Object)new KualiDecimal(32));
        Assertions.assertTrue((boolean)this.cut.validateTotalDollarAmountIsLessThanPurchaseOrderTotalLimit((PurchasingDocument)this.poDocMock));
    }

    @Test
    void validateTotalDollarAmountIsLessThanPurchaseOrderTotalLimit_SmallAmountSmallLimit() {
        Mockito.when((Object)this.poDocMock.getTotalDollarAmount()).thenReturn((Object)new KualiDecimal(32));
        Mockito.when((Object)this.poDocMock.getPurchaseOrderTotalLimit()).thenReturn((Object)new KualiDecimal(32));
        Assertions.assertTrue((boolean)this.cut.validateTotalDollarAmountIsLessThanPurchaseOrderTotalLimit((PurchasingDocument)this.poDocMock));
    }

    @Test
    void validateTotalDollarAmountIsLessThanPurchaseOrderTotalLimit_LargeAmountSmallLimit() {
        Mockito.when((Object)this.poDocMock.getTotalDollarAmount()).thenReturn((Object)new KualiDecimal(1024));
        Mockito.when((Object)this.poDocMock.getPurchaseOrderTotalLimit()).thenReturn((Object)new KualiDecimal(32));
        Assertions.assertFalse((boolean)this.cut.validateTotalDollarAmountIsLessThanPurchaseOrderTotalLimit((PurchasingDocument)this.poDocMock));
        Assertions.assertTrue((boolean)KNSGlobalVariables.getMessageList().contains((Object)new ErrorMessage("warning.purchaseOrderTotalLimit", new String[0])));
    }
}

