/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.Arrays;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.service.impl.PurchaseOrderServiceImpl;
import org.kuali.kfs.module.purap.document.validation.impl.PurchaseOrderSplitValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class PurchaseOrderSplitValidationTest {
    private PurchaseOrderSplitValidation cut;

    PurchaseOrderSplitValidationTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new PurchaseOrderSplitValidation();
        this.cut.setPurchaseOrderService((PurchaseOrderService)new PurchaseOrderServiceImpl());
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    private static PurchaseOrderItem setupPoItem(ItemType itemTypeMock) {
        PurchaseOrderItem poItem = new PurchaseOrderItem();
        poItem.setItemType(itemTypeMock);
        poItem.setItemTypeCode("ITEM");
        return poItem;
    }

    @Test
    void validate_OneMovingOneRemaining(@Mock(stubOnly=true) ItemType itemTypeMock, @Mock(stubOnly=true) PurchaseOrderDocument poDocMock) {
        Mockito.when((Object)itemTypeMock.isLineItemIndicator()).thenReturn((Object)true);
        Mockito.when((Object)itemTypeMock.getItemTypeCode()).thenReturn((Object)"ITEM");
        PurchaseOrderItem poItem1 = PurchaseOrderSplitValidationTest.setupPoItem(itemTypeMock);
        poItem1.setMovingToSplit(true);
        PurchaseOrderItem poItem2 = PurchaseOrderSplitValidationTest.setupPoItem(itemTypeMock);
        Mockito.when((Object)poDocMock.getItems()).thenReturn(Arrays.asList(poItem1, poItem2));
        Assertions.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)poDocMock)));
    }

    @Test
    void validate_NoneMovingTwoRemaining(@Mock(stubOnly=true) ItemType itemTypeMock, @Mock(stubOnly=true) PurchaseOrderDocument poDocMock) {
        Mockito.when((Object)itemTypeMock.isLineItemIndicator()).thenReturn((Object)true);
        Mockito.when((Object)itemTypeMock.getItemTypeCode()).thenReturn((Object)"ITEM");
        PurchaseOrderItem poItem1 = PurchaseOrderSplitValidationTest.setupPoItem(itemTypeMock);
        PurchaseOrderItem poItem2 = PurchaseOrderSplitValidationTest.setupPoItem(itemTypeMock);
        Mockito.when((Object)poDocMock.getItems()).thenReturn(Arrays.asList(poItem1, poItem2));
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)poDocMock)));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("document.splitPurchaseOrder", "error.purchaseOrder.split.atLeastOneItem.mustMove"));
    }

    @Test
    void validate_TwoMovingNoneRemaining(@Mock(stubOnly=true) ItemType itemTypeMock, @Mock(stubOnly=true) PurchaseOrderDocument poDocMock) {
        PurchaseOrderItem poItem1 = PurchaseOrderSplitValidationTest.setupPoItem(itemTypeMock);
        poItem1.setMovingToSplit(true);
        PurchaseOrderItem poItem2 = PurchaseOrderSplitValidationTest.setupPoItem(itemTypeMock);
        poItem2.setMovingToSplit(true);
        Mockito.when((Object)poDocMock.getItems()).thenReturn(Arrays.asList(poItem1, poItem2));
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)poDocMock)));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("document.splitPurchaseOrder", "error.purchaseOrder.split.atLeastOneItem.mustRemain"));
    }
}

