/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingAccountsPayableUniqueAccountingStringsValidation;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class PurchasingAccountsPayableUniqueAccountingStringsValidationTest {
    private PurchasingAccountsPayableUniqueAccountingStringsValidation cut;
    @Mock(stubOnly=true)
    private PurApItem purApItemMock;
    @Spy
    private PurchaseOrderAccount purchaseOrderAccount1Spy;
    @Spy
    private PurchaseOrderAccount purchaseOrderAccount2Spy;

    PurchasingAccountsPayableUniqueAccountingStringsValidationTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new PurchasingAccountsPayableUniqueAccountingStringsValidation();
        ArrayList<PurchaseOrderAccount> sourceAccountingLines = new ArrayList<PurchaseOrderAccount>();
        PurchasingAccountsPayableUniqueAccountingStringsValidationTest.partialMockSourceAccountingLine(this.purchaseOrderAccount1Spy);
        sourceAccountingLines.add(this.purchaseOrderAccount1Spy);
        PurchasingAccountsPayableUniqueAccountingStringsValidationTest.partialMockSourceAccountingLine(this.purchaseOrderAccount2Spy);
        sourceAccountingLines.add(this.purchaseOrderAccount2Spy);
        Mockito.when((Object)this.purApItemMock.getSourceAccountingLines()).thenReturn(sourceAccountingLines);
        this.cut.setItemForValidation(this.purApItemMock);
    }

    private static void partialMockSourceAccountingLine(PurchaseOrderAccount poa) {
        Mockito.when((Object)poa.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)poa.getAccountNumber()).thenReturn((Object)"1031400");
        Mockito.when((Object)poa.getFinancialObjectCode()).thenReturn((Object)"5000");
    }

    @Test
    void validateTest_SHOULD_FAIL_WITHOUT_SEQUENCE_NUMBERS() {
        Assertions.assertFalse((boolean)this.cut.validate(null));
    }

    @Test
    void validateTest_SHOULD_FAIL_WITH_DIFFERENT_SEQUENCE_NUMBERS() {
        Assertions.assertFalse((boolean)this.cut.validate(null));
    }

    @Test
    void validateTest_SHOULD_SUCCEED() {
        Mockito.when((Object)this.purchaseOrderAccount2Spy.getAccountNumber()).thenReturn((Object)"1024600");
        Assertions.assertTrue((boolean)this.cut.validate(null));
    }
}

