/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.math.BigDecimal;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.document.validation.impl.VendorCreditMemoAccountPercentBetween0And100Validation;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.document.validation.event.AddAccountingLineEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class VendorCreditMemoAccountPercentBetween0And100ValidationTest {
    private VendorCreditMemoAccountPercentBetween0And100Validation cut;

    VendorCreditMemoAccountPercentBetween0And100ValidationTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new VendorCreditMemoAccountPercentBetween0And100Validation();
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    void validate_100Percent(@Mock PurApAccountingLine accountingLineMock) {
        Mockito.when((Object)accountingLineMock.getAccountLinePercent()).thenReturn((Object)new BigDecimal("100"));
        Assertions.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AddAccountingLineEvent("", null, (AccountingLine)accountingLineMock)));
    }

    @Test
    void validate_PercentTooHigh(@Mock PurApAccountingLine accountingLineMock) {
        Mockito.when((Object)accountingLineMock.getAccountLinePercent()).thenReturn((Object)new BigDecimal("101"));
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AddAccountingLineEvent("", null, (AccountingLine)accountingLineMock)));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("accountLinePercent", "errors.creditMemo.line.percent"));
    }

    @Test
    void validate_PercentZero(@Mock PurApAccountingLine accountingLineMock) {
        Mockito.when((Object)accountingLineMock.getAccountLinePercent()).thenReturn((Object)new BigDecimal("0"));
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AddAccountingLineEvent("", null, (AccountingLine)accountingLineMock)));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("accountLinePercent", "errors.creditMemo.line.percent"));
    }

    @Test
    void validate_PercentNegative(@Mock PurApAccountingLine accountingLineMock) {
        Mockito.when((Object)accountingLineMock.getAccountLinePercent()).thenReturn((Object)new BigDecimal("-1"));
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AddAccountingLineEvent("", null, (AccountingLine)accountingLineMock)));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("accountLinePercent", "errors.creditMemo.line.percent"));
    }
}

