/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.validation.impl.VendorCreditMemoInitTabReferenceNumberValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class VendorCreditMemoInitTabReferenceNumberValidationTest {
    private VendorCreditMemoInitTabReferenceNumberValidation cut;
    @Mock(stubOnly=true)
    private PaymentRequestService paymentRequestSvcMock;
    @Mock(stubOnly=true)
    private PurchaseOrderService purchaseOrderSvcMock;
    @Mock(stubOnly=true)
    private VendorService vendorSvcMock;

    VendorCreditMemoInitTabReferenceNumberValidationTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new VendorCreditMemoInitTabReferenceNumberValidation();
        this.cut.setPaymentRequestService(this.paymentRequestSvcMock);
        this.cut.setPurchaseOrderService(this.purchaseOrderSvcMock);
        this.cut.setVendorService(this.vendorSvcMock);
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    void validate_OnlyPaymentRequestIdentifierSet_ExistingPaymentRequestDocument(@Mock(stubOnly=true) AttributedDocumentEvent eventMock, @Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock(stubOnly=true) VendorCreditMemoDocument vendorCreditMemoDocumentMock) {
        Mockito.when((Object)eventMock.getDocument()).thenReturn((Object)vendorCreditMemoDocumentMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"");
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn(null);
        Mockito.when((Object)this.paymentRequestSvcMock.getPaymentRequestById(Integer.valueOf(1))).thenReturn((Object)paymentRequestDocumentMock);
        Assertions.assertTrue((boolean)this.cut.validate(eventMock));
    }

    @Test
    void validate_OnlyPaymentRequestIdentifierSet_NonExistentPaymentRequestDocument(@Mock(stubOnly=true) AttributedDocumentEvent eventMock, @Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock(stubOnly=true) VendorCreditMemoDocument vendorCreditMemoDocumentMock) {
        Mockito.when((Object)eventMock.getDocument()).thenReturn((Object)vendorCreditMemoDocumentMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"");
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn(null);
        Mockito.when((Object)this.paymentRequestSvcMock.getPaymentRequestById(Integer.valueOf(1))).thenReturn((Object)paymentRequestDocumentMock);
        Mockito.when((Object)this.paymentRequestSvcMock.getPaymentRequestById(Integer.valueOf(1))).thenReturn(null);
        Assertions.assertFalse((boolean)this.cut.validate(eventMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("paymentRequestIdentifier");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"errors.creditMemo.paymentRequest.invalid", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        Assertions.assertEquals((Object)"1", (Object)((ErrorMessage)errorMessages.get(0)).getMessageParameters()[0]);
    }

    @Test
    void validate_OnlyPaymentRequestIdentifierSet_ExistingPaymentRequestDocument_InProcess(@Mock(stubOnly=true) AttributedDocumentEvent eventMock, @Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock(stubOnly=true) VendorCreditMemoDocument vendorCreditMemoDocumentMock) {
        Mockito.when((Object)eventMock.getDocument()).thenReturn((Object)vendorCreditMemoDocumentMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"");
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn(null);
        Mockito.when((Object)this.paymentRequestSvcMock.getPaymentRequestById(Integer.valueOf(1))).thenReturn((Object)paymentRequestDocumentMock);
        Mockito.when((Object)paymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"In Process");
        Assertions.assertFalse((boolean)this.cut.validate(eventMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("paymentRequestIdentifier");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"errors.creditMemo.paymentRequest.invalid.status", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        Assertions.assertEquals((Object)"1", (Object)((ErrorMessage)errorMessages.get(0)).getMessageParameters()[0]);
    }

    @Test
    void validate_OnlyPaymentRequestIdentifierSet_ExistingPaymentRequestDocument_CancelledInProgress(@Mock(stubOnly=true) AttributedDocumentEvent eventMock, @Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock(stubOnly=true) VendorCreditMemoDocument vendorCreditMemoDocumentMock) {
        Mockito.when((Object)eventMock.getDocument()).thenReturn((Object)vendorCreditMemoDocumentMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"");
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn(null);
        Mockito.when((Object)this.paymentRequestSvcMock.getPaymentRequestById(Integer.valueOf(1))).thenReturn((Object)paymentRequestDocumentMock);
        Mockito.when((Object)paymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"Cancelled In Process");
        Assertions.assertFalse((boolean)this.cut.validate(eventMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("paymentRequestIdentifier");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"errors.creditMemo.paymentRequest.invalid.status", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        Assertions.assertEquals((Object)"1", (Object)((ErrorMessage)errorMessages.get(0)).getMessageParameters()[0]);
    }

    @Test
    void validate_OnlyPaymentRequestIdentifierSet_ExistingPaymentRequestDocument_CancelledPostApApprove(@Mock(stubOnly=true) AttributedDocumentEvent eventMock, @Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock, @Mock(stubOnly=true) VendorCreditMemoDocument vendorCreditMemoDocumentMock) {
        Mockito.when((Object)eventMock.getDocument()).thenReturn((Object)vendorCreditMemoDocumentMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"");
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn(null);
        Mockito.when((Object)this.paymentRequestSvcMock.getPaymentRequestById(Integer.valueOf(1))).thenReturn((Object)paymentRequestDocumentMock);
        Mockito.when((Object)paymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"Cancelled");
        Assertions.assertFalse((boolean)this.cut.validate(eventMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("paymentRequestIdentifier");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"errors.creditMemo.paymentRequest.invalid.status", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        Assertions.assertEquals((Object)"1", (Object)((ErrorMessage)errorMessages.get(0)).getMessageParameters()[0]);
    }

    @Test
    void validate_OnlyVendorNumberSet_ExistingVendor(@Mock(stubOnly=true) AttributedDocumentEvent eventMock, @Mock(stubOnly=true) VendorCreditMemoDocument vendorCreditMemoDocumentMock, @Mock(stubOnly=true) VendorDetail vendorDetailMock) {
        Mockito.when((Object)eventMock.getDocument()).thenReturn((Object)vendorCreditMemoDocumentMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"");
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn(null);
        Mockito.when((Object)this.vendorSvcMock.getVendorDetail(Integer.valueOf(1000), Integer.valueOf(0))).thenReturn((Object)vendorDetailMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn(null);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"1000-0");
        Assertions.assertTrue((boolean)this.cut.validate(eventMock));
    }

    @Test
    void validate_OnlyVendorNumberSet_MissingVendor(@Mock(stubOnly=true) AttributedDocumentEvent eventMock, @Mock(stubOnly=true) VendorCreditMemoDocument vendorCreditMemoDocumentMock) {
        Mockito.when((Object)eventMock.getDocument()).thenReturn((Object)vendorCreditMemoDocumentMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"");
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn(null);
        Mockito.when((Object)this.vendorSvcMock.getVendorDetail(Integer.valueOf(1000), Integer.valueOf(1))).thenReturn(null);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn(null);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"1000-1");
        Assertions.assertFalse((boolean)this.cut.validate(eventMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("vendorNumber");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"errors.creditMemo.vendorNumber.invalid", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        Assertions.assertEquals((Object)"1000-1", (Object)((ErrorMessage)errorMessages.get(0)).getMessageParameters()[0]);
    }

    @Test
    void validate_OnlyPurchaseOrderIdentifier_ExistingPurchaseOrder_Open(@Mock(stubOnly=true) AttributedDocumentEvent eventMock, @Mock(stubOnly=true) PurchaseOrderDocument purchaseOrderDocumentMock, @Mock(stubOnly=true) VendorCreditMemoDocument vendorCreditMemoDocumentMock) {
        Mockito.when((Object)eventMock.getDocument()).thenReturn((Object)vendorCreditMemoDocumentMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"");
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn(null);
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(1))).thenReturn((Object)purchaseOrderDocumentMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn(null);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)purchaseOrderDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"Open");
        Assertions.assertTrue((boolean)this.cut.validate(eventMock));
    }

    @Test
    void validate_OnlyPurchaseOrderIdentifier_ExistingPurchaseOrder_Closed(@Mock(stubOnly=true) AttributedDocumentEvent eventMock, @Mock(stubOnly=true) PurchaseOrderDocument purchaseOrderDocumentMock, @Mock(stubOnly=true) VendorCreditMemoDocument vendorCreditMemoDocumentMock) {
        Mockito.when((Object)eventMock.getDocument()).thenReturn((Object)vendorCreditMemoDocumentMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"");
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn(null);
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(1))).thenReturn((Object)purchaseOrderDocumentMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn(null);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)purchaseOrderDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"Closed");
        Assertions.assertTrue((boolean)this.cut.validate(eventMock));
    }

    @Test
    void validate_OnlyPurchaseOrderIdentifier_ExistingPurchaseOrder_InProcess(@Mock(stubOnly=true) AttributedDocumentEvent eventMock, @Mock(stubOnly=true) PurchaseOrderDocument purchaseOrderDocumentMock, @Mock(stubOnly=true) VendorCreditMemoDocument vendorCreditMemoDocumentMock) {
        Mockito.when((Object)eventMock.getDocument()).thenReturn((Object)vendorCreditMemoDocumentMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"");
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn(null);
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(1))).thenReturn((Object)purchaseOrderDocumentMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn(null);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)purchaseOrderDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"In Process");
        Assertions.assertFalse((boolean)this.cut.validate(eventMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("purchaseOrderIdentifier");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"errors.creditMemo.purchaseOrder.invalid.status", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        Assertions.assertEquals((Object)"1", (Object)((ErrorMessage)errorMessages.get(0)).getMessageParameters()[0]);
    }

    @Test
    void validate_OnlyPurchaseOrderIdentifier_MissingPurchaseOrder(@Mock(stubOnly=true) AttributedDocumentEvent eventMock, @Mock(stubOnly=true) VendorCreditMemoDocument vendorCreditMemoDocumentMock) {
        Mockito.when((Object)eventMock.getDocument()).thenReturn((Object)vendorCreditMemoDocumentMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"");
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn(null);
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(2))).thenReturn(null);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn(null);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn((Object)2);
        Assertions.assertFalse((boolean)this.cut.validate(eventMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("purchaseOrderIdentifier");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"errors.creditMemo.purchaseOrder.invalid", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        Assertions.assertEquals((Object)"2", (Object)((ErrorMessage)errorMessages.get(0)).getMessageParameters()[0]);
    }

    @Test
    void validate_OnlyPurchaseOrderIdentifier_ExistingPurchaseOrder_PendingAction(@Mock(stubOnly=true) AttributedDocumentEvent eventMock, @Mock(stubOnly=true) PurchaseOrderDocument purchaseOrderDocumentMock, @Mock(stubOnly=true) VendorCreditMemoDocument vendorCreditMemoDocumentMock) {
        Mockito.when((Object)eventMock.getDocument()).thenReturn((Object)vendorCreditMemoDocumentMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"");
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn(null);
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(1))).thenReturn((Object)purchaseOrderDocumentMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn(null);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)purchaseOrderDocumentMock.isPendingActionIndicator()).thenReturn((Object)true);
        Assertions.assertFalse((boolean)this.cut.validate(eventMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("purchaseOrderIdentifier");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"error.invoice.purchaseOrder.pending.action", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        Assertions.assertEquals((int)0, (int)((ErrorMessage)errorMessages.get(0)).getMessageParameters().length);
    }

    @Test
    void validate_NoIdentifiersSet(@Mock(stubOnly=true) AttributedDocumentEvent eventMock, @Mock(stubOnly=true) VendorCreditMemoDocument vendorCreditMemoDocumentMock) {
        Mockito.when((Object)eventMock.getDocument()).thenReturn((Object)vendorCreditMemoDocumentMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"");
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn(null);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn(null);
        Assertions.assertFalse((boolean)this.cut.validate(eventMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("purchaseOrderIdentifier");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"errors.creditMemo.required.fields", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        Assertions.assertEquals((int)0, (int)((ErrorMessage)errorMessages.get(0)).getMessageParameters().length);
    }

    @Test
    void validate_PaymentRequestIdentifierAndVendorNumberSet(@Mock(stubOnly=true) AttributedDocumentEvent eventMock, @Mock(stubOnly=true) VendorCreditMemoDocument vendorCreditMemoDocumentMock) {
        Mockito.when((Object)eventMock.getDocument()).thenReturn((Object)vendorCreditMemoDocumentMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"");
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn(null);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"1000-0");
        Assertions.assertFalse((boolean)this.cut.validate(eventMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("purchaseOrderIdentifier");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"errors.creditMemo.required.fields", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        Assertions.assertEquals((int)0, (int)((ErrorMessage)errorMessages.get(0)).getMessageParameters().length);
    }

    @Test
    void validate_PaymentRequestIdentifierAndPurchaseOrderIdentifierSet(@Mock(stubOnly=true) AttributedDocumentEvent eventMock, @Mock(stubOnly=true) VendorCreditMemoDocument vendorCreditMemoDocumentMock) {
        Mockito.when((Object)eventMock.getDocument()).thenReturn((Object)vendorCreditMemoDocumentMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"");
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn(null);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn((Object)1);
        Assertions.assertFalse((boolean)this.cut.validate(eventMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("purchaseOrderIdentifier");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"errors.creditMemo.required.fields", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        Assertions.assertEquals((int)0, (int)((ErrorMessage)errorMessages.get(0)).getMessageParameters().length);
    }

    @Test
    void validate_VendorNumberAndPurchaseOrderIdentifierSet(@Mock(stubOnly=true) AttributedDocumentEvent eventMock, @Mock(stubOnly=true) VendorCreditMemoDocument vendorCreditMemoDocumentMock) {
        Mockito.when((Object)eventMock.getDocument()).thenReturn((Object)vendorCreditMemoDocumentMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"");
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn(null);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn(null);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"1000-0");
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn((Object)1);
        Assertions.assertFalse((boolean)this.cut.validate(eventMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("purchaseOrderIdentifier");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"errors.creditMemo.required.fields", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        Assertions.assertEquals((int)0, (int)((ErrorMessage)errorMessages.get(0)).getMessageParameters().length);
    }

    @Test
    void validate_PaymentRequestIdentifierVendorNumberAndPurchaseOrderIdentifierSet(@Mock(stubOnly=true) AttributedDocumentEvent eventMock, @Mock(stubOnly=true) VendorCreditMemoDocument vendorCreditMemoDocumentMock) {
        Mockito.when((Object)eventMock.getDocument()).thenReturn((Object)vendorCreditMemoDocumentMock);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"");
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn(null);
        Mockito.when((Object)vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"1000-0");
        Mockito.when((Object)vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn((Object)1);
        Assertions.assertFalse((boolean)this.cut.validate(eventMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("purchaseOrderIdentifier");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"errors.creditMemo.required.fields", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        Assertions.assertEquals((int)0, (int)((ErrorMessage)errorMessages.get(0)).getMessageParameters().length);
    }
}

