/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.sql.Date;
import java.time.LocalDate;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.core.impl.datetime.DateTimeServiceImpl;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.impl.PaymentRequestServiceImpl;
import org.kuali.kfs.module.purap.document.validation.impl.VendorCreditMemoInitTabRequiredFieldsValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class VendorCreditMemoInitTabRequiredFieldsValidationTest {
    private VendorCreditMemoInitTabRequiredFieldsValidation cut;
    @Mock
    private DataDictionaryService dataDictionarySvcMock;
    @Mock
    private VendorCreditMemoDocument creditMemoDocMock;

    VendorCreditMemoInitTabRequiredFieldsValidationTest() {
    }

    @BeforeEach
    void setUp() {
        this.setupCreditMemoDocMock();
        DateTimeServiceImpl dateTimeService = new DateTimeServiceImpl();
        PaymentRequestServiceImpl paymentRequestService = new PaymentRequestServiceImpl();
        paymentRequestService.setDateTimeService((DateTimeService)dateTimeService);
        this.cut = new VendorCreditMemoInitTabRequiredFieldsValidation();
        this.cut.setDataDictionaryService(this.dataDictionarySvcMock);
        this.cut.setPaymentRequestService((PaymentRequestService)paymentRequestService);
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    private void setupCreditMemoDocMock() {
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoNumber()).thenReturn((Object)"12345");
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoDate()).thenReturn((Object)Date.valueOf(LocalDate.now()));
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoAmount()).thenReturn((Object)new KualiDecimal(1));
    }

    @Test
    void validate_WithInvoiceWithTodayWithAmount() {
        Assertions.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
    }

    @Test
    void validate_WithInvoiceWithYesterdayWithAmount() {
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoDate()).thenReturn((Object)Date.valueOf(LocalDate.now().minusDays(1L)));
        Assertions.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
    }

    @Test
    void validate_WithInvoiceWithTomorrowWithAmount() {
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeErrorLabel(VendorCreditMemoDocument.class, "creditMemoDate")).thenReturn((Object)"Credit Memo Date");
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoDate()).thenReturn((Object)Date.valueOf(LocalDate.now().plusDays(1L)));
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("errors.invalid.invoice.date"));
    }

    @Test
    void validate_NoInvoiceWithTomorrowWithAmount() {
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeErrorLabel(VendorCreditMemoDocument.class, "creditMemoNumber")).thenReturn((Object)"Credit Memo Number");
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeErrorLabel(VendorCreditMemoDocument.class, "creditMemoDate")).thenReturn((Object)"Credit Memo Date");
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoDate()).thenReturn((Object)Date.valueOf(LocalDate.now().plusDays(1L)));
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoNumber()).thenReturn(null);
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assertions.assertEquals((int)2, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("errors.invalid.invoice.date"));
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("creditMemoNumber", "error.required"));
    }

    @Test
    void validate_WithInvoiceWithTomorrowNoAmount() {
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeErrorLabel(VendorCreditMemoDocument.class, "creditMemoAmount")).thenReturn((Object)"Credit Memo Amount");
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeErrorLabel(VendorCreditMemoDocument.class, "creditMemoDate")).thenReturn((Object)"Credit Memo Date");
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoDate()).thenReturn((Object)Date.valueOf(LocalDate.now().plusDays(1L)));
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoAmount()).thenReturn(null);
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assertions.assertEquals((int)2, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("errors.invalid.invoice.date"));
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("creditMemoAmount", "error.required"));
    }
}

