/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.core.api.parameter.ParameterEvaluator;
import org.kuali.kfs.core.api.parameter.ParameterEvaluatorService;
import org.kuali.kfs.core.impl.parameter.AlwaysSucceedParameterEvaluatorImpl;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.validation.impl.VendorCreditMemoObjectCodeValidation;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.document.validation.event.AddAccountingLineEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class VendorCreditMemoObjectCodeValidationTest {
    private VendorCreditMemoObjectCodeValidation cut;
    @Mock
    private ParameterEvaluatorService parameterEvaluatorSvcMock;

    VendorCreditMemoObjectCodeValidationTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new VendorCreditMemoObjectCodeValidation();
        this.cut.setParameterEvaluatorService(this.parameterEvaluatorSvcMock);
    }

    @Test
    void validate_validObjectCode(@Mock(stubOnly=true) ObjectCode objectCodeMock, @Mock(stubOnly=true) PurApAccountingLine accountingLineMock) {
        Mockito.when((Object)this.parameterEvaluatorSvcMock.getParameterEvaluator(VendorCreditMemoDocument.class, "VALID_OBJECT_LEVELS_BY_OBJECT_TYPE", "INVALID_OBJECT_LEVELS_BY_OBJECT_TYPE", "AS", "INV")).thenReturn((Object)AlwaysSucceedParameterEvaluatorImpl.getInstance());
        Mockito.when((Object)accountingLineMock.getObjectCode()).thenReturn((Object)objectCodeMock);
        Mockito.when((Object)objectCodeMock.getFinancialObjectTypeCode()).thenReturn((Object)"AS");
        Mockito.when((Object)objectCodeMock.getFinancialObjectLevelCode()).thenReturn((Object)"INV");
        Assertions.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AddAccountingLineEvent("", null, (AccountingLine)accountingLineMock)));
    }

    @Test
    void validate_invalidObjectCode(@Mock(stubOnly=true) ObjectCode objectCodeMock, @Mock(stubOnly=true) ParameterEvaluator alwaysFailParameterEvaluatorMock, @Mock(stubOnly=true) PurApAccountingLine accountingLineMock) {
        Mockito.when((Object)this.parameterEvaluatorSvcMock.getParameterEvaluator(VendorCreditMemoDocument.class, "VALID_OBJECT_LEVELS_BY_OBJECT_TYPE", "INVALID_OBJECT_LEVELS_BY_OBJECT_TYPE", "XX", "XXX")).thenReturn((Object)alwaysFailParameterEvaluatorMock);
        Mockito.when((Object)accountingLineMock.getObjectCode()).thenReturn((Object)objectCodeMock);
        Mockito.when((Object)objectCodeMock.getFinancialObjectTypeCode()).thenReturn((Object)"XX");
        Mockito.when((Object)objectCodeMock.getFinancialObjectLevelCode()).thenReturn((Object)"XXX");
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AddAccountingLineEvent("", null, (AccountingLine)accountingLineMock)));
    }
}

