/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.math.BigDecimal;
import java.util.Collections;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.CreditMemoService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.service.impl.CreditMemoServiceImpl;
import org.kuali.kfs.module.purap.document.validation.impl.VendorCreditMemoPurchaseOrderForInvoicedItemsValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class VendorCreditMemoPurchaseOrderForInvoicedItemsValidationTest {
    private static final int PO_ID = 1001;
    private VendorCreditMemoPurchaseOrderForInvoicedItemsValidation cut;
    @Mock
    private PurchaseOrderService purchaseOrderSvcMock;

    VendorCreditMemoPurchaseOrderForInvoicedItemsValidationTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new VendorCreditMemoPurchaseOrderForInvoicedItemsValidation();
        this.cut.setCreditMemoService((CreditMemoService)new CreditMemoServiceImpl());
        this.cut.setPurchaseOrderService(this.purchaseOrderSvcMock);
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    private static void setupCreditMemoDocMock(VendorCreditMemoDocument creditMemoDocMock) {
        Mockito.when((Object)creditMemoDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1001);
        Mockito.when((Object)creditMemoDocMock.isSourceDocumentPurchaseOrder()).thenReturn((Object)true);
    }

    private void setupPurchaseOrderSvcMock(PurchaseOrderDocument purchaseOrderDocMock, PurchaseOrderItem poItemMock) {
        ItemType itemType = new ItemType();
        itemType.setQuantityBasedGeneralLedgerIndicator(true);
        Mockito.when((Object)poItemMock.getItemType()).thenReturn((Object)itemType);
        Mockito.when((Object)poItemMock.getItemInvoicedTotalQuantity()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)purchaseOrderDocMock.getItems()).thenReturn(Collections.singletonList(poItemMock));
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(1001))).thenReturn((Object)purchaseOrderDocMock);
    }

    @Test
    void validate_SourceNotPO(@Mock(stubOnly=true) VendorCreditMemoDocument creditMemoDocMock) {
        Mockito.when((Object)creditMemoDocMock.isSourceDocumentPurchaseOrder()).thenReturn((Object)true);
        Mockito.when((Object)creditMemoDocMock.isSourceDocumentPurchaseOrder()).thenReturn((Object)false);
        Assertions.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)creditMemoDocMock)));
    }

    @Test
    void validate_InvoicedTotalQuantityGreaterThanZero(@Mock(stubOnly=true) PurchaseOrderDocument purchaseOrderDocMock, @Mock(stubOnly=true) PurchaseOrderItem poItemMock, @Mock(stubOnly=true) VendorCreditMemoDocument creditMemoDocMock) {
        VendorCreditMemoPurchaseOrderForInvoicedItemsValidationTest.setupCreditMemoDocMock(creditMemoDocMock);
        this.setupPurchaseOrderSvcMock(purchaseOrderDocMock, poItemMock);
        Mockito.when((Object)poItemMock.getItemInvoicedTotalQuantity()).thenReturn((Object)new KualiDecimal(1));
        Assertions.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)creditMemoDocMock)));
    }

    @Test
    void validate_ZeroUnitPriceAndOutstandingEncumberedAmount(@Mock(stubOnly=true) PurchaseOrderDocument purchaseOrderDocMock, @Mock(stubOnly=true) PurchaseOrderItem poItemMock, @Mock(stubOnly=true) VendorCreditMemoDocument creditMemoDocMock) {
        VendorCreditMemoPurchaseOrderForInvoicedItemsValidationTest.setupCreditMemoDocMock(creditMemoDocMock);
        this.setupPurchaseOrderSvcMock(purchaseOrderDocMock, poItemMock);
        Mockito.when((Object)poItemMock.getItemOutstandingEncumberedAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)creditMemoDocMock)));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("document.purchaseOrderIdentifier", "errors.creditMemo.po.noItems"));
    }

    @Test
    void validate_WithUnitPriceLessEqualOutstandingEncumberedAmount(@Mock(stubOnly=true) PurchaseOrderDocument purchaseOrderDocMock, @Mock(stubOnly=true) PurchaseOrderItem poItemMock, @Mock(stubOnly=true) VendorCreditMemoDocument creditMemoDocMock) {
        VendorCreditMemoPurchaseOrderForInvoicedItemsValidationTest.setupCreditMemoDocMock(creditMemoDocMock);
        this.setupPurchaseOrderSvcMock(purchaseOrderDocMock, poItemMock);
        Mockito.when((Object)poItemMock.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(1));
        Mockito.when((Object)poItemMock.getItemUnitPrice()).thenReturn((Object)new BigDecimal(1));
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)creditMemoDocMock)));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("document.purchaseOrderIdentifier", "errors.creditMemo.po.noItems"));
    }

    @Test
    void validate_NullUnitPrice(@Mock(stubOnly=true) PurchaseOrderDocument purchaseOrderDocMock, @Mock(stubOnly=true) PurchaseOrderItem poItemMock, @Mock(stubOnly=true) VendorCreditMemoDocument creditMemoDocMock) {
        VendorCreditMemoPurchaseOrderForInvoicedItemsValidationTest.setupCreditMemoDocMock(creditMemoDocMock);
        this.setupPurchaseOrderSvcMock(purchaseOrderDocMock, poItemMock);
        Mockito.when((Object)poItemMock.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(0.5));
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)creditMemoDocMock)));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("document.purchaseOrderIdentifier", "errors.creditMemo.po.noItems"));
    }

    @Test
    void validate_WithUnitPriceLessThanOutstandingEncumberedAmount(@Mock(stubOnly=true) PurchaseOrderDocument purchaseOrderDocMock, @Mock(stubOnly=true) PurchaseOrderItem poItemMock, @Mock(stubOnly=true) VendorCreditMemoDocument creditMemoDocMock) {
        VendorCreditMemoPurchaseOrderForInvoicedItemsValidationTest.setupCreditMemoDocMock(creditMemoDocMock);
        this.setupPurchaseOrderSvcMock(purchaseOrderDocMock, poItemMock);
        Mockito.when((Object)poItemMock.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(1));
        Mockito.when((Object)poItemMock.getItemUnitPrice()).thenReturn((Object)new BigDecimal("0.5"));
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)creditMemoDocMock)));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("document.purchaseOrderIdentifier", "errors.creditMemo.po.noItems"));
    }

    @Test
    void validate_WithUnitPriceEqualToOutstandingEncumberedAmount(@Mock(stubOnly=true) PurchaseOrderDocument purchaseOrderDocMock, @Mock(stubOnly=true) PurchaseOrderItem poItemMock, @Mock(stubOnly=true) VendorCreditMemoDocument creditMemoDocMock) {
        VendorCreditMemoPurchaseOrderForInvoicedItemsValidationTest.setupCreditMemoDocMock(creditMemoDocMock);
        this.setupPurchaseOrderSvcMock(purchaseOrderDocMock, poItemMock);
        Mockito.when((Object)poItemMock.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(1));
        Mockito.when((Object)poItemMock.getItemUnitPrice()).thenReturn((Object)new BigDecimal(1));
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)creditMemoDocMock)));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("document.purchaseOrderIdentifier", "errors.creditMemo.po.noItems"));
    }

    @Test
    void validate_WithUnitPriceGreaterThanOutstandingEncumberedAmount(@Mock(stubOnly=true) PurchaseOrderDocument purchaseOrderDocMock, @Mock(stubOnly=true) PurchaseOrderItem poItemMock, @Mock(stubOnly=true) VendorCreditMemoDocument creditMemoDocMock) {
        VendorCreditMemoPurchaseOrderForInvoicedItemsValidationTest.setupCreditMemoDocMock(creditMemoDocMock);
        this.setupPurchaseOrderSvcMock(purchaseOrderDocMock, poItemMock);
        Mockito.when((Object)poItemMock.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(1));
        Mockito.when((Object)poItemMock.getItemUnitPrice()).thenReturn((Object)new BigDecimal(2));
        Assertions.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)creditMemoDocMock)));
    }
}

