/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.validation.impl.VendorCreditMemoTotalOverZeroValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class VendorCreditMemoTotalOverZeroValidationTest {
    private VendorCreditMemoTotalOverZeroValidation cut;

    VendorCreditMemoTotalOverZeroValidationTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new VendorCreditMemoTotalOverZeroValidation();
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    void validate_PositiveTotal(@Mock(stubOnly=true) VendorCreditMemoDocument creditMemoDocMock) {
        Mockito.when((Object)creditMemoDocMock.getGrandTotal()).thenReturn((Object)new KualiDecimal(32));
        boolean actual = this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)creditMemoDocMock));
        Assertions.assertTrue((boolean)actual);
    }

    @Test
    void validate_NegativeTotal(@Mock(stubOnly=true) VendorCreditMemoDocument creditMemoDocMock) {
        Mockito.when((Object)creditMemoDocMock.getGrandTotal()).thenReturn((Object)new KualiDecimal(-32));
        boolean actual = this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)creditMemoDocMock));
        Assertions.assertFalse((boolean)actual);
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("document.item", "errors.creditMemo.total.zero"));
    }
}

