/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.web.struts;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.module.purap.businessobject.CapitalAssetSystemState;
import org.kuali.kfs.module.purap.businessobject.CapitalAssetSystemType;
import org.kuali.kfs.module.purap.document.web.struts.PurchaseOrderForm;
import org.kuali.kfs.module.purap.document.web.struts.PurchasingActionBase;
import org.kuali.kfs.module.purap.document.web.struts.PurchasingFormBase;
import org.kuali.kfs.module.purap.document.web.struts.RequisitionForm;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class PurchasingActionBaseTest {
    private PurchasingActionBase cut;

    PurchasingActionBaseTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new PurchasingActionBase();
    }

    @Test
    void requiresCalculate_PurchaseOrderForm_UserCanCalculate_NotCalculated_True(@Mock PurchaseOrderForm purchaseOrderFormMock) {
        Mockito.when((Object)purchaseOrderFormMock.canUserCalculate()).thenReturn((Object)true);
        Mockito.when((Object)purchaseOrderFormMock.isCalculated()).thenReturn((Object)false);
        boolean actual = this.cut.requiresCalculate((PurchasingFormBase)purchaseOrderFormMock);
        Assertions.assertTrue((boolean)actual);
    }

    @Test
    void requiresCalculate_PurchaseOrderForm_UserCanCalculate_Calculated_False(@Mock PurchaseOrderForm purchaseOrderFormMock) {
        Mockito.when((Object)purchaseOrderFormMock.isCalculated()).thenReturn((Object)true);
        boolean actual = this.cut.requiresCalculate((PurchasingFormBase)purchaseOrderFormMock);
        Assertions.assertFalse((boolean)actual);
    }

    @Test
    void requiresCalculate_PurchaseOrderForm_UserCannotCalculate_NotCalculated_False(@Mock PurchaseOrderForm purchaseOrderFormMock) {
        Mockito.when((Object)purchaseOrderFormMock.canUserCalculate()).thenReturn((Object)false);
        Mockito.when((Object)purchaseOrderFormMock.isCalculated()).thenReturn((Object)false);
        boolean actual = this.cut.requiresCalculate((PurchasingFormBase)purchaseOrderFormMock);
        Assertions.assertFalse((boolean)actual);
    }

    @Test
    void requiresCalculate_PurchaseOrderForm_UserCannotCalculate_Calculated_False(@Mock PurchaseOrderForm purchaseOrderFormMock) {
        Mockito.when((Object)purchaseOrderFormMock.isCalculated()).thenReturn((Object)true);
        boolean actual = this.cut.requiresCalculate((PurchasingFormBase)purchaseOrderFormMock);
        Assertions.assertFalse((boolean)actual);
    }

    @Test
    void requiresCalculate_RequisitionForm_UserCanCalculate_NotCalculated_True(@Mock RequisitionForm requisitionFormMock) {
        Mockito.when((Object)requisitionFormMock.canUserCalculate()).thenReturn((Object)true);
        Mockito.when((Object)requisitionFormMock.isCalculated()).thenReturn((Object)false);
        boolean actual = this.cut.requiresCalculate((PurchasingFormBase)requisitionFormMock);
        Assertions.assertTrue((boolean)actual);
    }

    @Test
    void requiresCalculate_RequisitionForm_UserCanCalculate_Calculated_False(@Mock RequisitionForm requisitionFormMock) {
        Mockito.when((Object)requisitionFormMock.isCalculated()).thenReturn((Object)true);
        boolean actual = this.cut.requiresCalculate((PurchasingFormBase)requisitionFormMock);
        Assertions.assertFalse((boolean)actual);
    }

    @Test
    void requiresCalculate_RequisitionForm_UserCannotCalculate_NotCalculated_False(@Mock RequisitionForm requisitionFormMock) {
        Mockito.when((Object)requisitionFormMock.canUserCalculate()).thenReturn((Object)false);
        Mockito.when((Object)requisitionFormMock.isCalculated()).thenReturn((Object)false);
        boolean actual = this.cut.requiresCalculate((PurchasingFormBase)requisitionFormMock);
        Assertions.assertFalse((boolean)actual);
    }

    @Test
    void requiresCalculate_RequisitionForm_UserCannotCalculate_Calculated_False(@Mock RequisitionForm requisitionFormMock) {
        Mockito.when((Object)requisitionFormMock.isCalculated()).thenReturn((Object)true);
        boolean actual = this.cut.requiresCalculate((PurchasingFormBase)requisitionFormMock);
        Assertions.assertFalse((boolean)actual);
    }

    @Test
    void validateCapitalAssetSystemStateAllowed_success(@Mock(stubOnly=true) CapitalAssetSystemType capitalAssetSystemType, @Mock(stubOnly=true) CapitalAssetSystemState capitalAssetSystemState) {
        Mockito.when((Object)capitalAssetSystemType.getAllowedCapitalAssetSystemStateCodes()).thenReturn((Object)"MOD;NEW");
        Mockito.when((Object)capitalAssetSystemState.getCapitalAssetSystemStateCode()).thenReturn((Object)"MOD");
        boolean actual = PurchasingActionBase.validateCapitalAssetSystemStateAllowed((CapitalAssetSystemType)capitalAssetSystemType, (CapitalAssetSystemState)capitalAssetSystemState);
        Assertions.assertTrue((boolean)actual);
    }

    @Test
    void validateCapitalAssetSystemStateAllowed_failure_type_individual(@Mock(stubOnly=true) CapitalAssetSystemType capitalAssetSystemType, @Mock(stubOnly=true) CapitalAssetSystemState capitalAssetSystemState) {
        Mockito.when((Object)capitalAssetSystemType.getCapitalAssetSystemTypeDescription()).thenReturn((Object)"doesn't matter A");
        Mockito.when((Object)capitalAssetSystemType.getAllowedCapitalAssetSystemStateCodes()).thenReturn((Object)"MOD");
        Mockito.when((Object)capitalAssetSystemState.getCapitalAssetSystemStateCode()).thenReturn((Object)"NEW");
        Mockito.when((Object)capitalAssetSystemState.getCapitalAssetSystemStateDescription()).thenReturn((Object)"doesn't matter B");
        boolean actual = PurchasingActionBase.validateCapitalAssetSystemStateAllowed((CapitalAssetSystemType)capitalAssetSystemType, (CapitalAssetSystemState)capitalAssetSystemState);
        Assertions.assertFalse((boolean)actual);
    }

    @Test
    void validateCapitalAssetSystemStateAllowed_failure_type_multiple(@Mock(stubOnly=true) CapitalAssetSystemType capitalAssetSystemType, @Mock(stubOnly=true) CapitalAssetSystemState capitalAssetSystemState) {
        Mockito.when((Object)capitalAssetSystemType.getCapitalAssetSystemTypeDescription()).thenReturn((Object)"doesn't matter A");
        Mockito.when((Object)capitalAssetSystemType.getAllowedCapitalAssetSystemStateCodes()).thenReturn((Object)"MOD");
        Mockito.when((Object)capitalAssetSystemState.getCapitalAssetSystemStateCode()).thenReturn((Object)"NEW");
        Mockito.when((Object)capitalAssetSystemState.getCapitalAssetSystemStateDescription()).thenReturn((Object)"doesn't matter B");
        boolean actual = PurchasingActionBase.validateCapitalAssetSystemStateAllowed((CapitalAssetSystemType)capitalAssetSystemType, (CapitalAssetSystemState)capitalAssetSystemState);
        Assertions.assertFalse((boolean)actual);
    }
}

