/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.Date;
import java.util.List;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.mo.common.GloballyUnique;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kim.api.identity.PersonService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.util.MessageList;
import org.kuali.kfs.krad.bo.Attachment;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.AttachmentService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.batch.ElectronicInvoiceStep;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceRejectReason;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.service.AccountsPayableService;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.RequisitionService;
import org.kuali.kfs.module.purap.service.ElectronicInvoiceMatchingService;
import org.kuali.kfs.module.purap.service.impl.ElectronicInvoiceHelperServiceImpl;
import org.kuali.kfs.module.purap.service.impl.ElectronicInvoiceOrderHolder;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.service.BankService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
@Execution(value=ExecutionMode.SAME_THREAD)
class ElectronicInvoiceHelperServiceImplTest {
    private static final String CAMPUS_CODE = "campus code";
    private static final Date CURRENT_DATE = new Date(2L);
    private static final String CUSTOMER_NUMBER = "customer number";
    private static final String INITIATOR_ID = "initiator id";
    private static final Date INVOICE_DATE = new Date(1L);
    private static final int INVOICE_NET_AMOUNT = 34;
    private static final String INVOICE_NUMBER = "invoice number";
    private static final int REQUISITION_IDENTIFIER = 56;
    private ElectronicInvoiceHelperServiceImpl cut;

    ElectronicInvoiceHelperServiceImplTest() {
    }

    @BeforeEach
    void setUp() {
        GlobalVariables.getMessageMap().clearErrorMessages();
        KNSGlobalVariables.setMessageList((MessageList)new MessageList());
        this.cut = new ElectronicInvoiceHelperServiceImpl();
    }

    @AfterAll
    static void tearDownMessages() {
        GlobalVariables.getMessageMap().clearErrorMessages();
        KNSGlobalVariables.setMessageList((MessageList)new MessageList());
    }

    @Test
    @DisplayName(value="createPaymentRequest() succeeds")
    void createPaymentRequest(@Mock(stubOnly=true) AccountsPayableService accountsPayableServiceMock, @Mock(stubOnly=true) BankService bankServiceMock, @Mock(stubOnly=true) BusinessObjectService businessObjectServiceMock, @Mock(stubOnly=true) DateTimeService dateTimeServiceMock, @Mock(stubOnly=true) DataDictionaryService dataDictionaryServiceMock, @Mock(stubOnly=true) DocumentService documentServiceMock, @Mock(stubOnly=true) KualiRuleService kualiRuleServiceMock, @Mock(stubOnly=true) ParameterService parameterServiceMock, @Mock PaymentRequestService paymentRequestServiceMock, @Mock(stubOnly=true) PersonService personServiceMock, @Mock(stubOnly=true) RequisitionService requisitionServiceMock, @Mock(stubOnly=true) ElectronicInvoiceOrderHolder orderHolderMock, @Mock(stubOnly=true) PurchaseOrderDocument purchaseOrderDocumentMock, @Mock(stubOnly=true) RequisitionDocument requisitionDocumentMock, @Mock(stubOnly=true) WorkflowDocument workflowDocumentMock, @Mock PaymentRequestDocument paymentRequestDocumentMock) {
        this.cut.setAccountsPayableService(accountsPayableServiceMock);
        this.cut.setBankService(bankServiceMock);
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        this.cut.setDateTimeService(dateTimeServiceMock);
        this.cut.setDataDictionaryService(dataDictionaryServiceMock);
        this.cut.setDocumentService(documentServiceMock);
        this.cut.setKualiRuleService(kualiRuleServiceMock);
        this.cut.setParameterService(parameterServiceMock);
        this.cut.setPaymentRequestService(paymentRequestServiceMock);
        this.cut.setPersonService(personServiceMock);
        this.cut.setRequisitionService(requisitionServiceMock);
        Mockito.when((Object)orderHolderMock.isInvoiceRejected()).thenReturn((Object)false);
        DocumentHeader paymentRequestHeader = ElectronicInvoiceHelperServiceImplTest.setUpPaymentRequest(documentServiceMock, paymentRequestDocumentMock);
        ElectronicInvoiceHelperServiceImplTest.setUpPurchaseOrder(orderHolderMock, purchaseOrderDocumentMock);
        ElectronicInvoiceHelperServiceImplTest.setUpInvoice(orderHolderMock);
        ElectronicInvoiceHelperServiceImplTest.setUpCurrentDate(dateTimeServiceMock);
        ElectronicInvoiceHelperServiceImplTest.setUpDataDictionary(dataDictionaryServiceMock);
        ElectronicInvoiceHelperServiceImplTest.setUpRequisition(requisitionServiceMock, purchaseOrderDocumentMock, requisitionDocumentMock, workflowDocumentMock);
        ElectronicInvoiceHelperServiceImplTest.setUpInitiator(parameterServiceMock, personServiceMock, workflowDocumentMock);
        PaymentRequestDocument result = this.cut.createPaymentRequest(orderHolderMock);
        Assertions.assertSame((Object)paymentRequestDocumentMock, (Object)result);
        Assertions.assertEquals((Object)"PO: 34 Vendor: null Electronic Invoice", (Object)paymentRequestHeader.getDocumentDescription());
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocumentMock)).setInvoiceDate(INVOICE_DATE);
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocumentMock)).setInvoiceNumber(INVOICE_NUMBER);
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocumentMock)).setVendorInvoiceAmount(new KualiDecimal(34));
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocumentMock)).setAccountsPayableProcessorIdentifier("E-Invoice");
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocumentMock)).setVendorCustomerNumber(CUSTOMER_NUMBER);
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocumentMock)).setPaymentRequestElectronicInvoiceIndicator(true);
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocumentMock)).setProcessingCampusCode(CAMPUS_CODE);
        ((PaymentRequestService)Mockito.verify((Object)paymentRequestServiceMock)).initializePaymentMethodAndBank(paymentRequestDocumentMock);
    }

    @Test
    @DisplayName(value="createPaymentRequest() with rejected invoice")
    void createPaymentRequestWithRejectedInvoice(@Mock(stubOnly=true) DateTimeService dateTimeServiceMock, @Mock(stubOnly=true) PaymentRequestService paymentRequestServiceMock, @Mock(stubOnly=true) ElectronicInvoiceOrderHolder orderHolderMock, @Mock(stubOnly=true) PurchaseOrderDocument purchaseOrderDocumentMock) {
        this.cut.setDateTimeService(dateTimeServiceMock);
        this.cut.setPaymentRequestService(paymentRequestServiceMock);
        Mockito.when((Object)orderHolderMock.isInvoiceRejected()).thenReturn((Object)true);
        Mockito.when((Object)orderHolderMock.getInvoiceDate()).thenReturn((Object)INVOICE_DATE);
        Mockito.when((Object)orderHolderMock.getPurchaseOrderDocument()).thenReturn((Object)purchaseOrderDocumentMock);
        ElectronicInvoiceHelperServiceImplTest.setUpCurrentDate(dateTimeServiceMock);
        Assertions.assertNull((Object)this.cut.createPaymentRequest(orderHolderMock));
    }

    @Test
    @DisplayName(value="createPaymentRequest() with campus code error")
    void createPaymentRequestWithCampusCodeError(@Mock(stubOnly=true) AccountsPayableService accountsPayableServiceMock, @Mock(stubOnly=true) BankService bankServiceMock, @Mock(stubOnly=true) BusinessObjectService businessObjectServiceMock, @Mock(stubOnly=true) DateTimeService dateTimeServiceMock, @Mock(stubOnly=true) DataDictionaryService dataDictionaryServiceMock, @Mock(stubOnly=true) DocumentService documentServiceMock, @Mock(stubOnly=true) ElectronicInvoiceMatchingService electronicInvoiceMatchingServiceMock, @Mock(stubOnly=true) KualiRuleService kualiRuleServiceMock, @Mock(stubOnly=true) ParameterService parameterServiceMock, @Mock(stubOnly=true) PaymentRequestService paymentRequestServiceMock, @Mock(stubOnly=true) PersonService personServiceMock, @Mock(stubOnly=true) RequisitionService requisitionServiceMock, @Mock ElectronicInvoiceOrderHolder orderHolderMock, @Mock(stubOnly=true) PurchaseOrderDocument purchaseOrderDocumentMock, @Mock(stubOnly=true) RequisitionDocument requisitionDocumentMock, @Mock(stubOnly=true) WorkflowDocument workflowDocumentMock, @Mock PaymentRequestDocument paymentRequestDocumentMock) {
        this.cut.setAccountsPayableService(accountsPayableServiceMock);
        this.cut.setBankService(bankServiceMock);
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        this.cut.setDateTimeService(dateTimeServiceMock);
        this.cut.setDataDictionaryService(dataDictionaryServiceMock);
        this.cut.setDocumentService(documentServiceMock);
        this.cut.setElectronicInvoiceMatchingService(electronicInvoiceMatchingServiceMock);
        this.cut.setKualiRuleService(kualiRuleServiceMock);
        this.cut.setParameterService(parameterServiceMock);
        this.cut.setPaymentRequestService(paymentRequestServiceMock);
        this.cut.setPersonService(personServiceMock);
        this.cut.setRequisitionService(requisitionServiceMock);
        Mockito.when((Object)orderHolderMock.isInvoiceRejected()).thenReturn((Object)false);
        ElectronicInvoiceHelperServiceImplTest.setUpPaymentRequest(documentServiceMock, paymentRequestDocumentMock);
        ElectronicInvoiceHelperServiceImplTest.setUpPurchaseOrder(orderHolderMock, purchaseOrderDocumentMock);
        ElectronicInvoiceHelperServiceImplTest.setUpInvoice(orderHolderMock);
        ElectronicInvoiceHelperServiceImplTest.setUpCurrentDate(dateTimeServiceMock);
        ElectronicInvoiceHelperServiceImplTest.setUpDataDictionary(dataDictionaryServiceMock);
        ElectronicInvoiceHelperServiceImplTest.setUpRequisition(requisitionServiceMock, purchaseOrderDocumentMock, requisitionDocumentMock, workflowDocumentMock);
        Mockito.when((Object)workflowDocumentMock.getInitiatorPrincipalId()).thenReturn((Object)INITIATOR_ID);
        Person initiator = new Person();
        Mockito.when((Object)personServiceMock.getPerson(INITIATOR_ID)).thenReturn((Object)initiator);
        Mockito.when((Object)parameterServiceMock.getParameterValueAsString(ElectronicInvoiceStep.class, "OVERRIDE_PROCESSING_CAMPUS")).thenThrow(new Throwable[]{new RuntimeException("no campus code")});
        ElectronicInvoiceRejectReason rejectReason = ElectronicInvoiceHelperServiceImplTest.setUpRejectReason(electronicInvoiceMatchingServiceMock, orderHolderMock);
        Assertions.assertNull((Object)this.cut.createPaymentRequest(orderHolderMock));
        ((ElectronicInvoiceOrderHolder)Mockito.verify((Object)orderHolderMock)).addInvoiceOrderRejectReason(rejectReason);
    }

    @Test
    @DisplayName(value="createPaymentRequest() with an invoice rejected in the middle of the process")
    void createPaymentRequestWithEventuallyRejectedInvoice(@Mock(stubOnly=true) AccountsPayableService accountsPayableServiceMock, @Mock(stubOnly=true) BankService bankServiceMock, @Mock(stubOnly=true) BusinessObjectService businessObjectServiceMock, @Mock(stubOnly=true) DateTimeService dateTimeServiceMock, @Mock(stubOnly=true) DataDictionaryService dataDictionaryServiceMock, @Mock(stubOnly=true) DocumentService documentServiceMock, @Mock(stubOnly=true) KualiRuleService kualiRuleServiceMock, @Mock(stubOnly=true) ParameterService parameterServiceMock, @Mock(stubOnly=true) PaymentRequestService paymentRequestServiceMock, @Mock(stubOnly=true) PersonService personServiceMock, @Mock(stubOnly=true) RequisitionService requisitionServiceMock, @Mock(stubOnly=true) ElectronicInvoiceOrderHolder orderHolderMock, @Mock(stubOnly=true) PurchaseOrderDocument purchaseOrderDocumentMock, @Mock(stubOnly=true) RequisitionDocument requisitionDocumentMock, @Mock(stubOnly=true) WorkflowDocument workflowDocumentMock, @Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock) {
        this.cut.setAccountsPayableService(accountsPayableServiceMock);
        this.cut.setBankService(bankServiceMock);
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        this.cut.setDateTimeService(dateTimeServiceMock);
        this.cut.setDataDictionaryService(dataDictionaryServiceMock);
        this.cut.setDocumentService(documentServiceMock);
        this.cut.setKualiRuleService(kualiRuleServiceMock);
        this.cut.setParameterService(parameterServiceMock);
        this.cut.setPaymentRequestService(paymentRequestServiceMock);
        this.cut.setPersonService(personServiceMock);
        this.cut.setRequisitionService(requisitionServiceMock);
        Mockito.when((Object)orderHolderMock.isInvoiceRejected()).thenReturn((Object)false, (Object[])new Boolean[]{false, true});
        ElectronicInvoiceHelperServiceImplTest.setUpPaymentRequest(documentServiceMock, paymentRequestDocumentMock);
        ElectronicInvoiceHelperServiceImplTest.setUpPurchaseOrder(orderHolderMock, purchaseOrderDocumentMock);
        ElectronicInvoiceHelperServiceImplTest.setUpInvoice(orderHolderMock);
        ElectronicInvoiceHelperServiceImplTest.setUpCurrentDate(dateTimeServiceMock);
        ElectronicInvoiceHelperServiceImplTest.setUpDataDictionary(dataDictionaryServiceMock);
        ElectronicInvoiceHelperServiceImplTest.setUpRequisition(requisitionServiceMock, purchaseOrderDocumentMock, requisitionDocumentMock, workflowDocumentMock);
        ElectronicInvoiceHelperServiceImplTest.setUpInitiator(parameterServiceMock, personServiceMock, workflowDocumentMock);
        Assertions.assertNull((Object)this.cut.createPaymentRequest(orderHolderMock));
    }

    @Test
    @DisplayName(value="createPaymentRequest() with routing error")
    void createPaymentRequestWithRoutingError(@Mock(stubOnly=true) AccountsPayableService accountsPayableServiceMock, @Mock(stubOnly=true) BankService bankServiceMock, @Mock(stubOnly=true) BusinessObjectService businessObjectServiceMock, @Mock(stubOnly=true) DateTimeService dateTimeServiceMock, @Mock(stubOnly=true) DataDictionaryService dataDictionaryServiceMock, @Mock(stubOnly=true) DocumentService documentServiceMock, @Mock(stubOnly=true) ElectronicInvoiceMatchingService electronicInvoiceMatchingServiceMock, @Mock(stubOnly=true) KualiRuleService kualiRuleServiceMock, @Mock(stubOnly=true) ParameterService parameterServiceMock, @Mock(stubOnly=true) PaymentRequestService paymentRequestServiceMock, @Mock(stubOnly=true) PersonService personServiceMock, @Mock(stubOnly=true) RequisitionService requisitionServiceMock, @Mock(stubOnly=true) ElectronicInvoiceOrderHolder orderHolderMock, @Mock(stubOnly=true) PurchaseOrderDocument purchaseOrderDocumentMock, @Mock(stubOnly=true) RequisitionDocument requisitionDocumentMock, @Mock(stubOnly=true) WorkflowDocument workflowDocumentMock, @Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocumentMock) {
        this.cut.setAccountsPayableService(accountsPayableServiceMock);
        this.cut.setBankService(bankServiceMock);
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        this.cut.setDateTimeService(dateTimeServiceMock);
        this.cut.setDataDictionaryService(dataDictionaryServiceMock);
        this.cut.setDocumentService(documentServiceMock);
        this.cut.setElectronicInvoiceMatchingService(electronicInvoiceMatchingServiceMock);
        this.cut.setKualiRuleService(kualiRuleServiceMock);
        this.cut.setParameterService(parameterServiceMock);
        this.cut.setPaymentRequestService(paymentRequestServiceMock);
        this.cut.setPersonService(personServiceMock);
        this.cut.setRequisitionService(requisitionServiceMock);
        Mockito.when((Object)orderHolderMock.isInvoiceRejected()).thenReturn((Object)false);
        ElectronicInvoiceHelperServiceImplTest.setUpPaymentRequest(documentServiceMock, paymentRequestDocumentMock);
        ElectronicInvoiceHelperServiceImplTest.setUpPurchaseOrder(orderHolderMock, purchaseOrderDocumentMock);
        ElectronicInvoiceHelperServiceImplTest.setUpInvoice(orderHolderMock);
        ElectronicInvoiceHelperServiceImplTest.setUpCurrentDate(dateTimeServiceMock);
        ElectronicInvoiceHelperServiceImplTest.setUpDataDictionary(dataDictionaryServiceMock);
        ElectronicInvoiceHelperServiceImplTest.setUpRequisition(requisitionServiceMock, purchaseOrderDocumentMock, requisitionDocumentMock, workflowDocumentMock);
        ElectronicInvoiceHelperServiceImplTest.setUpInitiator(parameterServiceMock, personServiceMock, workflowDocumentMock);
        Mockito.when((Object)documentServiceMock.routeDocument((Document)ArgumentMatchers.eq((Object)paymentRequestDocumentMock), (String)ArgumentMatchers.any(), (List)ArgumentMatchers.isNull())).thenThrow(new Throwable[]{new ValidationException("routing error")});
        ElectronicInvoiceHelperServiceImplTest.setUpRejectReason(electronicInvoiceMatchingServiceMock, orderHolderMock);
        Assertions.assertNull((Object)this.cut.createPaymentRequest(orderHolderMock));
    }

    @Test
    @DisplayName(value="createPaymentRequest() creates a note from the invoice file")
    void createPaymentRequestWithInvoiceFile(@Mock(stubOnly=true) AccountsPayableService accountsPayableServiceMock, @Mock(stubOnly=true) AttachmentService attachmentServiceMock, @Mock(stubOnly=true) BankService bankServiceMock, @Mock(stubOnly=true) BusinessObjectService businessObjectServiceMock, @Mock(stubOnly=true) DateTimeService dateTimeServiceMock, @Mock(stubOnly=true) DataDictionaryService dataDictionaryServiceMock, @Mock(stubOnly=true) DocumentService documentServiceMock, @Mock(stubOnly=true) KualiRuleService kualiRuleServiceMock, @Mock NoteService noteServiceMock, @Mock(stubOnly=true) ParameterService parameterServiceMock, @Mock PaymentRequestService paymentRequestServiceMock, @Mock(stubOnly=true) PersonService personServiceMock, @Mock(stubOnly=true) RequisitionService requisitionServiceMock, @Mock(stubOnly=true) ElectronicInvoiceOrderHolder orderHolderMock, @Mock(stubOnly=true) PurchaseOrderDocument purchaseOrderDocumentMock, @Mock(stubOnly=true) RequisitionDocument requisitionDocumentMock, @Mock(stubOnly=true) WorkflowDocument workflowDocumentMock, @Mock PaymentRequestDocument paymentRequestDocumentMock) throws IOException {
        this.cut.setAccountsPayableService(accountsPayableServiceMock);
        this.cut.setAttachmentService(attachmentServiceMock);
        this.cut.setBankService(bankServiceMock);
        this.cut.setBusinessObjectService(businessObjectServiceMock);
        this.cut.setDateTimeService(dateTimeServiceMock);
        this.cut.setDataDictionaryService(dataDictionaryServiceMock);
        this.cut.setDocumentService(documentServiceMock);
        this.cut.setKualiRuleService(kualiRuleServiceMock);
        this.cut.setNoteService(noteServiceMock);
        this.cut.setParameterService(parameterServiceMock);
        this.cut.setPaymentRequestService(paymentRequestServiceMock);
        this.cut.setPersonService(personServiceMock);
        this.cut.setRequisitionService(requisitionServiceMock);
        Mockito.when((Object)orderHolderMock.isInvoiceRejected()).thenReturn((Object)false);
        DocumentHeader paymentRequestHeader = ElectronicInvoiceHelperServiceImplTest.setUpPaymentRequest(documentServiceMock, paymentRequestDocumentMock);
        ElectronicInvoiceHelperServiceImplTest.setUpPurchaseOrder(orderHolderMock, purchaseOrderDocumentMock);
        ElectronicInvoiceHelperServiceImplTest.setUpInvoice(orderHolderMock);
        ElectronicInvoiceHelperServiceImplTest.setUpCurrentDate(dateTimeServiceMock);
        ElectronicInvoiceHelperServiceImplTest.setUpDataDictionary(dataDictionaryServiceMock);
        ElectronicInvoiceHelperServiceImplTest.setUpRequisition(requisitionServiceMock, purchaseOrderDocumentMock, requisitionDocumentMock, workflowDocumentMock);
        ElectronicInvoiceHelperServiceImplTest.setUpInitiator(parameterServiceMock, personServiceMock, workflowDocumentMock);
        File invoiceFile = Files.createTempFile(null, null, new FileAttribute[0]).toFile();
        invoiceFile.deleteOnExit();
        Note note = new Note();
        Mockito.when((Object)documentServiceMock.createNoteFromDocument((Document)ArgumentMatchers.eq((Object)paymentRequestDocumentMock), (String)ArgumentMatchers.any())).thenReturn((Object)note);
        Mockito.when((Object)paymentRequestDocumentMock.getNoteTarget()).thenReturn((Object)paymentRequestHeader);
        String objectId = "object id";
        paymentRequestHeader.setObjectId("object id");
        Attachment attachment = new Attachment();
        Mockito.when((Object)attachmentServiceMock.createAttachment((GloballyUnique)ArgumentMatchers.eq((Object)paymentRequestHeader), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"text/xml"), ArgumentMatchers.eq((int)0), (InputStream)ArgumentMatchers.any(), (String)ArgumentMatchers.isNull())).thenReturn((Object)attachment);
        PaymentRequestDocument result = this.cut.createPaymentRequest(orderHolderMock, invoiceFile);
        Assertions.assertSame((Object)paymentRequestDocumentMock, (Object)result);
        Assertions.assertEquals((Object)"PO: 34 Vendor: null Electronic Invoice", (Object)paymentRequestHeader.getDocumentDescription());
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocumentMock)).setInvoiceDate(INVOICE_DATE);
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocumentMock)).setInvoiceNumber(INVOICE_NUMBER);
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocumentMock)).setVendorInvoiceAmount(new KualiDecimal(34));
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocumentMock)).setVendorCustomerNumber(CUSTOMER_NUMBER);
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocumentMock)).setAccountsPayableProcessorIdentifier("E-Invoice");
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocumentMock)).setPaymentRequestElectronicInvoiceIndicator(true);
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocumentMock)).setProcessingCampusCode(CAMPUS_CODE);
        ((PaymentRequestService)Mockito.verify((Object)paymentRequestServiceMock)).initializePaymentMethodAndBank(paymentRequestDocumentMock);
        Assertions.assertEquals((Object)"object id", (Object)note.getRemoteObjectIdentifier());
        Assertions.assertSame((Object)attachment, (Object)note.getAttachment());
        Assertions.assertSame((Object)note, (Object)attachment.getNote());
        ((NoteService)Mockito.verify((Object)noteServiceMock)).save(note);
    }

    private static DocumentHeader setUpPaymentRequest(DocumentService documentServiceMock, PaymentRequestDocument paymentRequestDocumentMock) {
        Mockito.when((Object)documentServiceMock.getNewDocument("PREQ")).thenReturn((Object)paymentRequestDocumentMock);
        DocumentHeader paymentRequestHeader = new DocumentHeader();
        Mockito.when((Object)paymentRequestDocumentMock.getDocumentHeader()).thenReturn((Object)paymentRequestHeader);
        return paymentRequestHeader;
    }

    private static void setUpPurchaseOrder(ElectronicInvoiceOrderHolder orderHolderMock, PurchaseOrderDocument purchaseOrderDocumentMock) {
        Mockito.when((Object)purchaseOrderDocumentMock.getPurapDocumentIdentifier()).thenReturn((Object)34);
        Mockito.when((Object)orderHolderMock.getPurchaseOrderDocument()).thenReturn((Object)purchaseOrderDocumentMock);
    }

    private static void setUpInvoice(ElectronicInvoiceOrderHolder orderHolderMock) {
        Mockito.when((Object)orderHolderMock.getInvoiceDate()).thenReturn((Object)INVOICE_DATE);
        Mockito.when((Object)orderHolderMock.getInvoiceNumber()).thenReturn((Object)INVOICE_NUMBER);
        Mockito.when((Object)orderHolderMock.getInvoiceNetAmount()).thenReturn((Object)new BigDecimal(34));
        Mockito.when((Object)orderHolderMock.getCustomerNumber()).thenReturn((Object)CUSTOMER_NUMBER);
    }

    private static void setUpCurrentDate(DateTimeService dateTimeServiceMock) {
        Mockito.when((Object)dateTimeServiceMock.getCurrentDate()).thenReturn((Object)CURRENT_DATE);
    }

    private static void setUpDataDictionary(DataDictionaryService dataDictionaryServiceMock) {
        int veryLongAttributeLength = 10000;
        Mockito.when((Object)dataDictionaryServiceMock.getAttributeMaxLength(DocumentHeader.class, "documentDescription")).thenReturn((Object)10000);
    }

    private static void setUpRequisition(RequisitionService requisitionServiceMock, PurchaseOrderDocument purchaseOrderDocumentMock, RequisitionDocument requisitionDocumentMock, WorkflowDocument workflowDocumentMock) {
        Mockito.when((Object)purchaseOrderDocumentMock.getRequisitionIdentifier()).thenReturn((Object)56);
        Mockito.when((Object)requisitionServiceMock.getRequisitionById(Integer.valueOf(56))).thenReturn((Object)requisitionDocumentMock);
        DocumentHeader requisitionHeader = new DocumentHeader();
        requisitionHeader.setWorkflowDocument(workflowDocumentMock);
        Mockito.when((Object)requisitionDocumentMock.getDocumentHeader()).thenReturn((Object)requisitionHeader);
    }

    private static void setUpInitiator(ParameterService parameterServiceMock, PersonService personServiceMock, WorkflowDocument workflowDocumentMock) {
        Mockito.when((Object)workflowDocumentMock.getInitiatorPrincipalId()).thenReturn((Object)INITIATOR_ID);
        Person initiator = new Person();
        Mockito.when((Object)personServiceMock.getPerson(INITIATOR_ID)).thenReturn((Object)initiator);
        Mockito.when((Object)parameterServiceMock.getParameterValueAsString(ElectronicInvoiceStep.class, "OVERRIDE_PROCESSING_CAMPUS")).thenReturn((Object)CAMPUS_CODE);
    }

    private static ElectronicInvoiceRejectReason setUpRejectReason(ElectronicInvoiceMatchingService electronicInvoiceMatchingServiceMock, ElectronicInvoiceOrderHolder orderHolderMock) {
        String fileName = "file name";
        Mockito.when((Object)orderHolderMock.getFileName()).thenReturn((Object)"file name");
        ElectronicInvoiceRejectReason rejectReason = new ElectronicInvoiceRejectReason();
        Mockito.when((Object)electronicInvoiceMatchingServiceMock.createRejectReason((String)ArgumentMatchers.eq((Object)"PRVE"), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"file name"))).thenReturn((Object)rejectReason);
        return rejectReason;
    }
}

