/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.service.impl.PurapGeneralLedgerServiceImpl;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class CustomizeGeneralLedgerPendingEntryTest {
    private PurapGeneralLedgerServiceImpl cut;
    @Mock(stubOnly=true)
    private UniversityDateService universityDateSvcMock;
    @Mock(stubOnly=true)
    private ObjectCodeService objectCodeSvcMock;
    @Mock(stubOnly=true)
    private PaymentRequestService paymentRequestSvcMock;

    CustomizeGeneralLedgerPendingEntryTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new PurapGeneralLedgerServiceImpl();
        this.cut.setUniversityDateService(this.universityDateSvcMock);
        this.cut.setObjectCodeService(this.objectCodeSvcMock);
        this.cut.setPaymentRequestService(this.paymentRequestSvcMock);
    }

    @Test
    void poDocumentSameYearNonEncumbrancePositive(@Mock(stubOnly=true) PurchasingAccountsPayableDocument purapDocMock) {
        GeneralLedgerPendingEntry explicitEntry = CustomizeGeneralLedgerPendingEntryTest.getGeneralLedgerPendingEntry();
        Mockito.when((Object)purapDocMock.getDocumentNumber()).thenReturn((Object)"DOC1234");
        Mockito.when((Object)purapDocMock.getVendorName()).thenReturn((Object)"ACME Corporation");
        Mockito.when((Object)this.universityDateSvcMock.getCurrentUniversityDate()).thenReturn((Object)CustomizeGeneralLedgerPendingEntryTest.getUniversityDate());
        Mockito.when((Object)purapDocMock.getPostingYear()).thenReturn((Object)2016);
        Mockito.when((Object)this.objectCodeSvcMock.getByPrimaryId(Integer.valueOf(2016), "BL", "4166")).thenReturn((Object)CustomizeGeneralLedgerPendingEntryTest.getObjectCode());
        this.cut.customizeGeneralLedgerPendingEntry(purapDocMock, CustomizeGeneralLedgerPendingEntryTest.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, null, "D", "PO", false);
        Assertions.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assertions.assertEquals((Object)"ACME Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assertions.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assertions.assertEquals((int)2016, (int)explicitEntry.getUniversityFiscalYear());
        Assertions.assertEquals((Object)"03", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assertions.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assertions.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    void poDocumentNextYearNonEncumbrancePositive(@Mock(stubOnly=true) PurchasingAccountsPayableDocument purapDocMock) {
        GeneralLedgerPendingEntry explicitEntry = CustomizeGeneralLedgerPendingEntryTest.getGeneralLedgerPendingEntry();
        Mockito.when((Object)purapDocMock.getDocumentNumber()).thenReturn((Object)"DOC1234");
        Mockito.when((Object)purapDocMock.getVendorName()).thenReturn((Object)"ACME Corporation");
        Mockito.when((Object)this.universityDateSvcMock.getCurrentUniversityDate()).thenReturn((Object)CustomizeGeneralLedgerPendingEntryTest.getUniversityDate());
        Mockito.when((Object)purapDocMock.getPostingYear()).thenReturn((Object)2017);
        Mockito.when((Object)this.objectCodeSvcMock.getByPrimaryId(Integer.valueOf(2017), "BL", "4166")).thenReturn((Object)CustomizeGeneralLedgerPendingEntryTest.getObjectCode());
        this.cut.customizeGeneralLedgerPendingEntry(purapDocMock, CustomizeGeneralLedgerPendingEntryTest.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, null, "D", "PO", false);
        Assertions.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assertions.assertEquals((Object)"ACME Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assertions.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assertions.assertEquals((int)2017, (int)explicitEntry.getUniversityFiscalYear());
        Assertions.assertEquals((Object)"01", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assertions.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assertions.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    void poDocumentSameYearNonEncumbranceReferenceDocPositive(@Mock(stubOnly=true) PurchasingAccountsPayableDocument purapDocMock) {
        GeneralLedgerPendingEntry explicitEntry = CustomizeGeneralLedgerPendingEntryTest.getGeneralLedgerPendingEntry();
        Mockito.when((Object)purapDocMock.getDocumentNumber()).thenReturn((Object)"DOC1234");
        Mockito.when((Object)purapDocMock.getVendorName()).thenReturn((Object)"ACME Corporation");
        Mockito.when((Object)this.universityDateSvcMock.getCurrentUniversityDate()).thenReturn((Object)CustomizeGeneralLedgerPendingEntryTest.getUniversityDate());
        Mockito.when((Object)purapDocMock.getPostingYear()).thenReturn((Object)2016);
        Mockito.when((Object)this.objectCodeSvcMock.getByPrimaryId(Integer.valueOf(2016), "BL", "4166")).thenReturn((Object)CustomizeGeneralLedgerPendingEntryTest.getObjectCode());
        this.cut.customizeGeneralLedgerPendingEntry(purapDocMock, CustomizeGeneralLedgerPendingEntryTest.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, Integer.valueOf(100), "D", "PO", false);
        Assertions.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assertions.assertEquals((Object)"ACME Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assertions.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assertions.assertEquals((Object)"100", (Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assertions.assertEquals((Object)"PO", (Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assertions.assertEquals((Object)"01", (Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assertions.assertEquals((int)2016, (int)explicitEntry.getUniversityFiscalYear());
        Assertions.assertEquals((Object)"03", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assertions.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assertions.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    void poDocumentSameYearEncumbrancePositive(@Mock(stubOnly=true) PurchasingAccountsPayableDocument purapDocMock) {
        GeneralLedgerPendingEntry explicitEntry = CustomizeGeneralLedgerPendingEntryTest.getGeneralLedgerPendingEntry();
        Mockito.when((Object)purapDocMock.getDocumentNumber()).thenReturn((Object)"DOC1234");
        Mockito.when((Object)purapDocMock.getVendorName()).thenReturn((Object)"ACME Corporation");
        Mockito.when((Object)this.universityDateSvcMock.getCurrentUniversityDate()).thenReturn((Object)CustomizeGeneralLedgerPendingEntryTest.getUniversityDate());
        Mockito.when((Object)purapDocMock.getPostingYear()).thenReturn((Object)2016);
        Mockito.when((Object)this.objectCodeSvcMock.getByPrimaryId(Integer.valueOf(2016), "BL", "4166")).thenReturn((Object)CustomizeGeneralLedgerPendingEntryTest.getObjectCode());
        this.cut.customizeGeneralLedgerPendingEntry(purapDocMock, CustomizeGeneralLedgerPendingEntryTest.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, null, "D", "PO", true);
        Assertions.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assertions.assertEquals((Object)"ACME Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assertions.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assertions.assertEquals((int)2016, (int)explicitEntry.getUniversityFiscalYear());
        Assertions.assertEquals((Object)"03", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assertions.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assertions.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    void poDocumentSameYearNonEncumbranceNegativeDebit(@Mock(stubOnly=true) PurchasingAccountsPayableDocument purapDocMock) {
        GeneralLedgerPendingEntry explicitEntry = CustomizeGeneralLedgerPendingEntryTest.getGeneralLedgerPendingEntry();
        Mockito.when((Object)purapDocMock.getDocumentNumber()).thenReturn((Object)"DOC1234");
        Mockito.when((Object)purapDocMock.getVendorName()).thenReturn((Object)"ACME Corporation");
        Mockito.when((Object)this.universityDateSvcMock.getCurrentUniversityDate()).thenReturn((Object)CustomizeGeneralLedgerPendingEntryTest.getUniversityDate());
        Mockito.when((Object)purapDocMock.getPostingYear()).thenReturn((Object)2016);
        Mockito.when((Object)this.objectCodeSvcMock.getByPrimaryId(Integer.valueOf(2016), "BL", "4166")).thenReturn((Object)CustomizeGeneralLedgerPendingEntryTest.getObjectCode());
        this.cut.customizeGeneralLedgerPendingEntry(purapDocMock, CustomizeGeneralLedgerPendingEntryTest.getPurchaseOrderAccountingLine(new KualiDecimal("-100")), explicitEntry, null, "D", "PO", false);
        Assertions.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assertions.assertEquals((Object)"ACME Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assertions.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assertions.assertEquals((int)2016, (int)explicitEntry.getUniversityFiscalYear());
        Assertions.assertEquals((Object)"03", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assertions.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assertions.assertEquals((Object)"C", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    void poDocumentSameYearNonEncumbranceNegativeCredit(@Mock(stubOnly=true) PurchasingAccountsPayableDocument purapDocMock) {
        GeneralLedgerPendingEntry explicitEntry = CustomizeGeneralLedgerPendingEntryTest.getGeneralLedgerPendingEntry();
        Mockito.when((Object)purapDocMock.getDocumentNumber()).thenReturn((Object)"DOC1234");
        Mockito.when((Object)purapDocMock.getVendorName()).thenReturn((Object)"ACME Corporation");
        Mockito.when((Object)this.universityDateSvcMock.getCurrentUniversityDate()).thenReturn((Object)CustomizeGeneralLedgerPendingEntryTest.getUniversityDate());
        Mockito.when((Object)purapDocMock.getPostingYear()).thenReturn((Object)2016);
        Mockito.when((Object)this.objectCodeSvcMock.getByPrimaryId(Integer.valueOf(2016), "BL", "4166")).thenReturn((Object)CustomizeGeneralLedgerPendingEntryTest.getObjectCode());
        this.cut.customizeGeneralLedgerPendingEntry(purapDocMock, CustomizeGeneralLedgerPendingEntryTest.getPurchaseOrderAccountingLine(new KualiDecimal("-100")), explicitEntry, null, "C", "PO", false);
        Assertions.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assertions.assertEquals((Object)"ACME Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assertions.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assertions.assertEquals((int)2016, (int)explicitEntry.getUniversityFiscalYear());
        Assertions.assertEquals((Object)"03", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assertions.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assertions.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    void invalidDocType(@Mock(stubOnly=true) PurchasingAccountsPayableDocument purapDocMock) {
        GeneralLedgerPendingEntry explicitEntry = CustomizeGeneralLedgerPendingEntryTest.getGeneralLedgerPendingEntry();
        Mockito.when((Object)purapDocMock.getDocumentNumber()).thenReturn((Object)"DOC1234");
        Mockito.when((Object)purapDocMock.getVendorName()).thenReturn((Object)"ACME Corporation");
        Mockito.when((Object)this.universityDateSvcMock.getCurrentUniversityDate()).thenReturn((Object)CustomizeGeneralLedgerPendingEntryTest.getUniversityDate());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.cut.customizeGeneralLedgerPendingEntry(purapDocMock, CustomizeGeneralLedgerPendingEntryTest.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, null, "D", "BAD", true));
    }

    @Test
    void preqDocumentSameYearNonEncumbrancePositiveNoBackpost(@Mock(stubOnly=true) PaymentRequestDocument purapDocMock) {
        GeneralLedgerPendingEntry explicitEntry = CustomizeGeneralLedgerPendingEntryTest.getGeneralLedgerPendingEntry();
        Mockito.when((Object)purapDocMock.getDocumentNumber()).thenReturn((Object)"DOC1234");
        Mockito.when((Object)purapDocMock.getVendorName()).thenReturn((Object)"ACME Corporation");
        Mockito.when((Object)this.universityDateSvcMock.getCurrentUniversityDate()).thenReturn((Object)CustomizeGeneralLedgerPendingEntryTest.getUniversityDate());
        Mockito.when((Object)this.objectCodeSvcMock.getByPrimaryId(Integer.valueOf(2016), "BL", "4166")).thenReturn((Object)CustomizeGeneralLedgerPendingEntryTest.getObjectCode());
        Mockito.when((Object)this.paymentRequestSvcMock.allowBackpost((PaymentRequestDocument)ArgumentMatchers.any())).thenReturn((Object)false);
        Mockito.when((Object)purapDocMock.getAlternateVendorHeaderGeneratedIdentifier()).thenReturn(null);
        this.cut.customizeGeneralLedgerPendingEntry((PurchasingAccountsPayableDocument)purapDocMock, CustomizeGeneralLedgerPendingEntryTest.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, null, "D", "PREQ", false);
        Assertions.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assertions.assertEquals((Object)"ACME Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assertions.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assertions.assertEquals((int)2016, (int)explicitEntry.getUniversityFiscalYear());
        Assertions.assertEquals((Object)"03", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assertions.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assertions.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    void preqDocumentSameYearNonEncumbrancePositiveBackpost(@Mock(stubOnly=true) PaymentRequestDocument purapDocMock) {
        GeneralLedgerPendingEntry explicitEntry = CustomizeGeneralLedgerPendingEntryTest.getGeneralLedgerPendingEntry();
        Mockito.when((Object)purapDocMock.getDocumentNumber()).thenReturn((Object)"DOC1234");
        Mockito.when((Object)purapDocMock.getVendorName()).thenReturn((Object)"ACME Corporation");
        Mockito.when((Object)this.universityDateSvcMock.getCurrentUniversityDate()).thenReturn((Object)CustomizeGeneralLedgerPendingEntryTest.getUniversityDate());
        Mockito.when((Object)this.objectCodeSvcMock.getByPrimaryId(Integer.valueOf(2015), "BL", "4166")).thenReturn((Object)CustomizeGeneralLedgerPendingEntryTest.getObjectCode());
        Mockito.when((Object)this.paymentRequestSvcMock.allowBackpost((PaymentRequestDocument)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)purapDocMock.getAlternateVendorHeaderGeneratedIdentifier()).thenReturn(null);
        this.cut.customizeGeneralLedgerPendingEntry((PurchasingAccountsPayableDocument)purapDocMock, CustomizeGeneralLedgerPendingEntryTest.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, null, "D", "PREQ", false);
        Assertions.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assertions.assertEquals((Object)"ACME Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assertions.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assertions.assertEquals((int)2015, (int)explicitEntry.getUniversityFiscalYear());
        Assertions.assertEquals((Object)"12", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assertions.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assertions.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    void preqDocumentSameYearNonEncumbrancePositiveAlternativeVendor(@Mock(stubOnly=true) PaymentRequestDocument purapDocMock, @Mock(stubOnly=true) PurchaseOrderDocument purchaseOrderDocument) {
        GeneralLedgerPendingEntry explicitEntry = CustomizeGeneralLedgerPendingEntryTest.getGeneralLedgerPendingEntry();
        Mockito.when((Object)purapDocMock.getDocumentNumber()).thenReturn((Object)"DOC1234");
        Mockito.when((Object)purapDocMock.getVendorName()).thenReturn((Object)"ACME Corporation");
        Mockito.when((Object)this.universityDateSvcMock.getCurrentUniversityDate()).thenReturn((Object)CustomizeGeneralLedgerPendingEntryTest.getUniversityDate());
        Mockito.when((Object)this.objectCodeSvcMock.getByPrimaryId(Integer.valueOf(2015), "BL", "4166")).thenReturn((Object)CustomizeGeneralLedgerPendingEntryTest.getObjectCode());
        Mockito.when((Object)this.paymentRequestSvcMock.allowBackpost((PaymentRequestDocument)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)purapDocMock.getAlternateVendorHeaderGeneratedIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)purapDocMock.getAlternateVendorDetailAssignedIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)purapDocMock.getVendorHeaderGeneratedIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)purapDocMock.getVendorDetailAssignedIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)purapDocMock.getPurchaseOrderDocument()).thenReturn((Object)purchaseOrderDocument);
        Mockito.when((Object)purchaseOrderDocument.getAlternateVendorName()).thenReturn((Object)"HP Corporation");
        this.cut.customizeGeneralLedgerPendingEntry((PurchasingAccountsPayableDocument)purapDocMock, CustomizeGeneralLedgerPendingEntryTest.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, null, "D", "PREQ", false);
        Assertions.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assertions.assertEquals((Object)"HP Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assertions.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assertions.assertEquals((int)2015, (int)explicitEntry.getUniversityFiscalYear());
        Assertions.assertEquals((Object)"12", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assertions.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assertions.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    void cmDocumentSameYearNonEncumbrancePositiveNotAlternativeVendor(@Mock(stubOnly=true) VendorCreditMemoDocument purapDocMock) {
        GeneralLedgerPendingEntry explicitEntry = CustomizeGeneralLedgerPendingEntryTest.getGeneralLedgerPendingEntry();
        Mockito.when((Object)purapDocMock.getDocumentNumber()).thenReturn((Object)"DOC1234");
        Mockito.when((Object)purapDocMock.getVendorName()).thenReturn((Object)"ACME Corporation");
        Mockito.when((Object)this.universityDateSvcMock.getCurrentUniversityDate()).thenReturn((Object)CustomizeGeneralLedgerPendingEntryTest.getUniversityDate());
        Mockito.when((Object)this.objectCodeSvcMock.getByPrimaryId(Integer.valueOf(2016), "BL", "4166")).thenReturn((Object)CustomizeGeneralLedgerPendingEntryTest.getObjectCode());
        Mockito.when((Object)purapDocMock.isSourceDocumentPaymentRequest()).thenReturn((Object)false);
        this.cut.customizeGeneralLedgerPendingEntry((PurchasingAccountsPayableDocument)purapDocMock, CustomizeGeneralLedgerPendingEntryTest.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, null, "D", "CM", false);
        Assertions.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assertions.assertEquals((Object)"ACME Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assertions.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assertions.assertEquals((int)2016, (int)explicitEntry.getUniversityFiscalYear());
        Assertions.assertEquals((Object)"03", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assertions.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assertions.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    void cmDocumentSameYearNonEncumbrancePositiveAlternativeVendor(@Mock(stubOnly=true) VendorCreditMemoDocument purapDocMock, @Mock(stubOnly=true) PurchaseOrderDocument purchaseOrderDocMock, @Mock(stubOnly=true) PaymentRequestDocument paymentRequestDocMock) {
        GeneralLedgerPendingEntry explicitEntry = CustomizeGeneralLedgerPendingEntryTest.getGeneralLedgerPendingEntry();
        Mockito.when((Object)purapDocMock.getDocumentNumber()).thenReturn((Object)"DOC1234");
        Mockito.when((Object)purapDocMock.getVendorName()).thenReturn((Object)"ACME Corporation");
        Mockito.when((Object)this.universityDateSvcMock.getCurrentUniversityDate()).thenReturn((Object)CustomizeGeneralLedgerPendingEntryTest.getUniversityDate());
        Mockito.when((Object)this.objectCodeSvcMock.getByPrimaryId(Integer.valueOf(2016), "BL", "4166")).thenReturn((Object)CustomizeGeneralLedgerPendingEntryTest.getObjectCode());
        Mockito.when((Object)purapDocMock.isSourceDocumentPaymentRequest()).thenReturn((Object)true);
        Mockito.when((Object)purapDocMock.getPaymentRequestDocument()).thenReturn((Object)paymentRequestDocMock);
        Mockito.when((Object)paymentRequestDocMock.getAlternateVendorHeaderGeneratedIdentifier()).thenReturn((Object)111);
        Mockito.when((Object)paymentRequestDocMock.getAlternateVendorDetailAssignedIdentifier()).thenReturn((Object)222);
        Mockito.when((Object)paymentRequestDocMock.getVendorHeaderGeneratedIdentifier()).thenReturn((Object)111);
        Mockito.when((Object)paymentRequestDocMock.getVendorDetailAssignedIdentifier()).thenReturn((Object)222);
        Mockito.when((Object)purapDocMock.getPurchaseOrderDocument()).thenReturn((Object)purchaseOrderDocMock);
        Mockito.when((Object)purchaseOrderDocMock.getAlternateVendorName()).thenReturn((Object)"HP Corporation");
        this.cut.customizeGeneralLedgerPendingEntry((PurchasingAccountsPayableDocument)purapDocMock, CustomizeGeneralLedgerPendingEntryTest.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, null, "D", "CM", false);
        Assertions.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assertions.assertEquals((Object)"HP Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assertions.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assertions.assertNull((Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assertions.assertEquals((int)2016, (int)explicitEntry.getUniversityFiscalYear());
        Assertions.assertEquals((Object)"03", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assertions.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assertions.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    private static GeneralLedgerPendingEntry getGeneralLedgerPendingEntry() {
        GeneralLedgerPendingEntry g = new GeneralLedgerPendingEntry();
        g.setUniversityFiscalYear(Integer.valueOf(2016));
        g.setChartOfAccountsCode("BL");
        g.setAccountNumber("7654321");
        g.setFinancialObjectCode("4166");
        g.setFinancialSubObjectCode("321");
        g.setFinancialBalanceTypeCode("AC");
        return g;
    }

    private static UniversityDate getUniversityDate() {
        UniversityDate d = new UniversityDate();
        d.setUniversityFiscalYear(Integer.valueOf(2016));
        d.setUniversityFiscalAccountingPeriod("03");
        return d;
    }

    private static ObjectCode getObjectCode() {
        ObjectCode o = new ObjectCode();
        o.setUniversityFiscalYear(Integer.valueOf(2016));
        o.setChartOfAccountsCode("BL");
        o.setFinancialObjectCode("4166");
        o.setFinancialObjectTypeCode("EX");
        return o;
    }

    private static AccountingLine getPurchaseOrderAccountingLine(KualiDecimal amount) {
        PurchaseOrderAccount p = new PurchaseOrderAccount();
        p.setAmount(amount);
        return p;
    }
}

