/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.impl.PurapGeneralLedgerServiceImpl;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class GenerateEntriesApproveAmendPurchaseOrderTest {
    private PurapGeneralLedgerServiceImpl cut;
    @Mock
    private PurchaseOrderDocument oldPoMock;
    @Mock
    private PurchaseOrderDocument newPoMock;
    @Mock
    private PurapAccountingService purapAccountingSvcMock;
    @Mock
    private GeneralLedgerPendingEntryService glPendingEntrySvcMock;
    @Mock
    private BusinessObjectService boServiceMock;
    @Mock
    private PurchaseOrderService purchaseOrderSvcMock;
    private List<PurApItem> newPoItems;
    private List<PurApItem> newPoActiveItems;
    private List<PurApItem> oldPoItems;
    private List<GeneralLedgerPendingEntry> glpes;
    private List<SourceAccountingLine> newSummaryAccountingLines;
    private List<SourceAccountingLine> oldSummaryAccountingLines;

    GenerateEntriesApproveAmendPurchaseOrderTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new PurapGeneralLedgerServiceImpl();
        this.cut.setPurapAccountingService(this.purapAccountingSvcMock);
        this.cut.setGeneralLedgerPendingEntryService(this.glPendingEntrySvcMock);
        this.cut.setBusinessObjectService(this.boServiceMock);
        this.cut.setPurchaseOrderService(this.purchaseOrderSvcMock);
        this.newPoItems = new ArrayList<PurApItem>();
        this.newPoActiveItems = new ArrayList<PurApItem>();
        this.oldPoItems = new ArrayList<PurApItem>();
        this.glpes = new ArrayList<GeneralLedgerPendingEntry>();
        this.newSummaryAccountingLines = new ArrayList<SourceAccountingLine>();
        this.oldSummaryAccountingLines = new ArrayList<SourceAccountingLine>();
    }

    private void execute() {
        this.cut.generateEntriesApproveAmendPurchaseOrder(this.newPoMock);
        ((PurchaseOrderDocument)Mockito.verify((Object)this.oldPoMock)).getItemsActiveOnlySetupAlternateAmount();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.oldPoMock});
        ((PurchaseOrderDocument)Mockito.verify((Object)this.newPoMock)).getPurapDocumentIdentifier();
        ((PurchaseOrderDocument)Mockito.verify((Object)this.newPoMock)).getItems();
        ((PurchaseOrderDocument)Mockito.verify((Object)this.newPoMock)).getItemsActiveOnly();
        ((PurchaseOrderDocument)Mockito.verify((Object)this.newPoMock)).getGeneralLedgerPendingEntries();
        ((PurapAccountingService)Mockito.verify((Object)this.purapAccountingSvcMock, (VerificationMode)Mockito.atLeastOnce())).generateSummaryWithNoZeroTotalsUsingAlternateAmount(this.oldPoItems);
        ((PurapAccountingService)Mockito.verify((Object)this.purapAccountingSvcMock, (VerificationMode)Mockito.atLeastOnce())).generateSummaryWithNoZeroTotalsUsingAlternateAmount(this.newPoActiveItems);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.purapAccountingSvcMock});
        ((GeneralLedgerPendingEntryService)Mockito.verify((Object)this.glPendingEntrySvcMock)).generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)this.newPoMock);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.glPendingEntrySvcMock});
        ((BusinessObjectService)Mockito.verify((Object)this.boServiceMock)).save(this.glpes);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.boServiceMock});
        ((PurchaseOrderService)Mockito.verify((Object)this.purchaseOrderSvcMock)).getCurrentPurchaseOrder(Integer.valueOf(101));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.purchaseOrderSvcMock});
    }

    private void prepareNewPO() {
        Mockito.when((Object)this.newPoMock.getPurapDocumentIdentifier()).thenReturn((Object)101);
        Mockito.when((Object)this.newPoMock.getItems()).thenReturn(this.newPoItems);
        Mockito.when((Object)this.newPoMock.getItemsActiveOnly()).thenReturn(this.newPoActiveItems);
        Mockito.when((Object)this.newPoMock.getGeneralLedgerPendingEntries()).thenReturn(this.glpes);
    }

    private void prepareOldPO() {
        Mockito.when((Object)this.oldPoMock.getItemsActiveOnlySetupAlternateAmount()).thenReturn(this.oldPoItems);
    }

    private static KualiDecimal doubleToKualiDecimal(Double amount) {
        if (amount == null) {
            return null;
        }
        return new KualiDecimal(amount.doubleValue());
    }

    private void prepareItem(PurchaseOrderItem purchaseOrderItemMock, Double quantity, Double invoicedQuantity, Double outstandingQuantity, Double unitPrice, Double invoicedAmount, Double outstandingAmount, List<PurApAccountingLine> accountingLines) {
        Mockito.when((Object)purchaseOrderItemMock.getItemQuantity()).thenReturn((Object)GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(quantity));
        Mockito.when((Object)purchaseOrderItemMock.getItemInvoicedTotalQuantity()).thenReturn((Object)GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(invoicedQuantity));
        Mockito.when((Object)purchaseOrderItemMock.getItemInvoicedTotalAmount()).thenReturn((Object)GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(invoicedAmount));
        Mockito.when((Object)purchaseOrderItemMock.getSourceAccountingLines()).thenReturn(accountingLines);
        Mockito.when((Object)purchaseOrderItemMock.getItemOutstandingEncumberedQuantity()).thenReturn((Object)GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(outstandingQuantity));
        Mockito.when((Object)purchaseOrderItemMock.getItemOutstandingEncumberedAmount()).thenReturn((Object)GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(outstandingAmount));
        Mockito.when((Object)purchaseOrderItemMock.getItemUnitPrice()).thenReturn((Object)new BigDecimal(unitPrice));
        Mockito.when((Object)purchaseOrderItemMock.getItemTaxAmount()).thenReturn((Object)GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(0.0));
        purchaseOrderItemMock.setItemInvoicedTotalQuantity(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(invoicedQuantity));
        purchaseOrderItemMock.setItemInvoicedTotalAmount(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(invoicedAmount));
        purchaseOrderItemMock.setItemOutstandingEncumberedQuantity(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(outstandingQuantity));
        purchaseOrderItemMock.setItemOutstandingEncumberedAmount(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(outstandingAmount));
        Mockito.when((Object)purchaseOrderItemMock.isItemActiveIndicator()).thenReturn((Object)true);
        this.newPoActiveItems.add((PurApItem)purchaseOrderItemMock);
        this.newPoItems.add((PurApItem)purchaseOrderItemMock);
    }

    private void prepareSummaryAccountingLine(Double newAmount, Double oldAmount, Double diffAmount, String objectCode) {
        SourceAccountingLine account;
        if (newAmount != null) {
            account = new SourceAccountingLine();
            account.setFinancialObjectCode(objectCode);
            account.setAmount(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(newAmount));
            this.newSummaryAccountingLines.add(account);
        }
        if (oldAmount != null) {
            account = new SourceAccountingLine();
            account.setFinancialObjectCode(objectCode);
            account.setAmount(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(oldAmount));
            this.oldSummaryAccountingLines.add(account);
        }
        account = new SourceAccountingLine();
        account.setFinancialObjectCode(objectCode);
        account.setAmount(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(diffAmount));
    }

    private void prepareSummaryAccountingLines() {
        this.prepareSummaryAccountingLine(10.0, 7.0, 3.0, "Matching");
        this.prepareSummaryAccountingLine(10.0, null, 10.0, "NewOnly");
        this.prepareSummaryAccountingLine(null, 7.0, -7.0, "OldOnly");
    }

    private void baseExpectations() {
        this.prepareOldPO();
        this.prepareNewPO();
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(101))).thenReturn((Object)this.oldPoMock);
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryWithNoZeroTotalsUsingAlternateAmount(this.newPoActiveItems)).thenReturn(this.newSummaryAccountingLines);
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryWithNoZeroTotalsUsingAlternateAmount(this.oldPoItems)).thenReturn(this.oldSummaryAccountingLines);
        Mockito.when((Object)this.glPendingEntrySvcMock.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)this.newPoMock)).thenReturn((Object)true);
        Mockito.when((Object)this.boServiceMock.save(this.glpes)).thenReturn(null);
    }

    @Test
    void baseCase() {
        this.baseExpectations();
        this.execute();
    }

    @Test
    void poWithItems(@Mock(stubOnly=true) PurchaseOrderItem activePurchaseOrderItemMock, @Mock(stubOnly=true) PurchaseOrderItem inactivePurchaseOrderItemMock, @Mock(stubOnly=true) PurchaseOrderItem nullQuantityPurchaseOrderItemMock) {
        this.baseExpectations();
        Mockito.when((Object)activePurchaseOrderItemMock.getItemQuantity()).thenReturn((Object)GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(3.0));
        Mockito.when((Object)activePurchaseOrderItemMock.getItemInvoicedTotalQuantity()).thenReturn((Object)GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(1.0));
        Mockito.when((Object)activePurchaseOrderItemMock.getItemInvoicedTotalAmount()).thenReturn((Object)GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(5.0));
        Mockito.when((Object)activePurchaseOrderItemMock.getSourceAccountingLines()).thenReturn(new ArrayList());
        Mockito.when((Object)activePurchaseOrderItemMock.getItemOutstandingEncumberedQuantity()).thenReturn((Object)GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(2.0));
        Mockito.when((Object)activePurchaseOrderItemMock.getItemUnitPrice()).thenReturn((Object)new BigDecimal("5.0"));
        Mockito.when((Object)activePurchaseOrderItemMock.getItemTaxAmount()).thenReturn((Object)GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(0.5));
        activePurchaseOrderItemMock.setItemInvoicedTotalQuantity(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(1.0));
        activePurchaseOrderItemMock.setItemInvoicedTotalAmount(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(5.0));
        activePurchaseOrderItemMock.setItemOutstandingEncumberedQuantity(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(2.0));
        activePurchaseOrderItemMock.setItemOutstandingEncumberedAmount(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(10.5));
        Mockito.when((Object)activePurchaseOrderItemMock.isItemActiveIndicator()).thenReturn((Object)true);
        this.newPoActiveItems.add((PurApItem)activePurchaseOrderItemMock);
        this.newPoItems.add((PurApItem)activePurchaseOrderItemMock);
        Mockito.when((Object)inactivePurchaseOrderItemMock.getItemInvoicedTotalQuantity()).thenReturn((Object)GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(1.0));
        Mockito.when((Object)inactivePurchaseOrderItemMock.getItemInvoicedTotalAmount()).thenReturn((Object)GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(5.0));
        Mockito.when((Object)inactivePurchaseOrderItemMock.getSourceAccountingLines()).thenReturn(new ArrayList());
        inactivePurchaseOrderItemMock.setItemInvoicedTotalQuantity(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(1.0));
        inactivePurchaseOrderItemMock.setItemInvoicedTotalAmount(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(5.0));
        inactivePurchaseOrderItemMock.setItemOutstandingEncumberedQuantity(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(0.0));
        inactivePurchaseOrderItemMock.setItemOutstandingEncumberedAmount(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(0.0));
        Mockito.when((Object)inactivePurchaseOrderItemMock.isItemActiveIndicator()).thenReturn((Object)false);
        this.newPoItems.add((PurApItem)inactivePurchaseOrderItemMock);
        Mockito.when((Object)nullQuantityPurchaseOrderItemMock.getItemQuantity()).thenReturn((Object)GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(null));
        Mockito.when((Object)nullQuantityPurchaseOrderItemMock.getItemInvoicedTotalQuantity()).thenReturn((Object)GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(0.0));
        Mockito.when((Object)nullQuantityPurchaseOrderItemMock.getItemInvoicedTotalAmount()).thenReturn((Object)GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(3.0));
        Mockito.when((Object)nullQuantityPurchaseOrderItemMock.getSourceAccountingLines()).thenReturn(new ArrayList());
        Mockito.when((Object)nullQuantityPurchaseOrderItemMock.getItemOutstandingEncumberedQuantity()).thenReturn((Object)GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(null));
        Mockito.when((Object)nullQuantityPurchaseOrderItemMock.getItemUnitPrice()).thenReturn((Object)new BigDecimal("10.0"));
        nullQuantityPurchaseOrderItemMock.setItemInvoicedTotalQuantity(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(0.0));
        nullQuantityPurchaseOrderItemMock.setItemInvoicedTotalAmount(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(3.0));
        nullQuantityPurchaseOrderItemMock.setItemOutstandingEncumberedQuantity(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(null));
        nullQuantityPurchaseOrderItemMock.setItemOutstandingEncumberedAmount(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(7.0));
        Mockito.when((Object)nullQuantityPurchaseOrderItemMock.isItemActiveIndicator()).thenReturn((Object)true);
        this.newPoActiveItems.add((PurApItem)nullQuantityPurchaseOrderItemMock);
        this.newPoItems.add((PurApItem)nullQuantityPurchaseOrderItemMock);
        this.execute();
    }

    @Test
    void poWithAccountingLines(@Mock(stubOnly=true) PurchaseOrderAccount account, @Mock(stubOnly=true) PurchaseOrderAccount account1, @Mock(stubOnly=true) PurchaseOrderAccount account2, @Mock(stubOnly=true) PurchaseOrderAccount account3, @Mock(stubOnly=true) PurchaseOrderAccount account4, @Mock(stubOnly=true) PurchaseOrderItem purchaseOrderItem1Mock, @Mock(stubOnly=true) PurchaseOrderItem purchaseOrderItem2Mock, @Mock(stubOnly=true) PurchaseOrderItem purchaseOrderItem3Mock) {
        this.baseExpectations();
        ArrayList<Object> accountingLines = new ArrayList<PurApAccountingLine>();
        Mockito.when((Object)account.getAccountLinePercent()).thenReturn((Object)BigDecimal.valueOf(100.0));
        account.setItemAccountOutstandingEncumbranceAmount(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(10.0));
        account.setAlternateAmountForGLEntryCreation(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(10.0));
        accountingLines.add(account);
        this.prepareItem(purchaseOrderItem1Mock, 3.0, 1.0, 2.0, 5.0, 5.0, 10.0, accountingLines);
        accountingLines = new ArrayList();
        Mockito.when((Object)account1.getAccountLinePercent()).thenReturn((Object)BigDecimal.valueOf(50.0));
        account1.setItemAccountOutstandingEncumbranceAmount(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(5.0));
        account1.setAlternateAmountForGLEntryCreation(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(5.0));
        accountingLines.add((PurApAccountingLine)account1);
        Mockito.when((Object)account2.getAccountLinePercent()).thenReturn((Object)BigDecimal.valueOf(50.0));
        account2.setItemAccountOutstandingEncumbranceAmount(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(5.0));
        account2.setAlternateAmountForGLEntryCreation(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(5.0));
        accountingLines.add(account2);
        this.prepareItem(purchaseOrderItem2Mock, 3.0, 1.0, 2.0, 5.0, 5.0, 10.0, accountingLines);
        accountingLines = new ArrayList();
        Mockito.when((Object)account3.getAccountLinePercent()).thenReturn((Object)new BigDecimal("66.66"));
        account3.setItemAccountOutstandingEncumbranceAmount(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(6700.0));
        account3.setAlternateAmountForGLEntryCreation(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(6700.0));
        accountingLines.add((PurApAccountingLine)account3);
        Mockito.when((Object)account4.getAccountLinePercent()).thenReturn((Object)new BigDecimal("33.33"));
        account4.setItemAccountOutstandingEncumbranceAmount(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(3300.0));
        account4.setAlternateAmountForGLEntryCreation(GenerateEntriesApproveAmendPurchaseOrderTest.doubleToKualiDecimal(3300.0));
        accountingLines.add(account4);
        this.prepareItem(purchaseOrderItem3Mock, 1.0, 0.0, 1.0, 10000.0, 0.0, 10000.0, accountingLines);
        this.execute();
    }

    @Test
    void poWithSummaryAccountingLines() {
        this.baseExpectations();
        this.prepareSummaryAccountingLines();
        this.execute();
    }
}

