/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.impl.PurapGeneralLedgerServiceImpl;
import org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl.PurapGeneralLedgerTest;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.context.SpringContext;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class GenerateEntriesCreatePaymentRequestTest
extends PurapGeneralLedgerTest {
    private PurapGeneralLedgerServiceImpl cut;
    @Mock
    private PurchaseOrderService purchaseOrderSvcMock;
    @Mock
    private PurapAccountingService purapAccountingSvcMock;
    @Mock
    private BusinessObjectService boServiceMock;

    GenerateEntriesCreatePaymentRequestTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new PurapGeneralLedgerServiceImpl();
        this.cut.setPurchaseOrderService(this.purchaseOrderSvcMock);
        this.cut.setBusinessObjectService(this.boServiceMock);
        this.cut.setPurapAccountingService(this.purapAccountingSvcMock);
    }

    @Test
    void noItems(@Mock PaymentRequestDocument paymentRequestDocMock, @Mock PurchaseOrderDocument purchaseOrderDocMock) {
        Mockito.when((Object)paymentRequestDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1000);
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(1000))).thenReturn((Object)purchaseOrderDocMock);
        Mockito.when((Object)paymentRequestDocMock.getItems()).thenReturn(new ArrayList());
        Mockito.when((Object)((PurchaseOrderDocument)this.boServiceMock.save((PersistableBusinessObject)purchaseOrderDocMock))).thenReturn((Object)purchaseOrderDocMock);
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)paymentRequestDocMock)).thenReturn(new ArrayList());
        paymentRequestDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        Mockito.when((Object)paymentRequestDocMock.getDocumentNumber()).thenReturn((Object)"1111");
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("financialSystemOriginationCode", "01");
        matcher.put("documentNumber", "1111");
        Mockito.when((Object)this.boServiceMock.countMatching(GeneralLedgerPendingEntry.class, matcher)).thenReturn((Object)0);
        paymentRequestDocMock.setDebitCreditCodeForGLEntries("C");
        paymentRequestDocMock.setGenerateEncumbranceEntries(true);
        Mockito.when((Object)paymentRequestDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)this.boServiceMock.save(new ArrayList())).thenReturn(new ArrayList());
        this.cut.generateEntriesCreatePaymentRequest(paymentRequestDocMock);
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock)).getItems();
        this.verifyAll(paymentRequestDocMock);
    }

    @Test
    void itemsNoGLPEsNoAccountingLines(@Mock PaymentRequestDocument paymentRequestDocMock, @Mock PurchaseOrderDocument purchaseOrderDocMock) {
        Mockito.when((Object)paymentRequestDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1000);
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(1000))).thenReturn((Object)purchaseOrderDocMock);
        ArrayList<PurApItem> preqItems = new ArrayList<PurApItem>();
        preqItems.add(this.getPaymentRequestItem(paymentRequestDocMock, 100, null, null, "ITEM"));
        preqItems.add(this.getPaymentRequestItem(paymentRequestDocMock, 1, null, null, "ITEM"));
        preqItems.add(this.getPaymentRequestItem(paymentRequestDocMock, 2, null, null, "ITEM"));
        preqItems.add(this.getPaymentRequestItem(paymentRequestDocMock, 3, KDONE, BigDecimal.ZERO, "ITEM"));
        preqItems.add(this.getPaymentRequestItem(paymentRequestDocMock, 4, KDTWO, BigDecimal.ZERO, "ITEM"));
        preqItems.add(this.getPaymentRequestItem(paymentRequestDocMock, 5, KDONE, BigDecimal.ZERO, "ITEM"));
        preqItems.add(this.getPaymentRequestItem(paymentRequestDocMock, 6, KDONE, BigDecimal.ZERO, "ITEM"));
        preqItems.add(this.getPaymentRequestItem(paymentRequestDocMock, 7, KDONE, new BigDecimal("2.00"), "ITEM"));
        Mockito.when((Object)paymentRequestDocMock.getItems()).thenReturn(preqItems);
        ArrayList<PurApItem> poItems = new ArrayList<PurApItem>();
        poItems.add(this.getPurchaseOrderItem(purchaseOrderDocMock, 1, null, null, null, null, null, null, "ITEM"));
        poItems.add(this.getPurchaseOrderItem(purchaseOrderDocMock, 2, KDONE, BigDecimal.ZERO, null, null, null, null, "ITEM"));
        poItems.add(this.getPurchaseOrderItem(purchaseOrderDocMock, 3, KDONE, BigDecimal.ZERO, null, null, null, null, "ITEM"));
        poItems.add(this.getPurchaseOrderItem(purchaseOrderDocMock, 4, KDONE, BigDecimal.ZERO, KDONE, null, null, null, "ITEM"));
        poItems.add(this.getPurchaseOrderItem(purchaseOrderDocMock, 5, KDTWO, BigDecimal.ZERO, KDONE, null, null, null, "ITEM"));
        poItems.add(this.getPurchaseOrderItem(purchaseOrderDocMock, 6, KDTWO, BigDecimal.ZERO, KDONE, KDONE, null, null, "ITEM"));
        poItems.add(this.getPurchaseOrderItem(purchaseOrderDocMock, 7, KDTWO, BigDecimal.ONE, KDONE, KDONE, new KualiDecimal("0.50"), new KualiDecimal("0.75"), "ITEM"));
        Mockito.when((Object)purchaseOrderDocMock.getItems()).thenReturn(poItems);
        Mockito.when((Object)paymentRequestDocMock.isUseTaxIndicator()).thenReturn((Object)false);
        Mockito.when((Object)((PurchaseOrderDocument)this.boServiceMock.save((PersistableBusinessObject)purchaseOrderDocMock))).thenReturn((Object)purchaseOrderDocMock);
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)paymentRequestDocMock)).thenReturn(new ArrayList());
        paymentRequestDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        Mockito.when((Object)paymentRequestDocMock.getDocumentNumber()).thenReturn((Object)"1111");
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("financialSystemOriginationCode", "01");
        matcher.put("documentNumber", "1111");
        Mockito.when((Object)this.boServiceMock.countMatching(GeneralLedgerPendingEntry.class, matcher)).thenReturn((Object)0);
        paymentRequestDocMock.setDebitCreditCodeForGLEntries("C");
        paymentRequestDocMock.setGenerateEncumbranceEntries(true);
        Mockito.when((Object)paymentRequestDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)this.boServiceMock.save(new ArrayList())).thenReturn(new ArrayList());
        this.cut.generateEntriesCreatePaymentRequest(paymentRequestDocMock);
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock, (VerificationMode)Mockito.times((int)7))).isUseTaxIndicator();
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock)).getItems();
        ((PurchaseOrderDocument)Mockito.verify((Object)purchaseOrderDocMock, (VerificationMode)Mockito.times((int)8))).getItems();
        this.verifyAll(paymentRequestDocMock);
    }

    @Test
    void itemsNoGLPEsNoAccountingLinesMisc(@Mock PaymentRequestDocument paymentRequestDocMock, @Mock PurchaseOrderDocument purchaseOrderDocMock) {
        Mockito.when((Object)paymentRequestDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1000);
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(1000))).thenReturn((Object)purchaseOrderDocMock);
        ArrayList<PurApItem> preqItems = new ArrayList<PurApItem>();
        preqItems.add(this.getPaymentRequestItem(paymentRequestDocMock, 100, null, null, "MISC"));
        preqItems.add(this.getPaymentRequestItem(paymentRequestDocMock, 1, null, null, "MISC"));
        preqItems.add(this.getPaymentRequestItem(paymentRequestDocMock, 2, null, null, "MISC"));
        preqItems.add(this.getPaymentRequestItem(paymentRequestDocMock, 3, KDONE, BigDecimal.ZERO, "MISC"));
        preqItems.add(this.getPaymentRequestItem(paymentRequestDocMock, 4, KDTWO, BigDecimal.ZERO, "MISC"));
        preqItems.add(this.getPaymentRequestItem(paymentRequestDocMock, 5, KDONE, BigDecimal.ZERO, "MISC"));
        preqItems.add(this.getPaymentRequestItem(paymentRequestDocMock, 6, KDONE, BigDecimal.ZERO, "MISC"));
        preqItems.add(this.getPaymentRequestItem(paymentRequestDocMock, 7, KDONE, new BigDecimal("2.00"), "MISC"));
        Mockito.when((Object)paymentRequestDocMock.getItems()).thenReturn(preqItems);
        ArrayList<PurApItem> poItems = new ArrayList<PurApItem>();
        poItems.add(this.getPurchaseOrderItem(purchaseOrderDocMock, 1, null, null, null, null, KualiDecimal.ZERO, KualiDecimal.ZERO, "ITEM"));
        poItems.add(this.getPurchaseOrderItem(purchaseOrderDocMock, 2, KDONE, BigDecimal.ZERO, null, null, KualiDecimal.ZERO, KualiDecimal.ZERO, "MISC"));
        poItems.add(this.getPurchaseOrderItem(purchaseOrderDocMock, 3, KDONE, BigDecimal.ZERO, null, null, KualiDecimal.ZERO, KualiDecimal.ZERO, "MISC"));
        poItems.add(this.getPurchaseOrderItem(purchaseOrderDocMock, 4, KDONE, BigDecimal.ZERO, KDONE, null, KualiDecimal.ZERO, KualiDecimal.ZERO, "MISC"));
        poItems.add(this.getPurchaseOrderItem(purchaseOrderDocMock, 5, KDTWO, BigDecimal.ZERO, KDONE, null, KualiDecimal.ZERO, KualiDecimal.ZERO, "MISC"));
        poItems.add(this.getPurchaseOrderItem(purchaseOrderDocMock, 6, KDTWO, BigDecimal.ZERO, KDONE, KDONE, KualiDecimal.ZERO, KualiDecimal.ZERO, "MISC"));
        poItems.add(this.getPurchaseOrderItem(purchaseOrderDocMock, 7, KDTWO, BigDecimal.ONE, KDONE, KDONE, new KualiDecimal("0.50"), new KualiDecimal("0.75"), "MISC"));
        Mockito.when((Object)purchaseOrderDocMock.getItems()).thenReturn(poItems);
        Mockito.when((Object)paymentRequestDocMock.isUseTaxIndicator()).thenReturn((Object)false);
        Mockito.when((Object)((PurchaseOrderDocument)this.boServiceMock.save((PersistableBusinessObject)purchaseOrderDocMock))).thenReturn((Object)purchaseOrderDocMock);
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)paymentRequestDocMock)).thenReturn(new ArrayList());
        paymentRequestDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        Mockito.when((Object)paymentRequestDocMock.getDocumentNumber()).thenReturn((Object)"1111");
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("financialSystemOriginationCode", "01");
        matcher.put("documentNumber", "1111");
        Mockito.when((Object)this.boServiceMock.countMatching(GeneralLedgerPendingEntry.class, matcher)).thenReturn((Object)0);
        paymentRequestDocMock.setDebitCreditCodeForGLEntries("C");
        paymentRequestDocMock.setGenerateEncumbranceEntries(true);
        Mockito.when((Object)paymentRequestDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)this.boServiceMock.save(new ArrayList())).thenReturn(new ArrayList());
        this.cut.generateEntriesCreatePaymentRequest(paymentRequestDocMock);
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock, (VerificationMode)Mockito.times((int)8))).isUseTaxIndicator();
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock)).getItems();
        ((PurchaseOrderDocument)Mockito.verify((Object)purchaseOrderDocMock, (VerificationMode)Mockito.times((int)8))).getItems();
        this.verifyAll(paymentRequestDocMock);
    }

    @Test
    void itemsNoGLPEsAccountingLines(@Mock AccountService accountSvcMock, @Mock PaymentRequestDocument paymentRequestDocMock, @Mock PurchaseOrderDocument purchaseOrderDocMock) {
        Mockito.when((Object)paymentRequestDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1000);
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(1000))).thenReturn((Object)purchaseOrderDocMock);
        ArrayList<PurApItem> preqItems = new ArrayList<PurApItem>();
        preqItems.add(this.getPaymentRequestItem(paymentRequestDocMock, 1, KDONE, new BigDecimal("2.00"), "MISC"));
        Mockito.when((Object)paymentRequestDocMock.getItems()).thenReturn(preqItems);
        ArrayList<PurchaseOrderItem> poItems = new ArrayList<PurchaseOrderItem>();
        PurchaseOrderItem poItem = (PurchaseOrderItem)this.getPurchaseOrderItem(purchaseOrderDocMock, 1, KDTWO, BigDecimal.ONE, KDONE, KDONE, new KualiDecimal("0.50"), new KualiDecimal("0.75"), "MISC");
        ArrayList<PurchaseOrderAccount> als = new ArrayList<PurchaseOrderAccount>();
        als.add(this.getPurchaseOrderAccount(new KualiDecimal("10.00"), new KualiDecimal("5.00")));
        poItem.setSourceAccountingLines(als);
        poItems.add(poItem);
        accountSvcMock.populateAccountingLineChartIfNeeded((AccountingLine)ArgumentMatchers.any());
        Mockito.when((Object)purchaseOrderDocMock.getItems()).thenReturn(poItems);
        Mockito.when((Object)paymentRequestDocMock.isUseTaxIndicator()).thenReturn((Object)false);
        Mockito.when((Object)((PurchaseOrderDocument)this.boServiceMock.save((PersistableBusinessObject)purchaseOrderDocMock))).thenReturn((Object)purchaseOrderDocMock);
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)paymentRequestDocMock)).thenReturn(new ArrayList());
        paymentRequestDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        Mockito.when((Object)paymentRequestDocMock.getDocumentNumber()).thenReturn((Object)"1111");
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("financialSystemOriginationCode", "01");
        matcher.put("documentNumber", "1111");
        Mockito.when((Object)this.boServiceMock.countMatching(GeneralLedgerPendingEntry.class, matcher)).thenReturn((Object)0);
        paymentRequestDocMock.setDebitCreditCodeForGLEntries("C");
        paymentRequestDocMock.setGenerateEncumbranceEntries(true);
        Mockito.when((Object)paymentRequestDocMock.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)ArgumentMatchers.any(), (GeneralLedgerPendingEntrySequenceHelper)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)paymentRequestDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)this.boServiceMock.save(new ArrayList())).thenReturn(new ArrayList());
        try (MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            springContextStaticMock.when(() -> SpringContext.getBean(AccountService.class)).thenReturn((Object)accountSvcMock);
            this.cut.generateEntriesCreatePaymentRequest(paymentRequestDocMock);
        }
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock)).isUseTaxIndicator();
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock)).getItems();
        ((PurchaseOrderDocument)Mockito.verify((Object)purchaseOrderDocMock)).getItems();
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock)).generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)ArgumentMatchers.any(AccountingLine.class), (GeneralLedgerPendingEntrySequenceHelper)ArgumentMatchers.any(GeneralLedgerPendingEntrySequenceHelper.class));
        this.verifyAll(paymentRequestDocMock);
    }

    private void verifyAll(PaymentRequestDocument paymentRequestDocMock) {
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock)).getPurchaseOrderIdentifier();
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock, (VerificationMode)Mockito.times((int)2))).setGeneralLedgerPendingEntries(new ArrayList());
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock)).getDocumentNumber();
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock, (VerificationMode)Mockito.times((int)2))).setDebitCreditCodeForGLEntries("C");
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock, (VerificationMode)Mockito.times((int)2))).setGenerateEncumbranceEntries(true);
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock)).getGeneralLedgerPendingEntries();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{paymentRequestDocMock});
        ((PurchaseOrderService)Mockito.verify((Object)this.purchaseOrderSvcMock)).getCurrentPurchaseOrder(Integer.valueOf(1000));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.purchaseOrderSvcMock});
        ((BusinessObjectService)Mockito.verify((Object)this.boServiceMock)).save(ArgumentMatchers.anyList());
        ((BusinessObjectService)Mockito.verify((Object)this.boServiceMock)).countMatching((Class)ArgumentMatchers.eq(GeneralLedgerPendingEntry.class), ArgumentMatchers.anyMap());
        ((PurapAccountingService)Mockito.verify((Object)this.purapAccountingSvcMock)).generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)paymentRequestDocMock);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.purapAccountingSvcMock});
    }
}

