/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.service.PurapAccountRevisionService;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.impl.PurapGeneralLedgerServiceImpl;
import org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl.PurapGeneralLedgerTest;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class GenerateEntriesModifyPaymentRequestTest
extends PurapGeneralLedgerTest {
    private PurapGeneralLedgerServiceImpl cut;
    @Mock
    private PurapAccountingService purapAccountingSvcMock;
    @Mock
    private BusinessObjectService boServiceMock;
    @Mock
    private PurapAccountRevisionService purapAccountRevisionSvcMock;

    GenerateEntriesModifyPaymentRequestTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new PurapGeneralLedgerServiceImpl();
        this.cut.setBusinessObjectService(this.boServiceMock);
        this.cut.setPurapAccountingService(this.purapAccountingSvcMock);
        this.cut.setPurapAccountRevisionService(this.purapAccountRevisionSvcMock);
    }

    @Test
    void noAccountingLines(@Mock PaymentRequestDocument paymentRequestDocMock) {
        Mockito.when((Object)paymentRequestDocMock.getItems()).thenReturn(new ArrayList());
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryWithNoZeroTotalsNoUseTax(new ArrayList())).thenReturn(new ArrayList());
        Mockito.when((Object)paymentRequestDocMock.getPurapDocumentIdentifier()).thenReturn((Object)1000);
        Mockito.when((Object)this.purapAccountingSvcMock.getAccountsPayableSummaryAccounts(Integer.valueOf(1000), "PREQ")).thenReturn(new ArrayList());
        paymentRequestDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        Mockito.when((Object)paymentRequestDocMock.getDocumentNumber()).thenReturn((Object)"1000");
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("financialSystemOriginationCode", "01");
        matcher.put("documentNumber", "1000");
        Mockito.when((Object)this.boServiceMock.countMatching(GeneralLedgerPendingEntry.class, matcher)).thenReturn((Object)0);
        Mockito.when((Object)paymentRequestDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)this.boServiceMock.save(new ArrayList())).thenReturn(new ArrayList());
        this.cut.generateEntriesModifyPaymentRequest(paymentRequestDocMock);
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock)).getItems();
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock)).getPurapDocumentIdentifier();
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock, (VerificationMode)Mockito.times((int)2))).setGeneralLedgerPendingEntries(ArgumentMatchers.anyList());
        ((PurapAccountingService)Mockito.verify((Object)this.purapAccountingSvcMock)).generateSummaryWithNoZeroTotalsNoUseTax(ArgumentMatchers.anyList());
        ((PurapAccountingService)Mockito.verify((Object)this.purapAccountingSvcMock)).getAccountsPayableSummaryAccounts(Integer.valueOf(ArgumentMatchers.anyInt()), ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.purapAccountingSvcMock});
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock)).getDocumentNumber();
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock)).getGeneralLedgerPendingEntries();
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock, (VerificationMode)Mockito.times((int)2))).setGeneralLedgerPendingEntries(ArgumentMatchers.anyList());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{paymentRequestDocMock});
        ((BusinessObjectService)Mockito.verify((Object)this.boServiceMock)).countMatching((Class)ArgumentMatchers.any(), ArgumentMatchers.anyMap());
        ((BusinessObjectService)Mockito.verify((Object)this.boServiceMock)).save(ArgumentMatchers.anyList());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.boServiceMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.purapAccountRevisionSvcMock});
    }

    @Test
    void accountingLines(@Mock PaymentRequestDocument paymentRequestDocMock) {
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        PurApItem item1 = this.getPaymentRequestItem(paymentRequestDocMock, 1, KDONE, new BigDecimal("100.00"), "ITEM");
        items.add(item1);
        ArrayList<PurchaseOrderAccount> lines = new ArrayList<PurchaseOrderAccount>();
        lines.add(this.getPurchaseOrderAccount(KDTWO, KDONE));
        item1.setSourceAccountingLines(lines);
        Mockito.when((Object)paymentRequestDocMock.getItems()).thenReturn(items);
        ArrayList<PurchaseOrderAccount> salines = new ArrayList<PurchaseOrderAccount>();
        salines.add(this.getPurchaseOrderAccount(KDTWO, KDONE));
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryWithNoZeroTotalsNoUseTax(items)).thenReturn(salines);
        Mockito.when((Object)paymentRequestDocMock.getPurapDocumentIdentifier()).thenReturn((Object)1000);
        Mockito.when((Object)this.purapAccountingSvcMock.getAccountsPayableSummaryAccounts(Integer.valueOf(1000), "PREQ")).thenReturn(new ArrayList());
        paymentRequestDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        Mockito.when((Object)paymentRequestDocMock.getDocumentNumber()).thenReturn((Object)"1000");
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("financialSystemOriginationCode", "01");
        matcher.put("documentNumber", "1000");
        Mockito.when((Object)this.boServiceMock.countMatching(GeneralLedgerPendingEntry.class, matcher)).thenReturn((Object)0);
        paymentRequestDocMock.setGenerateEncumbranceEntries(false);
        paymentRequestDocMock.setDebitCreditCodeForGLEntries("D");
        Mockito.when((Object)paymentRequestDocMock.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)ArgumentMatchers.any(), (GeneralLedgerPendingEntrySequenceHelper)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.purapAccountingSvcMock.generateUseTaxAccount((PurchasingAccountsPayableDocument)paymentRequestDocMock)).thenReturn(new ArrayList());
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)paymentRequestDocMock)).thenReturn(new ArrayList());
        this.purapAccountingSvcMock.deleteSummaryAccounts(Integer.valueOf(1000), "PREQ");
        Mockito.when((Object)this.boServiceMock.save(new ArrayList())).thenReturn(new ArrayList());
        Mockito.when((Object)paymentRequestDocMock.getPostingYearFromPendingGLEntries()).thenReturn((Object)2016);
        Mockito.when((Object)paymentRequestDocMock.getPostingPeriodCodeFromPendingGLEntries()).thenReturn((Object)"01");
        this.purapAccountRevisionSvcMock.savePaymentRequestAccountRevisions((List)ArgumentMatchers.any(), Integer.valueOf(ArgumentMatchers.anyInt()), ArgumentMatchers.anyString());
        Mockito.when((Object)paymentRequestDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        this.cut.generateEntriesModifyPaymentRequest(paymentRequestDocMock);
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock, (VerificationMode)Mockito.times((int)2))).getItems();
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock, (VerificationMode)Mockito.times((int)2))).getPurapDocumentIdentifier();
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock, (VerificationMode)Mockito.times((int)2))).getPurapDocumentIdentifier();
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock, (VerificationMode)Mockito.times((int)2))).setGenerateEncumbranceEntries(ArgumentMatchers.anyBoolean());
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock, (VerificationMode)Mockito.times((int)2))).setDebitCreditCodeForGLEntries(ArgumentMatchers.anyString());
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock)).generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)ArgumentMatchers.any(), (GeneralLedgerPendingEntrySequenceHelper)ArgumentMatchers.any());
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock)).getPostingYearFromPendingGLEntries();
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock)).getPostingPeriodCodeFromPendingGLEntries();
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock)).getGeneralLedgerPendingEntries();
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock, (VerificationMode)Mockito.times((int)2))).setGeneralLedgerPendingEntries(ArgumentMatchers.anyList());
        ((PurapAccountingService)Mockito.verify((Object)this.purapAccountingSvcMock)).generateUseTaxAccount((PurchasingAccountsPayableDocument)paymentRequestDocMock);
        ((PurapAccountingService)Mockito.verify((Object)this.purapAccountingSvcMock)).generateSummaryWithNoZeroTotalsNoUseTax(ArgumentMatchers.anyList());
        ((PurapAccountingService)Mockito.verify((Object)this.purapAccountingSvcMock)).getAccountsPayableSummaryAccounts(Integer.valueOf(ArgumentMatchers.anyInt()), ArgumentMatchers.anyString());
        ((PurapAccountingService)Mockito.verify((Object)this.purapAccountingSvcMock, (VerificationMode)Mockito.times((int)2))).deleteSummaryAccounts(Integer.valueOf(ArgumentMatchers.anyInt()), ArgumentMatchers.anyString());
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock)).getDocumentNumber();
        ((PaymentRequestDocument)Mockito.verify((Object)paymentRequestDocMock)).getGeneralLedgerPendingEntries();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{paymentRequestDocMock});
        ((BusinessObjectService)Mockito.verify((Object)this.boServiceMock)).countMatching((Class)ArgumentMatchers.any(), ArgumentMatchers.anyMap());
        ((BusinessObjectService)Mockito.verify((Object)this.boServiceMock, (VerificationMode)Mockito.times((int)2))).save(ArgumentMatchers.anyList());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.boServiceMock});
        ((PurapAccountRevisionService)Mockito.verify((Object)this.purapAccountRevisionSvcMock, (VerificationMode)Mockito.times((int)2))).savePaymentRequestAccountRevisions((List)ArgumentMatchers.any(), Integer.valueOf(ArgumentMatchers.anyInt()), ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.purapAccountRevisionSvcMock});
    }
}

