/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.impl.PurapGeneralLedgerServiceImpl;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class GenerateEntriesVoidPurchaseOrderTest {
    private PurapGeneralLedgerServiceImpl cut;
    @Mock
    private PurapAccountingService purapAccountingSvcMock;
    @Mock
    private GeneralLedgerPendingEntryService glPendingEntrySvcMock;
    @Mock
    private BusinessObjectService boServiceMock;
    private List<PurApItem> poItems;
    private List<PurApItem> poActiveItems;
    private List<GeneralLedgerPendingEntry> glpes;
    private List<SourceAccountingLine> sourceAccountingLines;

    GenerateEntriesVoidPurchaseOrderTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new PurapGeneralLedgerServiceImpl();
        this.cut.setPurapAccountingService(this.purapAccountingSvcMock);
        this.cut.setGeneralLedgerPendingEntryService(this.glPendingEntrySvcMock);
        this.cut.setBusinessObjectService(this.boServiceMock);
        this.poItems = new ArrayList<PurApItem>();
        this.poActiveItems = new ArrayList<PurApItem>();
        this.glpes = new ArrayList<GeneralLedgerPendingEntry>();
        this.sourceAccountingLines = new ArrayList<SourceAccountingLine>();
    }

    private void execute(PurchaseOrderDocument poMock) {
        this.cut.generateEntriesVoidPurchaseOrder(poMock);
        ((PurchaseOrderDocument)Mockito.verify((Object)poMock)).getItems();
        ((PurchaseOrderDocument)Mockito.verify((Object)poMock)).getItemsActiveOnly();
        ((PurchaseOrderDocument)Mockito.verify((Object)poMock, (VerificationMode)Mockito.times((int)2))).setGlOnlySourceAccountingLines(this.sourceAccountingLines);
        ((PurchaseOrderDocument)Mockito.verify((Object)poMock)).getGeneralLedgerPendingEntries();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{poMock});
        ((PurapAccountingService)Mockito.verify((Object)this.purapAccountingSvcMock)).generateSummaryWithNoZeroTotalsUsingAlternateAmount(this.poActiveItems);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.purapAccountingSvcMock});
        ((GeneralLedgerPendingEntryService)Mockito.verify((Object)this.glPendingEntrySvcMock)).generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)poMock);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.glPendingEntrySvcMock});
        ((BusinessObjectService)Mockito.verify((Object)this.boServiceMock)).save(this.glpes);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.boServiceMock});
    }

    private void preparePO(PurchaseOrderDocument poMock) {
        Mockito.when((Object)poMock.getItems()).thenReturn(this.poItems);
        Mockito.when((Object)poMock.getItemsActiveOnly()).thenReturn(this.poActiveItems);
        poMock.setGlOnlySourceAccountingLines(this.sourceAccountingLines);
        Mockito.when((Object)poMock.getGeneralLedgerPendingEntries()).thenReturn(this.glpes);
    }

    private void prepareItem(PurchaseOrderItem itemMock, int lineNumber, double outstandingAmount, List<PurApAccountingLine> accountingLines, boolean active) {
        Mockito.when((Object)itemMock.getItemLineNumber()).thenReturn((Object)lineNumber);
        Mockito.when((Object)itemMock.isItemActiveIndicator()).thenReturn((Object)active);
        if (active) {
            Mockito.when((Object)itemMock.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(outstandingAmount));
            Mockito.when((Object)itemMock.getSourceAccountingLines()).thenReturn(accountingLines);
            this.poActiveItems.add((PurApItem)itemMock);
        }
        this.poItems.add((PurApItem)itemMock);
    }

    private PurchaseOrderAccount createPoAccountingLine(PurchaseOrderAccount accountMock, double percent, double newOutstandingAmount, Double altAmount) {
        Mockito.when((Object)accountMock.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)accountMock.getAccountLinePercent()).thenReturn((Object)new BigDecimal(percent));
        Mockito.when((Object)accountMock.compareTo(ArgumentMatchers.isA(PurchaseOrderAccount.class))).thenReturn((Object)0);
        accountMock.setAlternateAmountForGLEntryCreation(new KualiDecimal(newOutstandingAmount));
        ((PurchaseOrderAccount)Mockito.verify((Object)accountMock)).setAlternateAmountForGLEntryCreation((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        if (altAmount != null) {
            Mockito.when((Object)accountMock.getAlternateAmountForGLEntryCreation()).thenReturn((Object)new KualiDecimal(newOutstandingAmount));
            accountMock.setAlternateAmountForGLEntryCreation(new KualiDecimal(altAmount.doubleValue()));
            ((PurchaseOrderAccount)Mockito.verify((Object)accountMock, (VerificationMode)Mockito.times((int)2))).setAlternateAmountForGLEntryCreation((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        }
        this.sourceAccountingLines.add((SourceAccountingLine)accountMock);
        return accountMock;
    }

    private void prepareItemsNoAccountingLines(PurchaseOrderItem itemOrder1Mock, PurchaseOrderItem itemOrder2Mock) {
        this.prepareItem(itemOrder1Mock, 1, 10.0, new ArrayList<PurApAccountingLine>(), true);
        this.prepareItem(itemOrder2Mock, 2, 15.0, new ArrayList<PurApAccountingLine>(), false);
    }

    private void baseExpectations(@Mock PurchaseOrderDocument poMock) {
        this.preparePO(poMock);
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryWithNoZeroTotalsUsingAlternateAmount(this.poActiveItems)).thenReturn(this.sourceAccountingLines);
        Mockito.when((Object)this.glPendingEntrySvcMock.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)poMock)).thenReturn((Object)true);
        Mockito.when((Object)this.boServiceMock.save(this.glpes)).thenReturn(null);
    }

    @Test
    void baseCase(@Mock PurchaseOrderDocument poMock) {
        this.baseExpectations(poMock);
        this.execute(poMock);
    }

    @Test
    void poWithItems(@Mock PurchaseOrderDocument poMock, @Mock PurchaseOrderItem itemOrder1Mock, @Mock PurchaseOrderItem itemOrder2Mock) {
        this.baseExpectations(poMock);
        this.prepareItemsNoAccountingLines(itemOrder1Mock, itemOrder2Mock);
        this.execute(poMock);
    }

    @Test
    void poWithAccountingLines(@Mock PurchaseOrderDocument poMock, @Mock PurchaseOrderAccount account1Mock, @Mock PurchaseOrderAccount account2Mock, @Mock PurchaseOrderAccount account3Mock, @Mock PurchaseOrderAccount account4Mock, @Mock PurchaseOrderAccount account5Mock, @Mock PurchaseOrderItem itemOrder1Mock, @Mock PurchaseOrderItem itemOrder2Mock, @Mock PurchaseOrderItem itemOrder3Mock) {
        this.baseExpectations(poMock);
        ArrayList<Object> accountingLines = new ArrayList<PurApAccountingLine>();
        Mockito.when((Object)account1Mock.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)account1Mock.getAccountLinePercent()).thenReturn((Object)new BigDecimal("100"));
        account1Mock.setAlternateAmountForGLEntryCreation(new KualiDecimal(10.0));
        ((PurchaseOrderAccount)Mockito.verify((Object)account1Mock)).setAlternateAmountForGLEntryCreation((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        Mockito.when((Object)account1Mock.getAlternateAmountForGLEntryCreation()).thenReturn((Object)new KualiDecimal(10.0));
        account1Mock.setAlternateAmountForGLEntryCreation(new KualiDecimal(10.0));
        ((PurchaseOrderAccount)Mockito.verify((Object)account1Mock, (VerificationMode)Mockito.times((int)2))).setAlternateAmountForGLEntryCreation((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        this.sourceAccountingLines.add((SourceAccountingLine)account1Mock);
        accountingLines.add(account1Mock);
        this.prepareItem(itemOrder1Mock, 1, 10.0, accountingLines, true);
        accountingLines = new ArrayList();
        Mockito.when((Object)account2Mock.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)account2Mock.getAccountLinePercent()).thenReturn((Object)new BigDecimal("50"));
        account2Mock.setAlternateAmountForGLEntryCreation(new KualiDecimal(5.0));
        ((PurchaseOrderAccount)Mockito.verify((Object)account2Mock)).setAlternateAmountForGLEntryCreation((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        this.sourceAccountingLines.add((SourceAccountingLine)account2Mock);
        accountingLines.add((PurApAccountingLine)account2Mock);
        accountingLines.add(this.createPoAccountingLine(account3Mock, 50.0, 5.0, 5.0));
        this.prepareItem(itemOrder2Mock, 2, 10.0, accountingLines, true);
        accountingLines = new ArrayList();
        Mockito.when((Object)account4Mock.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)account4Mock.getAccountLinePercent()).thenReturn((Object)new BigDecimal("66.66"));
        account4Mock.setAlternateAmountForGLEntryCreation(new KualiDecimal(6666.0));
        ((PurchaseOrderAccount)Mockito.verify((Object)account4Mock)).setAlternateAmountForGLEntryCreation((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        this.sourceAccountingLines.add((SourceAccountingLine)account4Mock);
        accountingLines.add((PurApAccountingLine)account4Mock);
        accountingLines.add(this.createPoAccountingLine(account5Mock, 33.33, 3333.0, 3334.0));
        this.prepareItem(itemOrder3Mock, 3, 10000.0, accountingLines, true);
        this.execute(poMock);
    }
}

