/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.kfs.core.impl.datetime.DateTimeServiceImpl;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.batch.ElectronicInvoiceInputFileType;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoice;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceContact;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceDetailRequestHeader;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceDetailRequestSummary;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceItem;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceOrder;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoicePostalAddress;
import org.kuali.kfs.module.purap.businessobject.jaxb.Header;
import org.kuali.kfs.module.purap.util.ElectronicInvoiceUtils;
import org.kuali.kfs.module.purap.util.cxml.CxmlExtrinsic;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.exception.ParseException;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.core.io.Resource;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class ElectronicInvoiceParserTest {
    private static final String AMAZON_E_INVOICE_XML_FILE = ".." + File.separator + "fixture" + File.separator + "amazonInvoiceSample.xml";
    private static final String AMAZON_E_INVOICE_MALFORMED_XML_FILE = ".." + File.separator + "fixture" + File.separator + "amazonInvoiceMalformedSample.xml";
    private static final String E_INVOICE_XML_FILE = ".." + File.separator + "fixture" + File.separator + "electronicInvoiceSample.xml";
    private static final String SCHEMA_FILE = "org/kuali/kfs/module/purap/batch/electronicInvoice.xsd";
    private ElectronicInvoiceInputFileType cut;
    private DateTimeService dateTimeService;

    ElectronicInvoiceParserTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new ElectronicInvoiceInputFileType();
        this.cut.setSchemaLocation(SCHEMA_FILE);
        this.cut.setOutputClass(ElectronicInvoice.class);
        this.dateTimeService = new DateTimeServiceImpl();
    }

    @Test
    void parse_eInvoiceXMLFile(@Mock(strictness=Mock.Strictness.LENIENT) ParameterService parameterSvcMock, @Mock Resource schemaResourceMock) throws Exception {
        BufferedInputStream fileStream = new BufferedInputStream(this.getClass().getResourceAsStream(E_INVOICE_XML_FILE));
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)fileStream);
        try (MockedStatic globalResourceLoaderMockedStatic = Mockito.mockStatic(GlobalResourceLoader.class);
             MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            Mockito.when((Object)schemaResourceMock.getInputStream()).thenReturn((Object)this.getClass().getResourceAsStream("/org/kuali/kfs/module/purap/batch/electronicInvoice.xsd"), (Object[])new InputStream[]{this.getClass().getResourceAsStream("/org/kuali/kfs/module/purap/batch/electronicInvoice.xsd")});
            springContextStaticMock.when(() -> SpringContext.getBean(ParameterService.class)).thenReturn((Object)parameterSvcMock);
            globalResourceLoaderMockedStatic.when(() -> GlobalResourceLoader.getResource((String)SCHEMA_FILE)).thenReturn((Object)schemaResourceMock);
            springContextStaticMock.when(() -> SpringContext.getBean(DateTimeService.class)).thenReturn((Object)this.dateTimeService);
            Mockito.when((Object)parameterSvcMock.getParameterValueAsString("KFS-PURAP", "All", PurapConstants.NamedDateFormats.CXML_DATE_FORMAT)).thenReturn((Object)"0000-00-00");
            Mockito.when((Object)parameterSvcMock.getParameterValueAsString("KFS-PURAP", "All", PurapConstants.NamedDateFormats.KUALI_DATE_FORMAT)).thenReturn((Object)"00/00/0000");
            Mockito.when((Object)parameterSvcMock.getParameterValueAsString("KFS-PURAP", "All", PurapConstants.NamedDateFormats.CXML_SIMPLE_DATE_FORMAT)).thenReturn((Object)"yyyy-MM-dd");
            ElectronicInvoice eInvoice = (ElectronicInvoice)this.cut.parse(fileByteContent);
            Assertions.assertNotNull((Object)eInvoice);
            Assertions.assertEquals((Object)"200807260401062080.964@eai002", (Object)eInvoice.getPayloadID());
            Assertions.assertEquals((Object)"2008-07-26T04:01:06-08:00", (Object)eInvoice.getTimestamp());
            Assertions.assertEquals((Object)"1.2.014", (Object)eInvoice.getVersion());
            Assertions.assertEquals((Object)"en", (Object)eInvoice.getLang());
            Assertions.assertEquals((Object)"production", (Object)eInvoice.getDeploymentMode());
            Header header = eInvoice.getHeader();
            Assertions.assertNotNull((Object)header);
            Assertions.assertEquals((Object)"DUNS", (Object)header.getFromDomain());
            Assertions.assertEquals((Object)"121212", (Object)header.getFromIdentity());
            Assertions.assertEquals((Object)"NetworkId", (Object)header.getToDomain());
            Assertions.assertEquals((Object)"IUHIGHERM", (Object)header.getToIdentity());
            Assertions.assertEquals((Object)"DUNS", (Object)header.getSenderDomain());
            Assertions.assertEquals((Object)"121212", (Object)header.getSenderIdentity());
            Assertions.assertEquals((Object)"fisherscipass", (Object)header.getSenderSharedSecret());
            Assertions.assertEquals((Object)"IUPUI", (Object)header.getSenderUserAgent());
            ElectronicInvoiceDetailRequestHeader invoiceDetailRequestHeader = eInvoice.getInvoiceDetailRequestHeader();
            Assertions.assertNotNull((Object)invoiceDetailRequestHeader);
            String invoiceDate = invoiceDetailRequestHeader.getInvoiceDateString();
            Assertions.assertEquals((Object)"2008-07-25T00:00:00-08:00", (Object)invoiceDate);
            Date date = ElectronicInvoiceUtils.getDate((String)invoiceDate);
            Assertions.assertNotNull((Object)date);
            Assertions.assertEquals((Object)date.toString(), (Object)invoiceDetailRequestHeader.getInvoiceDate().toString());
            Assertions.assertEquals((Object)"133", (Object)invoiceDetailRequestHeader.getInvoiceId());
            Assertions.assertEquals((Object)"new", (Object)invoiceDetailRequestHeader.getOperation());
            Assertions.assertEquals((Object)"standard", (Object)invoiceDetailRequestHeader.getPurpose());
            Assertions.assertTrue((boolean)invoiceDetailRequestHeader.isInformationOnly());
            Assertions.assertTrue((boolean)invoiceDetailRequestHeader.isHeaderInvoiceIndicator());
            Assertions.assertTrue((boolean)invoiceDetailRequestHeader.isTaxInLine());
            Assertions.assertTrue((boolean)invoiceDetailRequestHeader.isSpecialHandlingInLine());
            Assertions.assertTrue((boolean)invoiceDetailRequestHeader.isShippingInLine());
            Assertions.assertTrue((boolean)invoiceDetailRequestHeader.isDiscountInLine());
            ElectronicInvoiceContact billToContact = invoiceDetailRequestHeader.getCxmlContactByRoleID("billTo");
            Assertions.assertNotNull((Object)billToContact);
            Assertions.assertEquals((Object)"", (Object)billToContact.getAddressID());
            Assertions.assertEquals((Object)"billTo", (Object)billToContact.getRole());
            Assertions.assertEquals((int)1, (int)billToContact.getPostalAddresses().size());
            Assertions.assertEquals((Object)"ACCOUNTING DEPT", (Object)((ElectronicInvoicePostalAddress)billToContact.getPostalAddresses().get(0)).getLine1());
            Assertions.assertEquals((Object)"620 UNION DR", (Object)((ElectronicInvoicePostalAddress)billToContact.getPostalAddresses().get(0)).getLine2());
            Assertions.assertEquals((Object)"RM 443", (Object)((ElectronicInvoicePostalAddress)billToContact.getPostalAddresses().get(0)).getLine3());
            Assertions.assertEquals((Object)"INDIANAPOLIS", (Object)((ElectronicInvoicePostalAddress)billToContact.getPostalAddresses().get(0)).getCityName());
            Assertions.assertEquals((Object)"IN", (Object)((ElectronicInvoicePostalAddress)billToContact.getPostalAddresses().get(0)).getStateCode());
            Assertions.assertEquals((Object)"United States", (Object)((ElectronicInvoicePostalAddress)billToContact.getPostalAddresses().get(0)).getCountryName());
            Assertions.assertEquals((Object)"US", (Object)((ElectronicInvoicePostalAddress)billToContact.getPostalAddresses().get(0)).getCountryCode());
            ElectronicInvoiceContact remitToContact = invoiceDetailRequestHeader.getCxmlContactByRoleID("remitTo");
            Assertions.assertNotNull((Object)remitToContact);
            Assertions.assertEquals((Object)"004321519", (Object)remitToContact.getAddressID());
            Assertions.assertEquals((Object)"remitTo", (Object)remitToContact.getRole());
            Assertions.assertEquals((int)1, (int)remitToContact.getPostalAddresses().size());
            ElectronicInvoicePostalAddress remitToAddress = (ElectronicInvoicePostalAddress)remitToContact.getPostalAddresses().get(0);
            Assertions.assertEquals((Object)"13551 COLLECTIONS CTR DR", (Object)remitToAddress.getLine1());
            Assertions.assertNull((Object)remitToAddress.getLine2());
            Assertions.assertNull((Object)remitToAddress.getLine3());
            Assertions.assertEquals((Object)"CHICAGO", (Object)remitToAddress.getCityName());
            Assertions.assertEquals((Object)"IL", (Object)remitToAddress.getStateCode());
            Assertions.assertEquals((Object)"United States", (Object)remitToAddress.getCountryName());
            Assertions.assertEquals((Object)"US", (Object)remitToAddress.getCountryCode());
            Assertions.assertEquals((Object)"2008-07-25T00:00:00-08:00", (Object)invoiceDetailRequestHeader.getShippingDateString());
            ElectronicInvoiceContact shipToContact = invoiceDetailRequestHeader.getCxmlContactByRoleID("shipTo");
            Assertions.assertNotNull((Object)shipToContact);
            Assertions.assertEquals((Object)"387520002", (Object)shipToContact.getAddressID());
            Assertions.assertEquals((Object)"shipTo", (Object)shipToContact.getRole());
            Assertions.assertEquals((int)1, (int)shipToContact.getPostalAddresses().size());
            ElectronicInvoicePostalAddress shipToAddress = (ElectronicInvoicePostalAddress)shipToContact.getPostalAddresses().get(0);
            Assertions.assertEquals((Object)"950 W WALNUT ST", (Object)shipToAddress.getLine1());
            Assertions.assertEquals((Object)"ROOM #451", (Object)shipToAddress.getLine2());
            Assertions.assertNull((Object)shipToAddress.getLine3());
            Assertions.assertEquals((Object)"INDIANAPOLIS", (Object)shipToAddress.getCityName());
            Assertions.assertEquals((Object)"IN", (Object)shipToAddress.getStateCode());
            Assertions.assertEquals((Object)"United States", (Object)shipToAddress.getCountryName());
            Assertions.assertEquals((Object)"US", (Object)shipToAddress.getCountryCode());
            Map emailAddresses = shipToContact.getEmailAddresses();
            Assertions.assertEquals((int)2, (int)emailAddresses.size());
            Assertions.assertEquals((Object)"abc@efg.com", emailAddresses.get("test1"));
            Assertions.assertEquals((Object)"efg@hij.com", emailAddresses.get("test2"));
            Map phoneNumbers = shipToContact.getPhoneNumbers();
            Assertions.assertEquals((int)2, (int)phoneNumbers.size());
            Assertions.assertEquals((Object)"12099545333", phoneNumbers.get("testPhone"));
            Assertions.assertEquals((Object)"12099545331", phoneNumbers.get("testFax"));
            String url = (String)shipToContact.getWebAddresses().get(0);
            Assertions.assertEquals((Object)"www.abc.com", (Object)url);
            Assertions.assertEquals((int)30, (int)invoiceDetailRequestHeader.getPayInNumberOfDays());
            Assertions.assertEquals((Object)"0", (Object)invoiceDetailRequestHeader.getPercentageRate());
            Assertions.assertEquals((int)1, (int)eInvoice.getInvoiceDetailOrders().size());
            ElectronicInvoiceOrder order = (ElectronicInvoiceOrder)eInvoice.getInvoiceDetailOrders().get(0);
            Assertions.assertEquals((Object)"2008-07-25T00:00:00-08:00", (Object)order.getOrderReferenceOrderDateString());
            Assertions.assertEquals((Object)"1085", (Object)order.getOrderReferenceOrderID());
            Assertions.assertEquals((Object)"", (Object)order.getOrderReferenceDocumentRefPayloadID());
            Assertions.assertEquals((int)1, (int)order.getInvoiceItems().size());
            ElectronicInvoiceItem item = (ElectronicInvoiceItem)order.getInvoiceItems().get(0);
            Assertions.assertEquals((Object)"1", (Object)item.getInvoiceLineNumber());
            Assertions.assertEquals((Object)"10", (Object)item.getQuantity());
            Assertions.assertEquals((Object)"BG", (Object)item.getUnitOfMeasure());
            Assertions.assertEquals((Object)"11", (Object)item.getUnitPrice());
            Assertions.assertEquals((Object)"1", (Object)item.getReferenceLineNumber());
            Assertions.assertEquals((Object)"1212", (Object)item.getReferenceItemIDSupplierPartID());
            Assertions.assertEquals((Object)"LABCOAT UNISEX LONG XL WHT", (Object)item.getReferenceDescription());
            Assertions.assertEquals((double)110.0, (double)item.getInvoiceLineSubTotalAmountBigDecimal().doubleValue(), (double)0.0);
            Assertions.assertEquals((double)2.0, (double)item.getInvoiceLineTaxAmountBigDecimal().doubleValue(), (double)0.0);
            Assertions.assertEquals((Object)"Sales Tax", (Object)item.getTaxDescription());
            Assertions.assertEquals((double)10.0, (double)item.getInvoiceLineShippingAmountBigDecimal().doubleValue(), (double)0.0);
            Assertions.assertEquals((double)5.0, (double)item.getInvoiceLineSpecialHandlingAmountBigDecimal().doubleValue(), (double)0.0);
            ElectronicInvoiceDetailRequestSummary summary = eInvoice.getInvoiceDetailRequestSummary();
            Assertions.assertNotNull((Object)summary);
            Assertions.assertEquals((Object)"1.00", (Object)summary.getSubTotalAmount());
            Assertions.assertEquals((Object)"2.00", (Object)summary.getTaxAmount());
            Assertions.assertEquals((Object)"Total Tax", (Object)summary.getTaxDescription());
            Assertions.assertEquals((Object)"3.00", (Object)summary.getSpecialHandlingAmount());
            Assertions.assertEquals((Object)"4.00", (Object)summary.getShippingAmount());
            Assertions.assertEquals((Object)"6.00", (Object)summary.getDiscountAmount());
            Assertions.assertEquals((Object)"5.00", (Object)summary.getGrossAmount());
            Assertions.assertEquals((Object)"7.00", (Object)summary.getNetAmount());
            Assertions.assertEquals((Object)"8.00", (Object)summary.getDepositAmount());
            Assertions.assertEquals((Object)"9.00", (Object)summary.getDueAmount());
        }
    }

    @Test
    void parse_amazonInvoiceXMLFile(@Mock(strictness=Mock.Strictness.LENIENT) ParameterService parameterSvcMock, @Mock Resource schemaResourceMock) throws Exception {
        BufferedInputStream fileStream = new BufferedInputStream(this.getClass().getResourceAsStream(AMAZON_E_INVOICE_XML_FILE));
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)fileStream);
        try (MockedStatic globalResourceLoaderMockedStatic = Mockito.mockStatic(GlobalResourceLoader.class);
             MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            Mockito.when((Object)parameterSvcMock.getParameterValueAsString("KFS-PURAP", "All", PurapConstants.NamedDateFormats.CXML_DATE_FORMAT)).thenReturn((Object)"0000-00-00");
            Mockito.when((Object)parameterSvcMock.getParameterValueAsString("KFS-PURAP", "All", PurapConstants.NamedDateFormats.KUALI_DATE_FORMAT)).thenReturn((Object)"00/00/0000");
            Mockito.when((Object)parameterSvcMock.getParameterValueAsString("KFS-PURAP", "All", PurapConstants.NamedDateFormats.CXML_SIMPLE_DATE_FORMAT)).thenReturn((Object)"yyyy-MM-dd");
            Mockito.when((Object)schemaResourceMock.getInputStream()).thenReturn((Object)this.getClass().getResourceAsStream("/org/kuali/kfs/module/purap/batch/electronicInvoice.xsd"), (Object[])new InputStream[]{this.getClass().getResourceAsStream("/org/kuali/kfs/module/purap/batch/electronicInvoice.xsd")});
            springContextStaticMock.when(() -> SpringContext.getBean(ParameterService.class)).thenReturn((Object)parameterSvcMock);
            globalResourceLoaderMockedStatic.when(() -> GlobalResourceLoader.getResource((String)SCHEMA_FILE)).thenReturn((Object)schemaResourceMock);
            ElectronicInvoice eInvoice = (ElectronicInvoice)this.cut.parse(fileByteContent);
            Assertions.assertNotNull((Object)eInvoice);
            Assertions.assertEquals((Object)"1528161523877.141.1289@amazon.com", (Object)eInvoice.getPayloadID());
            Assertions.assertEquals((Object)"2018-06-05T01:18:43+0000", (Object)eInvoice.getTimestamp());
            Assertions.assertEquals((Object)"1.2.030", (Object)eInvoice.getVersion());
            Assertions.assertEquals((Object)"en-US", (Object)eInvoice.getLang());
            Assertions.assertEquals((Object)"production", (Object)eInvoice.getDeploymentMode());
            Header header = eInvoice.getHeader();
            Assertions.assertNotNull((Object)header);
            Assertions.assertEquals((Object)"DUNS", (Object)header.getFromDomain());
            Assertions.assertEquals((Object)"174495606", (Object)header.getFromIdentity());
            Assertions.assertEquals((Object)"NetworkId", (Object)header.getToDomain());
            Assertions.assertEquals((Object)"174495606", (Object)header.getToIdentity());
            Assertions.assertEquals((Object)"NetworkId", (Object)header.getSenderDomain());
            Assertions.assertEquals((Object)"Amazon", (Object)header.getSenderIdentity());
            Assertions.assertEquals((Object)"Amazon LLC eProcurement Application", (Object)header.getSenderUserAgent());
            ElectronicInvoiceDetailRequestHeader invoiceDetailRequestHeader = eInvoice.getInvoiceDetailRequestHeader();
            Assertions.assertNotNull((Object)invoiceDetailRequestHeader);
            String invoiceDate = invoiceDetailRequestHeader.getInvoiceDateString();
            Date date = ElectronicInvoiceUtils.getDate((String)invoiceDate);
            Assertions.assertEquals((Object)"2018-06-05T00:53:26+0000", (Object)invoiceDate);
            Assertions.assertNotNull((Object)date);
            Assertions.assertEquals((Object)date.toString(), (Object)invoiceDetailRequestHeader.getInvoiceDate().toString());
            Assertions.assertEquals((Object)"1FGM-CH6N-DCV1", (Object)invoiceDetailRequestHeader.getInvoiceId());
            Assertions.assertEquals((Object)"new", (Object)invoiceDetailRequestHeader.getOperation());
            Assertions.assertEquals((Object)"standard", (Object)invoiceDetailRequestHeader.getPurpose());
            Assertions.assertFalse((boolean)invoiceDetailRequestHeader.isInformationOnly());
            Assertions.assertFalse((boolean)invoiceDetailRequestHeader.isHeaderInvoiceIndicator());
            Assertions.assertFalse((boolean)invoiceDetailRequestHeader.isTaxInLine());
            Assertions.assertFalse((boolean)invoiceDetailRequestHeader.isSpecialHandlingInLine());
            Assertions.assertFalse((boolean)invoiceDetailRequestHeader.isShippingInLine());
            Assertions.assertFalse((boolean)invoiceDetailRequestHeader.isDiscountInLine());
            Assertions.assertEquals((int)30, (int)invoiceDetailRequestHeader.getPayInNumberOfDays());
            Assertions.assertTrue((boolean)invoiceDetailRequestHeader.isAccountingInLine());
            List extrinsics = invoiceDetailRequestHeader.getExtrinsics();
            Assertions.assertEquals((int)2, (int)extrinsics.size());
            HashMap<String, String> expectedExtrinsicValues = new HashMap<String, String>();
            expectedExtrinsicValues.put("carrierName", "UPS");
            expectedExtrinsicValues.put("carrierTrackingNumber", "1Z2FW8240302944450");
            for (CxmlExtrinsic extrinsic : extrinsics) {
                Assertions.assertEquals(expectedExtrinsicValues.get(extrinsic.getName()), (Object)extrinsic.getValue());
            }
            ElectronicInvoiceContact billToContact = invoiceDetailRequestHeader.getCxmlContactByRoleID("billTo");
            Assertions.assertNull((Object)billToContact);
            ElectronicInvoiceContact remitToContact = invoiceDetailRequestHeader.getCxmlContactByRoleID("remitTo");
            Assertions.assertNull((Object)remitToContact);
            Assertions.assertEquals((int)1, (int)eInvoice.getInvoiceDetailOrders().size());
            ElectronicInvoiceOrder order = (ElectronicInvoiceOrder)eInvoice.getInvoiceDetailOrders().get(0);
            Assertions.assertEquals((Object)"2018-06-04T19:45:16+0000", (Object)order.getOrderReferenceOrderDateString());
            Assertions.assertEquals((Object)"61820446", (Object)order.getOrderReferenceOrderID());
            Assertions.assertEquals((Object)"2018-06-04-12-43-51.61820446:0:84.234388139244199091950851296116719871325@", (Object)order.getOrderReferenceDocumentRefPayloadID());
            Assertions.assertEquals((Object)"111-9115002-3933056", (Object)order.getSupplierOrderInfoID());
            Assertions.assertEquals((int)1, (int)order.getInvoiceItems().size());
            ElectronicInvoiceItem item = (ElectronicInvoiceItem)order.getInvoiceItems().get(0);
            Assertions.assertEquals((Object)"1", (Object)item.getInvoiceLineNumber());
            Assertions.assertEquals((Object)"1", (Object)item.getQuantity());
            Assertions.assertEquals((Object)"EA", (Object)item.getUnitOfMeasure());
            Assertions.assertEquals((Object)"316.99", (Object)item.getUnitPrice());
            Assertions.assertEquals((Object)"2", (Object)item.getReferenceLineNumber());
            Assertions.assertEquals((Object)"B01NB0P9K5", (Object)item.getReferenceItemIDSupplierPartID());
            Assertions.assertEquals((Object)"HP 410A Toner Cartridge Cyan, Yellow & Magenta", (Object)item.getReferenceDescription());
            Assertions.assertEquals((double)316.99, (double)item.getInvoiceLineSubTotalAmountBigDecimal().doubleValue(), (double)0.0);
            Assertions.assertEquals((double)28.53, (double)item.getInvoiceLineTaxAmountBigDecimal().doubleValue(), (double)0.0);
            Assertions.assertEquals((Object)"Cost of tax, including shipping tax", (Object)item.getTaxDescription());
            Assertions.assertEquals((double)0.0, (double)item.getInvoiceLineShippingAmountBigDecimal().doubleValue(), (double)0.0);
            Assertions.assertEquals((double)0.0, (double)item.getInvoiceLineSpecialHandlingAmountBigDecimal().doubleValue(), (double)0.0);
            ElectronicInvoiceDetailRequestSummary summary = eInvoice.getInvoiceDetailRequestSummary();
            Assertions.assertNotNull((Object)summary);
            Assertions.assertEquals((Object)"316.99", (Object)summary.getSubTotalAmount());
            Assertions.assertEquals((Object)"28.53", (Object)summary.getTaxAmount());
            Assertions.assertEquals((Object)"Cost of tax, including shipping tax", (Object)summary.getTaxDescription());
            Assertions.assertEquals((Object)"0.00", (Object)summary.getSpecialHandlingAmount());
            Assertions.assertEquals((Object)"0.00", (Object)summary.getShippingAmount());
            Assertions.assertEquals((Object)"0.00", (Object)summary.getDiscountAmount());
            Assertions.assertNull((Object)summary.getGrossAmount());
            Assertions.assertEquals((Object)"345.52", (Object)summary.getNetAmount());
            Assertions.assertNull((Object)summary.getDepositAmount());
            Assertions.assertEquals((Object)"345.52", (Object)summary.getDueAmount());
        }
    }

    @Test
    void parse_amazonInvoiceMalformedXMLFile(@Mock Resource schemaResourceMock) throws Exception {
        BufferedInputStream fileStream = new BufferedInputStream(this.getClass().getResourceAsStream(AMAZON_E_INVOICE_MALFORMED_XML_FILE));
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)fileStream);
        try (MockedStatic globalResourceLoaderMockedStatic = Mockito.mockStatic(GlobalResourceLoader.class);){
            Mockito.when((Object)schemaResourceMock.getInputStream()).thenReturn((Object)this.getClass().getResourceAsStream("/org/kuali/kfs/module/purap/batch/electronicInvoice.xsd"), (Object[])new InputStream[]{this.getClass().getResourceAsStream("/org/kuali/kfs/module/purap/batch/electronicInvoice.xsd")});
            globalResourceLoaderMockedStatic.when(() -> GlobalResourceLoader.getResource((String)SCHEMA_FILE)).thenReturn((Object)schemaResourceMock);
            Exception e = (Exception)Assertions.assertThrows(ParseException.class, () -> this.cut.parse(fileByteContent));
            Assertions.assertEquals((Object)"error Parsing error was encountered on line 41, column 42: cvc-complex-type.2.4.d: Invalid content was found starting with element 'Request'. No child element is expected at this point.", (Object)e.getMessage());
        }
    }
}

