/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.util;

import java.sql.Date;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.config.property.ConfigContext;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.impl.config.property.Config;
import org.kuali.kfs.core.impl.datetime.DateTimeServiceImpl;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.util.ElectronicInvoiceUtils;
import org.kuali.kfs.sys.context.SpringContext;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class ElectronicInvoiceUtilsTest {
    private DateTimeServiceImpl dateTimeService;

    ElectronicInvoiceUtilsTest() {
    }

    @BeforeEach
    void setup() {
        this.dateTimeService = new DateTimeServiceImpl();
    }

    @AfterEach
    void tearDown() {
        ConfigContext.destroy();
    }

    @Test
    void getDate_CDW_xml(@Mock(stubOnly=true) ParameterService parameterSvcMock) {
        Date formattedDate;
        String invoiceDate = "2008-08-11T00:00:00-06:00";
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(ParameterService.class)).thenReturn((Object)parameterSvcMock);
            formattedDate = ElectronicInvoiceUtils.getDate((String)"2008-08-11T00:00:00-06:00");
        }
        Assertions.assertEquals((Object)"2008-08-11", (Object)Objects.requireNonNull(formattedDate).toString());
    }

    @Test
    void getDate_VWR_xml(@Mock(stubOnly=true) ParameterService parameterSvcMock) {
        Date formattedDate;
        String invoiceDate = "2008-07-29";
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(ParameterService.class)).thenReturn((Object)parameterSvcMock);
            formattedDate = ElectronicInvoiceUtils.getDate((String)"2008-07-29");
        }
        Assertions.assertEquals((Object)"2008-07-29", (Object)Objects.requireNonNull(formattedDate).toString());
    }

    @Test
    void getDate_GuyBrown_xml(@Mock(stubOnly=true, strictness=Mock.Strictness.LENIENT) ParameterService parameterSvcMock) {
        Date formattedDate;
        String invoiceDate = "2008-07-29T12:00:00";
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            Mockito.when((Object)parameterSvcMock.getParameterValueAsString("KFS-PURAP", "All", PurapConstants.NamedDateFormats.CXML_DATE_FORMAT)).thenReturn((Object)"0000-00-00");
            Mockito.when((Object)parameterSvcMock.getParameterValueAsString("KFS-PURAP", "All", PurapConstants.NamedDateFormats.KUALI_DATE_FORMAT)).thenReturn((Object)"00/00/0000");
            Mockito.when((Object)parameterSvcMock.getParameterValueAsString("KFS-PURAP", "All", PurapConstants.NamedDateFormats.CXML_SIMPLE_DATE_FORMAT)).thenReturn((Object)"yyyy-MM-dd");
            springContextMockedStatic.when(() -> SpringContext.getBean(ParameterService.class)).thenReturn((Object)parameterSvcMock);
            formattedDate = ElectronicInvoiceUtils.getDate((String)"2008-07-29T12:00:00");
        }
        Assertions.assertEquals((Object)"2008-07-29", (Object)Objects.requireNonNull(formattedDate).toString());
    }

    @Test
    void getDate_BarnesAndNoble_xml(@Mock(stubOnly=true) ParameterService parameterSvcMock) {
        Date formattedDate;
        String invoiceDate = "2008-07-23T12:00:00-12:00";
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(ParameterService.class)).thenReturn((Object)parameterSvcMock);
            formattedDate = ElectronicInvoiceUtils.getDate((String)"2008-07-23T12:00:00-12:00");
        }
        Assertions.assertEquals((Object)"2008-07-23", (Object)Objects.requireNonNull(formattedDate).toString());
    }

    @Test
    void getDate_RejectDocDate_KualiFormat(@Mock(stubOnly=true) ParameterService parameterSvcMock) throws Exception {
        Date formattedDate;
        String invoiceDate = "07/23/2008";
        try (MockedStatic configContextMockedStatic = Mockito.mockStatic(ConfigContext.class);
             MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            Properties props = new Properties();
            props.put("STRING_TO_DATE_FORMATS", "MM/dd/yyyy hh:mm a;MM/dd/yy;MM/dd/yyyy;MM-dd-yy;MM-dd-yyyy;MMddyy;MMMM dd;yyyy;MM/dd/yy HH:mm:ss;MM/dd/yyyy HH:mm:ss;MM-dd-yy HH:mm:ss;MMddyy HH:mm:ss;MMMM dd HH:mm:ss;yyyy HH:mm:ss");
            Config config = new Config(props);
            configContextMockedStatic.when(ConfigContext::getCurrentContextConfig).thenReturn((Object)config);
            this.dateTimeService.afterPropertiesSet();
            springContextMockedStatic.when(() -> SpringContext.getBean(DateTimeService.class)).thenReturn((Object)this.dateTimeService);
            springContextMockedStatic.when(() -> SpringContext.getBean(ParameterService.class)).thenReturn((Object)parameterSvcMock);
            formattedDate = ElectronicInvoiceUtils.getDate((String)"07/23/2008");
        }
        Assertions.assertEquals((Object)"2008-07-23", (Object)Objects.requireNonNull(formattedDate).toString());
    }

    @Test
    void getDate_invalidFormat(@Mock ParameterService parameterSvcMock) {
        Date formattedDate;
        String invoiceDate = "2008|07|23";
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(ParameterService.class)).thenReturn((Object)parameterSvcMock);
            formattedDate = ElectronicInvoiceUtils.getDate((String)"2008|07|23");
        }
        Assertions.assertNull((Object)formattedDate);
    }

    @Test
    void getDate_invalidFormat_null() {
        String invoiceDate = null;
        Date formattedDate = ElectronicInvoiceUtils.getDate(invoiceDate);
        Assertions.assertNull((Object)formattedDate);
    }

    @Test
    void stripSplChars() {
        String rawInvoiceId = "A1!B2#C3$D4%";
        String stripped = ElectronicInvoiceUtils.stripSplChars((String)"A1!B2#C3$D4%");
        Assertions.assertEquals((Object)"A1B2C3D4", (Object)stripped);
    }

    @Test
    void getDateDisplayText() {
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(DateTimeService.class)).thenReturn((Object)this.dateTimeService);
            java.util.Date testDate = this.dateTimeService.getUtilDate(LocalDate.of(2012, 10, 7));
            String displayText = ElectronicInvoiceUtils.getDateDisplayText((java.util.Date)testDate);
            Assertions.assertEquals((Object)"10/07/2012", (Object)displayText);
        }
    }
}

