/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.util;

import java.math.BigDecimal;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.exception.ItemParserException;
import org.kuali.kfs.module.purap.util.ItemParser;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.springframework.util.AutoPopulatingList;

@ConfigureContext(session=UserNameFixture.parke)
public class ItemParserIntegTest
extends KualiIntegTestBase {
    PurchasingDocument purDoc;
    ItemParser parser;
    Class<? extends PurApItem> itemClass;
    String documentNumber;

    protected void setUp() throws Exception {
        super.setUp();
        this.purDoc = (RequisitionDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getNewDocument(RequisitionDocument.class);
        this.parser = this.purDoc.getItemParser();
        this.itemClass = this.purDoc.getItemClass();
        this.documentNumber = this.purDoc.getDocumentNumber();
    }

    private static void assertWrongPropertyNumber(ItemParserException e, int propertyNumber) {
        ItemParserIntegTest.assertEquals((String)e.getErrorKey(), (String)"error.itemParser.wrongPropertyNumber");
        ItemParserIntegTest.assertEquals((String)e.getErrorParameters()[1], (String)("" + propertyNumber));
    }

    private static void assertInvalidNumericValue(ItemParserException e, String propertyName, String propertyValue) {
        ItemParserIntegTest.assertEquals((String)e.getErrorKey(), (String)"error.itemParser.itemProperty");
        String errorPath = "document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*";
        String errorKey = "error.itemParser.invalidNumericValue";
        ItemParserIntegTest.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.itemParser.invalidNumericValue"));
        AutoPopulatingList params = GlobalVariables.getMessageMap().getMessages("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*");
        for (ErrorMessage param : params) {
            ErrorMessage errmsg = param;
            if (!errmsg.getErrorKey().equals("error.itemParser.invalidNumericValue")) continue;
            ItemParserIntegTest.assertEquals((String)errmsg.getMessageParameters()[0], (String)propertyValue);
            ItemParserIntegTest.assertEquals((String)errmsg.getMessageParameters()[1], (String)propertyName);
        }
    }

    public void testParseQuantityReqItem() {
        String itemLine = "3,BX,123,,paper,6";
        try {
            PurApItem item = this.parser.parseItem("3,BX,123,,paper,6", this.itemClass, this.documentNumber);
            ItemParserIntegTest.assertEquals((int)item.getItemQuantity().compareTo((AbstractKualiDecimal)new KualiDecimal(3)), (int)0);
            ItemParserIntegTest.assertEquals((String)item.getItemUnitOfMeasureCode(), (String)"BX");
            ItemParserIntegTest.assertEquals((String)item.getItemCatalogNumber(), (String)"123");
            ItemParserIntegTest.assertEquals((String)item.getItemDescription(), (String)"paper");
            ItemParserIntegTest.assertEquals((int)item.getItemUnitPrice().compareTo(new BigDecimal(6)), (int)0);
            ItemParserIntegTest.assertEquals((String)item.getItemTypeCode(), (String)"ITEM");
            ItemParserIntegTest.assertTrue((boolean)(item instanceof RequisitionItem));
            ItemParserIntegTest.assertFalse((boolean)((RequisitionItem)item).isItemRestrictedIndicator());
        }
        catch (ItemParserException e) {
            ItemParserIntegTest.fail((String)"Caught ItemParserException with valid quantity-driven requisition item.");
        }
    }

    public void testParseNonQuantityPOItem() throws Exception {
        this.purDoc = (PurchaseOrderDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getNewDocument(PurchaseOrderDocument.class);
        this.parser = this.purDoc.getItemParser();
        this.itemClass = this.purDoc.getItemClass();
        this.documentNumber = this.purDoc.getDocumentNumber();
        String itemLine = ",,100,,cleaning service,50";
        try {
            PurApItem item = this.parser.parseItem(",,100,,cleaning service,50", this.itemClass, this.documentNumber);
            ItemParserIntegTest.assertEquals((Object)item.getItemQuantity(), null);
            ItemParserIntegTest.assertEquals((String)item.getItemUnitOfMeasureCode(), null);
            ItemParserIntegTest.assertEquals((String)item.getItemCatalogNumber(), (String)"100");
            ItemParserIntegTest.assertEquals((String)item.getItemDescription(), (String)"cleaning service");
            ItemParserIntegTest.assertEquals((int)item.getItemUnitPrice().compareTo(new BigDecimal(50)), (int)0);
            ItemParserIntegTest.assertEquals((String)item.getItemTypeCode(), (String)"SRVC");
            ItemParserIntegTest.assertTrue((boolean)(item instanceof PurchaseOrderItem));
            ItemParserIntegTest.assertEquals((String)((PurchaseOrderItem)item).getDocumentNumber(), (String)this.documentNumber);
        }
        catch (ItemParserException e) {
            ItemParserIntegTest.fail((String)"Caught ItemParserException with valid nonquantity-driven purchase order item.");
        }
    }

    public void testParseWrongPropertyNumberItem() {
        PurApItem item;
        String itemLine;
        try {
            itemLine = "2.5,BX,123,,paper,5.99,blahblah";
            item = this.parser.parseItem("2.5,BX,123,,paper,5.99,blahblah", this.itemClass, this.documentNumber);
            ItemParserIntegTest.fail((String)"Fail to throw ItemParserException with extra item property fields.");
        }
        catch (ItemParserException e) {
            ItemParserIntegTest.assertWrongPropertyNumber(e, 7);
        }
        try {
            itemLine = "BX,123,paper,,5.99";
            item = this.parser.parseItem("BX,123,paper,,5.99", this.itemClass, this.documentNumber);
            ItemParserIntegTest.fail((String)"Fail to throw ItemParserException with missing item property fields.");
        }
        catch (ItemParserException e) {
            ItemParserIntegTest.assertWrongPropertyNumber(e, 5);
        }
    }

    public void testParseInvalidNumericItem() {
        String itemLine = "2.5,BX,123,,paper,blahblah";
        try {
            PurApItem item = this.parser.parseItem("2.5,BX,123,,paper,blahblah", this.itemClass, this.documentNumber);
            ItemParserIntegTest.fail((String)"Fail to throw ItemParserException with invalid numeric values for item property fields.");
        }
        catch (ItemParserException e) {
            ItemParserIntegTest.assertInvalidNumericValue(e, this.parser.getItemFormat()[5], "blahblah");
        }
    }
}

