/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.util.cxml;

import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.util.cxml.B2BPunchOutOrderFileType;
import org.kuali.kfs.module.purap.util.cxml.B2BShoppingCart;
import org.kuali.kfs.module.purap.util.cxml.B2BShoppingCartTestHelper;
import org.kuali.kfs.module.purap.util.cxml.Classification;
import org.kuali.kfs.module.purap.util.cxml.CxmlExtrinsic;
import org.kuali.kfs.module.purap.util.cxml.CxmlHeader;
import org.kuali.kfs.module.purap.util.cxml.ItemDetail;
import org.kuali.kfs.module.purap.util.cxml.ItemIn;
import org.kuali.kfs.module.purap.util.cxml.PunchOutOrderMessage;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.core.io.ClassPathResource;

@ExtendWith(value={MockitoExtension.class})
class B2BPunchOutOrderFileTypeTest {
    private B2BPunchOutOrderFileType cut;

    B2BPunchOutOrderFileTypeTest() {
    }

    @BeforeEach
    void setUp() {
        GlobalVariables.clear();
        this.cut = new B2BPunchOutOrderFileType();
        this.cut.setSchemaLocation("classpath:org/kuali/kfs/module/purap/util/cxml/b2bPunchOutOrder.xsd");
        this.cut.setOutputClass(B2BShoppingCart.class);
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.clear();
    }

    @Test
    void parse_ShouldUnmarshallToIdenticalB2bShoppingCart() throws Exception {
        try (MockedStatic globalResourceLoaderMockedStatic = Mockito.mockStatic(GlobalResourceLoader.class);
             InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/purap/fixture/b2bShoppingCartSample.xml");){
            ClassPathResource resource = new ClassPathResource("classpath:org/kuali/kfs/module/purap/util/cxml/b2bPunchOutOrder.xsd".substring("classpath:".length()), this.getClass().getClassLoader());
            globalResourceLoaderMockedStatic.when(() -> GlobalResourceLoader.getResource((String)"classpath:org/kuali/kfs/module/purap/util/cxml/b2bPunchOutOrder.xsd")).thenReturn((Object)resource);
            byte[] xmlBytes = Objects.requireNonNull(inputStream).readAllBytes();
            B2BShoppingCart expectedShoppingCart = B2BShoppingCartTestHelper.getExpectedShoppingCart();
            B2BShoppingCart shoppingCart = (B2BShoppingCart)this.cut.parse(xmlBytes);
            Assertions.assertNotNull((Object)shoppingCart);
            CxmlHeader expectedHeader = expectedShoppingCart.getCxmlHeader();
            CxmlHeader actualHeader = shoppingCart.getCxmlHeader();
            Assertions.assertEquals((Object)expectedHeader.getFromDomain(), (Object)actualHeader.getFromDomain());
            Assertions.assertEquals((Object)expectedHeader.getToDomain(), (Object)actualHeader.getToDomain());
            Assertions.assertEquals((Object)expectedHeader.getSenderDomain(), (Object)actualHeader.getSenderDomain());
            Assertions.assertEquals((Object)expectedHeader.getFromIdentity(), (Object)actualHeader.getFromIdentity());
            Assertions.assertEquals((Object)expectedHeader.getToIdentity(), (Object)actualHeader.getToIdentity());
            Assertions.assertEquals((Object)expectedHeader.getSenderIdentity(), (Object)actualHeader.getSenderIdentity());
            Assertions.assertEquals((Object)expectedHeader.getSenderUserAgent(), (Object)actualHeader.getSenderUserAgent());
            Assertions.assertEquals((Object)expectedShoppingCart.getMessageStatusCode(), (Object)shoppingCart.getMessageStatusCode());
            Assertions.assertEquals((Object)expectedShoppingCart.getMessageStatusText(), (Object)shoppingCart.getMessageStatusText());
            Assertions.assertEquals((Object)expectedShoppingCart.getBuyerCookieText(), (Object)shoppingCart.getBuyerCookieText());
            Assertions.assertEquals((Object)expectedShoppingCart.getTotal(), (Object)shoppingCart.getTotal());
            PunchOutOrderMessage expectedPunchOutOrder = expectedShoppingCart.getMessage().getPunchOutOrderMessage();
            PunchOutOrderMessage punchOutOrderMessage = shoppingCart.getMessage().getPunchOutOrderMessage();
            Assertions.assertEquals((int)1, (int)punchOutOrderMessage.getItemInList().size());
            ItemIn expectedItemIn = (ItemIn)expectedPunchOutOrder.getItemInList().get(0);
            ItemIn itemIn = (ItemIn)punchOutOrderMessage.getItemInList().get(0);
            Assertions.assertEquals((Long)expectedItemIn.getQuantity(), (Long)itemIn.getQuantity());
            Assertions.assertEquals((Object)expectedItemIn.getItemID().getSupplierPartAuxiliaryID(), (Object)itemIn.getItemID().getSupplierPartAuxiliaryID());
            Assertions.assertEquals((Object)expectedItemIn.getItemID().getSupplierPartID(), (Object)itemIn.getItemID().getSupplierPartID());
            ItemDetail expectedItemDetail = expectedItemIn.getItemDetail();
            ItemDetail itemDetail = itemIn.getItemDetail();
            Assertions.assertEquals((Object)expectedItemDetail.getUnitPrice().getMoney().getCurrency(), (Object)itemDetail.getUnitPrice().getMoney().getCurrency());
            Assertions.assertEquals((Object)expectedItemDetail.getUnitPrice().getMoney().getValue(), (Object)itemDetail.getUnitPrice().getMoney().getValue());
            Assertions.assertEquals((Object)expectedItemDetail.getDescription().getLang(), (Object)itemDetail.getDescription().getLang());
            Assertions.assertEquals((Object)expectedItemDetail.getDescription().getValue(), (Object)itemDetail.getDescription().getValue());
            Assertions.assertEquals((Object)expectedItemDetail.getUnitOfMeasure(), (Object)itemDetail.getUnitOfMeasure());
            List expectedClassifications = expectedItemDetail.getClassificationList();
            List classifications = itemDetail.getClassificationList();
            Assertions.assertEquals((int)expectedClassifications.size(), (int)classifications.size());
            for (int i = 0; i < classifications.size(); ++i) {
                Assertions.assertEquals((Object)((Classification)expectedClassifications.get(i)).getDomain(), (Object)((Classification)classifications.get(i)).getDomain());
                Assertions.assertEquals((Object)((Classification)expectedClassifications.get(i)).getValue(), (Object)((Classification)classifications.get(i)).getValue());
            }
            List expectedExtrinsics = expectedItemDetail.getExtrinsicList();
            List extrinsics = itemDetail.getExtrinsicList();
            Assertions.assertEquals((int)expectedExtrinsics.size(), (int)extrinsics.size());
            for (int i = 0; i < extrinsics.size(); ++i) {
                Assertions.assertEquals((Object)((CxmlExtrinsic)expectedExtrinsics.get(i)).getName(), (Object)((CxmlExtrinsic)extrinsics.get(i)).getName());
                Assertions.assertEquals((Object)((CxmlExtrinsic)expectedExtrinsics.get(i)).getValue(), (Object)((CxmlExtrinsic)extrinsics.get(i)).getValue());
            }
        }
    }
}

