/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.kew.api.KewApiServiceLocator;
import org.kuali.kfs.kew.doctype.bo.DocumentType;
import org.kuali.kfs.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.kfs.kew.service.KEWServiceLocator;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.datadictionary.exception.UnknownDocumentTypeException;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.context.SpringContext;

public abstract class AbstractRelatedView
extends PersistableBusinessObjectBase {
    private static final Logger LOG = LogManager.getLogger();
    private Integer accountsPayablePurchasingDocumentLinkIdentifier;
    private Integer purapDocumentIdentifier;
    private String documentNumber;
    private String poNumberMasked;
    private DateTime createDate;
    protected DocumentHeader documentHeader;

    public Integer getAccountsPayablePurchasingDocumentLinkIdentifier() {
        return this.accountsPayablePurchasingDocumentLinkIdentifier;
    }

    public void setAccountsPayablePurchasingDocumentLinkIdentifier(Integer accountsPayablePurchasingDocumentLinkIdentifier) {
        this.accountsPayablePurchasingDocumentLinkIdentifier = accountsPayablePurchasingDocumentLinkIdentifier;
    }

    public Integer getPurapDocumentIdentifier() {
        return this.purapDocumentIdentifier;
    }

    public void setPurapDocumentIdentifier(Integer purapDocumentIdentifier) {
        this.purapDocumentIdentifier = purapDocumentIdentifier;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public List<Note> getNotes() {
        ArrayList<Note> notes = new ArrayList<Note>();
        NoteService noteService = (NoteService)SpringContext.getBean(NoteService.class);
        List tmpNotes = noteService.getByRemoteObjectId(this.findDocument(this.documentNumber).getDocumentHeader().getObjectId());
        notes.clear();
        for (int i = tmpNotes.size() - 1; i >= 0; --i) {
            Note note = (Note)tmpNotes.get(i);
            notes.add(note);
        }
        return notes;
    }

    public String getUrl() {
        String documentTypeName = this.getDocumentTypeName();
        DocumentType docType = KEWServiceLocator.getDocumentTypeService().getDocumentTypeByName(documentTypeName);
        String docHandlerUrl = docType.getResolvedDocumentHandlerUrl();
        int endSubString = docHandlerUrl.lastIndexOf("/");
        String serverName = docHandlerUrl.substring(0, endSubString);
        String handler = docHandlerUrl.substring(endSubString + 1, docHandlerUrl.lastIndexOf("?"));
        return serverName + "/" + handler + "?channelTitle=" + docType.getName() + "&methodToCall=docHandler&docId=" + this.getDocumentNumber() + "&command=displayDocSearchView";
    }

    public String getDocumentIdentifierString() {
        if (this.purapDocumentIdentifier != null) {
            return this.purapDocumentIdentifier.toString();
        }
        return this.documentNumber;
    }

    public String getDocumentLabel() {
        return ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDocumentLabelByTypeName(this.getDocumentTypeName());
    }

    public abstract String getDocumentTypeName();

    public String getPoNumberMasked() {
        return this.poNumberMasked;
    }

    public void setPoNumberMasked(String poNumberMasked) {
        this.poNumberMasked = poNumberMasked;
    }

    public String getApplicationDocumentStatus() {
        return this.documentHeader.getApplicationDocumentStatus();
    }

    public DocumentRouteHeaderValue findWorkflowDocument(String documentId) {
        return KewApiServiceLocator.getWorkflowDocumentService().getDocument(documentId);
    }

    protected Document findDocument(String documentHeaderId) {
        Document document = null;
        try {
            document = ((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(documentHeaderId);
        }
        catch (UnknownDocumentTypeException ex) {
            LOG.error("Exception encountered on finding the document: {}", (Object)documentHeaderId, (Object)ex);
        }
        return document;
    }

    public DateTime getCreateDate() {
        DocumentRouteHeaderValue document = this.findWorkflowDocument(this.getDocumentNumber());
        return document.getDateCreated();
    }
}

