/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject;

import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.integration.cam.CapitalAssetManagementAssetTransactionType;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.bo.ExternalizableBusinessObject;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.AccountsPayableItem;
import org.kuali.kfs.module.purap.businessobject.PurApItemBase;
import org.kuali.kfs.module.purap.businessobject.PurApSummaryItem;
import org.kuali.kfs.module.purap.util.PurApItemUtils;
import org.kuali.kfs.sys.context.SpringContext;

public abstract class AccountsPayableItemBase
extends PurApItemBase
implements AccountsPayableItem {
    private KualiDecimal extendedPrice;
    private String capitalAssetTransactionTypeCode;
    private CapitalAssetManagementAssetTransactionType capitalAssetTransactionType;

    @Override
    public boolean isConsideredEntered() {
        return this.isConsideredEnteredWithZero();
    }

    private boolean isConsideredEntered(boolean allowsZero) {
        if (this.getItemType().isLineItemIndicator()) {
            if (this.getItemType().isQuantityBasedGeneralLedgerIndicator()) {
                return ObjectUtils.isNotNull((Object)this.getItemQuantity()) || ObjectUtils.isNotNull((Object)this.getExtendedPrice()) && (!allowsZero || !this.getExtendedPrice().isZero());
            }
            return ObjectUtils.isNotNull((Object)this.getExtendedPrice()) && (!allowsZero || !this.getExtendedPrice().isZero());
        }
        return ObjectUtils.isNotNull((Object)this.getItemUnitPrice()) && (!allowsZero || this.getItemUnitPrice().compareTo(new BigDecimal(0)) != 0) || StringUtils.isNotBlank((CharSequence)this.getItemDescription());
    }

    public boolean isEligibleDisplay() {
        return this.isConsideredEnteredWithZero();
    }

    public boolean isConsideredEnteredWithZero() {
        return this.isConsideredEntered(true);
    }

    public boolean isConsideredEnteredWithoutZero() {
        return this.isConsideredEntered(false);
    }

    public boolean isNonZeroAmount() {
        return PurApItemUtils.isNonZeroExtended(this);
    }

    @Override
    public KualiDecimal getExtendedPrice() {
        if (ObjectUtils.isNotNull((Object)this.getItemUnitPrice()) && ObjectUtils.isNotNull((Object)((Object)this.getItemType())) && this.getItemType().isAmountBasedGeneralLedgerIndicator()) {
            this.extendedPrice = ObjectUtils.isNotNull((Object)this.getItemUnitPrice()) ? new KualiDecimal(this.getItemUnitPrice().toString()) : null;
        } else if (ObjectUtils.isNull((Object)this.getItemUnitPrice()) && ObjectUtils.isNotNull((Object)((Object)this.getItemType())) && this.getItemType().isAmountBasedGeneralLedgerIndicator() && this.getItemType().isAdditionalChargeIndicator()) {
            this.extendedPrice = null;
        }
        return this.extendedPrice;
    }

    @Override
    public void setExtendedPrice(KualiDecimal extendedPrice) {
        this.extendedPrice = extendedPrice;
    }

    @Override
    public PurApSummaryItem getSummaryItem() {
        if (this.extendedPrice == null || this.extendedPrice.isZero()) {
            return null;
        }
        return super.getSummaryItem();
    }

    @Override
    public String getCapitalAssetTransactionTypeCode() {
        return this.capitalAssetTransactionTypeCode;
    }

    public void setCapitalAssetTransactionTypeCode(String capitalAssetTransactionTypeCode) {
        this.capitalAssetTransactionTypeCode = capitalAssetTransactionTypeCode;
    }

    @Override
    public CapitalAssetManagementAssetTransactionType getCapitalAssetTransactionType() {
        this.capitalAssetTransactionType = (CapitalAssetManagementAssetTransactionType)((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(CapitalAssetManagementAssetTransactionType.class).retrieveExternalizableBusinessObjectIfNecessary((BusinessObject)this, (ExternalizableBusinessObject)this.capitalAssetTransactionType, "capitalAssetTransactionType");
        return this.capitalAssetTransactionType;
    }

    @Override
    public void setItemDescription(String itemDescription) {
        if (itemDescription != null && itemDescription.length() > 100) {
            super.setItemDescription(itemDescription.substring(0, 100));
        } else {
            super.setItemDescription(itemDescription);
        }
    }
}

