/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.dataaccess.impl;

import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kew.api.document.DocumentStatus;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.PaymentRequestStatuses;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestView;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.dataaccess.PaymentRequestDao;
import org.kuali.kfs.module.purap.util.VendorGroupingHelper;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PaymentRequestDaoOjb
extends PlatformAwareDaoBaseOjb
implements PaymentRequestDao {
    private static final Logger LOG = LogManager.getLogger();
    private ParameterService parameterService;

    @Override
    public List<PaymentRequestDocument> getPaymentRequestsToExtract(boolean onlySpecialPayments, String campusCode, Date onOrBeforePaymentRequestPayDate) {
        LOG.debug("getPaymentRequestsToExtract() started");
        Criteria criteria = new Criteria();
        if (campusCode != null) {
            criteria.addEqualTo("processingCampusCode", (Object)campusCode);
        }
        criteria.addIsNull("extractedTimestamp");
        criteria.addEqualTo("holdIndicator", (Object)Boolean.FALSE);
        if (onlySpecialPayments) {
            Criteria a = new Criteria();
            Criteria c1 = new Criteria();
            c1.addNotNull("specialHandlingInstructionLine1Text");
            Criteria c2 = new Criteria();
            c2.addNotNull("specialHandlingInstructionLine2Text");
            Criteria c3 = new Criteria();
            c3.addNotNull("specialHandlingInstructionLine3Text");
            Criteria c4 = new Criteria();
            c4.addEqualTo("paymentAttachmentIndicator", (Object)Boolean.TRUE);
            c1.addOrCriteria(c2);
            c1.addOrCriteria(c3);
            c1.addOrCriteria(c4);
            a.addAndCriteria(c1);
            a.addLessOrEqualThan((Object)"paymentRequestPayDate", (Object)onOrBeforePaymentRequestPayDate);
            Criteria c5 = new Criteria();
            c5.addEqualTo("immediatePaymentIndicator", (Object)Boolean.TRUE);
            c5.addOrCriteria(a);
            criteria.addAndCriteria(a);
        } else {
            Criteria c1 = new Criteria();
            c1.addLessOrEqualThan((Object)"paymentRequestPayDate", (Object)onOrBeforePaymentRequestPayDate);
            Criteria c2 = new Criteria();
            c2.addEqualTo("immediatePaymentIndicator", (Object)Boolean.TRUE);
            c1.addOrCriteria(c2);
            criteria.addAndCriteria(c1);
        }
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(PaymentRequestDocument.class, criteria));
    }

    @Override
    @Deprecated
    public List<PaymentRequestDocument> getPaymentRequestsToExtract(String campusCode, Integer paymentRequestIdentifier, Integer purchaseOrderIdentifier, Integer vendorHeaderGeneratedIdentifier, Integer vendorDetailAssignedIdentifier, Date currentSqlDateMidnight) {
        LOG.debug("getPaymentRequestsToExtract() started");
        Criteria criteria = new Criteria();
        criteria.addEqualTo("processingCampusCode", (Object)campusCode);
        criteria.addIsNull("extractedTimestamp");
        criteria.addEqualTo("holdIndicator", (Object)Boolean.FALSE);
        Criteria c1 = new Criteria();
        c1.addLessOrEqualThan((Object)"paymentRequestPayDate", (Object)currentSqlDateMidnight);
        Criteria c2 = new Criteria();
        c2.addEqualTo("immediatePaymentIndicator", (Object)Boolean.TRUE);
        c1.addOrCriteria(c2);
        criteria.addAndCriteria(c1);
        if (paymentRequestIdentifier != null) {
            criteria.addEqualTo("purapDocumentIdentifier", (Object)paymentRequestIdentifier);
        }
        if (purchaseOrderIdentifier != null) {
            criteria.addEqualTo("purchaseOrderIdentifier", (Object)purchaseOrderIdentifier);
        }
        criteria.addEqualTo("vendorHeaderGeneratedIdentifier", (Object)vendorHeaderGeneratedIdentifier);
        criteria.addEqualTo("vendorDetailAssignedIdentifier", (Object)vendorDetailAssignedIdentifier);
        return (List)((Object)this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)new QueryByCriteria(PaymentRequestDocument.class, criteria)));
    }

    @Override
    public List<PaymentRequestDocument> getImmediatePaymentRequestsToExtract(String campusCode) {
        LOG.debug("getImmediatePaymentRequestsToExtract() started");
        Criteria criteria = new Criteria();
        if (campusCode != null) {
            criteria.addEqualTo("processingCampusCode", (Object)campusCode);
        }
        criteria.addIsNull("extractedTimestamp");
        criteria.addEqualTo("immediatePaymentIndicator", (Object)Boolean.TRUE);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(PaymentRequestDocument.class, criteria));
    }

    @Override
    public Collection<PaymentRequestDocument> getPaymentRequestsToExtractForVendor(String campusCode, VendorGroupingHelper vendor, Date onOrBeforePaymentRequestPayDate) {
        LOG.debug("getPaymentRequestsToExtract() started");
        Criteria criteria = new Criteria();
        criteria.addEqualTo("processingCampusCode", (Object)campusCode);
        criteria.addIsNull("extractedTimestamp");
        criteria.addEqualTo("holdIndicator", (Object)Boolean.FALSE);
        Criteria c1 = new Criteria();
        c1.addLessOrEqualThan((Object)"paymentRequestPayDate", (Object)onOrBeforePaymentRequestPayDate);
        Criteria c2 = new Criteria();
        c2.addEqualTo("immediatePaymentIndicator", (Object)Boolean.TRUE);
        c1.addOrCriteria(c2);
        criteria.addAndCriteria(c1);
        criteria.addEqualTo("vendorHeaderGeneratedIdentifier", (Object)vendor.getVendorHeaderGeneratedIdentifier());
        criteria.addEqualTo("vendorDetailAssignedIdentifier", (Object)vendor.getVendorDetailAssignedIdentifier());
        criteria.addEqualTo("vendorCountryCode", (Object)vendor.getVendorCountry());
        if (vendor.getVendorPostalCode() == null) {
            criteria.addIsNull("vendorPostalCode");
        } else {
            criteria.addLike((Object)"vendorPostalCode", (Object)(vendor.getVendorPostalCode() + "%"));
        }
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(PaymentRequestDocument.class, criteria));
    }

    @Override
    public List<String> getEligibleForAutoApproval(Date todayAtMidnight) {
        Criteria criteria = new Criteria();
        criteria.addLessOrEqualThan((Object)"paymentRequestPayDate", (Object)todayAtMidnight);
        criteria.addEqualTo("holdIndicator", (Object)"N");
        criteria.addEqualTo("paymentRequestedCancelIndicator", (Object)"N");
        criteria.addIn("documentHeader.applicationDocumentStatus", Arrays.asList(PaymentRequestStatuses.PREQ_STATUSES_FOR_AUTO_APPROVE));
        return this.getDocumentNumbersOfPaymentRequestByCriteria(criteria, false);
    }

    @Override
    public String getDocumentNumberByPaymentRequestId(Integer id) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("purapDocumentIdentifier", (Object)id);
        return this.getDocumentNumberOfPaymentRequestByCriteria(criteria);
    }

    @Override
    public List<String> getDocumentNumbersByPurchaseOrderId(Integer poPurApId) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("purchaseOrderIdentifier", (Object)poPurApId);
        return this.getDocumentNumbersOfPaymentRequestByCriteria(criteria, false);
    }

    protected String getDocumentNumberOfPaymentRequestByCriteria(Criteria criteria) {
        LOG.debug("getDocumentNumberOfPaymentRequestByCriteria() started");
        List<String> returnList = this.getDocumentNumbersOfPaymentRequestByCriteria(criteria, false);
        if (returnList.isEmpty()) {
            return null;
        }
        if (returnList.size() > 1) {
            String errorMsg = "Expected single document number for given criteria but multiple (at least 2) were returned";
            LOG.error("Expected single document number for given criteria but multiple (at least 2) were returned");
            throw new RuntimeException();
        }
        return returnList.get(0);
    }

    protected List<String> getDocumentNumbersOfPaymentRequestByCriteria(Criteria criteria, boolean orderByAscending) {
        LOG.debug("getDocumentNumberOfPaymentRequestByCriteria() started");
        ReportQueryByCriteria rqbc = new ReportQueryByCriteria(PaymentRequestDocument.class, criteria);
        if (orderByAscending) {
            rqbc.addOrderByAscending("documentNumber");
        } else {
            rqbc.addOrderByDescending("documentNumber");
        }
        ArrayList<String> returnList = new ArrayList<String>();
        List prDocs = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)rqbc);
        for (PaymentRequestDocument prDoc : prDocs) {
            returnList.add(prDoc.getDocumentNumber());
        }
        return returnList;
    }

    protected List<PaymentRequestDocument> getPaymentRequestsByQueryByCriteria(QueryByCriteria qbc) {
        LOG.debug("getPaymentRequestsByQueryByCriteria() started");
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)qbc);
    }

    @Override
    public List<PaymentRequestDocument> getActivePaymentRequestsByVendorNumberInvoiceNumber(Integer vendorHeaderGeneratedId, Integer vendorDetailAssignedId, String invoiceNumber) {
        LOG.debug("getActivePaymentRequestsByVendorNumberInvoiceNumber() started");
        Criteria criteria = new Criteria();
        criteria.addEqualTo("vendorHeaderGeneratedIdentifier", (Object)vendorHeaderGeneratedId);
        criteria.addEqualTo("vendorDetailAssignedIdentifier", (Object)vendorDetailAssignedId);
        criteria.addEqualTo("invoiceNumber", (Object)invoiceNumber);
        QueryByCriteria qbc = new QueryByCriteria(PaymentRequestDocument.class, criteria);
        return this.getPaymentRequestsByQueryByCriteria(qbc);
    }

    @Override
    public List<PaymentRequestView> getPossibleDuplicatePaymentRequestsByVendorNumber(Integer vendorHeaderGeneratedId, Integer vendorDetailAssignedId) {
        LOG.debug("getPossibleDuplicatePaymentRequestsByVendorNumber started");
        Criteria vendorCriteria = new Criteria();
        vendorCriteria.addEqualTo("vendorHeaderGeneratedIdentifier", (Object)vendorHeaderGeneratedId);
        vendorCriteria.addEqualTo("vendorDetailAssignedIdentifier", (Object)vendorDetailAssignedId);
        QueryByCriteria vendorQuery = new QueryByCriteria(VendorDetail.class, vendorCriteria);
        VendorDetail vendorDetail = (VendorDetail)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)vendorQuery);
        if (ObjectUtils.isNull((Object)vendorDetail)) {
            return List.of();
        }
        Criteria paymentRequestCriteria = new Criteria();
        paymentRequestCriteria.addEqualTo("UPPER(vendorName)", (Object)vendorDetail.getVendorName().toUpperCase(Locale.US));
        String duplicateInvoiceDaysString = this.parameterService.getParameterValueAsString("KFS-SYS", "Document", "DUPLICATE_INVOICE_DAYS");
        if (StringUtils.isNotBlank((CharSequence)duplicateInvoiceDaysString)) {
            try {
                long duplicateInvoiceDays = Long.parseLong(duplicateInvoiceDaysString);
                LocalDate date = LocalDate.now();
                LocalDate duplicateInvoiceStartDate = date.minusDays(duplicateInvoiceDays);
                paymentRequestCriteria.addGreaterOrEqualThan((Object)"invoiceDate", (Object)duplicateInvoiceStartDate);
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid non-numeric value for {} / {} / {} parameter: {}", (Object)"KFS-SYS", (Object)"Document", (Object)"DUPLICATE_INVOICE_DAYS", (Object)duplicateInvoiceDaysString);
            }
        }
        QueryByCriteria paymentRequestQuery = new QueryByCriteria(PaymentRequestView.class, paymentRequestCriteria);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)paymentRequestQuery);
    }

    @Override
    public List<PaymentRequestDocument> getActivePaymentRequestsByPOIdInvoiceAmountInvoiceDate(Integer poId, KualiDecimal vendorInvoiceAmount, Date invoiceDate) {
        LOG.debug("getActivePaymentRequestsByVendorNumberInvoiceNumber() started");
        Criteria criteria = new Criteria();
        criteria.addEqualTo("purchaseOrderIdentifier", (Object)poId);
        criteria.addEqualTo("vendorInvoiceAmount", (Object)vendorInvoiceAmount);
        criteria.addEqualTo("invoiceDate", (Object)invoiceDate);
        QueryByCriteria qbc = new QueryByCriteria(PaymentRequestDocument.class, criteria);
        return this.getPaymentRequestsByQueryByCriteria(qbc);
    }

    @Override
    public List<PaymentRequestDocument> getActivePaymentRequestsByInvoiceAmountInvoiceDate(Integer vendorHeaderGeneratedId, Integer vendorDetailAssignedId, KualiDecimal vendorInvoiceAmount, Date invoiceDate) {
        LOG.debug("getActivePaymentRequestsByVendorNumberInvoiceNumber() started");
        Criteria criteria = new Criteria();
        criteria.addEqualTo("vendorHeaderGeneratedIdentifier", (Object)vendorHeaderGeneratedId);
        criteria.addEqualTo("vendorDetailAssignedIdentifier", (Object)vendorDetailAssignedId);
        criteria.addEqualTo("vendorInvoiceAmount", (Object)vendorInvoiceAmount);
        criteria.addEqualTo("invoiceDate", (Object)invoiceDate);
        QueryByCriteria qbc = new QueryByCriteria(PaymentRequestDocument.class, criteria);
        return this.getPaymentRequestsByQueryByCriteria(qbc);
    }

    @Override
    public int getActivePaymentRequestCountForPurchaseOrder(Integer purchaseOrderId) {
        LOG.debug("getActivePaymentRequestsByVendorNumberInvoiceNumber() started");
        Criteria criteria = new Criteria();
        criteria.addEqualTo("purchaseOrderIdentifier", (Object)purchaseOrderId);
        criteria.addIn("documentHeader.applicationDocumentStatus", Arrays.asList(PaymentRequestStatuses.STATUSES_POTENTIALLY_ACTIVE));
        List<String> workflowNotActiveStatuses = Arrays.asList(DocumentStatus.CANCELED.getCode(), DocumentStatus.EXCEPTION.getCode());
        criteria.addNotIn("documentHeader.workflowDocumentStatusCode", workflowNotActiveStatuses);
        QueryByCriteria qbc = new QueryByCriteria(PaymentRequestDocument.class, criteria);
        return this.getPersistenceBrokerTemplate().getCount((Query)qbc);
    }

    @Override
    public List<PaymentRequestDocument> getPaymentRequestInReceivingStatus() {
        Criteria criteria = new Criteria();
        criteria.addNotEqualTo((Object)"holdIndicator", (Object)"Y");
        criteria.addNotEqualTo((Object)"paymentRequestedCancelIndicator", (Object)"Y");
        criteria.addEqualTo("documentHeader.applicationDocumentStatus", (Object)"Awaiting Receiving");
        QueryByCriteria qbc = new QueryByCriteria(PaymentRequestDocument.class, criteria);
        return this.getPaymentRequestsByQueryByCriteria(qbc);
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

