/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingProcessRequestorPhoneAndEmailAddressValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.service.PostalCodeValidationService;
import org.kuali.kfs.vnd.businessobject.CampusParameter;

public class PurchasingDeliveryValidation
extends PurchasingProcessRequestorPhoneAndEmailAddressValidation {
    protected BusinessObjectService businessObjectService;
    protected PostalCodeValidationService postalCodeValidationService;

    @Override
    public boolean validate(AttributedDocumentEvent event) {
        String emailAddress;
        boolean valid = true;
        PurchasingDocument purDocument = (PurchasingDocument)event.getDocument();
        GlobalVariables.getMessageMap().addToErrorPath("document.delivery*");
        String phoneNumber = purDocument.getDeliveryToPhoneNumber();
        if (StringUtils.isNotBlank((CharSequence)phoneNumber) && !this.validatePhoneNumber(phoneNumber)) {
            valid = false;
            GlobalVariables.getMessageMap().putError("deliveryToPhoneNumber", "errors.delivery.phoneNumber.invalid", new String[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)(emailAddress = purDocument.getRequestorPersonEmailAddress())) && !this.validateEmailAddress(emailAddress)) {
            valid = false;
            GlobalVariables.getMessageMap().putError("requestorPersonEmailAddress", "errors.invalid.requestorEmailAddress", new String[0]);
        }
        this.postalCodeValidationService.validateAddress(purDocument.getDeliveryCountryCode(), purDocument.getDeliveryStateCode(), purDocument.getDeliveryPostalCode(), "deliveryStateCode", "deliveryPostalCode");
        int match = this.businessObjectService.countMatching(CampusParameter.class, Collections.singletonMap("campusCode", purDocument.getDeliveryCampusCode()));
        if (match < 1) {
            valid = false;
            GlobalVariables.getMessageMap().putError("deliveryCampusCode", "error.delivery.campus.invalid", new String[0]);
        }
        GlobalVariables.getMessageMap().clearErrorPath();
        return valid;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setPostalCodeValidationService(PostalCodeValidationService postalCodeValidationService) {
        this.postalCodeValidationService = postalCodeValidationService;
    }
}

