/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.HashMap;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderSensitiveData;
import org.kuali.kfs.module.purap.businessobject.SensitiveData;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.vnd.businessobject.CommodityCode;

public class SensitiveDataRule
extends MaintenanceDocumentRuleBase {
    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.validateInactivationBlocking();
    }

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.validateInactivationBlocking();
    }

    protected boolean validateInactivationBlocking() {
        SensitiveData oldSensitiveData = (SensitiveData)((Object)this.getOldBo());
        SensitiveData newSensitiveData = (SensitiveData)((Object)this.getNewBo());
        if (oldSensitiveData.isActive() && !newSensitiveData.isActive() && this.hasABlockingRecord(newSensitiveData.getSensitiveDataCode())) {
            String documentLabel = "SensitiveData";
            this.putGlobalError("error.document.cannot.inactivate.used.by.active.records", "SensitiveData");
            return false;
        }
        return true;
    }

    protected boolean hasABlockingRecord(String sensitiveDataCode) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("sensitiveDataCode", sensitiveDataCode);
        boolean hasPurchaseOrderSensitiveDataBlockingRecord = ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).countMatching(PurchaseOrderSensitiveData.class, queryMap) > 0;
        queryMap.put("active", true);
        boolean hasCommodityCodeBlockingRecord = ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).countMatching(CommodityCode.class, queryMap) > 0;
        return hasPurchaseOrderSensitiveDataBlockingRecord || hasCommodityCodeBlockingRecord;
    }
}

