/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.mo.common.GloballyUnique;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.gl.service.impl.StringHelper;
import org.kuali.kfs.kim.api.identity.PersonService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.bo.Attachment;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.AttachmentService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.batch.ElectronicInvoiceInputFileType;
import org.kuali.kfs.module.purap.batch.ElectronicInvoiceStep;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoice;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceItem;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceLoad;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceLoadSummary;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceOrder;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceRejectReason;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceRejectReasonType;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItem;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.dataaccess.ElectronicInvoicingDao;
import org.kuali.kfs.module.purap.document.ElectronicInvoiceRejectDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.service.AccountsPayableService;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.service.RequisitionService;
import org.kuali.kfs.module.purap.document.validation.event.AttributedCalculateAccountsPayableEvent;
import org.kuali.kfs.module.purap.document.validation.event.AttributedPaymentRequestForEInvoiceEvent;
import org.kuali.kfs.module.purap.exception.CxmlParseException;
import org.kuali.kfs.module.purap.exception.PurError;
import org.kuali.kfs.module.purap.service.ElectronicInvoiceHelperService;
import org.kuali.kfs.module.purap.service.ElectronicInvoiceMatchingService;
import org.kuali.kfs.module.purap.service.impl.ElectronicInvoiceItemHolder;
import org.kuali.kfs.module.purap.service.impl.ElectronicInvoiceOrderHolder;
import org.kuali.kfs.module.purap.util.ElectronicInvoiceUtils;
import org.kuali.kfs.module.purap.util.ExpiredOrClosedAccountEntry;
import org.kuali.kfs.sys.batch.BatchInputFileType;
import org.kuali.kfs.sys.batch.InitiateDirectoryBase;
import org.kuali.kfs.sys.batch.service.BatchInputFileService;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.exception.ParseException;
import org.kuali.kfs.sys.mail.BodyMailMessage;
import org.kuali.kfs.sys.mail.MailMessage;
import org.kuali.kfs.sys.service.BankService;
import org.kuali.kfs.sys.service.EmailService;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Element;

public class ElectronicInvoiceHelperServiceImpl
extends InitiateDirectoryBase
implements ElectronicInvoiceHelperService {
    private static final Logger LOG = LogManager.getLogger();
    protected static final String UNKNOWN_DUNS_IDENTIFIER = "Unknown";
    protected static final String INVOICE_FILE_MIME_TYPE = "text/xml";
    private StringBuffer emailTextErrorList;
    protected ElectronicInvoiceInputFileType electronicInvoiceInputFileType;
    protected EmailService emailService;
    protected ElectronicInvoiceMatchingService matchingService;
    protected ElectronicInvoicingDao electronicInvoicingDao;
    protected BatchInputFileService batchInputFileService;
    protected VendorService vendorService;
    protected PurchaseOrderService purchaseOrderService;
    protected PaymentRequestService paymentRequestService;
    protected ConfigurationService kualiConfigurationService;
    protected DateTimeService dateTimeService;
    protected ParameterService parameterService;
    protected DocumentService documentService;
    protected AttachmentService attachmentService;
    protected NoteService noteService;
    protected BankService bankService;
    protected KualiRuleService kualiRuleService;
    private BusinessObjectService businessObjectService;
    private DataDictionaryService dataDictionaryService;
    private RequisitionService requisitionService;
    private AccountsPayableService accountsPayableService;
    protected PersonService personService;

    @Override
    public ElectronicInvoiceLoad loadElectronicInvoices() {
        LOG.debug("loadElectronicInvoices() started");
        this.prepareDirectories(this.getRequiredDirectoryNames());
        String rejectDirName = this.getRejectDirName();
        String acceptDirName = this.getAcceptDirName();
        this.emailTextErrorList = new StringBuffer();
        boolean moveFiles = this.parameterService.getParameterValueAsBoolean(ElectronicInvoiceStep.class, "FILE_MOVE_AFTER_LOAD_IND");
        int failedCnt = 0;
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> ((ElectronicInvoiceInputFileType)this.electronicInvoiceInputFileType).getDirectoryPath();
        LOG.info("Invoice Base Directory - {}", supplierArray);
        LOG.info("Invoice Accept Directory - {}", (Object)acceptDirName);
        LOG.info("Invoice Reject Directory - {}", (Object)rejectDirName);
        LOG.info("Is moving files allowed - {}", (Object)moveFiles);
        if (StringUtils.isBlank((CharSequence)rejectDirName)) {
            throw new RuntimeException("Reject directory name should not be empty");
        }
        if (StringUtils.isBlank((CharSequence)acceptDirName)) {
            throw new RuntimeException("Accept directory name should not be empty");
        }
        File[] filesToBeProcessed = this.getFilesToBeProcessed();
        ElectronicInvoiceLoad eInvoiceLoad = new ElectronicInvoiceLoad();
        if (filesToBeProcessed == null || filesToBeProcessed.length == 0) {
            StringBuffer mailText = new StringBuffer();
            mailText.append("\n\n");
            mailText.append(PurapConstants.ElectronicInvoice.NO_FILES_PROCESSED_EMAIL_MESSAGE);
            mailText.append("\n\n");
            this.sendSummary(mailText);
            return eInvoiceLoad;
        }
        try {
            FileUtils.forceMkdir((File)new File(acceptDirName));
            FileUtils.forceMkdir((File)new File(rejectDirName));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LOG.info("{} file(s) available for processing", (Object)filesToBeProcessed.length);
        StringBuilder emailMsg = new StringBuilder();
        for (File xmlFile : filesToBeProcessed) {
            Supplier[] supplierArray2 = new Supplier[1];
            supplierArray2[0] = xmlFile::getName;
            LOG.info("Processing {}....", supplierArray2);
            byte[] modifiedXML = null;
            if (xmlFile.length() != 0L) {
                modifiedXML = this.addNamespaceDefinition(eInvoiceLoad, xmlFile);
            }
            boolean isRejected = false;
            if (modifiedXML == null) {
                isRejected = true;
            } else {
                try {
                    isRejected = this.processElectronicInvoice(eInvoiceLoad, xmlFile, modifiedXML);
                }
                catch (Exception e) {
                    String msg = xmlFile.getName() + "\n";
                    LOG.error(msg, (Throwable)e);
                    StackTraceElement[] elements = e.getStackTrace();
                    StringBuffer trace = new StringBuffer();
                    trace.append(e.getClass().getName());
                    if (e.getMessage() != null) {
                        trace.append(": ");
                        trace.append(e.getMessage());
                    }
                    trace.append("\n");
                    for (StackTraceElement element : elements) {
                        trace.append("    at ");
                        trace.append(ElectronicInvoiceHelperServiceImpl.describeStackTraceElement(element));
                        trace.append("\n");
                    }
                    LOG.error((CharSequence)trace);
                    emailMsg.append(msg);
                    msg = msg + "\n--------------------------------------------------------------------------------------\n" + trace;
                    this.logProcessElectronicInvoiceError(msg);
                    ++failedCnt;
                    GlobalVariables.getMessageMap().clearErrorMessages();
                    continue;
                }
            }
            if (isRejected) {
                Supplier[] supplierArray3 = new Supplier[1];
                supplierArray3[0] = xmlFile::getName;
                LOG.info("{} has been rejected", supplierArray3);
                if (moveFiles) {
                    Supplier[] supplierArray4 = new Supplier[2];
                    supplierArray4[0] = xmlFile::getName;
                    supplierArray4[1] = () -> rejectDirName;
                    LOG.info("{} has been marked to move to {}", supplierArray4);
                    eInvoiceLoad.addRejectFileToMove(xmlFile, rejectDirName);
                }
            } else {
                Supplier[] supplierArray5 = new Supplier[1];
                supplierArray5[0] = xmlFile::getName;
                LOG.info("{} has been accepted", supplierArray5);
                if (moveFiles && !this.moveFile(xmlFile, acceptDirName)) {
                    String msg = xmlFile.getName() + " unable to move";
                    LOG.error(msg);
                    throw new PurError(msg);
                }
            }
            if (!moveFiles) {
                String fullPath = FilenameUtils.getFullPath((String)xmlFile.getAbsolutePath());
                String fileName = FilenameUtils.getBaseName((String)xmlFile.getAbsolutePath());
                File processedFile = new File(fullPath + File.separator + fileName + ".processed");
                try {
                    FileUtils.touch((File)processedFile);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.deleteDoneFile(xmlFile);
        }
        this.emailTextErrorList.append("\nFAILED FILES\n");
        this.emailTextErrorList.append("-----------------------------------------------------------\n\n");
        this.emailTextErrorList.append((CharSequence)emailMsg);
        this.emailTextErrorList.append("\nTOTAL COUNT\n");
        this.emailTextErrorList.append("===========================\n");
        this.emailTextErrorList.append("      ").append(failedCnt).append(" FAILED\n");
        this.emailTextErrorList.append("===========================\n");
        StringBuffer summaryText = this.saveLoadSummary(eInvoiceLoad);
        StringBuffer finalText = new StringBuffer();
        finalText.append(summaryText);
        finalText.append("\n");
        finalText.append(this.emailTextErrorList);
        this.sendSummary(finalText);
        LOG.info("Processing completed");
        return eInvoiceLoad;
    }

    protected File[] getFilesToBeProcessed() {
        String baseDirName = this.getBaseDirName();
        File baseDir = new File(baseDirName);
        if (!baseDir.exists()) {
            throw new RuntimeException("Base dir [" + baseDirName + "] doesn't exists in the system");
        }
        File[] filesToBeProcessed = baseDir.listFiles(file -> {
            String fullPath = FilenameUtils.getFullPath((String)file.getAbsolutePath());
            String fileName = FilenameUtils.getBaseName((String)file.getAbsolutePath());
            File processedFile = new File(fullPath + File.separator + fileName + ".processed");
            return !file.isDirectory() && file.getName().endsWith(this.electronicInvoiceInputFileType.getFileExtension()) && !processedFile.exists();
        });
        return filesToBeProcessed;
    }

    private void logProcessElectronicInvoiceError(String msg) {
        File file = new File(this.electronicInvoiceInputFileType.getReportPath() + "/" + this.electronicInvoiceInputFileType.getReportPrefix() + "_" + this.dateTimeService.toDateTimeStringForFilename(this.dateTimeService.getCurrentDate()) + "." + this.electronicInvoiceInputFileType.getReportExtension());
        try (BufferedWriter writer = new BufferedWriter(new PrintWriter(file, StandardCharsets.UTF_8));){
            writer.write(msg);
            writer.newLine();
        }
        catch (FileNotFoundException e) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> file;
            supplierArray[1] = e::getMessage;
            LOG.error("{} not found  {}", supplierArray);
            throw new RuntimeException(file + " not found " + e.getMessage(), e);
        }
        catch (IOException e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = e::getMessage;
            LOG.error("Error writing to BufferedWriter {}", supplierArray);
            throw new RuntimeException("Error writing to BufferedWriter " + e.getMessage(), e);
        }
    }

    private static String describeStackTraceElement(StackTraceElement element) {
        StringBuffer description = new StringBuffer();
        if (element == null) {
            description.append("invalid (null) element");
        }
        description.append(element.getClassName());
        description.append(".");
        description.append(element.getMethodName());
        description.append("(");
        description.append(element.getFileName());
        description.append(":");
        description.append(element.getLineNumber());
        description.append(")");
        return description.toString();
    }

    protected byte[] addNamespaceDefinition(ElectronicInvoiceLoad eInvoiceLoad, File invoiceFile) {
        Element node;
        org.w3c.dom.Document xmlDoc;
        DocumentBuilder builder;
        LOG.debug("addNamespaceDefinition() started");
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setValidating(false);
        builderFactory.setIgnoringElementContentWhitespace(true);
        try {
            builder = builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = e::getMessage;
            LOG.error("addNamespaceDefinition() Error getting document builder - {}", supplierArray);
            throw new RuntimeException(e);
        }
        try {
            LOG.info("addNamespaceDefinition: builder.parse");
            xmlDoc = builder.parse(invoiceFile);
        }
        catch (Exception e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = e::getMessage;
            LOG.info("addNamespaceDefinition: Error parsing the file - {}", supplierArray);
            this.rejectElectronicInvoiceFile(eInvoiceLoad, UNKNOWN_DUNS_IDENTIFIER, invoiceFile, e.getMessage(), "INFF");
            return null;
        }
        LOG.info("addNamespaceDefinition: xmlDoc.getDocumentElement()");
        Element element = node = xmlDoc.getDocumentElement();
        String xmlnsValue = element.getAttribute("xmlns");
        String xmlnsXsiValue = element.getAttribute("xmlns:xsi");
        LOG.info("addNamespaceDefinition: getInvoiceFile");
        if (StringUtils.equals((CharSequence)xmlnsValue, (CharSequence)"http://www.kuali.org/kfs/purap/electronicInvoice") && StringUtils.equals((CharSequence)xmlnsXsiValue, (CharSequence)"http://www.w3.org/2001/XMLSchema-instance")) {
            LOG.info("addNamespaceDefinition: xmlns and xmlns:xsi attributes already exists in the invoice xml");
        } else {
            element.setAttribute("xmlns", "http://www.kuali.org/kfs/purap/electronicInvoice");
            element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(xmlDoc);
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            LOG.fatal("Failed to transform {} xml.{}", (Object)invoiceFile.getName(), (Object)e);
            throw new RuntimeException(e);
        }
        LOG.info("addNamespaceDefinition() Namespace validation completed");
        return out.toByteArray();
    }

    @Transactional
    protected boolean processElectronicInvoice(ElectronicInvoiceLoad eInvoiceLoad, File invoiceFile, byte[] xmlAsBytes) {
        ElectronicInvoice eInvoice;
        try {
            eInvoice = this.loadElectronicInvoice(xmlAsBytes);
        }
        catch (CxmlParseException e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = e::getMessage;
            LOG.info("Error loading file - {}", supplierArray);
            this.rejectElectronicInvoiceFile(eInvoiceLoad, UNKNOWN_DUNS_IDENTIFIER, invoiceFile, e.getMessage(), "INFF");
            return true;
        }
        eInvoice.setFileName(invoiceFile.getName());
        boolean isCompleteFailure = this.checkForCompleteFailure(eInvoiceLoad, eInvoice, invoiceFile);
        if (isCompleteFailure) {
            return true;
        }
        this.setVendorDUNSNumber(eInvoice);
        this.setVendorDetails(eInvoice);
        Map itemTypeMappings = this.getItemTypeMappings(eInvoice.getVendorHeaderID(), eInvoice.getVendorDetailID());
        Map<String, ItemType> kualiItemTypes = this.getKualiItemTypes();
        if (itemTypeMappings != null && !itemTypeMappings.isEmpty()) {
            LOG.info("Item mappings found");
        }
        boolean validateHeader = true;
        for (ElectronicInvoiceOrder order : eInvoice.getInvoiceDetailOrders()) {
            ElectronicInvoiceLoadSummary loadSummary;
            String poID = order.getOrderReferenceOrderID();
            PurchaseOrderDocument po = null;
            if (NumberUtils.isDigits((String)StringUtils.defaultString((String)poID)) && (po = this.purchaseOrderService.getCurrentPurchaseOrder(Integer.valueOf(poID))) != null) {
                order.setInvoicePurchaseOrderID(poID);
                order.setPurchaseOrderID(po.getPurapDocumentIdentifier());
                order.setPurchaseOrderCampusCode(po.getDeliveryCampusCode());
                LOG.info("PO matching Document found");
            }
            ElectronicInvoiceOrderHolder orderHolder = new ElectronicInvoiceOrderHolder(eInvoice, order, po, itemTypeMappings, kualiItemTypes, validateHeader);
            this.matchingService.doMatchingProcess(orderHolder);
            if (orderHolder.isInvoiceRejected()) {
                ElectronicInvoiceRejectDocument rejectDocument = this.createRejectDocument(eInvoice, order, eInvoiceLoad);
                if (orderHolder.getAccountsPayablePurchasingDocumentLinkIdentifier() != null) {
                    rejectDocument.setAccountsPayablePurchasingDocumentLinkIdentifier(orderHolder.getAccountsPayablePurchasingDocumentLinkIdentifier());
                }
                String dunsNumber = StringUtils.isEmpty((CharSequence)eInvoice.getDunsNumber()) ? UNKNOWN_DUNS_IDENTIFIER : eInvoice.getDunsNumber();
                loadSummary = this.getOrCreateLoadSummary(eInvoiceLoad, dunsNumber);
                loadSummary.addFailedInvoiceOrder(rejectDocument.getTotalAmount(), eInvoice);
                eInvoiceLoad.insertInvoiceLoadSummary(loadSummary);
            } else {
                PaymentRequestDocument preqDoc = this.createPaymentRequest(orderHolder, invoiceFile);
                if (orderHolder.isInvoiceRejected()) {
                    GlobalVariables.getMessageMap().clearErrorMessages();
                    ElectronicInvoiceRejectDocument rejectDocument = this.createRejectDocument(eInvoice, order, eInvoiceLoad);
                    if (orderHolder.getAccountsPayablePurchasingDocumentLinkIdentifier() != null) {
                        rejectDocument.setAccountsPayablePurchasingDocumentLinkIdentifier(orderHolder.getAccountsPayablePurchasingDocumentLinkIdentifier());
                    }
                    loadSummary = this.getOrCreateLoadSummary(eInvoiceLoad, eInvoice.getDunsNumber());
                    loadSummary.addFailedInvoiceOrder(rejectDocument.getTotalAmount(), eInvoice);
                    eInvoiceLoad.insertInvoiceLoadSummary(loadSummary);
                } else {
                    ElectronicInvoiceLoadSummary loadSummary2 = this.getOrCreateLoadSummary(eInvoiceLoad, eInvoice.getDunsNumber());
                    loadSummary2.addSuccessfulInvoiceOrder(preqDoc.getTotalDollarAmount(), eInvoice);
                    eInvoiceLoad.insertInvoiceLoadSummary(loadSummary2);
                }
            }
            validateHeader = false;
        }
        return eInvoice.isFileRejected();
    }

    protected void setVendorDUNSNumber(ElectronicInvoice eInvoice) {
        String dunsNumber = null;
        if (StringUtils.equals((CharSequence)eInvoice.getHeader().getFromDomain(), (CharSequence)"DUNS")) {
            dunsNumber = eInvoice.getHeader().getFromIdentity();
        } else if (StringUtils.equals((CharSequence)eInvoice.getHeader().getSenderDomain(), (CharSequence)"DUNS")) {
            dunsNumber = eInvoice.getHeader().getSenderIdentity();
        }
        if (StringUtils.isNotEmpty((CharSequence)dunsNumber)) {
            LOG.info("Setting Vendor DUNS number - {}", (Object)dunsNumber);
            eInvoice.setDunsNumber(dunsNumber);
        }
    }

    protected void setVendorDetails(ElectronicInvoice eInvoice) {
        if (StringUtils.isNotEmpty((CharSequence)eInvoice.getDunsNumber())) {
            VendorDetail vendorDetail = this.vendorService.getVendorByDunsNumber(eInvoice.getDunsNumber());
            if (vendorDetail != null) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = () -> ((VendorDetail)vendorDetail).getVendorNumber();
                LOG.info("Vendor match found - {}", supplierArray);
                eInvoice.setVendorHeaderID(vendorDetail.getVendorHeaderGeneratedIdentifier());
                eInvoice.setVendorDetailID(vendorDetail.getVendorDetailAssignedIdentifier());
                eInvoice.setVendorName(vendorDetail.getVendorName());
            } else {
                eInvoice.setVendorHeaderID(null);
                eInvoice.setVendorDetailID(null);
                eInvoice.setVendorName(null);
            }
        }
    }

    protected void validateVendorDetails(ElectronicInvoiceRejectDocument rejectDocument) {
        VendorDetail vendorDetail;
        boolean vendorFound = false;
        if (StringUtils.isNotEmpty((CharSequence)rejectDocument.getVendorDunsNumber()) && (vendorDetail = this.vendorService.getVendorByDunsNumber(rejectDocument.getVendorDunsNumber())) != null) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((VendorDetail)vendorDetail).getVendorNumber();
            supplierArray[1] = rejectDocument::getVendorDunsNumber;
            LOG.info("Vendor [{}] match found for the DUNS - {}", supplierArray);
            rejectDocument.setVendorHeaderGeneratedIdentifier(vendorDetail.getVendorHeaderGeneratedIdentifier());
            rejectDocument.setVendorDetailAssignedIdentifier(vendorDetail.getVendorDetailAssignedIdentifier());
            rejectDocument.setVendorDetail(vendorDetail);
            vendorFound = true;
        }
        if (!vendorFound) {
            rejectDocument.setVendorHeaderGeneratedIdentifier(null);
            rejectDocument.setVendorDetailAssignedIdentifier(null);
            rejectDocument.setVendorDetail(null);
        }
        String newDocumentDesc = this.generateRejectDocumentDescription(rejectDocument);
        rejectDocument.getDocumentHeader().setDocumentDescription(newDocumentDesc);
    }

    protected Map getItemTypeMappings(Integer vendorHeaderId, Integer vendorDetailId) {
        Map itemTypeMappings = null;
        if (vendorHeaderId != null && vendorDetailId != null) {
            itemTypeMappings = this.electronicInvoicingDao.getItemMappingMap(vendorHeaderId, vendorDetailId);
        }
        if (itemTypeMappings == null || itemTypeMappings.isEmpty()) {
            itemTypeMappings = this.electronicInvoicingDao.getDefaultItemMappingMap();
        }
        return itemTypeMappings;
    }

    protected String getVendorNumber(Integer vendorHeaderId, Integer vendorDetailId) {
        if (vendorHeaderId != null && vendorDetailId != null) {
            VendorDetail forVendorNo = new VendorDetail();
            forVendorNo.setVendorHeaderGeneratedIdentifier(vendorHeaderId);
            forVendorNo.setVendorDetailAssignedIdentifier(vendorDetailId);
            return forVendorNo.getVendorNumber();
        }
        return null;
    }

    protected Map<String, ItemType> getKualiItemTypes() {
        Collection collection = this.businessObjectService.findAll(ItemType.class);
        HashMap<String, ItemType> kualiItemTypes = new HashMap<String, ItemType>();
        if (collection == null || collection.size() == 0) {
            throw new RuntimeException("Kuali Item types not available");
        }
        ItemType[] itemTypes = new ItemType[collection.size()];
        collection.toArray(itemTypes);
        for (ItemType itemType : itemTypes) {
            kualiItemTypes.put(itemType.getItemTypeCode(), itemType);
        }
        return kualiItemTypes;
    }

    protected boolean checkForCompleteFailure(ElectronicInvoiceLoad electronicInvoiceLoad, ElectronicInvoice electronicInvoice, File invoiceFile) {
        LOG.debug("checkForCompleteFailure() started");
        if (electronicInvoice.getInvoiceDetailRequestHeader().isHeaderInvoiceIndicator()) {
            this.rejectElectronicInvoiceFile(electronicInvoiceLoad, UNKNOWN_DUNS_IDENTIFIER, invoiceFile, "HIIO");
            return true;
        }
        if (electronicInvoice.getInvoiceDetailOrders().size() < 1) {
            this.rejectElectronicInvoiceFile(electronicInvoiceLoad, UNKNOWN_DUNS_IDENTIFIER, invoiceFile, "NOIV");
            return true;
        }
        for (ElectronicInvoiceOrder invoiceOrder : electronicInvoice.getInvoiceDetailOrders()) {
            for (ElectronicInvoiceItem invoiceItem : invoiceOrder.getInvoiceItems()) {
                if (invoiceItem == null) continue;
                invoiceItem.setCatalogNumber(invoiceItem.getReferenceItemIDSupplierPartID());
            }
        }
        LOG.info("No Complete failure");
        return false;
    }

    protected ElectronicInvoiceRejectReasonType getRejectReasonType(String rejectReasonTypeCode) {
        return this.matchingService.getElectronicInvoiceRejectReasonType(rejectReasonTypeCode);
    }

    protected void rejectElectronicInvoiceFile(ElectronicInvoiceLoad eInvoiceLoad, String fileDunsNumber, File filename, String rejectReasonTypeCode) {
        this.rejectElectronicInvoiceFile(eInvoiceLoad, fileDunsNumber, filename, null, rejectReasonTypeCode);
    }

    protected void rejectElectronicInvoiceFile(ElectronicInvoiceLoad eInvoiceLoad, String fileDunsNumber, File invoiceFile, String extraDescription, String rejectReasonTypeCode) {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = invoiceFile::getName;
        LOG.info("Rejecting the entire invoice file - {}", supplierArray);
        ElectronicInvoiceLoadSummary eInvoiceLoadSummary = this.getOrCreateLoadSummary(eInvoiceLoad, fileDunsNumber);
        eInvoiceLoadSummary.addFailedInvoiceOrder();
        eInvoiceLoad.insertInvoiceLoadSummary(eInvoiceLoadSummary);
        ElectronicInvoiceRejectDocument eInvoiceRejectDocument = (ElectronicInvoiceRejectDocument)this.documentService.getNewDocument("EIRT");
        eInvoiceRejectDocument.setInvoiceProcessTimestamp(this.dateTimeService.getCurrentTimestamp());
        eInvoiceRejectDocument.setVendorDunsNumber(fileDunsNumber);
        eInvoiceRejectDocument.setDocumentCreationInProgress(true);
        if (invoiceFile != null) {
            eInvoiceRejectDocument.setInvoiceFileName(invoiceFile.getName());
        }
        ArrayList<ElectronicInvoiceRejectReason> list = new ArrayList<ElectronicInvoiceRejectReason>(1);
        String message = "Complete failure document has been created for the Invoice with Filename '" + invoiceFile.getName() + "' due to the following error:\n";
        this.emailTextErrorList.append(message);
        ElectronicInvoiceRejectReason rejectReason = this.matchingService.createRejectReason(rejectReasonTypeCode, extraDescription, invoiceFile.getName());
        list.add(rejectReason);
        this.emailTextErrorList.append("    - ").append(rejectReason.getInvoiceRejectReasonDescription());
        this.emailTextErrorList.append("\n\n");
        eInvoiceRejectDocument.setInvoiceRejectReasons(list);
        eInvoiceRejectDocument.getDocumentHeader().setDocumentDescription("Complete failure");
        this.documentService.saveDocument((Document)eInvoiceRejectDocument);
        String noteText = "Invoice file";
        this.attachInvoiceXmltoDocument((Document)eInvoiceRejectDocument, invoiceFile, "Invoice file");
        eInvoiceLoad.addInvoiceReject(eInvoiceRejectDocument);
        Supplier[] supplierArray2 = new Supplier[1];
        supplierArray2[0] = () -> ((ElectronicInvoiceRejectDocument)eInvoiceRejectDocument).getDocumentNumber();
        LOG.info("Complete failure document has been created (DocNo:{})", supplierArray2);
    }

    private void attachInvoiceXmltoDocument(Document document, File attachmentFile, String noteText) {
        Note note;
        try {
            note = this.documentService.createNoteFromDocument(document, noteText);
            note.setRemoteObjectIdentifier(document.getDocumentHeader().getObjectId());
        }
        catch (Exception e1) {
            throw new RuntimeException("Unable to create note from document: ", e1);
        }
        Attachment attachment = null;
        try (BufferedInputStream fileStream = new BufferedInputStream(new FileInputStream(attachmentFile));){
            String attachmentType = null;
            attachment = this.attachmentService.createAttachment((GloballyUnique)document.getNoteTarget(), attachmentFile.getName(), INVOICE_FILE_MIME_TYPE, (int)attachmentFile.length(), (InputStream)fileStream, attachmentType);
        }
        catch (FileNotFoundException e) {
            LOG.error("Exception opening attachment file", (Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create attachment", e);
        }
        note.setAttachment(attachment);
        attachment.setNote(note);
        this.noteService.save(note);
    }

    public ElectronicInvoiceRejectDocument createRejectDocument(ElectronicInvoice eInvoice, ElectronicInvoiceOrder electronicInvoiceOrder, ElectronicInvoiceLoad eInvoiceLoad) {
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = eInvoice::getDunsNumber;
        supplierArray[1] = electronicInvoiceOrder::getInvoicePurchaseOrderID;
        LOG.info("Creating reject document [DUNS={},POID={}]", supplierArray);
        ElectronicInvoiceRejectDocument eInvoiceRejectDocument = (ElectronicInvoiceRejectDocument)this.documentService.getNewDocument("EIRT");
        eInvoiceRejectDocument.setInvoiceProcessTimestamp(this.dateTimeService.getCurrentTimestamp());
        String rejectDocDesc = this.generateRejectDocumentDescription(eInvoice, electronicInvoiceOrder);
        eInvoiceRejectDocument.getDocumentHeader().setDocumentDescription(rejectDocDesc);
        eInvoiceRejectDocument.setDocumentCreationInProgress(true);
        eInvoiceRejectDocument.setFileLevelData(eInvoice);
        eInvoiceRejectDocument.setInvoiceOrderLevelData(eInvoice, electronicInvoiceOrder);
        this.documentService.saveDocument((Document)eInvoiceRejectDocument);
        String noteText = "Invoice file";
        this.attachInvoiceXmltoDocument((Document)eInvoiceRejectDocument, this.getInvoiceFile(eInvoice.getFileName()), "Invoice file");
        eInvoiceLoad.addInvoiceReject(eInvoiceRejectDocument);
        Supplier[] supplierArray2 = new Supplier[1];
        supplierArray2[0] = () -> ((ElectronicInvoiceRejectDocument)eInvoiceRejectDocument).getDocumentNumber();
        LOG.info("Reject document has been created (DocNo={})", supplierArray2);
        this.emailTextErrorList.append("DUNS Number - ").append(eInvoice.getDunsNumber()).append(" ").append(eInvoice.getVendorName()).append(":\n");
        this.emailTextErrorList.append("An Invoice from file '").append(eInvoice.getFileName()).append("' has been rejected due to the following error(s):\n");
        int index = 1;
        for (ElectronicInvoiceRejectReason reason : eInvoiceRejectDocument.getInvoiceRejectReasons()) {
            this.emailTextErrorList.append("    - ").append(reason.getInvoiceRejectReasonDescription()).append("\n");
            this.addRejectReasonsToNote("Reject Reason " + index + ". " + reason.getInvoiceRejectReasonDescription(), eInvoiceRejectDocument);
            ++index;
        }
        this.emailTextErrorList.append("\n");
        return eInvoiceRejectDocument;
    }

    protected void addRejectReasonsToNote(String rejectReasons, ElectronicInvoiceRejectDocument eInvoiceRejectDocument) {
        try {
            Note note = this.documentService.createNoteFromDocument((Document)eInvoiceRejectDocument, rejectReasons);
            note.setRemoteObjectIdentifier(eInvoiceRejectDocument.getDocumentHeader().getObjectId());
            this.noteService.save(note);
        }
        catch (Exception e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = e::getMessage;
            LOG.error("Error creating reject reason note - {}", supplierArray);
        }
    }

    protected String generateRejectDocumentDescription(ElectronicInvoice eInvoice, ElectronicInvoiceOrder electronicInvoiceOrder) {
        String poID = StringUtils.isEmpty((CharSequence)electronicInvoiceOrder.getInvoicePurchaseOrderID()) ? "UNKNOWN" : electronicInvoiceOrder.getInvoicePurchaseOrderID();
        String vendorName = StringUtils.isEmpty((CharSequence)eInvoice.getVendorName()) ? "UNKNOWN" : eInvoice.getVendorName();
        String description = "PO: " + poID + " Vendor: " + vendorName;
        return this.checkDescriptionLengthAndStripIfNeeded(description);
    }

    protected String generateRejectDocumentDescription(ElectronicInvoiceRejectDocument rejectDoc) {
        String poID = StringUtils.isEmpty((CharSequence)rejectDoc.getInvoicePurchaseOrderNumber()) ? "UNKNOWN" : rejectDoc.getInvoicePurchaseOrderNumber();
        String vendorName = "UNKNOWN";
        if (rejectDoc.getVendorDetail() != null) {
            vendorName = rejectDoc.getVendorDetail().getVendorName();
        }
        String description = "PO: " + poID + " Vendor: " + vendorName;
        return this.checkDescriptionLengthAndStripIfNeeded(description);
    }

    protected String checkDescriptionLengthAndStripIfNeeded(String description) {
        int noteTextMaxLength = this.dataDictionaryService.getAttributeMaxLength(DocumentHeader.class, "documentDescription");
        if (noteTextMaxLength < description.length()) {
            description = description.substring(0, noteTextMaxLength);
        }
        return description;
    }

    public ElectronicInvoiceLoadSummary getOrCreateLoadSummary(ElectronicInvoiceLoad eInvoiceLoad, String fileDunsNumber) {
        ElectronicInvoiceLoadSummary eInvoiceLoadSummary = eInvoiceLoad.getInvoiceLoadSummaries().containsKey(fileDunsNumber) ? (ElectronicInvoiceLoadSummary)((Object)eInvoiceLoad.getInvoiceLoadSummaries().get(fileDunsNumber)) : new ElectronicInvoiceLoadSummary(fileDunsNumber);
        return eInvoiceLoadSummary;
    }

    public ElectronicInvoice loadElectronicInvoice(byte[] xmlAsBytes) throws CxmlParseException {
        ElectronicInvoice electronicInvoice;
        LOG.info("Loading Invoice File");
        try {
            electronicInvoice = (ElectronicInvoice)this.batchInputFileService.parse((BatchInputFileType)this.electronicInvoiceInputFileType, xmlAsBytes);
        }
        catch (ParseException e) {
            throw new CxmlParseException(e.getMessage());
        }
        LOG.info("Successfully loaded the Invoice File");
        return electronicInvoice;
    }

    protected StringBuffer saveLoadSummary(ElectronicInvoiceLoad eInvoiceLoad) {
        HashMap<String, ElectronicInvoiceLoadSummary> savedLoadSummariesMap = new HashMap<String, ElectronicInvoiceLoadSummary>();
        StringBuffer summaryMessage = new StringBuffer();
        for (Object key : eInvoiceLoad.getInvoiceLoadSummaries().keySet()) {
            String dunsNumber = (String)key;
            ElectronicInvoiceLoadSummary eInvoiceLoadSummary = (ElectronicInvoiceLoadSummary)((Object)eInvoiceLoad.getInvoiceLoadSummaries().get(dunsNumber));
            if (!eInvoiceLoadSummary.isEmpty().booleanValue()) {
                LOG.info("Saving Load Summary for DUNS '{}'", (Object)dunsNumber);
                ElectronicInvoiceLoadSummary currentLoadSummary = this.saveElectronicInvoiceLoadSummary(eInvoiceLoadSummary);
                summaryMessage.append("DUNS Number - ").append(eInvoiceLoadSummary.getVendorDescriptor()).append(":\n");
                summaryMessage.append("     ").append(eInvoiceLoadSummary.getInvoiceLoadSuccessCount()).append(" successfully processed invoices for a total of $ ").append(eInvoiceLoadSummary.getInvoiceLoadSuccessAmount().doubleValue()).append("\n");
                summaryMessage.append("     ").append(eInvoiceLoadSummary.getInvoiceLoadFailCount()).append(" rejected invoices for an approximate total of $ ").append(eInvoiceLoadSummary.getInvoiceLoadFailAmount().doubleValue()).append("\n");
                summaryMessage.append("\n\n");
                savedLoadSummariesMap.put(currentLoadSummary.getVendorDunsNumber(), eInvoiceLoadSummary);
                continue;
            }
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> dunsNumber;
            supplierArray[1] = eInvoiceLoadSummary::isEmpty;
            LOG.info("Not saving Load Summary for DUNS '{}' because empty indicator is '{}'", supplierArray);
        }
        summaryMessage.append("\n\n");
        for (Object doc : eInvoiceLoad.getRejectDocuments()) {
            ElectronicInvoiceRejectDocument rejectDoc = (ElectronicInvoiceRejectDocument)((Object)doc);
            this.routeRejectDocument(rejectDoc, savedLoadSummariesMap);
        }
        this.moveFileList(eInvoiceLoad.getRejectFilesToMove());
        return summaryMessage;
    }

    protected void routeRejectDocument(ElectronicInvoiceRejectDocument rejectDoc, Map savedLoadSummariesMap) {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = rejectDoc::getVendorDunsNumber;
        LOG.info("Saving Invoice Reject for DUNS '{}'", supplierArray);
        if (savedLoadSummariesMap.containsKey(rejectDoc.getVendorDunsNumber())) {
            rejectDoc.setInvoiceLoadSummary((ElectronicInvoiceLoadSummary)((Object)savedLoadSummariesMap.get(rejectDoc.getVendorDunsNumber())));
        } else {
            rejectDoc.setInvoiceLoadSummary((ElectronicInvoiceLoadSummary)((Object)savedLoadSummariesMap.get(UNKNOWN_DUNS_IDENTIFIER)));
        }
        this.documentService.routeDocument((Document)rejectDoc, "Routed by electronic invoice batch job", null);
    }

    protected void sendSummary(StringBuffer message) {
        String fromMailId = this.parameterService.getParameterValueAsString(ElectronicInvoiceStep.class, "DAILY_SUMMARY_REPORT_FROM_EMAIL_ADDRESS");
        ArrayList<String> toMailIds = new ArrayList<String>(this.parameterService.getParameterValuesAsString(ElectronicInvoiceStep.class, "DAILY_SUMMARY_REPORT_TO_EMAIL_ADDRESSES"));
        LOG.info("From email address parameter value:{}", (Object)fromMailId);
        LOG.info("To email address parameter value:{}", toMailIds);
        if (StringUtils.isBlank((CharSequence)fromMailId) || toMailIds.isEmpty()) {
            LOG.error("From/To mail addresses are empty. Unable to send the message");
        } else {
            BodyMailMessage mailMessage = new BodyMailMessage();
            mailMessage.setFromAddress(fromMailId);
            this.setMessageToAddressesAndSubject(mailMessage, toMailIds);
            mailMessage.setMessage(message.toString());
            try {
                this.emailService.sendMessage((MailMessage)mailMessage, false);
            }
            catch (Exception e) {
                LOG.error("Invalid email address. Message not sent", (Throwable)e);
            }
        }
    }

    protected BodyMailMessage setMessageToAddressesAndSubject(BodyMailMessage message, List<String> toAddressList) {
        if (!toAddressList.isEmpty()) {
            for (String aToAddressList : toAddressList) {
                if (!StringUtils.isNotEmpty((CharSequence)aToAddressList)) continue;
                message.addToAddress(aToAddressList.trim());
            }
        }
        String mailTitle = "E-Invoice Load Results for " + ElectronicInvoiceUtils.getDateDisplayText(this.dateTimeService.getCurrentDate());
        message.setSubject(mailTitle);
        return message;
    }

    @Override
    public boolean doMatchingProcess(ElectronicInvoiceRejectDocument rejectDocument) {
        this.validateVendorDetails(rejectDocument);
        Map itemTypeMappings = this.getItemTypeMappings(rejectDocument.getVendorHeaderGeneratedIdentifier(), rejectDocument.getVendorDetailAssignedIdentifier());
        Map<String, ItemType> kualiItemTypes = this.getKualiItemTypes();
        ElectronicInvoiceOrderHolder rejectDocHolder = new ElectronicInvoiceOrderHolder(rejectDocument, itemTypeMappings, kualiItemTypes);
        this.matchingService.doMatchingProcess(rejectDocHolder);
        if (!rejectDocHolder.isInvoiceRejected()) {
            this.validateInvoiceOrderValidForPREQCreation(rejectDocHolder);
        }
        ArrayList ignoreRejectTypes = new ArrayList(this.parameterService.getParameterValuesAsString("KFS-PURAP", "ElectronicInvoiceReject", "SUPPRESS_REJECT_REASON_CODES_ON_EIRT_APPROVAL"));
        ArrayList<ElectronicInvoiceRejectReason> rejectReasonsToDelete = new ArrayList<ElectronicInvoiceRejectReason>();
        for (ElectronicInvoiceRejectReason rejectReason : rejectDocument.getInvoiceRejectReasons()) {
            String rejectedReasonTypeCode = rejectReason.getInvoiceRejectReasonTypeCode();
            if (!StringUtils.isNotBlank((CharSequence)rejectedReasonTypeCode) || !ignoreRejectTypes.contains(rejectedReasonTypeCode)) continue;
            rejectReasonsToDelete.add(rejectReason);
        }
        if (!rejectReasonsToDelete.isEmpty()) {
            rejectDocument.getInvoiceRejectReasons().removeAll(rejectReasonsToDelete);
        }
        if (rejectDocument.getInvoiceRejectReasons().isEmpty()) {
            GlobalVariables.getMessageMap().clearErrorMessages();
        }
        return !rejectDocHolder.isInvoiceRejected();
    }

    @Override
    public boolean createPaymentRequest(ElectronicInvoiceRejectDocument rejectDocument) {
        if (!rejectDocument.getInvoiceRejectReasons().isEmpty()) {
            throw new RuntimeException("Not possible to create payment request since the reject document contains " + rejectDocument.getInvoiceRejectReasons().size() + " rejects");
        }
        Map itemTypeMappings = this.getItemTypeMappings(rejectDocument.getVendorHeaderGeneratedIdentifier(), rejectDocument.getVendorDetailAssignedIdentifier());
        Map<String, ItemType> kualiItemTypes = this.getKualiItemTypes();
        ElectronicInvoiceOrderHolder rejectDocHolder = new ElectronicInvoiceOrderHolder(rejectDocument, itemTypeMappings, kualiItemTypes);
        PaymentRequestDocument preqDocument = this.createPaymentRequest(rejectDocHolder);
        rejectDocument.setPaymentRequestIdentifier(preqDocument.getPurapDocumentIdentifier());
        return !rejectDocHolder.isInvoiceRejected();
    }

    protected PaymentRequestDocument createPaymentRequest(ElectronicInvoiceOrderHolder orderHolder) {
        return this.createPaymentRequest(orderHolder, null);
    }

    protected PaymentRequestDocument createPaymentRequest(ElectronicInvoiceOrderHolder orderHolder, File invoiceFile) {
        PaymentRequestDocument preqDoc = this.initializePaymentRequestDocument(orderHolder);
        if (preqDoc != null) {
            this.documentService.saveDocument((Document)preqDoc);
            if (invoiceFile != null) {
                LOG.debug("************************************  attaching doc without save");
                this.attachInvoiceXmltoDocument((Document)preqDoc, invoiceFile, "original eInvoice xml");
                LOG.debug("************************************  done attaching doc without save");
            }
            if (!this.routeCreatedPaymentRequest(orderHolder, preqDoc)) {
                return null;
            }
        }
        return preqDoc;
    }

    protected PaymentRequestDocument initializePaymentRequestDocument(ElectronicInvoiceOrderHolder orderHolder) {
        LOG.info("Creating Payment Request document");
        KNSGlobalVariables.getMessageList().clear();
        this.validateInvoiceOrderValidForPREQCreation(orderHolder);
        if (orderHolder.isInvoiceRejected()) {
            LOG.info("Not possible to convert einvoice details into payment request");
        } else {
            LOG.info("Payment request document creation validation succeeded");
        }
        if (orderHolder.isInvoiceRejected()) {
            return null;
        }
        PaymentRequestDocument preqDoc = (PaymentRequestDocument)this.documentService.getNewDocument("PREQ");
        PurchaseOrderDocument poDoc = orderHolder.getPurchaseOrderDocument();
        if (poDoc == null) {
            throw new RuntimeException("Purchase Order document does not exist in the system");
        }
        preqDoc.getDocumentHeader().setDocumentDescription(this.generatePREQDocumentDescription(poDoc));
        preqDoc.updateAndSaveAppDocStatus("In Process");
        preqDoc.setInvoiceDate(orderHolder.getInvoiceDate());
        preqDoc.setInvoiceNumber(orderHolder.getInvoiceNumber());
        preqDoc.setVendorInvoiceAmount(new KualiDecimal(orderHolder.getInvoiceNetAmount()));
        preqDoc.setAccountsPayableProcessorIdentifier("E-Invoice");
        preqDoc.setVendorCustomerNumber(orderHolder.getCustomerNumber());
        preqDoc.setPaymentRequestElectronicInvoiceIndicator(true);
        if (orderHolder.getAccountsPayablePurchasingDocumentLinkIdentifier() != null) {
            preqDoc.setAccountsPayablePurchasingDocumentLinkIdentifier(orderHolder.getAccountsPayablePurchasingDocumentLinkIdentifier());
        }
        this.paymentRequestService.initializePaymentMethodAndBank(preqDoc);
        RequisitionDocument reqDoc = this.requisitionService.getRequisitionById(poDoc.getRequisitionIdentifier());
        String reqDocInitiator = reqDoc.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
        try {
            Person user = this.personService.getPerson(reqDocInitiator);
            this.setProcessingCampus(preqDoc, user.getCampusCode());
        }
        catch (Exception e) {
            String extraDescription = "Error setting processing campus code - " + e.getMessage();
            ElectronicInvoiceRejectReason rejectReason = this.matchingService.createRejectReason("PRVE", extraDescription, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason);
            return null;
        }
        HashMap<String, ExpiredOrClosedAccountEntry> expiredOrClosedAccountList = this.accountsPayableService.expiredOrClosedAccountsList(poDoc);
        if (expiredOrClosedAccountList == null) {
            expiredOrClosedAccountList = new HashMap();
        }
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = expiredOrClosedAccountList::size;
        LOG.info("{} accounts has been found as Expired or Closed", supplierArray);
        preqDoc.populatePaymentRequestFromPurchaseOrder(orderHolder.getPurchaseOrderDocument(), expiredOrClosedAccountList);
        this.populateItemDetails(preqDoc, orderHolder);
        this.kualiRuleService.applyRules((KualiDocumentEvent)new AttributedCalculateAccountsPayableEvent((Document)preqDoc));
        this.paymentRequestService.calculatePaymentRequest(preqDoc, true);
        this.processItemsForDiscount(preqDoc, orderHolder);
        if (orderHolder.isInvoiceRejected()) {
            return null;
        }
        this.paymentRequestService.calculatePaymentRequest(preqDoc, false);
        this.kualiRuleService.applyRules((KualiDocumentEvent)new AttributedPaymentRequestForEInvoiceEvent((Document)preqDoc));
        if (GlobalVariables.getMessageMap().hasErrors()) {
            LOG.info("***************Error in rules processing - {}", new Supplier[]{GlobalVariables::getMessageMap});
            Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
            String errors = errorMessages.toString();
            ElectronicInvoiceRejectReason rejectReason = this.matchingService.createRejectReason("PRVE", errors, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason);
            return null;
        }
        if (KNSGlobalVariables.getMessageList().size() > 0) {
            LOG.info("Payment request contains {} warning message(s)", new Supplier[]{() -> KNSGlobalVariables.getMessageList().size()});
            for (int i = 0; i < KNSGlobalVariables.getMessageList().size(); ++i) {
                ErrorMessage errorMessage = (ErrorMessage)KNSGlobalVariables.getMessageList().get(i);
                LOG.info("Warning {}  - {}", (Object)i, (Object)errorMessage);
            }
        }
        this.addShipToNotes(preqDoc, orderHolder);
        return preqDoc;
    }

    protected boolean routeCreatedPaymentRequest(ElectronicInvoiceOrderHolder orderHolder, PaymentRequestDocument preqDoc) {
        String routingAnnotation = null;
        if (!orderHolder.isRejectDocumentHolder()) {
            routingAnnotation = "Routed by electronic invoice batch job";
        }
        try {
            this.documentService.routeDocument((Document)preqDoc, routingAnnotation, null);
        }
        catch (ValidationException e) {
            String extraDescription = GlobalVariables.getMessageMap().toString();
            ElectronicInvoiceRejectReason rejectReason = this.matchingService.createRejectReason("PRVE", extraDescription, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason);
            return false;
        }
        return true;
    }

    protected void setProcessingCampus(PaymentRequestDocument preqDoc, String initiatorCampusCode) {
        String campusCode = this.parameterService.getParameterValueAsString(ElectronicInvoiceStep.class, "OVERRIDE_PROCESSING_CAMPUS");
        if (!StringHelper.isNullOrEmpty((String)campusCode)) {
            preqDoc.setProcessingCampusCode(campusCode);
        } else {
            preqDoc.setProcessingCampusCode(initiatorCampusCode);
        }
    }

    protected void addShipToNotes(PaymentRequestDocument preqDoc, ElectronicInvoiceOrderHolder orderHolder) {
        String shipToAddress = orderHolder.getInvoiceShipToAddressAsString();
        try {
            Note noteObj = this.documentService.createNoteFromDocument((Document)preqDoc, shipToAddress);
            preqDoc.addNote(noteObj);
        }
        catch (Exception e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = e::getMessage;
            LOG.error("Error creating ShipTo notes - {}", supplierArray);
        }
    }

    protected void processItemsForDiscount(PaymentRequestDocument preqDocument, ElectronicInvoiceOrderHolder orderHolder) {
        LOG.info("Processing payment request items for discount");
        if (!orderHolder.isItemTypeAvailableInItemMapping(ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_DISCOUNT)) {
            LOG.info("Skipping discount processing since there is no mapping of discount type for this vendor");
            return;
        }
        if (orderHolder.getInvoiceDiscountAmount() == null || orderHolder.getInvoiceDiscountAmount() == BigDecimal.ZERO) {
            LOG.info("Skipping discount processing since there is no discount amount found in the invoice file");
            return;
        }
        KualiDecimal discountValueToUse = new KualiDecimal(orderHolder.getInvoiceDiscountAmount().negate());
        List preqItems = preqDocument.getItems();
        boolean alreadyProcessedInvoiceDiscount = false;
        boolean hasKualiPaymentTermsDiscountItem = false;
        for (PaymentRequestItem preqItem : preqItems) {
            boolean bl = hasKualiPaymentTermsDiscountItem = hasKualiPaymentTermsDiscountItem || StringUtils.equals((CharSequence)"DISC", (CharSequence)preqItem.getItemTypeCode());
            if (!this.isItemValidForUpdation(preqItem.getItemTypeCode(), ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_DISCOUNT, orderHolder)) continue;
            alreadyProcessedInvoiceDiscount = true;
            if (StringUtils.equals((CharSequence)preqItem.getItemTypeCode(), (CharSequence)"DISC")) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = preqItem::getItemTypeCode;
                LOG.info("Discount Check - E-Invoice matches PREQ item type '{}'... now checking for amount", supplierArray);
                KualiDecimal preqExtendedPrice = preqItem.getExtendedPrice() == null ? KualiDecimal.ZERO : preqItem.getExtendedPrice();
                if (discountValueToUse.compareTo((AbstractKualiDecimal)preqExtendedPrice) >= 0) continue;
                LOG.info("Discount Check - Using E-Invoice amount ({}) as it is more discount than current payment terms amount {}", (Object)discountValueToUse, (Object)preqExtendedPrice);
                preqItem.setItemUnitPrice(discountValueToUse.bigDecimalValue());
                preqItem.setExtendedPrice(discountValueToUse);
                continue;
            }
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = preqItem::getItemTypeCode;
            LOG.info("Discount Check - E-Invoice matches PREQ item type '{}'", supplierArray);
            LOG.info("Discount Check - Using E-Invoice amount ({}) as it is greater than payment terms amount", (Object)discountValueToUse);
            preqItem.addToUnitPrice(discountValueToUse.bigDecimalValue());
            preqItem.addToExtendedPrice(discountValueToUse);
        }
        if (!alreadyProcessedInvoiceDiscount) {
            if (hasKualiPaymentTermsDiscountItem || !orderHolder.isItemTypeAvailableInItemMapping(ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_DISCOUNT)) {
                ElectronicInvoiceRejectReason rejectReason = this.matchingService.createRejectReason("PRDE", null, orderHolder.getFileName());
                orderHolder.addInvoiceOrderRejectReason(rejectReason);
                return;
            }
            PaymentRequestItem newItem = new PaymentRequestItem();
            newItem.setItemUnitPrice(discountValueToUse.bigDecimalValue());
            newItem.setItemTypeCode("DISC");
            newItem.setExtendedPrice(discountValueToUse);
            newItem.setPurapDocument(preqDocument);
            preqDocument.addItem(newItem);
        }
        LOG.info("Completed processing payment request items for discount");
    }

    protected void populateItemDetails(PaymentRequestDocument preqDocument, ElectronicInvoiceOrderHolder orderHolder) {
        LOG.info("Populating invoice order items into the payment request document");
        List preqItems = preqDocument.getItems();
        for (PurApItem item : preqItems) {
            PaymentRequestItem preqItem = (PaymentRequestItem)item;
            this.processInvoiceItem(preqItem, orderHolder);
        }
        this.addMissingMappedItems(preqItems, orderHolder);
        this.removeEmptyItems(preqItems);
        LOG.info("Successfully populated the invoice order items");
    }

    protected void removeEmptyItems(List<PurApItem> preqItems) {
        for (int i = preqItems.size() - 1; i >= 0; --i) {
            PurApItem item = preqItems.get(i);
            if (!this.isNullOrZero(item.getItemUnitPrice()) || !this.isNullOrZero(item.getExtendedPrice())) continue;
            preqItems.remove(i);
        }
    }

    protected void addMissingMappedItems(List<PurApItem> preqItems, ElectronicInvoiceOrderHolder orderHolder) {
        PurchasingAccountsPayableDocument purapDoc = null;
        Integer purapDocIdentifier = null;
        List requiredItemTypeCodeList = this.createInvoiceRequiresItemTypeCodeList(orderHolder);
        if (ObjectUtils.isNotNull((Object)requiredItemTypeCodeList) && !requiredItemTypeCodeList.isEmpty()) {
            for (PurApItem item : preqItems) {
                requiredItemTypeCodeList.remove(item.getItemTypeCode());
                purapDoc = (PurchasingAccountsPayableDocument)item.getPurapDocument();
                purapDocIdentifier = item.getPurapDocumentIdentifier();
            }
            if (ObjectUtils.isNotNull((Object)requiredItemTypeCodeList) && !requiredItemTypeCodeList.isEmpty()) {
                for (PurApItem requiredItemTypeCode : requiredItemTypeCodeList) {
                    PaymentRequestItem preqItem = new PaymentRequestItem();
                    preqItem.resetAccount();
                    preqItem.setPurapDocumentIdentifier(purapDocIdentifier);
                    preqItem.setPurapDocument(purapDoc);
                    preqItem.setItemTypeCode((String)((Object)requiredItemTypeCode));
                    this.processInvoiceItem(preqItem, orderHolder);
                    if (!ObjectUtils.isNotNull((Object)preqItem.getItemUnitPrice()) || preqItem.getItemUnitPrice() == BigDecimal.ZERO || !ObjectUtils.isNotNull((Object)preqItem.getExtendedPrice()) || preqItem.getExtendedPrice() == KualiDecimal.ZERO) continue;
                    preqItems.add(preqItem);
                }
            }
        }
    }

    protected List createInvoiceRequiresItemTypeCodeList(ElectronicInvoiceOrderHolder orderHolder) {
        ArrayList itemTypeCodeList = new ArrayList();
        this.addToListIfExists(itemTypeCodeList, ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_TAX, orderHolder);
        this.addToListIfExists(itemTypeCodeList, ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_SHIPPING, orderHolder);
        this.addToListIfExists(itemTypeCodeList, ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_SPECIAL_HANDLING, orderHolder);
        this.addToListIfExists(itemTypeCodeList, ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_DEPOSIT, orderHolder);
        this.addToListIfExists(itemTypeCodeList, ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_DUE, orderHolder);
        this.addToListIfExists(itemTypeCodeList, ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_DISCOUNT, orderHolder);
        return itemTypeCodeList;
    }

    protected void addToListIfExists(List itemTypeCodeList, String invoiceItemTypeCode, ElectronicInvoiceOrderHolder orderHolder) {
        String itemTypeCode = orderHolder.getKualiItemTypeCodeFromMappings(invoiceItemTypeCode);
        if (ObjectUtils.isNotNull((Object)itemTypeCode)) {
            itemTypeCodeList.add(itemTypeCode);
        }
    }

    protected void processInvoiceItem(PaymentRequestItem preqItem, ElectronicInvoiceOrderHolder orderHolder) {
        if (this.isItemValidForUpdation(preqItem.getItemTypeCode(), ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_ITEM, orderHolder)) {
            this.processAboveTheLineItem(preqItem, orderHolder);
        } else if (this.isItemValidForUpdation(preqItem.getItemTypeCode(), ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_TAX, orderHolder)) {
            this.processTaxItem(preqItem, orderHolder);
        } else if (this.isItemValidForUpdation(preqItem.getItemTypeCode(), ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_SHIPPING, orderHolder)) {
            this.processShippingItem(preqItem, orderHolder);
        } else if (this.isItemValidForUpdation(preqItem.getItemTypeCode(), ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_SPECIAL_HANDLING, orderHolder)) {
            this.processSpecialHandlingItem(preqItem, orderHolder);
        } else if (this.isItemValidForUpdation(preqItem.getItemTypeCode(), ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_DEPOSIT, orderHolder)) {
            this.processDepositItem(preqItem, orderHolder);
        } else if (this.isItemValidForUpdation(preqItem.getItemTypeCode(), ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_DUE, orderHolder)) {
            this.processDueItem(preqItem, orderHolder);
        } else if (this.isItemValidForUpdation(preqItem.getItemTypeCode(), ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_DISCOUNT, orderHolder)) {
            this.processDiscountItem(preqItem, orderHolder);
        } else if (this.isItemValidForUpdation(preqItem.getItemTypeCode(), ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_EXMT, orderHolder)) {
            this.processAboveTheLineItem(preqItem, orderHolder);
        }
    }

    protected void processAboveTheLineItem(PaymentRequestItem purapItem, ElectronicInvoiceOrderHolder orderHolder) {
        LOG.info("Processing above the line item");
        ElectronicInvoiceItemHolder itemHolder = orderHolder.getItemByLineNumber(purapItem.getItemLineNumber());
        if (itemHolder == null) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = purapItem::getItemLineNumber;
            LOG.info("Electronic Invoice does not have item with Ref Item Line number {}", supplierArray);
            return;
        }
        purapItem.setItemUnitPrice(itemHolder.getInvoiceItemUnitPrice());
        purapItem.setItemQuantity(new KualiDecimal(itemHolder.getInvoiceItemQuantity()));
        purapItem.setItemTaxAmount(new KualiDecimal(itemHolder.getTaxAmount()));
        purapItem.setItemCatalogNumber(itemHolder.getInvoiceItemCatalogNumber());
        purapItem.setItemDescription(itemHolder.getInvoiceItemDescription());
        if (itemHolder.getSubTotalAmount() != null && itemHolder.getSubTotalAmount().compareTo((AbstractKualiDecimal)KualiDecimal.ZERO) != 0) {
            purapItem.setExtendedPrice(itemHolder.getSubTotalAmount());
        } else if (purapItem.getItemQuantity() != null) {
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = purapItem::getItemLineNumber;
            supplierArray[1] = purapItem::getItemQuantity;
            supplierArray[2] = purapItem::getItemUnitPrice;
            LOG.info("Item number {} needs calculation of extended price from quantity {} and unit cost {}", supplierArray);
            purapItem.setExtendedPrice((KualiDecimal)purapItem.getItemQuantity().multiply((AbstractKualiDecimal)new KualiDecimal(purapItem.getItemUnitPrice())));
        } else {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = purapItem::getItemLineNumber;
            supplierArray[1] = purapItem::getItemUnitPrice;
            LOG.info("Item number {} has no quantity so extended price equals unit price of {}", supplierArray);
            purapItem.setExtendedPrice(new KualiDecimal(purapItem.getItemUnitPrice()));
        }
    }

    protected void processSpecialHandlingItem(PaymentRequestItem purapItem, ElectronicInvoiceOrderHolder orderHolder) {
        LOG.info("Processing special handling item");
        purapItem.addToUnitPrice(orderHolder.getInvoiceSpecialHandlingAmount());
        purapItem.addToExtendedPrice(new KualiDecimal(orderHolder.getInvoiceSpecialHandlingAmount()));
        String invoiceSpecialHandlingDescription = orderHolder.getInvoiceSpecialHandlingDescription();
        if (invoiceSpecialHandlingDescription == null && orderHolder.getInvoiceSpecialHandlingAmount() != null && BigDecimal.ZERO.compareTo(orderHolder.getInvoiceSpecialHandlingAmount()) != 0) {
            invoiceSpecialHandlingDescription = "Handling";
        }
        if (StringUtils.isNotEmpty((CharSequence)invoiceSpecialHandlingDescription)) {
            if (StringUtils.isEmpty((CharSequence)purapItem.getItemDescription())) {
                purapItem.setItemDescription(invoiceSpecialHandlingDescription);
            } else {
                purapItem.setItemDescription(purapItem.getItemDescription() + " - " + invoiceSpecialHandlingDescription);
            }
        }
    }

    protected void processTaxItem(PaymentRequestItem preqItem, ElectronicInvoiceOrderHolder orderHolder) {
        LOG.info("Processing Tax Item");
        preqItem.addToUnitPrice(orderHolder.getTaxAmount());
        preqItem.addToExtendedPrice(new KualiDecimal(orderHolder.getTaxAmount()));
        if (StringUtils.isNotEmpty((CharSequence)orderHolder.getTaxDescription())) {
            if (StringUtils.isEmpty((CharSequence)preqItem.getItemDescription())) {
                preqItem.setItemDescription(orderHolder.getTaxDescription());
            } else {
                preqItem.setItemDescription(preqItem.getItemDescription() + " - " + orderHolder.getTaxDescription());
            }
        }
    }

    protected void processShippingItem(PaymentRequestItem preqItem, ElectronicInvoiceOrderHolder orderHolder) {
        LOG.info("Processing Shipping Item");
        preqItem.addToUnitPrice(orderHolder.getInvoiceShippingAmount());
        preqItem.addToExtendedPrice(new KualiDecimal(orderHolder.getInvoiceShippingAmount()));
        if (StringUtils.isNotEmpty((CharSequence)orderHolder.getInvoiceShippingDescription())) {
            if (StringUtils.isEmpty((CharSequence)preqItem.getItemDescription())) {
                preqItem.setItemDescription(orderHolder.getInvoiceShippingDescription());
            } else {
                preqItem.setItemDescription(preqItem.getItemDescription() + " - " + orderHolder.getInvoiceShippingDescription());
            }
        }
    }

    protected void processDiscountItem(PaymentRequestItem preqItem, ElectronicInvoiceOrderHolder orderHolder) {
        LOG.info("Processing Discount Item");
        preqItem.addToUnitPrice(orderHolder.getInvoiceDiscountAmount());
        preqItem.addToExtendedPrice(new KualiDecimal(orderHolder.getInvoiceDiscountAmount()));
    }

    protected void processDepositItem(PaymentRequestItem preqItem, ElectronicInvoiceOrderHolder orderHolder) {
        LOG.info("Processing Deposit Item");
        preqItem.addToUnitPrice(orderHolder.getInvoiceDepositAmount());
        preqItem.addToExtendedPrice(new KualiDecimal(orderHolder.getInvoiceDepositAmount()));
    }

    protected void processDueItem(PaymentRequestItem preqItem, ElectronicInvoiceOrderHolder orderHolder) {
        LOG.info("Processing Deposit Item");
        preqItem.addToUnitPrice(orderHolder.getInvoiceDueAmount());
        preqItem.addToExtendedPrice(new KualiDecimal(orderHolder.getInvoiceDueAmount()));
    }

    protected boolean isNullOrZero(BigDecimal value) {
        return ObjectUtils.isNull((Object)value) || value.compareTo(BigDecimal.ZERO) == 0;
    }

    protected boolean isNullOrZero(KualiDecimal value) {
        return ObjectUtils.isNull((Object)value) || value.isZero();
    }

    protected void setItemDefaultDescription(PaymentRequestItem preqItem) {
        if (StringUtils.isEmpty((CharSequence)preqItem.getItemDescription()) && !StringUtils.equals((CharSequence)"ITEM", (CharSequence)preqItem.getItemTypeCode()) && ArrayUtils.contains((Object[])PurapConstants.ElectronicInvoice.ITEM_TYPES_REQUIRES_DESCRIPTION, (Object)preqItem.getItemTypeCode())) {
            preqItem.setItemDescription(PurapConstants.ElectronicInvoice.DEFAULT_BELOW_LINE_ITEM_DESCRIPTION);
        }
    }

    protected boolean isItemValidForUpdation(String itemTypeCode, String invoiceItemTypeCode, ElectronicInvoiceOrderHolder orderHolder) {
        boolean isItemTypeAvailableInItemMapping = orderHolder.isItemTypeAvailableInItemMapping(invoiceItemTypeCode);
        String itemTypeCodeFromMappings = orderHolder.getKualiItemTypeCodeFromMappings(invoiceItemTypeCode);
        return isItemTypeAvailableInItemMapping && StringUtils.equals((CharSequence)itemTypeCodeFromMappings, (CharSequence)itemTypeCode);
    }

    protected String generatePREQDocumentDescription(PurchaseOrderDocument poDocument) {
        String description = "PO: " + poDocument.getPurapDocumentIdentifier() + " Vendor: " + poDocument.getVendorName() + " Electronic Invoice";
        return this.checkDescriptionLengthAndStripIfNeeded(description);
    }

    public void validateInvoiceOrderValidForPREQCreation(ElectronicInvoiceOrderHolder orderHolder) {
        ElectronicInvoiceRejectReason rejectReason;
        List preqs;
        LOG.info("Validating ElectronicInvoice Order to make sure that it can be turned into a Payment Request document");
        PurchaseOrderDocument poDoc = orderHolder.getPurchaseOrderDocument();
        if (poDoc == null) {
            throw new RuntimeException("PurchaseOrder not available");
        }
        if (!orderHolder.isInvoiceNumberAcceptIndicatorEnabled() && (preqs = this.paymentRequestService.getPaymentRequestsByVendorNumberInvoiceNumber(poDoc.getVendorHeaderGeneratedIdentifier(), poDoc.getVendorDetailAssignedIdentifier(), orderHolder.getInvoiceNumber())) != null && preqs.size() > 0) {
            ElectronicInvoiceRejectReason rejectReason2 = this.matchingService.createRejectReason("EIDU", null, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason2, "invoiceFileNumber", "errors.reject.invoice.duplicate");
            return;
        }
        if (orderHolder.getInvoiceDate() == null) {
            rejectReason = this.matchingService.createRejectReason("IDIV", null, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason, "invoiceFileDate", "errors.reject.invoicedate.invalid");
        } else if (orderHolder.getInvoiceDate().after(this.dateTimeService.getCurrentDate())) {
            rejectReason = this.matchingService.createRejectReason("IDAG", null, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason, "invoiceFileDate", "errors.reject.invoicedate.greater");
        }
    }

    protected void moveFileList(Map filesToMove) {
        for (Object file : filesToMove.keySet()) {
            File fileToMove = (File)file;
            boolean success = this.moveFile(fileToMove, (String)filesToMove.get(fileToMove));
            if (success) continue;
            String errorMessage = "File with name '" + fileToMove.getName() + "' could not be moved";
            throw new PurError(errorMessage);
        }
    }

    protected boolean moveFile(File fileForMove, String location) {
        File moveDir = new File(location);
        return fileForMove.renameTo(new File(moveDir, fileForMove.getName()));
    }

    protected void deleteDoneFile(File invoiceFile) {
        File doneFile = new File(invoiceFile.getAbsolutePath().replace(this.electronicInvoiceInputFileType.getFileExtension(), ".done"));
        if (doneFile.exists()) {
            doneFile.delete();
        }
    }

    protected String getErrorMessages(Map<String, ArrayList> errorMap) {
        StringBuffer errorList = new StringBuffer();
        for (Map.Entry<String, ArrayList> errorEntry : errorMap.entrySet()) {
            ArrayList errorMessages = errorEntry.getValue();
            for (Object message : errorMessages) {
                ErrorMessage errorMessage = (ErrorMessage)message;
                String errorText = this.kualiConfigurationService.getPropertyValueAsString(errorMessage.getErrorKey());
                errorText = MessageFormat.format(errorText, errorMessage.getMessageParameters());
                errorList.append(errorText).append("\n");
            }
        }
        return errorList.toString();
    }

    protected String getBaseDirName() {
        return this.electronicInvoiceInputFileType.getDirectoryPath() + File.separator;
    }

    public String getRejectDirName() {
        return this.getBaseDirName() + "reject" + File.separator;
    }

    public String getAcceptDirName() {
        return this.getBaseDirName() + "accept" + File.separator;
    }

    protected File getInvoiceFile(String fileName) {
        return new File(this.getBaseDirName() + fileName);
    }

    protected ElectronicInvoiceLoadSummary saveElectronicInvoiceLoadSummary(ElectronicInvoiceLoadSummary eils) {
        this.businessObjectService.save((PersistableBusinessObject)eils);
        eils.refreshNonUpdateableReferences();
        return eils;
    }

    public List<String> getRequiredDirectoryNames() {
        return List.of(this.getBaseDirName(), this.getAcceptDirName(), this.getRejectDirName());
    }

    public void setElectronicInvoiceInputFileType(ElectronicInvoiceInputFileType electronicInvoiceInputFileType) {
        this.electronicInvoiceInputFileType = electronicInvoiceInputFileType;
    }

    public void setElectronicInvoicingDao(ElectronicInvoicingDao electronicInvoicingDao) {
        this.electronicInvoicingDao = electronicInvoicingDao;
    }

    public void setBatchInputFileService(BatchInputFileService batchInputFileService) {
        this.batchInputFileService = batchInputFileService;
    }

    public void setElectronicInvoiceMatchingService(ElectronicInvoiceMatchingService matchingService) {
        this.matchingService = matchingService;
    }

    public void setVendorService(VendorService vendorService) {
        this.vendorService = vendorService;
    }

    public void setPurchaseOrderService(PurchaseOrderService purchaseOrderService) {
        this.purchaseOrderService = purchaseOrderService;
    }

    public void setPaymentRequestService(PaymentRequestService paymentRequestService) {
        this.paymentRequestService = paymentRequestService;
    }

    public void setConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setAttachmentService(AttachmentService attachmentService) {
        this.attachmentService = attachmentService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }

    public void setBankService(BankService bankService) {
        this.bankService = bankService;
    }

    public void setKualiRuleService(KualiRuleService kualiRuleService) {
        this.kualiRuleService = kualiRuleService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    protected RequisitionService getRequisitionService() {
        return this.requisitionService;
    }

    public void setRequisitionService(RequisitionService requisitionService) {
        this.requisitionService = requisitionService;
    }

    protected AccountsPayableService getAccountsPayableService() {
        return this.accountsPayableService;
    }

    public void setAccountsPayableService(AccountsPayableService accountsPayableService) {
        this.accountsPayableService = accountsPayableService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

